/*
 * Decompiled with CFR 0.152.
 */
package net.daum.mf.map.api;

import android.app.Activity;
import android.content.Context;
import java.lang.ref.WeakReference;
import net.daum.android.map.geocoding.ReverseGeoCodingWebService;
import net.daum.mf.map.api.MapPoint;
import net.daum.mf.map.n.api.internal.NativeMapBuildSettings;

public class MapReverseGeoCoder
implements ReverseGeoCodingWebService.ReverseGeoCodingResultListener {
    private Activity contextActivity;
    private String openAPIKey;
    private MapPoint mapPoint;
    private WeakReference<ReverseGeoCodingResultListener> resultListener;
    private ReverseGeoCodingWebService reverseGeoCodingWebService = null;

    public MapReverseGeoCoder(String openAPIKey, MapPoint mapPoint, ReverseGeoCodingResultListener resultListener, Activity contextActivity) {
        this.contextActivity = contextActivity;
        this.openAPIKey = openAPIKey;
        this.mapPoint = mapPoint;
        this.resultListener = new WeakReference<ReverseGeoCodingResultListener>(resultListener);
    }

    public void startFindingAddress() {
        this.reverseGeoCodingWebService = new ReverseGeoCodingWebService(this.openAPIKey, this.contextActivity.getPackageName(), this.mapPoint, this);
        this.reverseGeoCodingWebService.requestReverseGeoCodingService();
    }

    public void startFindingAddress(AddressType addressType) {
        ReverseGeoCodingWebService.ResultFormat resultFormat = addressType == AddressType.ShortAddress ? ReverseGeoCodingWebService.ResultFormat.Simple : (NativeMapBuildSettings.isOpenAPIMapLibraryBuild() ? ReverseGeoCodingWebService.ResultFormat.Simple : ReverseGeoCodingWebService.ResultFormat.Full);
        this.reverseGeoCodingWebService = new ReverseGeoCodingWebService(this.openAPIKey, this.contextActivity.getPackageName(), this.mapPoint, resultFormat, this);
        this.reverseGeoCodingWebService.requestReverseGeoCodingService();
    }

    public void cancelFindingAddress() {
        if (this.reverseGeoCodingWebService != null) {
            this.reverseGeoCodingWebService.cancelRequest();
            this.reverseGeoCodingWebService = null;
        }
    }

    @Deprecated
    public static String findAddressForMapPoint(String openAPIKey, MapPoint mapPoint) {
        ReverseGeoCodingWebService rGeoCodingWebService = new ReverseGeoCodingWebService(openAPIKey, null, mapPoint, null);
        String address = rGeoCodingWebService.requestReverseGeoCodingServiceSync();
        return address;
    }

    @Deprecated
    public static String findAddressForMapPoint(String openAPIKey, MapPoint mapPoint, AddressType addressType) {
        ReverseGeoCodingWebService.ResultFormat resultFormat = addressType == AddressType.ShortAddress ? ReverseGeoCodingWebService.ResultFormat.Simple : ReverseGeoCodingWebService.ResultFormat.Full;
        ReverseGeoCodingWebService rGeoCodingWebService = new ReverseGeoCodingWebService(openAPIKey, null, mapPoint, resultFormat, null);
        String address = rGeoCodingWebService.requestReverseGeoCodingServiceSync();
        return address;
    }

    public String findAddressForMapPointSync(String openAPIKey, MapPoint mapPoint) {
        ReverseGeoCodingWebService rGeoCodingWebService = new ReverseGeoCodingWebService(openAPIKey, this.contextActivity.getPackageName(), mapPoint, null);
        String address = rGeoCodingWebService.requestReverseGeoCodingServiceSync();
        return address;
    }

    public String findAddressForMapPointSync(String openAPIKey, MapPoint mapPoint, AddressType addressType) {
        ReverseGeoCodingWebService.ResultFormat resultFormat = addressType == AddressType.ShortAddress ? ReverseGeoCodingWebService.ResultFormat.Simple : ReverseGeoCodingWebService.ResultFormat.Full;
        ReverseGeoCodingWebService rGeoCodingWebService = new ReverseGeoCodingWebService(openAPIKey, this.contextActivity.getPackageName(), mapPoint, resultFormat, null);
        String address = rGeoCodingWebService.requestReverseGeoCodingServiceSync();
        return address;
    }

    @Override
    public void onAddressFound(final String address) {
        if (this.resultListener != null && this.resultListener.get() != null) {
            if (this.contextActivity != null) {
                this.contextActivity.runOnUiThread(new Runnable(){

                    @Override
                    public void run() {
                        if (MapReverseGeoCoder.this.resultListener != null && MapReverseGeoCoder.this.resultListener.get() != null) {
                            ((ReverseGeoCodingResultListener)MapReverseGeoCoder.this.resultListener.get()).onReverseGeoCoderFoundAddress(MapReverseGeoCoder.this, address);
                        }
                    }
                });
            } else {
                ((ReverseGeoCodingResultListener)this.resultListener.get()).onReverseGeoCoderFoundAddress(this, address);
            }
        }
        this.reverseGeoCodingWebService = null;
    }

    @Override
    public void onFailedToFindAddress() {
        if (this.resultListener != null && this.resultListener.get() != null) {
            if (this.contextActivity != null) {
                this.contextActivity.runOnUiThread(new Runnable(){

                    @Override
                    public void run() {
                        if (MapReverseGeoCoder.this.resultListener != null && MapReverseGeoCoder.this.resultListener.get() != null) {
                            ((ReverseGeoCodingResultListener)MapReverseGeoCoder.this.resultListener.get()).onReverseGeoCoderFailedToFindAddress(MapReverseGeoCoder.this);
                        }
                    }
                });
            } else {
                ((ReverseGeoCodingResultListener)this.resultListener.get()).onReverseGeoCoderFailedToFindAddress(this);
            }
        }
        this.reverseGeoCodingWebService = null;
    }

    @Override
    public Context getContext() {
        return this.contextActivity;
    }

    public static enum AddressType {
        ShortAddress,
        FullAddress;

    }

    public static interface ReverseGeoCodingResultListener {
        public void onReverseGeoCoderFoundAddress(MapReverseGeoCoder var1, String var2);

        public void onReverseGeoCoderFailedToFindAddress(MapReverseGeoCoder var1);
    }
}

