/*
 * Decompiled with CFR 0.152.
 */
package net.daum.mf.map.common.net;

import android.util.Log;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import net.daum.android.map.MapBuildSettings;
import net.daum.mf.map.common.io.CloseableUtils;
import net.daum.mf.map.common.io.InputStreamUtils;
import net.daum.mf.map.common.net.HttpProtocolUtils;
import net.daum.mf.map.common.net.KeyValuePair;
import net.daum.mf.map.common.net.NetWebClient;

public class WebClient {
    NetWebClient _httpClient;
    private static ExecutorService executor = new ThreadPoolExecutor(2, Integer.MAX_VALUE, 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>());

    public void execute(Runnable task) {
        executor.execute(task);
    }

    private void _createHttpClientIfNeeded() {
        if (this._httpClient == null) {
            this._httpClient = new NetWebClient();
        }
    }

    private boolean _requestGet(String url, Map<String, String> header) {
        this._createHttpClientIfNeeded();
        if (header != null) {
            for (String key : header.keySet()) {
                this._httpClient.addHeader(key, header.get(key));
            }
        }
        this._httpClient.setUserAgent(HttpProtocolUtils.getUserAgent());
        boolean result = false;
        try {
            this._httpClient.requestGetWithCookie(url, null);
            result = true;
        }
        catch (Exception e) {
            Log.e((String)WebClient.class.getName(), (String)("" + e.getMessage()));
        }
        return result;
    }

    public boolean requestGet(String url) {
        return this._requestGet(url, null);
    }

    public boolean requestGetWithHeader(String url, Map<String, String> header) {
        return this._requestGet(url, header);
    }

    public boolean requestPost(String url, ArrayList<KeyValuePair> params, String cookie) {
        this._createHttpClientIfNeeded();
        this._httpClient.setUserAgent(HttpProtocolUtils.getUserAgent());
        boolean result = false;
        try {
            this._httpClient.requestPost(url, params, cookie);
            result = true;
        }
        catch (Exception e) {
            Log.e((String)WebClient.class.getName(), (String)("" + e.getMessage()));
        }
        return result;
    }

    public boolean requestPost(String url, ArrayList<KeyValuePair> params) {
        return this.requestPost(url, params, null);
    }

    public void cancel() {
        if (this._httpClient != null) {
            this._httpClient.cancel();
        }
        if (!MapBuildSettings.getInstance().isDistribution()) {
            Log.d((String)WebClient.class.getName(), (String)"NetworkCanceled");
        }
    }

    public InputStream openContentStream() throws IllegalStateException, IOException {
        if (this._httpClient == null) {
            return null;
        }
        try {
            InputStream content = this._httpClient.openContentStream();
            return content;
        }
        catch (Exception e) {
            Log.e((String)WebClient.class.getName(), (String)("" + e.getMessage()));
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getContentString(String encoding) {
        if (this._httpClient == null) {
            return null;
        }
        long contentLength = this._httpClient.getContentLength();
        InputStream is = null;
        String result = null;
        try {
            is = this._httpClient.openContentStream();
            result = InputStreamUtils.toString(is, encoding, (int)contentLength);
        }
        catch (Exception e) {
            Log.e((String)WebClient.class.getName(), (String)("" + e.getMessage()));
        }
        finally {
            CloseableUtils.closeQuietly(is);
        }
        return result;
    }

    public int getStatusCode() {
        if (this._httpClient == null) {
            return -1;
        }
        return this._httpClient.getStatusCode();
    }

    public long getContentLength() {
        if (this._httpClient == null) {
            return -1L;
        }
        return this._httpClient.getContentLength();
    }
}

