/*
 * Decompiled with CFR 0.152.
 */
package net.daum.mf.map.n.api;

import android.app.Application;
import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.util.DisplayMetrics;
import android.view.WindowManager;
import java.io.File;

public final class NativeMapEngineContext {
    private static final NativeMapEngineContext instance = new NativeMapEngineContext();
    private Context appContext;

    public static NativeMapEngineContext getInstance() {
        return instance;
    }

    public void setApplicationContext(Context context) {
        if (!(context instanceof Application)) {
            throw new IllegalArgumentException("Please set Applcation Context.");
        }
        this.appContext = context;
    }

    public Context getApplicationContext() {
        return this.appContext;
    }

    public String getApplicationRoot() {
        ApplicationInfo appInfo = this.appContext.getApplicationInfo();
        return appInfo.publicSourceDir;
    }

    public String getApplicationDataDirectory() {
        ApplicationInfo appInfo = this.appContext.getApplicationInfo();
        return appInfo.dataDir;
    }

    public String getCacheDirectory() {
        File cacheDirectory = this.appContext.getCacheDir();
        return cacheDirectory.getAbsolutePath();
    }

    public String getExternalCacheDirectory() {
        return this.getCacheDirectory();
    }

    public String getApplicationCacheDirectory() {
        return this.getCacheDirectory();
    }

    public String getApplicationPackageName() {
        ApplicationInfo appInfo = this.appContext.getApplicationInfo();
        String packageName = appInfo.packageName.replace(".", "/");
        return packageName;
    }

    public DisplayMetrics getMainScreenSize() {
        DisplayMetrics metrics = new DisplayMetrics();
        WindowManager wm = (WindowManager)this.appContext.getSystemService("window");
        wm.getDefaultDisplay().getMetrics(metrics);
        return metrics;
    }
}

