/*
 * Decompiled with CFR 0.152.
 */
package net.daum.mf.map.n.api;

import android.view.MotionEvent;
import net.daum.mf.map.common.MapEvent;
import net.daum.mf.map.common.MotionEventAdapter;
import net.daum.mf.map.n.api.NativeMapLibraryLoader;

public class NativeMapViewUiEvent
extends MapEvent {
    public static final int ACTION_UNDEFINED = 0;
    public static final int ACTION_DOWN = 1;
    public static final int ACTION_UP = 2;
    public static final int ACTION_MOVE = 3;
    protected int action;
    protected int pointCount;
    protected float[] x;
    protected float[] y;
    protected long timestamp;

    public NativeMapViewUiEvent(MotionEvent event) {
        MotionEventAdapter eventAdapter = new MotionEventAdapter(event);
        this.pointCount = eventAdapter.getPointerCount();
        this.x = new float[this.pointCount];
        this.y = new float[this.pointCount];
        this.setX(event.getX());
        this.setY(event.getY());
        if (this.pointCount > 1) {
            this.setX(eventAdapter.getX(1), 1);
            this.setY(eventAdapter.getY(1), 1);
        }
        this.setTimstamp(event.getEventTime());
        switch (event.getAction()) {
            case 0: 
            case 5: 
            case 261: 
            case 517: {
                this.setAction(1);
                break;
            }
            case 1: 
            case 6: 
            case 262: 
            case 518: {
                this.setAction(2);
                break;
            }
            case 2: {
                this.setAction(3);
            }
        }
    }

    public int getAction() {
        return this.action;
    }

    public void setAction(int action) {
        this.action = action;
    }

    public float getX() {
        return this.x[0];
    }

    public void setX(float x) {
        this.x[0] = x;
    }

    public float getY() {
        return this.y[0];
    }

    public void setY(float y) {
        this.y[0] = y;
    }

    public float getX(int index) {
        return this.x[index];
    }

    public void setX(float x, int index) {
        this.x[index] = x;
    }

    public float getY(int index) {
        return this.y[index];
    }

    public void setY(float y, int index) {
        this.y[index] = y;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public void setTimstamp(long timestamp) {
        this.timestamp = timestamp;
    }

    public int getPointCount() {
        return this.pointCount;
    }

    static {
        NativeMapLibraryLoader.loadLibrary();
    }
}

