/*
 * Decompiled with CFR 0.152.
 */
package net.daum.android.map.location;

import android.app.Activity;
import android.app.ProgressDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.hardware.Sensor;
import android.hardware.SensorEvent;
import android.hardware.SensorEventListener;
import android.hardware.SensorManager;
import android.location.Criteria;
import android.location.GpsStatus;
import android.location.Location;
import android.location.LocationManager;
import android.location.LocationProvider;
import android.os.Bundle;
import android.os.Looper;
import android.os.SystemClock;
import android.util.Log;
import android.view.Display;
import android.view.Window;
import android.view.WindowManager;
import java.util.Date;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import net.daum.android.map.MapController;
import net.daum.android.map.MapViewController;
import net.daum.android.map.coord.MapCoord;
import net.daum.android.map.coord.MapCoordLatLng;
import net.daum.mf.map.api.InternalMapViewAccessor;
import net.daum.mf.map.api.MapView;
import net.daum.mf.map.n.api.NativeMapCoord;
import net.daum.mf.map.n.api.internal.NativeMapController;
import net.daum.mf.map.task.MainQueueManager;

public class MapViewLocationManager
implements DialogInterface.OnCancelListener,
DialogInterface.OnClickListener {
    private static final int MAX_DURATION_TIME = 40000;
    private static final MapViewLocationManager instance = new MapViewLocationManager();
    private Activity dmapActivity;
    private boolean isTrackingMode = false;
    private boolean isTrackingHeading = false;
    private boolean isUsingMapMove = true;
    private boolean isTrackingMarkerHeading = false;
    private Timer timer = null;
    private GpsSeekingTimerTask task = null;
    private long startTimerTime;
    private LocationManager locationManager;
    private LocationListener fineLocationListener;
    private LocationListener coarseLocationListener;
    private final HeadingEventListener headingListener = new HeadingEventListener();
    Date firstLocationTimestamp = null;
    private Criteria coarseCriteria;
    private Criteria fineCriteria;
    private BestInactiveLocationProviderListener bestInactiveLocationProviderListener = new BestInactiveLocationProviderListener();
    private final GpsStatus.Listener gpsStatusListener = new GpsStatus.Listener(){

        public void onGpsStatusChanged(int event) {
            switch (event) {
                case 1: {
                    break;
                }
                case 2: {
                    break;
                }
                case 3: {
                    if (MapViewLocationManager.this.coarseLocationListener == null) break;
                    MapViewLocationManager.this.locationManager.removeUpdates((android.location.LocationListener)MapViewLocationManager.this.coarseLocationListener);
                    break;
                }
                case 4: {
                    break;
                }
            }
        }
    };
    static int MAX_LEVEL_FOR_ACCURACY = 8;
    static int MIN_LEVEL_FOR_ACCURACY = 0;
    private ProgressDialog loadingDialog = null;

    public static MapViewLocationManager getInstance() {
        return instance;
    }

    private MapViewLocationManager() {
        this.coarseCriteria = new Criteria();
        this.coarseCriteria.setAccuracy(2);
        this.fineCriteria = new Criteria();
        this.fineCriteria.setAccuracy(1);
    }

    public void init() {
        try {
            if (this.locationManager == null) {
                this.locationManager = (LocationManager)this.dmapActivity.getSystemService("location");
                this.locationManager.addGpsStatusListener(this.gpsStatusListener);
                this.fineLocationListener = new LocationListener();
                this.coarseLocationListener = new LocationListener();
            }
        }
        catch (Exception e) {
            Log.e((String)"MapViewLocationManager", (String)"init failed");
            this.locationManager = null;
        }
    }

    public void setMapActivity(Activity dmapActivity) {
        this.dmapActivity = dmapActivity;
        this.init();
    }

    public void onResumeMapActivity() {
        if (this.isTrackingHeading) {
            try {
                SensorManager sensorManager = (SensorManager)this.dmapActivity.getSystemService("sensor");
                Sensor orientation = sensorManager.getDefaultSensor(3);
                sensorManager.registerListener((SensorEventListener)this.headingListener, orientation, 0);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.isTrackingMode) {
            this.requestLocationUpdate();
        }
    }

    public void onPauseMapActivity() {
        if (this.isTrackingHeading) {
            SensorManager sensorManager = (SensorManager)this.dmapActivity.getSystemService("sensor");
            sensorManager.unregisterListener((SensorEventListener)this.headingListener);
        }
        if (this.isTrackingMode) {
            if (this.coarseLocationListener != null) {
                this.locationManager.removeUpdates((android.location.LocationListener)this.coarseLocationListener);
            }
            if (this.fineLocationListener != null) {
                this.locationManager.removeUpdates((android.location.LocationListener)this.fineLocationListener);
            }
        }
    }

    public boolean isWpsLocationSet() {
        boolean isWpsEnabled = false;
        try {
            isWpsEnabled = this.locationManager.isProviderEnabled("network");
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (Exception exception) {
            // empty catch block
        }
        return isWpsEnabled;
    }

    public boolean isGpsLocationSet() {
        boolean isGPSEnabled = false;
        try {
            isGPSEnabled = this.locationManager.isProviderEnabled("gps");
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (Exception exception) {
            // empty catch block
        }
        return isGPSEnabled;
    }

    public void startTracking() {
        MapViewController.getInstance().switchTrackingMarker(true);
        this.startResolveCurrentLocation();
        this.isTrackingMode = true;
    }

    public void stopTracking() {
        MapViewController.getInstance().switchTrackingMarker(false);
        this.stopResolveCurrentLocation();
        this.isTrackingMode = false;
    }

    public boolean isTrackingMode() {
        return this.isTrackingMode;
    }

    public boolean isTrackingHeadingMode() {
        return this.isTrackingHeading;
    }

    public boolean isUsingMapMove() {
        return this.isUsingMapMove;
    }

    public void startTrackingHeading() {
        Sensor orientation;
        SensorManager sensorManager = (SensorManager)this.dmapActivity.getSystemService("sensor");
        if (sensorManager.registerListener((SensorEventListener)this.headingListener, orientation = sensorManager.getDefaultSensor(3), 0)) {
            this.isTrackingHeading = true;
            MapController.getInstance().setUseHeading(true);
        }
        MapViewController.getInstance().switchHeadingMarker(!this.isTrackingMarkerHeading);
    }

    public void setUsingMapMove(boolean use) {
        this.isUsingMapMove = use;
    }

    public void setMarkerHeadingTracking(boolean trackMarkerHeading) {
        this.isTrackingMarkerHeading = trackMarkerHeading;
    }

    public boolean getMarkerHeadingTracking() {
        return this.isTrackingMarkerHeading;
    }

    public void stopTrackingHeading() {
        SensorManager sensorManager = (SensorManager)this.dmapActivity.getSystemService("sensor");
        sensorManager.unregisterListener((SensorEventListener)this.headingListener);
        this.isTrackingHeading = false;
        MapController.getInstance().setUseHeading(false);
        MapViewController.getInstance().switchHeadingMarker(false);
    }

    public void requestLocationUpdate() {
        if (this.isWpsLocationSet() && this.coarseLocationListener != null) {
            this.locationManager.requestLocationUpdates("network", 0L, 0.0f, (android.location.LocationListener)this.coarseLocationListener);
        }
        if (this.isGpsLocationSet() && this.fineLocationListener != null) {
            this.locationManager.requestLocationUpdates("gps", 0L, 0.0f, (android.location.LocationListener)this.fineLocationListener);
        }
        String bestProvider = this.locationManager.getBestProvider(this.fineCriteria, false);
        String bestAvailableProvider = this.locationManager.getBestProvider(this.fineCriteria, true);
        if (bestProvider != null && !bestProvider.equals(bestAvailableProvider)) {
            this.locationManager.requestLocationUpdates(bestProvider, 0L, 0.0f, (android.location.LocationListener)this.bestInactiveLocationProviderListener, Looper.getMainLooper());
        }
    }

    public boolean startResolveCurrentLocation() {
        if (this.dmapActivity.isFinishing()) {
            return false;
        }
        this.dmapActivity.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                if (!MapViewLocationManager.this.isWpsLocationSet() && !MapViewLocationManager.this.isGpsLocationSet()) {
                    MapViewLocationManager.this.isTrackingMode = false;
                } else {
                    if (!MapViewLocationManager.this.isWpsLocationSet()) {
                        MapViewLocationManager.this.showLoadingIndicator();
                        MapViewLocationManager.this.cancelTimer();
                        MapViewLocationManager.this.timer = new Timer();
                        MapViewLocationManager.this.task = new GpsSeekingTimerTask();
                        MapViewLocationManager.this.timer.schedule((TimerTask)MapViewLocationManager.this.task, 0L, 1000L);
                        MapViewLocationManager.this.startTimerTime = SystemClock.elapsedRealtime();
                    }
                    MapViewLocationManager.this.requestLocationUpdate();
                }
            }
        });
        return true;
    }

    public boolean stopResolveCurrentLocation() {
        this.dmapActivity.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                MapViewLocationManager.this.cancelTimer();
                MapViewLocationManager.this.hideLoadingIndicator();
                if (MapViewLocationManager.this.coarseLocationListener != null) {
                    MapViewLocationManager.this.locationManager.removeUpdates((android.location.LocationListener)MapViewLocationManager.this.coarseLocationListener);
                }
                if (MapViewLocationManager.this.fineLocationListener != null) {
                    MapViewLocationManager.this.locationManager.removeUpdates((android.location.LocationListener)MapViewLocationManager.this.fineLocationListener);
                }
                if (MapViewLocationManager.this.isTrackingHeading) {
                    MapViewLocationManager.this.stopTrackingHeading();
                }
            }
        });
        return true;
    }

    public void cancelTimer() {
        if (this.timer != null) {
            this.timer.cancel();
            this.timer = null;
        }
    }

    void updateLocationMarkerWithAccuracy(float locationAccuracy) {
        MapViewController.getInstance().setAccuracy(locationAccuracy, false);
    }

    public float getZoomWithLevel(int level) {
        return (float)(1.0 / Math.pow(2.0, level));
    }

    public float getLevelWithZoom(float zoom) {
        float value = (float)(Math.log(1.0f / zoom) / Math.log(2.0));
        return value;
    }

    boolean isCurrentLevelOutOfRange() {
        int currentLevel = MapController.getInstance().getZoomLevelInt();
        float zoom = MapController.getInstance().getZoom();
        boolean currentLevelIsTooLow = currentLevel <= MIN_LEVEL_FOR_ACCURACY && (double)zoom > 1.0;
        boolean currentLevelIsTooHigh = currentLevel > MAX_LEVEL_FOR_ACCURACY;
        boolean currentLevelIsOutOfRange = currentLevelIsTooLow || currentLevelIsTooHigh;
        return currentLevelIsOutOfRange;
    }

    void makeTimeStampIfFirstLoading() {
        if (this.firstLocationTimestamp == null) {
            this.firstLocationTimestamp = new Date();
        }
    }

    boolean isShortIntervalFromFirstLoading(Date date) {
        long MAX_INTERVAL_TO_BE_REZOOMED_AUTOMATICALLY;
        if (this.firstLocationTimestamp == null) {
            return false;
        }
        boolean isTheSameTimeStamp = this.firstLocationTimestamp.equals(date);
        if (isTheSameTimeStamp) {
            return false;
        }
        Date currentTime = new Date();
        long intervalTimeMillis = currentTime.getTime() - this.firstLocationTimestamp.getTime();
        boolean isShort = intervalTimeMillis < (MAX_INTERVAL_TO_BE_REZOOMED_AUTOMATICALLY = 2000L);
        return isShort;
    }

    public boolean isLocationAvailable() {
        boolean locationAvailable = false;
        List locationProviders = this.locationManager.getAllProviders();
        if (locationProviders != null && locationProviders.size() > 0) {
            for (int i = 0; i < locationProviders.size(); ++i) {
                LocationProvider locationProvider;
                String providerName = (String)locationProviders.get(i);
                if (!providerName.equals("network") && !providerName.equals("gps") || (locationProvider = this.locationManager.getProvider(providerName)) == null) continue;
                locationAvailable = true;
                break;
            }
        }
        return locationAvailable;
    }

    public boolean isHeadingAvailable() {
        boolean sensorAvailable = false;
        SensorManager sensorManager = (SensorManager)this.dmapActivity.getSystemService("sensor");
        Sensor orientationSensor = sensorManager.getDefaultSensor(3);
        sensorAvailable = orientationSensor != null;
        orientationSensor = null;
        return sensorAvailable;
    }

    private void showLoadingIndicator() {
        if (this.dmapActivity == null || this.dmapActivity.isFinishing()) {
            return;
        }
        this.dmapActivity.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                if (MapViewLocationManager.this.loadingDialog != null && MapViewLocationManager.this.loadingDialog.isShowing()) {
                    return;
                }
                MapViewLocationManager.this.loadingDialog = new ProgressDialog((Context)MapViewLocationManager.this.dmapActivity);
                Window theWindow = MapViewLocationManager.this.loadingDialog.getWindow();
                theWindow.requestFeature(1);
                WindowManager.LayoutParams attribute = theWindow.getAttributes();
                attribute.softInputMode = 1;
                MapViewLocationManager.this.loadingDialog.setMessage((CharSequence)"\ud604\uc7ac \uc704\uce58\ub97c \ucc3e\uace0 \uc788\uc2b5\ub2c8\ub2e4.");
                MapViewLocationManager.this.loadingDialog.setCanceledOnTouchOutside(false);
                MapViewLocationManager.this.loadingDialog.setOnCancelListener((DialogInterface.OnCancelListener)MapViewLocationManager.this);
                MapViewLocationManager.this.loadingDialog.setButton((CharSequence)"\ucde8\uc18c", (DialogInterface.OnClickListener)MapViewLocationManager.this);
                theWindow.setAttributes(attribute);
                try {
                    MapViewLocationManager.this.loadingDialog.show();
                }
                catch (WindowManager.BadTokenException badTokenException) {
                    // empty catch block
                }
            }
        });
    }

    private void hideLoadingIndicator() {
        if (this.loadingDialog == null || !this.loadingDialog.isShowing()) {
            return;
        }
        if (this.dmapActivity == null || this.dmapActivity.isFinishing()) {
            return;
        }
        this.dmapActivity.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                if (MapViewLocationManager.this.loadingDialog != null && MapViewLocationManager.this.loadingDialog.isShowing()) {
                    MapViewLocationManager.this.loadingDialog.dismiss();
                    MapViewLocationManager.this.loadingDialog = null;
                }
            }
        });
    }

    public void onCancel(DialogInterface dialog) {
        this.hideLoadingIndicator();
        InternalMapViewAccessor.callMapView_onCurrentLocationUpdateCancelled();
        MapView mapView = InternalMapViewAccessor.getCurrentMapViewInstance();
        mapView.setCurrentLocationTrackingMode(MapView.CurrentLocationTrackingMode.TrackingModeOff);
    }

    public void onClick(DialogInterface dialog, int which) {
        this.hideLoadingIndicator();
        InternalMapViewAccessor.callMapView_onCurrentLocationUpdateCancelled();
        MapView mapView = InternalMapViewAccessor.getCurrentMapViewInstance();
        mapView.setCurrentLocationTrackingMode(MapView.CurrentLocationTrackingMode.TrackingModeOff);
    }

    private class GpsSeekingTimerTask
    extends TimerTask {
        private GpsSeekingTimerTask() {
        }

        @Override
        public void run() {
            long endTime = SystemClock.elapsedRealtime();
            if (endTime - MapViewLocationManager.this.startTimerTime > 40000L) {
                MapViewLocationManager.this.cancelTimer();
                InternalMapViewAccessor.callMapView_onCurrentLocationUpdateFailed();
            }
        }
    }

    class BestInactiveLocationProviderListener
    implements android.location.LocationListener {
        BestInactiveLocationProviderListener() {
        }

        public void onLocationChanged(Location l) {
        }

        public void onProviderDisabled(String provider) {
        }

        public void onStatusChanged(String provider, int status, Bundle extras) {
        }

        public void onProviderEnabled(String provider) {
            MapViewLocationManager.this.locationManager.removeUpdates((android.location.LocationListener)MapViewLocationManager.this.bestInactiveLocationProviderListener);
            MapViewLocationManager.this.requestLocationUpdate();
        }
    }

    private class LocationListener
    implements android.location.LocationListener {
        public void onLocationChanged(final Location newLocation) {
            MapViewLocationManager.this.cancelTimer();
            MapViewLocationManager.this.makeTimeStampIfFirstLoading();
            MapViewLocationManager.this.hideLoadingIndicator();
            MapCoordLatLng latLng = new MapCoordLatLng(newLocation.getLatitude(), newLocation.getLongitude());
            final MapCoord currentLocation = latLng.toWcong();
            if (currentLocation == null) {
                return;
            }
            NativeMapCoord nativeCoord = new NativeMapCoord(currentLocation);
            if (!NativeMapController.isValidMapCoordForSouthKorea(nativeCoord)) {
                return;
            }
            Runnable task = new Runnable(){

                @Override
                public void run() {
                    MapViewController.getInstance().showLocationMarkerWithAnimation(currentLocation, true, false);
                    if (MapViewLocationManager.this.isUsingMapMove) {
                        MapController.getInstance().move2(currentLocation);
                    }
                    float locationAccuracy = newLocation.getAccuracy();
                    MapViewLocationManager.this.updateLocationMarkerWithAccuracy(locationAccuracy);
                }
            };
            MainQueueManager.getInstance().queueToMainQueue(task);
            InternalMapViewAccessor.callMapView_onCurrentLocationUpdate(newLocation.getLatitude(), newLocation.getLongitude(), newLocation.getAccuracy());
        }

        public void onProviderEnabled(String provider) {
        }

        public void onProviderDisabled(String provider) {
            MapViewLocationManager.this.requestLocationUpdate();
        }

        public void onStatusChanged(String provider, int status, Bundle extras) {
            if (provider.equals("gps")) {
                switch (status) {
                    case 0: {
                        MapViewLocationManager.this.requestLocationUpdate();
                        break;
                    }
                }
            }
        }
    }

    private class HeadingEventListener
    implements SensorEventListener {
        private HeadingEventListener() {
        }

        public void onAccuracyChanged(Sensor arg0, int arg1) {
        }

        public void onSensorChanged(SensorEvent event) {
            float heading = event.values[0];
            Display display = ((WindowManager)MapViewLocationManager.this.dmapActivity.getSystemService("window")).getDefaultDisplay();
            if (display.getOrientation() == 1) {
                heading += 90.0f;
            } else if (display.getOrientation() == 3) {
                heading += 270.0f;
            }
            if (MapViewLocationManager.this.isTrackingMarkerHeading) {
                MapViewController.getInstance().setLocationMarkerRotation(heading, false);
            } else {
                MapController.getInstance().setMapGroundAngleWithAnimation(heading, true);
                InternalMapViewAccessor.callMapView_onCurrentLocationDeviceHeadingUpdate(heading);
            }
        }
    }
}

