/*
 * Decompiled with CFR 0.152.
 */
package net.daum.mf.map.api;

import net.daum.android.map.MapController;
import net.daum.android.map.coord.MapCoord;
import net.daum.android.map.coord.MapCoordLatLng;

public class MapPoint {
    private MapCoord _internalCoord;

    private MapPoint(MapCoord mapCoordWCONG) {
        this._internalCoord = mapCoordWCONG;
    }

    public static MapPoint mapPointWithGeoCoord(double latitude, double longitude) {
        MapCoordLatLng mapCoordWGS84 = new MapCoordLatLng(latitude, longitude);
        MapCoord mapCoordWCONG = mapCoordWGS84.toWcong();
        return new MapPoint(mapCoordWCONG);
    }

    public static MapPoint mapPointWithWCONGCoord(double xWCONG, double yWCONG) {
        MapCoord mapCoordWCONG = new MapCoord(xWCONG, yWCONG, 2);
        return new MapPoint(mapCoordWCONG);
    }

    public static MapPoint mapPointWithCONGCoord(double xCONG, double yCONG) {
        MapCoord mapCoordCONG = new MapCoord(xCONG, yCONG, 1);
        MapCoord mapCoordWCONG = mapCoordCONG.toWcong();
        return new MapPoint(mapCoordWCONG);
    }

    public static MapPoint mapPointWithScreenLocation(double xPixel, double yPixel) {
        MapCoord mapCoordWCONG = MapController.getInstance().convertGraphicPixelCoordToMapCoord(new MapCoord(xPixel, yPixel));
        return new MapPoint(mapCoordWCONG);
    }

    public GeoCoordinate getMapPointGeoCoord() {
        MapCoordLatLng mapCoordLatLng = this._internalCoord.toWgs();
        return new GeoCoordinate(mapCoordLatLng.getLatitude(), mapCoordLatLng.getLongitude());
    }

    public PlainCoordinate getMapPointWCONGCoord() {
        return new PlainCoordinate(this._internalCoord.getX(), this._internalCoord.getY());
    }

    public PlainCoordinate getMapPointCONGCoord() {
        MapCoord mapCoordCONG = this._internalCoord.toCong();
        return new PlainCoordinate(mapCoordCONG.getX(), mapCoordCONG.getY());
    }

    public PlainCoordinate getMapPointScreenLocation() {
        MapCoord mapCoordScreenLocation = MapController.getInstance().convertMapCoordToGraphicPixelCoord(this._internalCoord);
        return new PlainCoordinate(mapCoordScreenLocation.getX(), mapCoordScreenLocation.getY());
    }

    MapCoord getInternalCoordObject() {
        return this._internalCoord;
    }

    public static class PlainCoordinate {
        public double x;
        public double y;

        public PlainCoordinate(double x, double y) {
            this.x = x;
            this.y = y;
        }
    }

    public static class GeoCoordinate {
        public double latitude;
        public double longitude;

        public GeoCoordinate(double latitude, double longitude) {
            this.latitude = latitude;
            this.longitude = longitude;
        }
    }
}

