/*
 * Decompiled with CFR 0.152.
 */
package net.daum.mf.map.common.io;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;

public class IoUtils {
    private static final String TAG = "IoUtils";

    public static void fastChannelCopy(ReadableByteChannel inputChannel, WritableByteChannel outputChannel) throws IOException {
        ByteBuffer buffer = ByteBuffer.allocateDirect(16384);
        while (inputChannel.read(buffer) != -1) {
            buffer.flip();
            outputChannel.write(buffer);
            buffer.compact();
        }
        buffer.flip();
        while (buffer.hasRemaining()) {
            outputChannel.write(buffer);
        }
    }

    public static int safeLongToInt(long l) throws IllegalArgumentException {
        if (l < Integer.MIN_VALUE || l > Integer.MAX_VALUE) {
            throw new IllegalArgumentException(l + " cannot be cast to int without changing its value.");
        }
        return (int)l;
    }
}

