/*
 * Decompiled with CFR 0.152.
 */
package com.kakao.util.maps.helper;

import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.Signature;
import android.util.Base64;
import android.util.Log;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public final class Utility {
    private static final String TAG = Utility.class.getCanonicalName();

    public static PackageInfo getPackageInfo(Context context, int flag) {
        try {
            return context.getPackageManager().getPackageInfo(context.getPackageName(), flag);
        }
        catch (PackageManager.NameNotFoundException e) {
            Log.w((String)TAG, (String)"Unable to get PackageInfo", (Throwable)e);
            return null;
        }
    }

    public static String getKeyHash(Context context) {
        PackageInfo packageInfo = Utility.getPackageInfo(context, 64);
        if (packageInfo == null) {
            return null;
        }
        for (Signature signature : packageInfo.signatures) {
            try {
                MessageDigest md = MessageDigest.getInstance("SHA");
                md.update(signature.toByteArray());
                return Base64.encodeToString((byte[])md.digest(), (int)2);
            }
            catch (NoSuchAlgorithmException e) {
                Log.w((String)TAG, (String)("Unable to get MessageDigest. signature=" + signature), (Throwable)e);
            }
        }
        return null;
    }

    public static String getMetadata(Context context, String key) {
        try {
            ApplicationInfo ai = context.getPackageManager().getApplicationInfo(context.getPackageName(), 128);
            if (ai == null) {
                return null;
            }
            if (ai.metaData == null) {
                return null;
            }
            return ai.metaData.getString(key);
        }
        catch (PackageManager.NameNotFoundException e) {
            return null;
        }
    }
}

