/*
 * Decompiled with CFR 0.152.
 */
package net.daum.android.map;

import android.content.Context;
import android.graphics.PointF;
import android.opengl.alt.GLSurfaceView;
import android.util.AttributeSet;
import android.view.MotionEvent;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.microedition.khronos.egl.EGLConfig;
import javax.microedition.khronos.opengles.GL10;
import net.daum.android.map.MapController;
import net.daum.android.map.MapEngineManager;
import net.daum.android.map.MapViewEventListener;
import net.daum.android.map.MapViewTouchEventListener;
import net.daum.android.map.coord.MapCoord;
import net.daum.mf.map.common.MapThreadScheduling;
import net.daum.mf.map.n.api.NativeMapViewUiEvent;
import net.daum.mf.map.n.api.internal.NativeMapGraphicsViewGles;
import net.daum.mf.map.task.MainQueueHandler;
import net.daum.mf.map.task.WaitQueueManager;

public class MapView
extends GLSurfaceView
implements GLSurfaceView.Renderer,
MainQueueHandler {
    private static boolean _needToRecreate = true;
    private NativeMapGraphicsViewGles nativeGraphicsViewGles;
    private MotionEvent lastEvent = null;
    private PointF _lastDisplacement = new PointF(0.0f, 0.0f);
    private PointF _lastDisplacementSecond = new PointF(0.0f, 0.0f);
    private ConcurrentLinkedQueue<Object> eventQueue = new ConcurrentLinkedQueue();
    private AtomicBoolean isRunning = new AtomicBoolean();
    private AtomicBoolean mapViewUpdated = new AtomicBoolean();
    private boolean hasSurface = false;
    private boolean isValidSurface = false;
    private boolean initialized = false;
    private MapViewTouchEventListener touchEventListener;
    private MapViewEventListener mapViewEventListener;

    private void init() {
        this.setRenderer(this);
        this.setFocusableInTouchMode(true);
        this.nativeGraphicsViewGles = new NativeMapGraphicsViewGles();
    }

    public MapView(Context context) {
        super(context);
        this.init();
    }

    public MapView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    public MapView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs);
        this.init();
    }

    public boolean onTouchEvent(MotionEvent event) {
        if (event.getAction() == 2 && this.ignoreMotionEvent(event)) {
            return true;
        }
        this.queueMapEvent(new NativeMapViewUiEvent(event));
        if (event.getAction() == 1) {
            this.lastEvent = null;
            this._lastDisplacement.set(0.0f, 0.0f);
            this._lastDisplacementSecond.set(0.0f, 0.0f);
        }
        return true;
    }

    protected float calculateDisplacement(float x, float y, float lastX, float lastY, PointF resultDisplacement) {
        float diffX = x - lastX;
        float diffY = y - lastY;
        if (Math.abs(diffX) < 1.0f && Math.abs(diffY) < 1.0f) {
            return 0.0f;
        }
        float vectorSize = (float)Math.sqrt(diffX * diffX + diffY * diffY);
        float normalizedX = diffX / vectorSize;
        float normalizedY = diffY / vectorSize;
        float lastDisplacementX = resultDisplacement.x;
        float lastDisplacementY = resultDisplacement.y;
        float dotProduct = lastDisplacementX * normalizedX + lastDisplacementY * normalizedY;
        lastDisplacementX = normalizedX;
        lastDisplacementY = normalizedY;
        resultDisplacement.set(lastDisplacementX, lastDisplacementY);
        return dotProduct;
    }

    protected boolean ignoreMotionEvent(MotionEvent event) {
        float dotProductFirstTouch = 1.0f;
        float dotProductSecondTouch = 1.0f;
        if (this.lastEvent != null) {
            dotProductFirstTouch = this.calculateDisplacement(event.getX(), event.getY(), this.lastEvent.getX(), this.lastEvent.getY(), this._lastDisplacement);
            if (event.getPointerCount() > 1 && this.lastEvent.getPointerCount() > 1) {
                dotProductSecondTouch = this.calculateDisplacement(event.getX(1), event.getY(1), this.lastEvent.getX(1), this.lastEvent.getY(1), this._lastDisplacementSecond);
            }
        }
        this.lastEvent = MotionEvent.obtain((MotionEvent)event);
        return dotProductFirstTouch < 0.9f || dotProductSecondTouch < 0.9f;
    }

    public boolean onTrackballEvent(final MotionEvent event) {
        Runnable task = new Runnable(){

            @Override
            public void run() {
                float defaultDisplacement = 250.0f;
                MapController mapController = MapController.getInstance();
                float zoomLevel = 1.0f / mapController.getZoom();
                MapCoord coord = mapController.getCurrentMapViewpoint();
                float directionX = 1.0f;
                float directionY = 1.0f;
                if ((double)event.getX() == 0.0) {
                    directionX = 0.0f;
                } else if (event.getX() < 0.0f) {
                    directionX = -1.0f;
                }
                if ((double)event.getY() == 0.0) {
                    directionY = 0.0f;
                } else if (event.getY() < 0.0f) {
                    directionY = -1.0f;
                }
                MapCoord newCoord = new MapCoord(coord.getX() + (double)(directionX * 250.0f * zoomLevel), coord.getY() - (double)(directionY * 250.0f * zoomLevel));
                MapController.getInstance().move(newCoord);
            }
        };
        this.queueToMainQueue(task);
        return true;
    }

    void forceDestroyGraphicsView() {
        super.onDetachedFromWindow();
    }

    void queueMapEvent(Object event) {
        MapThreadScheduling.forceContinue();
        this.eventQueue.add(event);
    }

    @Override
    public void queueToMainQueue(Runnable task) {
        MapThreadScheduling.forceContinue();
        this.queueEvent(task);
    }

    @Override
    public void onSurfaceCreated(GL10 gl, EGLConfig config) {
        this.nativeGraphicsViewGles.onInitMapView();
        this.hasSurface = true;
        MapEngineManager.getInstance().resumeMapEngine();
    }

    @Override
    public void onSurfaceChanged(GL10 gl, int w, int h) {
        this.nativeGraphicsViewGles.onSizeChangedMapView(w, h, 0, 0);
        this.isValidSurface = true;
        if (this.mapViewEventListener != null && !this.initialized) {
            this.mapViewEventListener.onLoadMapView();
            this.initialized = true;
        }
    }

    @Override
    public void onDrawFrame(GL10 gl) {
        if (this.isRunning.get() && this.isValidSurface && this.hasSurface) {
            while (!this.eventQueue.isEmpty()) {
                Object event = this.eventQueue.poll();
                if (event == null) continue;
                this.onUiEvent((NativeMapViewUiEvent)event);
            }
            int res = this.nativeGraphicsViewGles.onDrawMapView(null);
            if (res == 1) {
                this.mapViewUpdated.set(true);
            } else {
                this.mapViewUpdated.set(false);
            }
        }
    }

    @Override
    public void onBeforeFinished(GL10 gl) {
        if (this.isRunning.get() && this.isValidSurface) {
            _needToRecreate = true;
            this.nativeGraphicsViewGles.onBeforeFinishedMapView();
        }
    }

    @Override
    public void onAfterFinished(GL10 gl) {
        this.isRunning.set(false);
    }

    @Override
    public boolean needsSwap(GL10 gl) {
        if (!this.mapViewUpdated.get()) {
            return false;
        }
        return !MapEngineManager.getInstance().getStopGlSwap();
    }

    @Override
    public void didSwap(GL10 gl) {
        if (_needToRecreate) {
            _needToRecreate = false;
        }
    }

    void onPauseActivity() {
        this.mapViewUpdated.set(false);
        this.onPause();
    }

    void onResumeActivity() {
        this.onResume();
        this.isRunning.set(true);
    }

    void onUiEvent(NativeMapViewUiEvent event) {
        MapThreadScheduling.forceContinue();
        this.nativeGraphicsViewGles.onUiEventMapView(event);
    }

    @Override
    public void onLoopWhenPaused(GL10 gl) {
        WaitQueueManager.getInstance().onLoop();
    }

    public MapViewTouchEventListener getTouchEventListener() {
        return this.touchEventListener;
    }

    public void setTouchEventListener(MapViewTouchEventListener touchEventListener) {
        this.touchEventListener = touchEventListener;
    }

    public MapViewEventListener getMapViewEventListener() {
        return this.mapViewEventListener;
    }

    public void setMapViewEventListener(MapViewEventListener mapViewEventListener) {
        this.mapViewEventListener = mapViewEventListener;
    }
}

