/*
 * Decompiled with CFR 0.152.
 */
package net.daum.android.map.util;

import android.content.Context;
import android.content.ContextWrapper;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.view.View;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class BitmapUtils {
    public static Bitmap createBitmapFromView(View v) {
        if (v == null) {
            return null;
        }
        if (v.getMeasuredHeight() <= 0) {
            v.measure(-2, -2);
            Bitmap b = Bitmap.createBitmap((int)v.getMeasuredWidth(), (int)v.getMeasuredHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
            Canvas c = new Canvas(b);
            v.layout(0, 0, v.getMeasuredWidth(), v.getMeasuredHeight());
            v.draw(c);
            return b;
        }
        Bitmap b = Bitmap.createBitmap((int)v.getMeasuredWidth(), (int)v.getMeasuredHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas c = new Canvas(b);
        v.layout(v.getLeft(), v.getTop(), v.getRight(), v.getBottom());
        v.draw(c);
        return b;
    }

    public static Bitmap createBitmapFromDrawable(Drawable drawable) {
        if (drawable == null) {
            return null;
        }
        if (drawable instanceof BitmapDrawable) {
            return ((BitmapDrawable)drawable).getBitmap();
        }
        Bitmap bitmap = Bitmap.createBitmap((int)drawable.getIntrinsicWidth(), (int)drawable.getIntrinsicHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(bitmap);
        drawable.setBounds(0, 0, canvas.getWidth(), canvas.getHeight());
        drawable.draw(canvas);
        return bitmap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File saveBitmapAsPngFile(Context context, Bitmap bmp, String dirPath, String fileName) {
        ContextWrapper cw = new ContextWrapper(context);
        File directory = cw.getDir("dirPath", 0);
        File file = new File(directory, fileName);
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(file);
            bmp.compress(Bitmap.CompressFormat.PNG, 90, (OutputStream)out);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return file;
    }

    public static void deleteFile(Context context, String dirPath, String fileName) {
        ContextWrapper cw = new ContextWrapper(context);
        File directory = cw.getDir("dirPath", 0);
        File file = new File(directory, fileName);
        if (file.exists()) {
            file.delete();
        }
    }

    public static void deleteAllFilesInDirectory(Context context, String dirPath) {
        ContextWrapper cw = new ContextWrapper(context);
        File directory = cw.getDir("dirPath", 0);
        BitmapUtils.purgeDirectory(directory);
    }

    private static void purgeDirectory(File dir) {
        for (File file : dir.listFiles()) {
            if (file.isDirectory()) {
                BitmapUtils.purgeDirectory(file);
            }
            file.delete();
        }
    }
}

