/*
 * Decompiled with CFR 0.152.
 */
package net.daum.mf.map.api;

import android.app.Activity;
import android.content.Context;
import android.content.pm.PackageManager;
import android.graphics.Bitmap;
import android.graphics.PorterDuff;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.util.AttributeSet;
import android.view.Display;
import android.view.SurfaceHolder;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.view.WindowManager;
import android.widget.LinearLayout;
import java.io.File;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Queue;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentLinkedQueue;
import javax.microedition.khronos.opengles.GL10;
import net.daum.android.map.MapController;
import net.daum.android.map.MapEngineManager;
import net.daum.android.map.MapTileVersionCheckWebService;
import net.daum.android.map.coord.MapCoord;
import net.daum.android.map.location.MapViewLocationManager;
import net.daum.android.map.openapi.auth.OpenAPIKeyAuthenticationWebService;
import net.daum.android.map.util.BitmapUtils;
import net.daum.android.map.util.PersistentKeyValueStore;
import net.daum.mf.map.api.CalloutBalloonAdapter;
import net.daum.mf.map.api.CameraUpdate;
import net.daum.mf.map.api.CancelableCallback;
import net.daum.mf.map.api.MapCircle;
import net.daum.mf.map.api.MapCurrentLocationMarker;
import net.daum.mf.map.api.MapPOIItem;
import net.daum.mf.map.api.MapPoint;
import net.daum.mf.map.api.MapPointBounds;
import net.daum.mf.map.api.MapPolyline;
import net.daum.mf.map.common.ResourceUtils;
import net.daum.mf.map.n.api.NativeMapCoord;
import net.daum.mf.map.n.api.NativeTileUrlInfo;
import net.daum.mf.map.n.api.internal.NativeCircleOverlayManager;
import net.daum.mf.map.n.api.internal.NativeMapBuildSettings;
import net.daum.mf.map.n.api.internal.NativeMapController;
import net.daum.mf.map.n.api.internal.NativeMapLocationManager;
import net.daum.mf.map.n.api.internal.NativePOIItemMarkerManager;
import net.daum.mf.map.n.api.internal.NativePolylineOverlayManager;
import net.daum.mf.map.task.MainQueueManager;
import net.daum.mf.map.task.MapTaskManager;

public class MapView
extends net.daum.android.map.MapView
implements OpenAPIKeyAuthenticationWebService.OpenAPIKeyAuthenticationResultListener,
MapTileVersionCheckWebService.MapTileVersionCheckResultListener {
    public static float MAX_ZOOM_LEVEL = 12.0f;
    public static float MIN_ZOOM_LEVEL = -2.0f;
    private static boolean MapEngineIsActive = false;
    static MapView CurrentMapViewInstance = null;
    private WeakReference<Activity> dmapActivity;
    private String apiKey;
    private Queue<MapPOIItem> poiItems;
    private ArrayList<MapPolyline> polylines;
    private ArrayList<MapCircle> circles;
    private WeakReference<OpenAPIKeyAuthenticationResultListener> openAPIKeyAuthenticationResultListener;
    private WeakReference<MapViewEventListener> mapViewEventListener;
    private WeakReference<CurrentLocationEventListener> currentLocationEventListener;
    private WeakReference<POIItemEventListener> poiItemEventListener;
    private CalloutBalloonAdapter calloutBalloonAdapter;
    private boolean mapEngineLoadedForThisMapView;
    boolean dragStarted = false;
    private MapPoint dragStartedMapPoint = null;
    private boolean needSynchronousCalloutBalloonGeneration = false;
    private static boolean IsMapTilePersistentCacheEnabled = false;
    private static CurrentLocationTrackingMode currentLocationTrackingMode = CurrentLocationTrackingMode.TrackingModeOff;
    private OpenAPIKeyAuthenticationWebService openAPIKeyAuthService = null;
    private MapTileVersionCheckWebService mapTileVersionCheckWebService = null;
    Timer cameraAnimationTimer;
    CancelableCallback cameraAnimationCancelableCallback;
    private final float DEFAULT_CAMERA_ANIMATION_DURATION = 1000.0f;
    private final long CAMERA_ANIMATION_TIMER_PERIOD = 33L;
    private final int CAMERA_ANIMATION_PHASE_COUNT = 2;
    boolean isFirstOnDrawFrame = true;

    public static boolean isMapTilePersistentCacheEnabled() {
        String GALAXYS = "SHW-M110S";
        String GALAXYK = "SHW-M130K";
        if ("SHW-M110S".equals(Build.MODEL) || "SHW-M130K".equals(Build.MODEL)) {
            return false;
        }
        return IsMapTilePersistentCacheEnabled;
    }

    public static void setMapTilePersistentCacheEnabled(boolean enableCache) {
        IsMapTilePersistentCacheEnabled = enableCache;
    }

    public static void clearMapTilePersistentCache() {
        if (CurrentMapViewInstance != null) {
            MapController.getInstance().resetMapTileCache();
        } else {
            MapController.getInstance().resetMapTileCacheRunOnCurrentThread();
        }
    }

    private void init(Activity activity) {
        if (MapEngineIsActive) {
            throw new RuntimeException("DaumMap does not support that two or more net.daum.mf.map.api.MapView objects exists at the same time");
        }
        CurrentMapViewInstance = this;
        MapEngineManager.getInstance().onCreateMapActivity((Context)activity, this);
        MapEngineManager.getInstance().onStartMapActivity();
        MapViewLocationManager.getInstance().setMapActivity(activity);
        MapEngineIsActive = true;
        this.dmapActivity = new WeakReference<Activity>(activity);
        this.poiItems = new ConcurrentLinkedQueue<MapPOIItem>();
        this.polylines = new ArrayList(8);
        this.circles = new ArrayList(16);
        this.openAPIKeyAuthenticationResultListener = null;
        this.mapViewEventListener = null;
        this.currentLocationEventListener = null;
        this.poiItemEventListener = null;
        this.mapEngineLoadedForThisMapView = false;
        this.setMapType(MapType.Standard);
        this.needSynchronousCalloutBalloonGeneration = Build.VERSION.SDK_INT <= 10 || Build.MODEL != null && Build.MODEL.startsWith("SHV-E160") || Build.MODEL != null && Build.MODEL.startsWith("IM-A830S");
    }

    public MapView(Activity activity) {
        super((Context)activity);
        this.init(activity);
    }

    public MapView(Context context) {
        super(context);
        if (!(context instanceof Activity)) {
            throw new RuntimeException("net.daum.mf.map.api.MapView.MapView constructors should get Activity instance as context input parameter");
        }
        this.init((Activity)context);
    }

    public MapView(Context context, AttributeSet attrs) {
        super(context, attrs);
        if (!(context instanceof Activity)) {
            throw new RuntimeException("net.daum.mf.map.api.MapView.MapView constructors should get Activity instance as context input parameter");
        }
        this.init((Activity)context);
    }

    public MapView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        if (!(context instanceof Activity)) {
            throw new RuntimeException("net.daum.mf.map.api.MapView.MapView constructors should get Activity instance as context input parameter");
        }
        this.init((Activity)context);
    }

    @Override
    public void surfaceCreated(SurfaceHolder holder) {
        super.surfaceCreated(holder);
        MapEngineManager.getInstance().onResumeMapActivity();
        MapViewLocationManager.getInstance().onResumeMapActivity();
        if (NativeMapBuildSettings.isOpenAPIMapLibraryBuild()) {
            String apiKey = this.getDaumMapApiKey();
            String appId = null;
            if (this.dmapActivity.get() != null) {
                appId = ((Activity)this.dmapActivity.get()).getPackageName();
            }
            String appVersion = null;
            try {
                if (this.dmapActivity.get() != null) {
                    Activity activity = (Activity)this.dmapActivity.get();
                    appVersion = activity.getPackageManager().getPackageInfo((String)activity.getPackageName(), (int)0).versionName;
                }
            }
            catch (PackageManager.NameNotFoundException nameNotFoundException) {
                // empty catch block
            }
            this.openAPIKeyAuthService = new OpenAPIKeyAuthenticationWebService((Context)this.dmapActivity.get(), apiKey, appId, appVersion, this);
            this.openAPIKeyAuthService.requestOpenAPIKeyAuthenticationService();
        } else {
            this.mapTileVersionCheckWebService = new MapTileVersionCheckWebService(this);
            this.mapTileVersionCheckWebService.requestMapTileVersionCheckService();
        }
    }

    private void updateTileVersions(String imageTileVersion, String hybridTileVersion, String roadViewTileVersion) {
        boolean currentTileVersionExists = false;
        boolean newImageTileVersion = false;
        boolean newHybridTileVersion = false;
        boolean newRoadViewTileVersion = false;
        Activity activity = (Activity)this.dmapActivity.get();
        if (activity == null) {
            return;
        }
        PersistentKeyValueStore keyValueStore = new PersistentKeyValueStore((Context)activity);
        if (imageTileVersion != null && (imageTileVersion = imageTileVersion.trim()).length() > 0) {
            currentTileVersionExists = true;
            if (!imageTileVersion.equals(keyValueStore.getLastImageTileVersion())) {
                keyValueStore.setLastImageTileVersion(imageTileVersion);
                newImageTileVersion = true;
            }
        }
        if (hybridTileVersion != null && (hybridTileVersion = hybridTileVersion.trim()).length() > 0) {
            currentTileVersionExists = true;
            if (!hybridTileVersion.equals(keyValueStore.getLastHybridTileVersion())) {
                keyValueStore.setLastHybridTileVersion(hybridTileVersion);
                newHybridTileVersion = true;
            }
        }
        if (roadViewTileVersion != null && (roadViewTileVersion = roadViewTileVersion.trim()).length() > 0) {
            currentTileVersionExists = true;
            if (!roadViewTileVersion.equals(keyValueStore.getLastRoadViewTileVersion())) {
                keyValueStore.setLastRoadViewTileVersion(roadViewTileVersion);
                newRoadViewTileVersion = true;
            }
        }
        if (!currentTileVersionExists || newImageTileVersion || newHybridTileVersion || newRoadViewTileVersion) {
            Runnable task = new Runnable(){

                @Override
                public void run() {
                    NativeTileUrlInfo.resetToDefaultTileVersion();
                    NativeMapController mapController = new NativeMapController();
                    mapController.resetMapTileCache();
                }
            };
            MainQueueManager.getInstance().queueToMainQueue(task);
            return;
        }
    }

    @Override
    public void onAuthenticationResultReceived(int resultCode, String message, String imageTileVersion, String hybridTileVersion, String roadViewTileVersion) {
        this.onOpenAPIKeyAuthenticationResult(resultCode, message);
        if (this.dmapActivity.get() == null) {
            return;
        }
        this.updateTileVersions(imageTileVersion, hybridTileVersion, roadViewTileVersion);
    }

    @Override
    public void onAuthenticationErrorOccured() {
        Activity activity = (Activity)this.dmapActivity.get();
        if (activity == null) {
            return;
        }
        activity.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                MapEngineManager.getInstance().onPauseMapActivity();
            }
        });
    }

    @Override
    public void onMapTileVersionCheckResultReceived(String imageTileVersion, String hybridTileVersion, String roadViewTileVersion) {
        this.updateTileVersions(imageTileVersion, hybridTileVersion, roadViewTileVersion);
    }

    @Override
    public void onMapTileVersionCheckServiceErrorOccured() {
    }

    public void onSurfaceDestroyed() {
        MapEngineManager.getInstance().onPauseMapActivity();
        MapViewLocationManager.getInstance().onPauseMapActivity();
        MapEngineIsActive = false;
    }

    @Override
    public void surfaceDestroyed(SurfaceHolder holder) {
        this.onSurfaceDestroyed();
        super.surfaceDestroyed(holder);
    }

    @Override
    public void surfaceChanged(SurfaceHolder holder, int format, int w, int h) {
        super.surfaceChanged(holder, format, w, h);
    }

    @Override
    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        NativePOIItemMarkerManager.removeAllPOIItemMarkers();
        NativePolylineOverlayManager.removeAllPolylines();
        NativeCircleOverlayManager.removeAllCircles();
        this.poiItems.clear();
        this.polylines.clear();
        this.circles.clear();
        MapEngineManager.getInstance().onStopMapActivity();
        MapEngineIsActive = false;
        this.dmapActivity.clear();
    }

    @Deprecated
    public void setDaumMapApiKey(String apiKey) {
        this.apiKey = apiKey;
    }

    String getDaumMapApiKey() {
        return this.apiKey;
    }

    public void setOpenAPIKeyAuthenticationResultListener(OpenAPIKeyAuthenticationResultListener openAPIKeyAuthListener) {
        this.openAPIKeyAuthenticationResultListener = new WeakReference<OpenAPIKeyAuthenticationResultListener>(openAPIKeyAuthListener);
    }

    public void setMapViewEventListener(MapViewEventListener mapViewEventListener) {
        this.mapViewEventListener = new WeakReference<MapViewEventListener>(mapViewEventListener);
    }

    public void setCurrentLocationEventListener(CurrentLocationEventListener currentLocationEventListener) {
        this.currentLocationEventListener = new WeakReference<CurrentLocationEventListener>(currentLocationEventListener);
    }

    public void setPOIItemEventListener(POIItemEventListener poiItemEventListener) {
        this.poiItemEventListener = new WeakReference<POIItemEventListener>(poiItemEventListener);
    }

    public void setCalloutBalloonAdapter(CalloutBalloonAdapter calloutBalloonAdapter) {
        this.calloutBalloonAdapter = calloutBalloonAdapter;
    }

    public MapType getMapType() {
        int mapViewType = MapController.getInstance().getViewType();
        if (mapViewType == 1) {
            return MapType.Standard;
        }
        if (mapViewType == 2) {
            return MapType.Satellite;
        }
        if (mapViewType == 3) {
            return MapType.Hybrid;
        }
        return MapType.Standard;
    }

    public void setMapType(MapType mapType) {
        MapController mapController = MapController.getInstance();
        if (mapType == MapType.Standard) {
            mapController.setViewType(1);
        } else if (mapType == MapType.Satellite) {
            mapController.setViewType(2);
        } else if (mapType == MapType.Hybrid) {
            mapController.setViewType(3);
        }
        mapController.setNeedsRefreshTiles();
    }

    public boolean isHDMapTileEnabled() {
        MapController mapController = MapController.getInstance();
        return mapController.isHDMapTileEnabled();
    }

    public void setHDMapTileEnabled(boolean enabled) {
        MapController mapController = MapController.getInstance();
        mapController.setHDMapTileEnabled(enabled, true);
    }

    public MapTileMode getMapTileMode() {
        MapController mapController = MapController.getInstance();
        int tileMode = mapController.getMapTileMode();
        if (tileMode == 200) {
            return MapTileMode.HD2X;
        }
        if (tileMode == 100) {
            return MapTileMode.HD;
        }
        return MapTileMode.Standard;
    }

    public void setMapTileMode(MapTileMode tileMode) {
        MapController mapController = MapController.getInstance();
        if (tileMode == MapTileMode.HD2X) {
            mapController.setMapTileMode(200, false);
        } else if (tileMode == MapTileMode.HD) {
            mapController.setMapTileMode(100, false);
        } else {
            mapController.setMapTileMode(0, false);
        }
    }

    public void setCurrentLocationTrackingMode(CurrentLocationTrackingMode trackingMode) {
        int trackingModeInt = 1;
        boolean isUsingMapMove = false;
        boolean trackMarkerHeading = false;
        if (trackingMode == CurrentLocationTrackingMode.TrackingModeOnWithoutHeading) {
            trackingModeInt = 2;
            isUsingMapMove = true;
        } else if (trackingMode == CurrentLocationTrackingMode.TrackingModeOnWithHeading) {
            trackingModeInt = 3;
            isUsingMapMove = true;
        } else if (trackingMode == CurrentLocationTrackingMode.TrackingModeOnWithoutHeadingWithoutMapMoving) {
            trackingModeInt = 4;
            isUsingMapMove = false;
        } else if (trackingMode == CurrentLocationTrackingMode.TrackingModeOnWithHeadingWithoutMapMoving) {
            trackingModeInt = 5;
            isUsingMapMove = false;
        } else if (trackingMode == CurrentLocationTrackingMode.TrackingModeOnWithMarkerHeadingWithoutMapMoving) {
            trackingModeInt = 5;
            isUsingMapMove = false;
            trackMarkerHeading = true;
        }
        MapViewLocationManager.getInstance().init();
        MapViewLocationManager.getInstance().setUsingMapMove(isUsingMapMove);
        MapViewLocationManager.getInstance().setMarkerHeadingTracking(trackMarkerHeading);
        NativeMapLocationManager.setCurrentLocationTrackingMode(trackingModeInt);
    }

    public CurrentLocationTrackingMode getCurrentLocationTrackingMode() {
        int trackingModeInt = NativeMapLocationManager.getCurrentLocationTrackingMode();
        if (trackingModeInt == 2) {
            return CurrentLocationTrackingMode.TrackingModeOnWithoutHeading;
        }
        if (trackingModeInt == 3) {
            return CurrentLocationTrackingMode.TrackingModeOnWithHeading;
        }
        if (trackingModeInt == 4) {
            return CurrentLocationTrackingMode.TrackingModeOnWithoutHeadingWithoutMapMoving;
        }
        if (trackingModeInt == 5) {
            if (MapViewLocationManager.getInstance().getMarkerHeadingTracking()) {
                return CurrentLocationTrackingMode.TrackingModeOnWithMarkerHeadingWithoutMapMoving;
            }
            return CurrentLocationTrackingMode.TrackingModeOnWithHeadingWithoutMapMoving;
        }
        return CurrentLocationTrackingMode.TrackingModeOff;
    }

    public void setShowCurrentLocationMarker(boolean show) {
        NativeMapLocationManager.setShowCurrentLocationMarker(show);
    }

    public boolean isShowingCurrentLocationMarker() {
        return NativeMapLocationManager.isShowingCurrentLocationMarker();
    }

    public void setCurrentLocationMarker(final MapCurrentLocationMarker marker) {
        NativeMapLocationManager.setCurrentLocationRadius(marker.getRadius());
        NativeMapLocationManager.setCurrentLocationRadiusStrokeColor(marker.getRadiusStrokeColor());
        NativeMapLocationManager.setCurrentLocationRadiusFillColor(marker.getRadiusFillColor());
        Runnable task = new Runnable(){

            @Override
            public void run() {
                int directionImageId;
                int trackingOffImageId;
                int[] trackingAnimationImageIds = marker.getTrackingAnimationImageIds();
                float[] trackingAnimationImageAnchorRatioXs = marker.getTrackingAnimationImageAnchorRatioX();
                float[] trackingAnimationImageAnchorRatioYs = marker.getTrackingAnimationImageAnchorRatioY();
                if (trackingAnimationImageIds != null && trackingAnimationImageIds.length > 0) {
                    int count = trackingAnimationImageIds.length;
                    String[] paths = new String[count];
                    int[] widths = new int[count];
                    int[] heights = new int[count];
                    int[] anchorPointX = new int[count];
                    int[] anchorPointY = new int[count];
                    for (int i = 0; i < trackingAnimationImageIds.length; ++i) {
                        int trackingAnimationImageId = trackingAnimationImageIds[i];
                        paths[i] = MapView.this.getCustomImageResourcePath(trackingAnimationImageId);
                        widths[i] = -1;
                        heights[i] = -1;
                        Drawable drawable = MapView.this.getContext().getResources().getDrawable(trackingAnimationImageId);
                        if (drawable != null) {
                            widths[i] = drawable.getIntrinsicWidth();
                            heights[i] = drawable.getIntrinsicHeight();
                        }
                        float trackingAnimationImageAnchorRatioX = 0.5f;
                        float trackingAnimationImageAnchorRatioY = 0.5f;
                        if (i < trackingAnimationImageAnchorRatioXs.length) {
                            trackingAnimationImageAnchorRatioX = Math.min(1.0f, trackingAnimationImageAnchorRatioXs[i]);
                        }
                        if (i < trackingAnimationImageAnchorRatioYs.length) {
                            trackingAnimationImageAnchorRatioY = Math.min(1.0f, trackingAnimationImageAnchorRatioYs[i]);
                        }
                        int trackingAnimationImageAnchorOffsetX = Math.round((float)widths[i] * trackingAnimationImageAnchorRatioX);
                        int trackingAnimationImageAnchorOffsetY = Math.round((float)heights[i] * trackingAnimationImageAnchorRatioY);
                        trackingAnimationImageAnchorOffsetY = Math.max(0, heights[i] - trackingAnimationImageAnchorOffsetY);
                        anchorPointX[i] = trackingAnimationImageAnchorOffsetX;
                        anchorPointY[i] = trackingAnimationImageAnchorOffsetY;
                    }
                    NativeMapLocationManager.setCustomCurrentLocationMarkerTrackingAnimationImages(paths, widths, heights, anchorPointX, anchorPointY, marker.getTrackingAnimationDuration());
                }
                if ((trackingOffImageId = marker.getTrackingOffImageId()) != 0) {
                    int trackingOffImageWidth = -1;
                    int trackingOffImageHeight = -1;
                    Drawable drawable = MapView.this.getContext().getResources().getDrawable(trackingOffImageId);
                    if (drawable != null) {
                        trackingOffImageWidth = drawable.getIntrinsicWidth();
                        trackingOffImageHeight = drawable.getIntrinsicHeight();
                    }
                    float trackingOffImageAnchorRatioX = Math.min(1.0f, marker.getTrackingOffImageAnchorRatioX());
                    float trackingOffImageAnchorRatioY = Math.min(1.0f, marker.getTrackingOffImageAnchorRatioY());
                    int trackingOffImageAnchorOffsetX = Math.round((float)trackingOffImageWidth * trackingOffImageAnchorRatioX);
                    int trackingOffImageAnchorOffsetY = Math.round((float)trackingOffImageHeight * trackingOffImageAnchorRatioY);
                    trackingOffImageAnchorOffsetY = Math.max(0, trackingOffImageHeight - trackingOffImageAnchorOffsetY);
                    NativeMapLocationManager.setCustomCurrentLocationMarkerImage(MapView.this.getCustomImageResourcePath(trackingOffImageId), trackingOffImageWidth, trackingOffImageHeight, trackingOffImageAnchorOffsetX, trackingOffImageAnchorOffsetY, false);
                }
                if ((directionImageId = marker.getDirectionImageId()) != 0) {
                    int directionImageWidth = -1;
                    int directionImageHeight = -1;
                    Drawable drawable = MapView.this.getContext().getResources().getDrawable(directionImageId);
                    if (drawable != null) {
                        directionImageWidth = drawable.getIntrinsicWidth();
                        directionImageHeight = drawable.getIntrinsicHeight();
                    }
                    float directionImageAnchorRatioX = Math.min(1.0f, marker.getDirectionImageAnchorRatioX());
                    float directionImageAnchorRatioY = Math.min(1.0f, marker.getDirectionImageAnchorRatioY());
                    int directionImageAnchorOffsetX = Math.round((float)directionImageWidth * directionImageAnchorRatioX);
                    int directionImageAnchorOffsetY = Math.round((float)directionImageHeight * directionImageAnchorRatioY);
                    directionImageAnchorOffsetY = Math.max(0, directionImageHeight - directionImageAnchorOffsetY);
                    NativeMapLocationManager.setCustomCurrentLocationMarkerDirectionImage(MapView.this.getCustomImageResourcePath(directionImageId), directionImageWidth, directionImageHeight, directionImageAnchorOffsetX, directionImageAnchorOffsetY, false);
                }
            }
        };
        MapTaskManager.getInstance().queueTask(task, MapEngineManager.getInstance().getStopGlSwap());
    }

    public void setCurrentLocationRadius(int meter) {
        NativeMapLocationManager.setCurrentLocationRadius(meter);
    }

    public void setCurrentLocationRadiusStrokeColor(int color) {
        NativeMapLocationManager.setCurrentLocationRadiusStrokeColor(color);
    }

    public void setCurrentLocationRadiusFillColor(int color) {
        NativeMapLocationManager.setCurrentLocationRadiusFillColor(color);
    }

    public void setCustomCurrentLocationMarkerImage(int id, MapPOIItem.ImageOffset anchorPointOffset) {
        Drawable customImageDrawable;
        int anchorPointOffsetX = -1;
        int anchorPointOffsetY = -1;
        if (anchorPointOffset != null) {
            anchorPointOffsetX = anchorPointOffset.offsetX;
            anchorPointOffsetY = anchorPointOffset.offsetY;
        }
        int width = -1;
        int height = -1;
        if (id != 0 && (customImageDrawable = this.getContext().getResources().getDrawable(id)) != null) {
            width = customImageDrawable.getIntrinsicWidth();
            height = customImageDrawable.getIntrinsicHeight();
        }
        final int final_id = id;
        final int final_anchorPointOffsetX = anchorPointOffsetX;
        final int final_anchorPointOffsetY = anchorPointOffsetY;
        final int final_width = width;
        final int final_height = height;
        Runnable task = new Runnable(){

            @Override
            public void run() {
                NativeMapLocationManager.setCustomCurrentLocationMarkerImage(MapView.this.getCustomImageResourcePath(final_id), final_width, final_height, final_anchorPointOffsetX, final_anchorPointOffsetY, true);
            }
        };
        MapTaskManager.getInstance().queueTask(task, MapEngineManager.getInstance().getStopGlSwap());
    }

    public void setCustomCurrentLocationMarkerTrackingImage(int id, MapPOIItem.ImageOffset anchorPointOffset) {
        Drawable customImageDrawable;
        int anchorPointOffsetX = -1;
        int anchorPointOffsetY = -1;
        if (anchorPointOffset != null) {
            anchorPointOffsetX = anchorPointOffset.offsetX;
            anchorPointOffsetY = anchorPointOffset.offsetY;
        }
        int width = -1;
        int height = -1;
        if (id != 0 && (customImageDrawable = this.getContext().getResources().getDrawable(id)) != null) {
            width = customImageDrawable.getIntrinsicWidth();
            height = customImageDrawable.getIntrinsicHeight();
        }
        final int final_id = id;
        final int final_anchorPointOffsetX = anchorPointOffsetX;
        final int final_anchorPointOffsetY = anchorPointOffsetY;
        final int final_width = width;
        final int final_height = height;
        Runnable task = new Runnable(){

            @Override
            public void run() {
                NativeMapLocationManager.setCustomCurrentLocationMarkerTrackingImage(MapView.this.getCustomImageResourcePath(final_id), final_width, final_height, final_anchorPointOffsetX, final_anchorPointOffsetY, true);
            }
        };
        MapTaskManager.getInstance().queueTask(task, MapEngineManager.getInstance().getStopGlSwap());
    }

    public void setCustomCurrentLocationMarkerDirectionImage(int id, MapPOIItem.ImageOffset anchorPointOffset) {
        Drawable customImageDrawable;
        int anchorPointOffsetX = -1;
        int anchorPointOffsetY = -1;
        if (anchorPointOffset != null) {
            anchorPointOffsetX = anchorPointOffset.offsetX;
            anchorPointOffsetY = anchorPointOffset.offsetY;
        }
        int width = -1;
        int height = -1;
        if (id != 0 && (customImageDrawable = this.getContext().getResources().getDrawable(id)) != null) {
            width = customImageDrawable.getIntrinsicWidth();
            height = customImageDrawable.getIntrinsicHeight();
        }
        final int final_id = id;
        final int final_anchorPointOffsetX = anchorPointOffsetX;
        final int final_anchorPointOffsetY = anchorPointOffsetY;
        final int final_width = width;
        final int final_height = height;
        Runnable task = new Runnable(){

            @Override
            public void run() {
                NativeMapLocationManager.setCustomCurrentLocationMarkerDirectionImage(MapView.this.getCustomImageResourcePath(final_id), final_width, final_height, final_anchorPointOffsetX, final_anchorPointOffsetY, true);
            }
        };
        MapTaskManager.getInstance().queueTask(task, MapEngineManager.getInstance().getStopGlSwap());
    }

    public void setDefaultCurrentLocationMarker() {
        Runnable task = new Runnable(){

            @Override
            public void run() {
                NativeMapLocationManager.setDefaultCurrentLocationMarker();
            }
        };
        MapTaskManager.getInstance().queueTask(task, MapEngineManager.getInstance().getStopGlSwap());
    }

    private String getCustomImageResourcePath(int id) {
        if (id == 0) {
            return null;
        }
        return String.format("res:%d", id);
    }

    public MapPoint getMapCenterPoint() {
        MapController mapController = MapController.getInstance();
        MapCoord coord = mapController.getDestinationMapViewpoint();
        return MapPoint.mapPointWithWCONGCoord(coord.getX(), coord.getY());
    }

    public MapPointBounds getMapPointBounds() {
        MapController mapController = MapController.getInstance();
        return mapController.getCurrentMapBounds();
    }

    public int getZoomLevel() {
        return MapController.getInstance().getZoomLevelInt();
    }

    public float getZoomLevelFloat() {
        return MapController.getInstance().getZoomLevelFloat();
    }

    public float getMapRotationAngle() {
        return MapController.getInstance().getMapRotationAngle();
    }

    public void setMapCenterPoint(MapPoint centerPoint, boolean animated) {
        MapController.getInstance().move(centerPoint.getInternalCoordObject(), animated);
    }

    public void setMapCenterPointAndZoomLevel(MapPoint centerPoint, int zoomLevel, boolean animated) {
        MapController.getInstance().move(centerPoint.getInternalCoordObject(), zoomLevel, animated);
    }

    public void setZoomLevel(int zoomLevel, boolean animated) {
        MapController.getInstance().setZoomLevel(zoomLevel, animated);
    }

    public void setZoomLevelFloat(float zoomLevel, boolean animated) {
        MapController.getInstance().setZoomLevel(zoomLevel, animated);
    }

    public void zoomIn(boolean animated) {
        MapController.getInstance().zoomIn(animated);
    }

    public void zoomOut(boolean animated) {
        MapController.getInstance().zoomOut(animated);
    }

    public void setMapRotationAngle(float angle, boolean animated) {
        MapController.getInstance().setMapRotationAngle(angle, animated);
    }

    public void fitMapViewAreaToShowMapPoints(MapPoint[] mapPoints) {
        if (mapPoints == null || mapPoints.length <= 0) {
            return;
        }
        NativeMapCoord[] nativeMapCoords = new NativeMapCoord[mapPoints.length];
        for (int i = 0; i < mapPoints.length; ++i) {
            MapPoint mapPoint = mapPoints[i];
            MapPoint.PlainCoordinate mapPointWCONG = mapPoint.getMapPointWCONGCoord();
            nativeMapCoords[i] = new NativeMapCoord(mapPointWCONG.x, mapPointWCONG.y);
        }
        MapController.getInstance().fitMapViewAreaToShowAllMapPoints(nativeMapCoords);
    }

    public void refreshMapTiles() {
        MapController.getInstance().setNeedsRefreshTiles();
    }

    public void releaseUnusedMapTileImageResources() {
        MapController.getInstance().releaseUnusedMapTileImageResources();
    }

    public MapPOIItem[] getPOIItems() {
        return this.poiItems.toArray(new MapPOIItem[0]);
    }

    public void addPOIItem(final MapPOIItem poiItem) {
        if (poiItem.getItemName() == null) {
            return;
        }
        if (poiItem.getMapPoint() == null) {
            return;
        }
        if (poiItem.getMarkerType() == MapPOIItem.MarkerType.CustomImage && poiItem.getCustomImageResourceId() == 0 && poiItem.getCustomImageBitmap() == null) {
            return;
        }
        if (this.needSynchronousCalloutBalloonGeneration && this.poiItems != null && this.poiItems.size() > 0) {
            long mx = 0L;
            for (MapPOIItem item : this.poiItems) {
                mx = Math.max(mx, item.createdTime);
            }
            if (mx >= poiItem.createdTime) {
                poiItem.createdTime = mx + 1L;
            }
        }
        this.poiItems.add(poiItem);
        final MapPOIItem poiItem_ = poiItem;
        final String itemName = poiItem.getItemName();
        MapPoint mapPoint = poiItem.getMapPoint();
        MapPoint.PlainCoordinate mapPointWCONG = mapPoint.getMapPointWCONGCoord();
        final NativeMapCoord nativeMapPoint = new NativeMapCoord(mapPointWCONG.x, mapPointWCONG.y, 2);
        final int markerType = this.convertMarkerType(poiItem.getMarkerType());
        final int selectedMarkerType = this.convertMarkerType(poiItem.getSelectedMarkerType());
        MapPOIItem.ShowAnimationType showAnimationType_ = poiItem.getShowAnimationType();
        int showAnimationTypeN = showAnimationType_ == MapPOIItem.ShowAnimationType.DropFromHeaven ? 2 : (showAnimationType_ == MapPOIItem.ShowAnimationType.SpringFromGround ? 3 : 1);
        final int showAnimationType = showAnimationTypeN;
        final boolean showCalloutBalloonOnTouch = poiItem.isShowCalloutBalloonOnTouch();
        final boolean showDisclosureButtonOnCalloutBalloon = poiItem.isShowDisclosureButtonOnCalloutBalloon();
        final boolean draggable = poiItem.isDraggable();
        final float alpha = poiItem.getAlpha();
        final float rotation = poiItem.getRotation();
        String customImageResourcePath = null;
        String customSelectedImageResourcePath = null;
        int customImageAnchorPointOffsetX = -1;
        int customImageAnchorPointOffsetY = -1;
        final int customImageAnchorPointOffsetX_F = customImageAnchorPointOffsetX;
        final int customImageAnchorPointOffsetY_F = customImageAnchorPointOffsetY;
        final float customImageAnchorRatioFromTopLeftOriginX_F = poiItem.getCustomImageAnchorRatioFromTopLeftOriginX();
        final float customImageAnchorRatioFromTopLeftOriginY_F = poiItem.getCustomImageAnchorRatioFromTopLeftOriginY();
        int customImageWidth_F = -1;
        int customImageHeight_F = -1;
        final boolean customImageAutoscale = poiItem.isCustomImageAutoscale();
        final String leftSideButtonResourceIdOnCalloutBalloon_F = ResourceUtils.getResourcePath(poiItem.getLeftSideButtonResourceIdOnCalloutBalloon());
        final String rightSideButtonResourceIdOnCalloutBalloon_F = ResourceUtils.getResourcePath(poiItem.getRightSideButtonResourceIdOnCalloutBalloon());
        final boolean useCalloutBalloonAdapter = this.calloutBalloonAdapter != null;
        final boolean moveToCenterOnSelect = poiItem.isMoveToCenterOnSelect();
        String customImageFileAbsolutePath = null;
        if (poiItem.getMarkerType() == MapPOIItem.MarkerType.CustomImage) {
            if (poiItem.getCustomImageResourceId() != 0) {
                customImageResourcePath = poiItem.getCustomImageResourcePath();
            } else {
                Bitmap customImageBitmap = poiItem.getCustomImageBitmap();
                File file = BitmapUtils.saveBitmapAsPngFile(this.getContext(), customImageBitmap, "image/custom_info_window", poiItem.getCustomImageFileName());
                if (file.exists()) {
                    customImageFileAbsolutePath = ResourceUtils.getResourceAbsolutePath(file.getAbsolutePath());
                }
                poiItem_.setCustomImageBitmap(null);
            }
            MapPOIItem.ImageOffset imageAnchorPointOffset = poiItem.getCustomImageAnchorPointOffset();
            if (imageAnchorPointOffset != null) {
                customImageAnchorPointOffsetX = imageAnchorPointOffset.offsetX;
                customImageAnchorPointOffsetY = imageAnchorPointOffset.offsetY;
            }
        }
        String customPressedImageFileAbsolutePath = null;
        if (poiItem.getSelectedMarkerType() == MapPOIItem.MarkerType.CustomImage) {
            if (poiItem.getCustomSelectedImageResourceId() != 0) {
                customSelectedImageResourcePath = poiItem.getCustomSelectedImageResourcePath();
            } else {
                Bitmap customSelectedImageBitmap = poiItem.getCustomSelectedImageBitmap();
                File file = BitmapUtils.saveBitmapAsPngFile(this.getContext(), customSelectedImageBitmap, "image/custom_info_window", poiItem.getCustomSelectedImageFileName());
                if (file.exists()) {
                    customPressedImageFileAbsolutePath = ResourceUtils.getResourceAbsolutePath(file.getAbsolutePath());
                }
                poiItem_.setCustomSelectedImageBitmap(null);
            }
        }
        final String customImageResourcePath_F = customImageResourcePath;
        final String customSelectedImageResourcePath_F = customSelectedImageResourcePath;
        String customInfoWindowImageFileAbsolutePath = null;
        String customPressedInfoWindowImageFileAbsolutePath = null;
        if (this.needSynchronousCalloutBalloonGeneration) {
            Bitmap customCalloutBalloonBitmap;
            if (useCalloutBalloonAdapter) {
                LinearLayout ll = this.wrapViewWithLinearLayout(this.calloutBalloonAdapter.getCalloutBalloon(poiItem_));
                poiItem_.setCustomCalloutBalloon((View)ll);
                if (ll != null) {
                    ll.removeAllViews();
                }
                LinearLayout llPressed = this.wrapViewWithLinearLayout(this.calloutBalloonAdapter.getPressedCalloutBalloon(poiItem_));
                poiItem_.setCustomPressedCalloutBalloon((View)llPressed);
                if (llPressed != null) {
                    llPressed.removeAllViews();
                }
            }
            if ((customCalloutBalloonBitmap = poiItem_.getCustomCalloutBalloonBitmap()) != null) {
                File filePressed;
                Bitmap customPressedCalloutBalloonBitmap;
                File file = BitmapUtils.saveBitmapAsPngFile(this.getContext(), customCalloutBalloonBitmap, "image/custom_info_window", poiItem.getCustomCalloutBalloonImageFileName());
                if (file.exists()) {
                    customInfoWindowImageFileAbsolutePath = ResourceUtils.getResourceAbsolutePath(file.getAbsolutePath());
                }
                if ((customPressedCalloutBalloonBitmap = poiItem_.getCustomPressedCalloutBalloonBitmap()) == null) {
                    LinearLayout ll;
                    View customCalloutBalloonView = poiItem_.getCustomCalloutBalloon();
                    if (useCalloutBalloonAdapter && (ll = this.wrapViewWithLinearLayout(customCalloutBalloonView = this.calloutBalloonAdapter.getCalloutBalloon(poiItem_))) != null) {
                        ll.removeAllViews();
                    }
                    if (customCalloutBalloonView != null) {
                        Drawable bgBackup = customCalloutBalloonView.getBackground().getConstantState().newDrawable();
                        Drawable bg = customCalloutBalloonView.getBackground();
                        bg.setColorFilter(0x33333333, PorterDuff.Mode.SRC_ATOP);
                        customPressedCalloutBalloonBitmap = BitmapUtils.createBitmapFromView(customCalloutBalloonView);
                        customCalloutBalloonView.setBackgroundDrawable(bgBackup);
                    }
                }
                if (customPressedCalloutBalloonBitmap != null && (filePressed = BitmapUtils.saveBitmapAsPngFile(this.getContext(), customPressedCalloutBalloonBitmap, "image/custom_pressed_info_window", poiItem.getCustomPressedCalloutBalloonImageFileName())).exists()) {
                    customPressedInfoWindowImageFileAbsolutePath = ResourceUtils.getResourceAbsolutePath(filePressed.getAbsolutePath());
                }
            }
            poiItem_.setCustomCalloutBalloonBitmap(null);
            poiItem_.setCustomPressedCalloutBalloonBitmap(null);
        }
        final String customInfoWindowImageFileAbsolutePath_F = customInfoWindowImageFileAbsolutePath;
        final String customPressedInfoWindowImageFileAbsolutePath_F = customPressedInfoWindowImageFileAbsolutePath;
        final String customImageFileAbsolutePath_F = customImageFileAbsolutePath;
        final String customPressedImageFileAbsolutePath_F = customPressedImageFileAbsolutePath;
        Runnable task = new Runnable(){

            @Override
            public void run() {
                int id = NativePOIItemMarkerManager.addPOIItemMarkerToMapView(itemName, nativeMapPoint, markerType, selectedMarkerType, showAnimationType, showCalloutBalloonOnTouch, showDisclosureButtonOnCalloutBalloon, draggable, alpha, rotation, customImageResourcePath_F, customSelectedImageResourcePath_F, customImageFileAbsolutePath_F, customPressedImageFileAbsolutePath_F, customImageAnchorPointOffsetX_F, customImageAnchorPointOffsetY_F, customImageAnchorRatioFromTopLeftOriginX_F, customImageAnchorRatioFromTopLeftOriginY_F, -1, -1, customImageAutoscale, leftSideButtonResourceIdOnCalloutBalloon_F, rightSideButtonResourceIdOnCalloutBalloon_F, useCalloutBalloonAdapter, moveToCenterOnSelect);
                poiItem_.setId(id);
                if (MapView.this.needSynchronousCalloutBalloonGeneration) {
                    if (customInfoWindowImageFileAbsolutePath_F != null) {
                        NativePOIItemMarkerManager.setCustomCalloutBalloonImageFilePath(id, customInfoWindowImageFileAbsolutePath_F);
                    }
                    if (customPressedInfoWindowImageFileAbsolutePath_F != null) {
                        NativePOIItemMarkerManager.setCustomPressedCalloutBalloonImageFilePath(id, customPressedInfoWindowImageFileAbsolutePath_F);
                    }
                } else {
                    Bitmap customCalloutBalloonBitmap = poiItem_.getCustomCalloutBalloonBitmap();
                    if (customCalloutBalloonBitmap != null) {
                        File filePressed;
                        View customCalloutBalloonView;
                        Bitmap customPressedCalloutBalloonBitmap;
                        File file = BitmapUtils.saveBitmapAsPngFile(MapView.this.getContext(), customCalloutBalloonBitmap, "image/custom_info_window", poiItem.getCustomCalloutBalloonImageFileName());
                        if (file.exists()) {
                            String customInfoWindowImageFileAbsolutePath = file.getAbsolutePath();
                            String pathForMapEngine = ResourceUtils.getResourceAbsolutePath(customInfoWindowImageFileAbsolutePath);
                            NativePOIItemMarkerManager.setCustomCalloutBalloonImageFilePath(id, pathForMapEngine);
                        }
                        if ((customPressedCalloutBalloonBitmap = poiItem_.getCustomPressedCalloutBalloonBitmap()) == null && (customCalloutBalloonView = poiItem_.getCustomCalloutBalloon()) != null) {
                            Drawable bgBackup = customCalloutBalloonView.getBackground().getConstantState().newDrawable();
                            Drawable bg = customCalloutBalloonView.getBackground();
                            bg.setColorFilter(0x33333333, PorterDuff.Mode.SRC_ATOP);
                            customPressedCalloutBalloonBitmap = BitmapUtils.createBitmapFromView(customCalloutBalloonView);
                            customCalloutBalloonView.setBackgroundDrawable(bgBackup);
                        }
                        if (customPressedCalloutBalloonBitmap != null && (filePressed = BitmapUtils.saveBitmapAsPngFile(MapView.this.getContext(), customPressedCalloutBalloonBitmap, "image/custom_pressed_info_window", poiItem.getCustomPressedCalloutBalloonImageFileName())).exists()) {
                            String customInfoWindowImageFileAbsolutePath = filePressed.getAbsolutePath();
                            String pathForMapEngine = ResourceUtils.getResourceAbsolutePath(customInfoWindowImageFileAbsolutePath);
                            NativePOIItemMarkerManager.setCustomPressedCalloutBalloonImageFilePath(id, pathForMapEngine);
                        }
                    }
                }
            }
        };
        MapTaskManager.getInstance().queueTask(task, MapEngineManager.getInstance().getStopGlSwap());
    }

    private int convertMarkerType(MapPOIItem.MarkerType markerType) {
        if (markerType == MapPOIItem.MarkerType.BluePin) {
            return 1;
        }
        if (markerType == MapPOIItem.MarkerType.RedPin) {
            return 2;
        }
        if (markerType == MapPOIItem.MarkerType.YellowPin) {
            return 3;
        }
        if (markerType == MapPOIItem.MarkerType.CustomImage) {
            return 4;
        }
        return 0;
    }

    public void addPOIItems(MapPOIItem[] poiItems) {
        for (int i = 0; i < poiItems.length; ++i) {
            MapPOIItem poiItem = poiItems[i];
            this.addPOIItem(poiItem);
        }
    }

    public void selectPOIItem(MapPOIItem poiItem, boolean animated) {
        final MapPOIItem poiItemF = poiItem;
        final boolean animatedF = animated;
        Runnable task = new Runnable(){

            @Override
            public void run() {
                int mapComponentId = poiItemF.getId();
                NativePOIItemMarkerManager.selectPOIItemMarker(mapComponentId, animatedF);
            }
        };
        MapTaskManager.getInstance().queueTask(task, MapEngineManager.getInstance().getStopGlSwap());
    }

    public void deselectPOIItem(MapPOIItem poiItem) {
        final MapPOIItem poiItemF = poiItem;
        Runnable task = new Runnable(){

            @Override
            public void run() {
                int mapComponentId = poiItemF.getId();
                NativePOIItemMarkerManager.deselectPOIItemMarker(mapComponentId);
            }
        };
        MapTaskManager.getInstance().queueTask(task, MapEngineManager.getInstance().getStopGlSwap());
    }

    public MapPOIItem findPOIItemByTag(int tag) {
        for (MapPOIItem poiItem : this.poiItems) {
            if (poiItem.getTag() != tag) continue;
            return poiItem;
        }
        return null;
    }

    public MapPOIItem[] findPOIItemByName(String itemName) {
        if (itemName == null) {
            return null;
        }
        ArrayList<MapPOIItem> foundPOIItems = null;
        for (MapPOIItem poiItem : this.poiItems) {
            String itemName_ = poiItem.getItemName();
            if (itemName_ == null || !itemName_.equals(itemName)) continue;
            if (foundPOIItems == null) {
                foundPOIItems = new ArrayList<MapPOIItem>();
            }
            foundPOIItems.add(poiItem);
        }
        if (foundPOIItems == null) {
            return null;
        }
        return foundPOIItems.toArray(new MapPOIItem[0]);
    }

    public void removePOIItem(MapPOIItem poiItem) {
        final MapPOIItem poiItemF = poiItem;
        Runnable task = new Runnable(){

            @Override
            public void run() {
                int mapComponentId = poiItemF.getId();
                NativePOIItemMarkerManager.removePOIItemMarker(mapComponentId);
            }
        };
        MapTaskManager.getInstance().queueTask(task, MapEngineManager.getInstance().getStopGlSwap());
        BitmapUtils.deleteFile(this.getContext(), "image/custom_info_window", poiItem.getCustomCalloutBalloonImageFileName());
        BitmapUtils.deleteFile(this.getContext(), "image/custom_pressed_info_window", poiItem.getCustomPressedCalloutBalloonImageFileName());
        this.poiItems.remove(poiItem);
    }

    public void removePOIItems(MapPOIItem[] poiItems) {
        for (int i = 0; i < poiItems.length; ++i) {
            MapPOIItem poiItem = poiItems[i];
            this.removePOIItem(poiItem);
        }
    }

    public void removeAllPOIItems() {
        Runnable task = new Runnable(){

            @Override
            public void run() {
                NativePOIItemMarkerManager.removeAllPOIItemMarkers();
            }
        };
        MapTaskManager.getInstance().queueTask(task, MapEngineManager.getInstance().getStopGlSwap());
        BitmapUtils.deleteAllFilesInDirectory(this.getContext(), "image/custom_info_window");
        BitmapUtils.deleteAllFilesInDirectory(this.getContext(), "image/custom_pressed_info_window");
        this.poiItems.clear();
    }

    public void fitMapViewAreaToShowAllPOIItems() {
        int poiItemCount = this.poiItems.size();
        if (poiItemCount == 0) {
            return;
        }
        MapPoint[] mapPoints = new MapPoint[poiItemCount];
        int i = 0;
        for (MapPOIItem poiItem : this.poiItems) {
            mapPoints[i++] = poiItem.getMapPoint();
        }
        this.fitMapViewAreaToShowMapPoints(mapPoints);
    }

    public MapCircle[] getCircles() {
        return this.circles.toArray(new MapCircle[0]);
    }

    public void addCircle(final MapCircle circle) {
        this.circles.add(circle);
        Runnable task = new Runnable(){

            @Override
            public void run() {
                MapPoint mapPoint = circle.getCenter();
                NativeMapCoord nativeMapPoint = new NativeMapCoord(mapPoint.getMapPointWCONGCoord().x, mapPoint.getMapPointWCONGCoord().y, 2);
                int id = NativeCircleOverlayManager.addCircleToMap(nativeMapPoint, circle.getRadius(), circle.getStrokeColor(), 1, circle.getFillColor());
                circle.setId(id);
            }
        };
        MapTaskManager.getInstance().queueTask(task, MapEngineManager.getInstance().getStopGlSwap());
    }

    public MapCircle findCircleByTag(int tag) {
        for (MapCircle circle : this.circles) {
            if (circle.getTag() != tag) continue;
            return circle;
        }
        return null;
    }

    public void removeCircle(MapCircle circle) {
        final MapCircle circleF = circle;
        Runnable task = new Runnable(){

            @Override
            public void run() {
                int id = circleF.getId();
                NativeCircleOverlayManager.removeCircle(id);
            }
        };
        MapTaskManager.getInstance().queueTask(task, MapEngineManager.getInstance().getStopGlSwap());
        this.circles.remove(circle);
    }

    public void removeAllCircles() {
        Runnable task = new Runnable(){

            @Override
            public void run() {
                NativeCircleOverlayManager.removeAllCircles();
            }
        };
        MapTaskManager.getInstance().queueTask(task, MapEngineManager.getInstance().getStopGlSwap());
        this.circles.clear();
    }

    public void fitMapViewAreaToShowCircle(MapCircle circle) {
        if (circle == null) {
            return;
        }
        MapPoint[] mapPoints = new MapPoint[2];
        MapPoint.PlainCoordinate point = circle.getCenter().getMapPointWCONGCoord();
        int radius = circle.getRadius();
        mapPoints[0] = MapPoint.mapPointWithWCONGCoord(point.x - (double)radius * 2.5, point.y - (double)radius * 2.5);
        mapPoints[1] = MapPoint.mapPointWithWCONGCoord(point.x + (double)radius * 2.5, point.y + (double)radius * 2.5);
        this.fitMapViewAreaToShowMapPoints(mapPoints);
    }

    public void fitMapViewAreaToShowAllCircle() {
        if (this.circles == null || this.circles.size() == 0) {
            return;
        }
        MapPoint[] mapPoints = new MapPoint[2];
        double minx = Double.POSITIVE_INFINITY;
        double maxx = Double.NEGATIVE_INFINITY;
        double miny = Double.POSITIVE_INFINITY;
        double maxy = Double.NEGATIVE_INFINITY;
        for (MapCircle circle : this.circles) {
            MapPoint.PlainCoordinate point = circle.getCenter().getMapPointWCONGCoord();
            int radius = circle.getRadius();
            minx = Math.min(minx, point.x - (double)radius * 2.5);
            maxx = Math.max(maxx, point.x + (double)radius * 2.5);
            miny = Math.min(miny, point.y - (double)radius * 2.5);
            maxy = Math.max(maxy, point.y + (double)radius * 2.5);
        }
        mapPoints[0] = MapPoint.mapPointWithWCONGCoord(minx, miny);
        mapPoints[1] = MapPoint.mapPointWithWCONGCoord(maxx, maxy);
        this.fitMapViewAreaToShowMapPoints(mapPoints);
    }

    public MapPolyline[] getPolylines() {
        return this.polylines.toArray(new MapPolyline[0]);
    }

    public void addPolyline(MapPolyline polyline) {
        this.polylines.add(polyline);
        final MapPolyline _polyline = polyline;
        Runnable task = new Runnable(){

            @Override
            public void run() {
                int id = NativePolylineOverlayManager.addPolylineToMap(_polyline);
                _polyline.setId(id);
            }
        };
        MapTaskManager.getInstance().queueTask(task, MapEngineManager.getInstance().getStopGlSwap());
    }

    public MapPolyline findPolylineByTag(int tag) {
        for (MapPolyline polyline : this.polylines) {
            if (polyline.getTag() != tag) continue;
            return polyline;
        }
        return null;
    }

    public void removePolyline(MapPolyline polyline) {
        final MapPolyline polylineF = polyline;
        Runnable task = new Runnable(){

            @Override
            public void run() {
                int id = polylineF.getId();
                NativePolylineOverlayManager.removePolyline(id);
            }
        };
        MapTaskManager.getInstance().queueTask(task, MapEngineManager.getInstance().getStopGlSwap());
        this.polylines.remove(polyline);
    }

    public void removeAllPolylines() {
        Runnable task = new Runnable(){

            @Override
            public void run() {
                NativePolylineOverlayManager.removeAllPolylines();
            }
        };
        MapTaskManager.getInstance().queueTask(task, MapEngineManager.getInstance().getStopGlSwap());
        this.polylines.clear();
    }

    public void fitMapViewAreaToShowPolyline(MapPolyline polyline) {
        if (polyline == null) {
            return;
        }
        int pointCount = polyline.getPointCount();
        MapPoint[] mapPoints = new MapPoint[pointCount];
        for (int i = 0; i < pointCount; ++i) {
            mapPoints[i] = polyline.getPoint(i);
        }
        this.fitMapViewAreaToShowMapPoints(mapPoints);
    }

    public void fitMapViewAreaToShowAllPolylines() {
        int polylineCount = this.polylines.size();
        int totalPointCount = 0;
        for (int i = 0; i < polylineCount; ++i) {
            MapPolyline polyline = this.polylines.get(i);
            totalPointCount += polyline.getPointCount();
        }
        if (totalPointCount <= 0) {
            return;
        }
        MapPoint[] mapPoints = new MapPoint[totalPointCount];
        int pointIndex = 0;
        for (int i = 0; i < polylineCount; ++i) {
            MapPolyline polyline = this.polylines.get(i);
            int pointCountInPolyline = polyline.getPointCount();
            for (int j = 0; j < pointCountInPolyline; ++j) {
                mapPoints[pointIndex++] = polyline.getPoint(j);
            }
        }
        this.fitMapViewAreaToShowMapPoints(mapPoints);
    }

    public void moveCamera(CameraUpdate cameraUpdate) {
        switch (cameraUpdate.mUpdateType) {
            case UPDATE_WITH_MAP_POINT: {
                if (cameraUpdate.mMapPoint == null) break;
                MapController.getInstance().move(cameraUpdate.mMapPoint.getInternalCoordObject(), true);
                break;
            }
            case UPDATE_WITH_MAP_POINT_AND_ZOOM_LEVEL: {
                if (cameraUpdate.mMapPoint == null) break;
                int zoomLevel = Math.max(0, Math.round(cameraUpdate.mZoomLevel));
                MapController.getInstance().move(cameraUpdate.mMapPoint.getInternalCoordObject(), zoomLevel, true);
                break;
            }
            case UPDATE_WITH_MAP_POINT_AND_DIAMETER: {
                if (cameraUpdate.mMapPoint == null) break;
                MapController.getInstance().updateCameraWithMapPointAndDiameter(cameraUpdate.mMapPoint.getInternalCoordObject(), cameraUpdate.mDiameter);
                break;
            }
            case UPDATE_WITH_MAP_POINT_AND_DIAMETER_AND_PADDING: {
                if (cameraUpdate.mMapPoint == null) break;
                MapController.getInstance().updateCameraWithMapPointAndDiameterAndPadding(cameraUpdate.mMapPoint.getInternalCoordObject(), cameraUpdate.mDiameter, cameraUpdate.mPadding);
                break;
            }
            case UPDATE_WITH_MAP_POINT_BOUNDS: {
                if (cameraUpdate.mMapPointBounds == null || cameraUpdate.mMapPointBounds.bottomLeft == null || cameraUpdate.mMapPointBounds.topRight == null) break;
                NativeMapCoord[] nativeMapCoords = new NativeMapCoord[2];
                MapPoint.PlainCoordinate mapPointBottomLeftWCONG = cameraUpdate.mMapPointBounds.bottomLeft.getMapPointWCONGCoord();
                nativeMapCoords[0] = new NativeMapCoord(mapPointBottomLeftWCONG.x, mapPointBottomLeftWCONG.y);
                MapPoint.PlainCoordinate mapPointTopRightWCONG = cameraUpdate.mMapPointBounds.topRight.getMapPointWCONGCoord();
                nativeMapCoords[1] = new NativeMapCoord(mapPointTopRightWCONG.x, mapPointTopRightWCONG.y);
                MapController.getInstance().updateCameraWithMapPoints(nativeMapCoords);
                break;
            }
            case UPDATE_WITH_MAP_POINT_BOUNDS_AND_PADDING: {
                if (cameraUpdate.mMapPointBounds == null || cameraUpdate.mMapPointBounds.bottomLeft == null || cameraUpdate.mMapPointBounds.topRight == null) break;
                NativeMapCoord[] nativeMapCoords = new NativeMapCoord[2];
                MapPoint.PlainCoordinate mapPointBottomLeftWCONG = cameraUpdate.mMapPointBounds.bottomLeft.getMapPointWCONGCoord();
                nativeMapCoords[0] = new NativeMapCoord(mapPointBottomLeftWCONG.x, mapPointBottomLeftWCONG.y);
                MapPoint.PlainCoordinate mapPointTopRightWCONG = cameraUpdate.mMapPointBounds.topRight.getMapPointWCONGCoord();
                nativeMapCoords[1] = new NativeMapCoord(mapPointTopRightWCONG.x, mapPointTopRightWCONG.y);
                MapController.getInstance().updateCameraWithMapPointsAndPadding(nativeMapCoords, cameraUpdate.mPadding);
                break;
            }
            case UPDATE_WITH_MAP_POINT_BOUNDS_AND_PADDING_AND_MIN_ZOOM_LEVEL_AND_MAX_ZOOM_LEVEL: {
                if (cameraUpdate.mMapPointBounds == null || cameraUpdate.mMapPointBounds.bottomLeft == null || cameraUpdate.mMapPointBounds.topRight == null) break;
                NativeMapCoord[] nativeMapCoords = new NativeMapCoord[2];
                MapPoint.PlainCoordinate mapPointBottomLeftWCONG = cameraUpdate.mMapPointBounds.bottomLeft.getMapPointWCONGCoord();
                nativeMapCoords[0] = new NativeMapCoord(mapPointBottomLeftWCONG.x, mapPointBottomLeftWCONG.y);
                MapPoint.PlainCoordinate mapPointTopRightWCONG = cameraUpdate.mMapPointBounds.topRight.getMapPointWCONGCoord();
                nativeMapCoords[1] = new NativeMapCoord(mapPointTopRightWCONG.x, mapPointTopRightWCONG.y);
                float minZoomLevel = cameraUpdate.mMinZoomLevel;
                float maxZoomLevel = cameraUpdate.mMaxZoomLevel;
                if (minZoomLevel > maxZoomLevel) {
                    float tmp = minZoomLevel;
                    minZoomLevel = maxZoomLevel;
                    maxZoomLevel = tmp;
                }
                MapController.getInstance().updateCameraWithMapPointsAndPaddingAndMinZoomLevelAndMaxZoomLevel(nativeMapCoords, cameraUpdate.mPadding, minZoomLevel, maxZoomLevel);
                break;
            }
        }
    }

    public void animateCamera(CameraUpdate cameraUpdate) {
        this.animateCamera(cameraUpdate, 1000.0f, null);
    }

    public void animateCamera(CameraUpdate cameraUpdate, CancelableCallback callback) {
        this.animateCamera(cameraUpdate, 1000.0f, callback);
    }

    public void animateCamera(CameraUpdate cameraUpdate, float duration, final CancelableCallback callback) {
        if (duration < 0.0f) {
            duration = 1000.0f;
        }
        final double currentZoomLevel = this.getZoomLevelFloat();
        double targetZoomLevel = cameraUpdate.mZoomLevel;
        if (targetZoomLevel < (double)MIN_ZOOM_LEVEL) {
            targetZoomLevel = currentZoomLevel;
        }
        MapPoint currentMapPoint = this.getMapCenterPoint();
        final MapPoint targetMapPoint = cameraUpdate.mMapPoint;
        final MapCoord currentCoord = currentMapPoint.getInternalCoordObject();
        final MapCoord targetCoord = targetMapPoint.getInternalCoordObject();
        double distanceWcong = Math.hypot(currentCoord.getX() - targetCoord.getX(), currentCoord.getY() - targetCoord.getY());
        final double dx = targetCoord.getX() - currentCoord.getX();
        final double dy = targetCoord.getY() - currentCoord.getY();
        WindowManager wm = (WindowManager)this.getContext().getSystemService("window");
        Display display = wm.getDefaultDisplay();
        MapPoint leftScreenMapPoint = MapPoint.mapPointWithScreenLocation(0.0, 0.0);
        MapPoint rightScreenMapPoint = MapPoint.mapPointWithScreenLocation(display.getWidth(), 0.0);
        MapCoord leftScreenCoord = leftScreenMapPoint.getInternalCoordObject();
        MapCoord rightScreenCoord = rightScreenMapPoint.getInternalCoordObject();
        double screenWidthWcong = Math.abs(leftScreenCoord.getX() - rightScreenCoord.getX());
        double peakZoomLevel = currentZoomLevel + Math.log(distanceWcong / 2.0 / screenWidthWcong) / Math.log(2.0);
        peakZoomLevel = Math.max(peakZoomLevel, currentZoomLevel);
        peakZoomLevel = Math.max(peakZoomLevel, targetZoomLevel);
        peakZoomLevel = Math.min(peakZoomLevel, (double)MAX_ZOOM_LEVEL);
        final double targetZoomLevelFinal = targetZoomLevel;
        final double peakZoomLevelFinal = peakZoomLevel;
        final int timerCountLimit = (int)Math.floor(duration / 33.0f);
        final int timerCountPerPhase = timerCountLimit / 2;
        if (this.cameraAnimationTimer != null) {
            this.cameraAnimationTimer.cancel();
            this.cameraAnimationTimer = null;
            if (this.cameraAnimationCancelableCallback != null) {
                this.cameraAnimationCancelableCallback.onCancel();
                this.cameraAnimationCancelableCallback = null;
            }
        }
        this.cameraAnimationCancelableCallback = callback;
        this.cameraAnimationTimer = new Timer();
        this.cameraAnimationTimer.schedule(new TimerTask(){
            int timerCount = 0;
            double zoomLevel = currentZoomLevel;
            double x;
            double y;

            @Override
            public void run() {
                if (this.timerCount == timerCountLimit) {
                    this.update(targetZoomLevelFinal, targetMapPoint);
                    MapView.this.cameraAnimationTimer.cancel();
                    MapView.this.cameraAnimationTimer = null;
                    Handler handler = new Handler(Looper.getMainLooper());
                    handler.post(new Runnable(){

                        @Override
                        public void run() {
                            if (callback != null) {
                                callback.onFinish();
                            }
                        }
                    });
                    return;
                }
                double distanceRate = (-Math.cos(Math.PI * (double)this.timerCount / (double)timerCountLimit) + 1.0) / (-Math.cos(Math.PI) + 1.0);
                boolean isUpPhase = this.timerCount < timerCountPerPhase;
                boolean isDownPhase = this.timerCount >= timerCountLimit - timerCountPerPhase;
                boolean isPeakPhaseStarted = false;
                double peakPhaseDx = 0.0;
                double peakPhaseDy = 0.0;
                if (isUpPhase) {
                    double deg = Math.PI * (double)this.timerCount / (double)timerCountPerPhase / 2.0;
                    this.zoomLevel = currentZoomLevel + (peakZoomLevelFinal - currentZoomLevel) * Math.sin(deg);
                    this.zoomLevel = Math.min(this.zoomLevel, peakZoomLevelFinal);
                    this.x = currentCoord.getX() + dx * distanceRate;
                    this.y = currentCoord.getY() + dy * distanceRate;
                } else if (isDownPhase) {
                    double deg = Math.PI * (0.5 * (double)(timerCountPerPhase - (timerCountLimit - this.timerCount)) / (double)timerCountPerPhase + 0.5);
                    this.zoomLevel = targetZoomLevelFinal + (peakZoomLevelFinal - targetZoomLevelFinal) * Math.sin(deg);
                    this.zoomLevel = Math.max(this.zoomLevel, targetZoomLevelFinal);
                    this.x = currentCoord.getX() + dx * distanceRate;
                    this.y = currentCoord.getY() + dy * distanceRate;
                } else {
                    if (!isPeakPhaseStarted) {
                        isPeakPhaseStarted = true;
                        peakPhaseDx = Math.abs(dx) - Math.abs(currentCoord.getX() - this.x) * 2.0;
                        if (targetCoord.getX() < currentCoord.getX()) {
                            peakPhaseDx = -peakPhaseDx;
                        }
                        peakPhaseDy = Math.abs(dy) - Math.abs(currentCoord.getY() - this.y) * 2.0;
                        if (targetCoord.getY() < currentCoord.getY()) {
                            peakPhaseDy = -peakPhaseDy;
                        }
                    }
                    this.x += peakPhaseDx;
                    this.y += peakPhaseDy;
                    this.zoomLevel = peakZoomLevelFinal;
                }
                this.update(this.zoomLevel, MapPoint.mapPointWithWCONGCoord(this.x, this.y));
                ++this.timerCount;
            }

            void update(double zoomLevel, MapPoint point) {
                float zoomLevelFloat = (float)zoomLevel;
                MapCoord mapCoord = point.getInternalCoordObject();
                MapController.getInstance().move(mapCoord, zoomLevelFloat, true);
            }
        }, 0L, 33L);
    }

    public void stopAnimation() {
        if (this.cameraAnimationTimer != null) {
            this.cameraAnimationTimer.cancel();
            this.cameraAnimationTimer = null;
            Handler handler = new Handler(Looper.getMainLooper());
            handler.post(new Runnable(){

                @Override
                public void run() {
                    if (MapView.this.cameraAnimationCancelableCallback != null) {
                        MapView.this.cameraAnimationCancelableCallback.onCancel();
                    }
                }
            });
        }
    }

    void onOpenAPIKeyAuthenticationResult(final int resultCode, final String resultMessage) {
        Activity activity = (Activity)this.dmapActivity.get();
        if (activity == null) {
            return;
        }
        if (this.openAPIKeyAuthenticationResultListener == null || this.openAPIKeyAuthenticationResultListener.get() == null) {
            return;
        }
        final MapView mapView = this;
        activity.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                if (MapView.this.openAPIKeyAuthenticationResultListener == null) {
                    return;
                }
                OpenAPIKeyAuthenticationResultListener listener = (OpenAPIKeyAuthenticationResultListener)MapView.this.openAPIKeyAuthenticationResultListener.get();
                if (listener == null) {
                    return;
                }
                listener.onDaumMapOpenAPIKeyAuthenticationResult(mapView, resultCode, resultMessage);
            }
        });
    }

    void onMapViewLoaded() {
        if (this.mapEngineLoadedForThisMapView) {
            return;
        }
        this.mapEngineLoadedForThisMapView = true;
        if (this.mapViewEventListener == null || this.mapViewEventListener.get() == null) {
            return;
        }
    }

    @Override
    public void onDrawFrame(GL10 gl) {
        super.onDrawFrame(gl);
        if (!this.isFirstOnDrawFrame) {
            return;
        }
        this.isFirstOnDrawFrame = false;
        Activity activity = (Activity)this.dmapActivity.get();
        if (activity == null) {
            return;
        }
        final MapView mapView = this;
        activity.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                ViewGroup viewGroup;
                View viewToShowBeforeMapViewInitialized;
                if (MapView.this.mapViewEventListener == null) {
                    return;
                }
                MapViewEventListener listener = (MapViewEventListener)MapView.this.mapViewEventListener.get();
                if (listener == null) {
                    return;
                }
                ViewParent parent = mapView.getParent();
                if (parent != null && parent instanceof ViewGroup && (viewToShowBeforeMapViewInitialized = (viewGroup = (ViewGroup)parent).findViewWithTag((Object)"VIEW_TO_SHOW_BEFORE_MAP_VIEW_INITIALIZED")) != null) {
                    viewGroup.removeView(viewToShowBeforeMapViewInitialized);
                }
                listener.onMapViewInitialized(mapView);
            }
        });
    }

    void onMapViewCenterPointMoved(final double centerPointX, final double centerPointY) {
        Activity activity = (Activity)this.dmapActivity.get();
        if (activity == null) {
            return;
        }
        if (this.mapViewEventListener == null || this.mapViewEventListener.get() == null) {
            return;
        }
        final MapView mapView = this;
        activity.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                if (MapView.this.mapViewEventListener == null) {
                    return;
                }
                MapViewEventListener listener = (MapViewEventListener)MapView.this.mapViewEventListener.get();
                if (listener == null) {
                    return;
                }
                if (!MapView.this.dragStarted && MapView.this.dragStartedMapPoint != null) {
                    MapView.this.dragStarted = true;
                    listener.onMapViewDragStarted(mapView, MapView.this.dragStartedMapPoint);
                }
                listener.onMapViewCenterPointMoved(mapView, MapPoint.mapPointWithWCONGCoord(centerPointX, centerPointY));
            }
        });
    }

    void onMapViewZoomLevelChanged(final int zoomLevel) {
        Activity activity = (Activity)this.dmapActivity.get();
        if (activity == null) {
            return;
        }
        if (this.mapViewEventListener == null || this.mapViewEventListener.get() == null) {
            return;
        }
        final MapView mapView = this;
        activity.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                if (MapView.this.mapViewEventListener == null) {
                    return;
                }
                MapViewEventListener listener = (MapViewEventListener)MapView.this.mapViewEventListener.get();
                if (listener == null) {
                    return;
                }
                listener.onMapViewZoomLevelChanged(mapView, zoomLevel);
            }
        });
    }

    void onMapViewSingleTapped(final double mapPointX, final double mapPointY) {
        Activity activity = (Activity)this.dmapActivity.get();
        if (activity == null) {
            return;
        }
        if (this.mapViewEventListener == null || this.mapViewEventListener.get() == null) {
            return;
        }
        final MapView mapView = this;
        activity.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                if (MapView.this.mapViewEventListener == null) {
                    return;
                }
                MapViewEventListener listener = (MapViewEventListener)MapView.this.mapViewEventListener.get();
                if (listener == null) {
                    return;
                }
                listener.onMapViewSingleTapped(mapView, MapPoint.mapPointWithWCONGCoord(mapPointX, mapPointY));
            }
        });
    }

    void onMapViewDoubleTapped(final double mapPointX, final double mapPointY) {
        Activity activity = (Activity)this.dmapActivity.get();
        if (activity == null) {
            return;
        }
        if (this.mapViewEventListener == null || this.mapViewEventListener.get() == null) {
            return;
        }
        final MapView mapView = this;
        activity.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                if (MapView.this.mapViewEventListener == null) {
                    return;
                }
                MapViewEventListener listener = (MapViewEventListener)MapView.this.mapViewEventListener.get();
                if (listener == null) {
                    return;
                }
                listener.onMapViewDoubleTapped(mapView, MapPoint.mapPointWithWCONGCoord(mapPointX, mapPointY));
            }
        });
    }

    void onMapViewLongPressed(final double mapPointX, final double mapPointY) {
        Activity activity = (Activity)this.dmapActivity.get();
        if (activity == null) {
            return;
        }
        if (this.mapViewEventListener == null || this.mapViewEventListener.get() == null) {
            return;
        }
        final MapView mapView = this;
        activity.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                if (MapView.this.mapViewEventListener == null) {
                    return;
                }
                MapViewEventListener listener = (MapViewEventListener)MapView.this.mapViewEventListener.get();
                if (listener == null) {
                    return;
                }
                listener.onMapViewLongPressed(mapView, MapPoint.mapPointWithWCONGCoord(mapPointX, mapPointY));
            }
        });
    }

    void onMapViewDragStarted(double mapPointX, double mapPointY) {
        this.stopAnimation();
        this.dragStartedMapPoint = MapPoint.mapPointWithWCONGCoord(mapPointX, mapPointY);
    }

    void onMapViewDragEnded(final double mapPointX, final double mapPointY) {
        Activity activity = (Activity)this.dmapActivity.get();
        if (activity == null) {
            return;
        }
        if (!this.dragStarted) {
            return;
        }
        this.dragStarted = false;
        if (this.mapViewEventListener == null || this.mapViewEventListener.get() == null) {
            return;
        }
        final MapView mapView = this;
        activity.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                if (MapView.this.mapViewEventListener == null) {
                    return;
                }
                MapViewEventListener listener = (MapViewEventListener)MapView.this.mapViewEventListener.get();
                if (listener == null) {
                    return;
                }
                listener.onMapViewDragEnded(mapView, MapPoint.mapPointWithWCONGCoord(mapPointX, mapPointY));
            }
        });
    }

    void onMapViewMoveFinished(final double mapPointX, final double mapPointY) {
        Activity activity = (Activity)this.dmapActivity.get();
        if (activity == null) {
            return;
        }
        if (this.mapViewEventListener == null || this.mapViewEventListener.get() == null) {
            return;
        }
        final MapView mapView = this;
        activity.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                if (MapView.this.mapViewEventListener == null) {
                    return;
                }
                MapViewEventListener listener = (MapViewEventListener)MapView.this.mapViewEventListener.get();
                if (listener == null) {
                    return;
                }
                listener.onMapViewMoveFinished(mapView, MapPoint.mapPointWithWCONGCoord(mapPointX, mapPointY));
            }
        });
    }

    void onCurrentLocationUpdate(final double latitude, final double longitude, final float accuracy) {
        Activity activity = (Activity)this.dmapActivity.get();
        if (activity == null) {
            return;
        }
        if (this.currentLocationEventListener == null || this.currentLocationEventListener.get() == null) {
            return;
        }
        final MapView mapView = this;
        activity.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                if (MapView.this.currentLocationEventListener == null) {
                    return;
                }
                CurrentLocationEventListener listener = (CurrentLocationEventListener)MapView.this.currentLocationEventListener.get();
                if (listener == null) {
                    return;
                }
                listener.onCurrentLocationUpdate(mapView, MapPoint.mapPointWithGeoCoord(latitude, longitude), accuracy);
            }
        });
    }

    void onCurrentLocationDeviceHeadingUpdate(final float headingAngle) {
        Activity activity = (Activity)this.dmapActivity.get();
        if (activity == null) {
            return;
        }
        if (this.currentLocationEventListener == null || this.currentLocationEventListener.get() == null) {
            return;
        }
        final MapView mapView = this;
        activity.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                if (MapView.this.currentLocationEventListener == null) {
                    return;
                }
                CurrentLocationEventListener listener = (CurrentLocationEventListener)MapView.this.currentLocationEventListener.get();
                if (listener == null) {
                    return;
                }
                listener.onCurrentLocationDeviceHeadingUpdate(mapView, headingAngle);
            }
        });
    }

    void onCurrentLocationUpdateFailed() {
        Activity activity = (Activity)this.dmapActivity.get();
        if (activity == null) {
            return;
        }
        if (this.currentLocationEventListener == null || this.currentLocationEventListener.get() == null) {
            return;
        }
        final MapView mapView = this;
        activity.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                if (MapView.this.currentLocationEventListener == null) {
                    return;
                }
                CurrentLocationEventListener listener = (CurrentLocationEventListener)MapView.this.currentLocationEventListener.get();
                if (listener == null) {
                    return;
                }
                listener.onCurrentLocationUpdateFailed(mapView);
            }
        });
    }

    void onCurrentLocationUpdateCancelled() {
        Activity activity = (Activity)this.dmapActivity.get();
        if (activity == null) {
            return;
        }
        if (this.currentLocationEventListener == null || this.currentLocationEventListener.get() == null) {
            return;
        }
        final MapView mapView = this;
        activity.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                if (MapView.this.currentLocationEventListener == null) {
                    return;
                }
                CurrentLocationEventListener listener = (CurrentLocationEventListener)MapView.this.currentLocationEventListener.get();
                if (listener == null) {
                    return;
                }
                listener.onCurrentLocationUpdateCancelled(mapView);
            }
        });
    }

    void onPOIItemSelected(final int poiMarkerId) {
        Activity activity = (Activity)this.dmapActivity.get();
        if (activity == null) {
            return;
        }
        if (this.poiItemEventListener == null || this.poiItemEventListener.get() == null) {
            return;
        }
        final MapView mapView = this;
        activity.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                if (MapView.this.poiItemEventListener == null) {
                    return;
                }
                POIItemEventListener listener = (POIItemEventListener)MapView.this.poiItemEventListener.get();
                if (listener == null) {
                    return;
                }
                for (MapPOIItem poiItem : MapView.this.poiItems) {
                    if (poiItem.getId() != poiMarkerId) continue;
                    listener.onPOIItemSelected(mapView, poiItem);
                }
            }
        });
    }

    LinearLayout wrapViewWithLinearLayout(View view) {
        if (view == null) {
            return null;
        }
        Activity activity = (Activity)this.dmapActivity.get();
        if (activity == null) {
            return null;
        }
        LinearLayout ll = new LinearLayout((Context)activity);
        ll.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-2, -2));
        ll.addView(view);
        return ll;
    }

    void prepareCalloutBalloonImageAndCallback(final int poiMarkerId, final boolean animated) {
        if (this.poiItems == null || this.poiItems.size() == 0) {
            return;
        }
        if (this.calloutBalloonAdapter != null) {
            for (MapPOIItem poiItem : this.poiItems) {
                View customPressedCalloutBalloonView;
                if (poiItem.getId() != poiMarkerId) continue;
                Bitmap customCalloutBalloonBitmap = null;
                Bitmap customPressedCalloutBalloonBitmap = null;
                View customCalloutBalloonView = this.calloutBalloonAdapter.getCalloutBalloon(poiItem);
                if (customCalloutBalloonView != null) {
                    LinearLayout ll = this.wrapViewWithLinearLayout(customCalloutBalloonView);
                    if (ll != null) {
                        customCalloutBalloonBitmap = BitmapUtils.createBitmapFromView((View)ll);
                        ll.removeAllViews();
                    } else {
                        customCalloutBalloonBitmap = BitmapUtils.createBitmapFromView(customCalloutBalloonView);
                    }
                }
                if ((customPressedCalloutBalloonView = this.calloutBalloonAdapter.getPressedCalloutBalloon(poiItem)) != null) {
                    LinearLayout ll = this.wrapViewWithLinearLayout(customPressedCalloutBalloonView);
                    if (ll != null) {
                        customPressedCalloutBalloonBitmap = BitmapUtils.createBitmapFromView((View)ll);
                        ll.removeAllViews();
                    } else {
                        customPressedCalloutBalloonBitmap = BitmapUtils.createBitmapFromView(customPressedCalloutBalloonView);
                    }
                }
                if (customCalloutBalloonBitmap != null) {
                    File filePressed;
                    String customInfoWindowImageFileAbsolutePath = null;
                    String customPressedInfoWindowImageFileAbsolutePath = null;
                    File file = BitmapUtils.saveBitmapAsPngFile(this.getContext(), customCalloutBalloonBitmap, "image/custom_info_window", poiItem.getCustomCalloutBalloonImageFileName());
                    if (file.exists()) {
                        customInfoWindowImageFileAbsolutePath = ResourceUtils.getResourceAbsolutePath(file.getAbsolutePath());
                    }
                    if (customPressedCalloutBalloonBitmap == null && customCalloutBalloonView != null) {
                        Drawable bgBackup = customCalloutBalloonView.getBackground().getConstantState().newDrawable();
                        Drawable bg = customCalloutBalloonView.getBackground();
                        bg.setColorFilter(0x33333333, PorterDuff.Mode.SRC_ATOP);
                        customPressedCalloutBalloonBitmap = BitmapUtils.createBitmapFromView(customCalloutBalloonView);
                        customCalloutBalloonView.setBackgroundDrawable(bgBackup);
                    }
                    if (customPressedCalloutBalloonBitmap != null && (filePressed = BitmapUtils.saveBitmapAsPngFile(this.getContext(), customPressedCalloutBalloonBitmap, "image/custom_pressed_info_window", poiItem.getCustomPressedCalloutBalloonImageFileName())).exists()) {
                        customPressedInfoWindowImageFileAbsolutePath = ResourceUtils.getResourceAbsolutePath(filePressed.getAbsolutePath());
                    }
                    final String customInfoWindowImageFileAbsolutePath_F = customInfoWindowImageFileAbsolutePath;
                    final String customPressedInfoWindowImageFileAbsolutePath_F = customPressedInfoWindowImageFileAbsolutePath;
                    if (customInfoWindowImageFileAbsolutePath_F == null) continue;
                    Runnable task = new Runnable(){

                        @Override
                        public void run() {
                            if (customInfoWindowImageFileAbsolutePath_F != null) {
                                NativePOIItemMarkerManager.setCustomCalloutBalloonImageFilePath(poiMarkerId, customInfoWindowImageFileAbsolutePath_F);
                            }
                            if (customPressedInfoWindowImageFileAbsolutePath_F != null) {
                                NativePOIItemMarkerManager.setCustomPressedCalloutBalloonImageFilePath(poiMarkerId, customPressedInfoWindowImageFileAbsolutePath_F);
                            }
                            NativePOIItemMarkerManager.callbackAfterPrepareCalloutBalloonImage(poiMarkerId, animated);
                        }
                    };
                    MapTaskManager.getInstance().queueTask(task, MapEngineManager.getInstance().getStopGlSwap());
                    continue;
                }
                Runnable task = new Runnable(){

                    @Override
                    public void run() {
                        NativePOIItemMarkerManager.callbackAfterPrepareCalloutBalloonImage(poiMarkerId, animated);
                    }
                };
                MapTaskManager.getInstance().queueTask(task, MapEngineManager.getInstance().getStopGlSwap());
            }
        }
    }

    void onCalloutBalloonOfPOIItemTouched(final int poiMarkerId, int buttonType) {
        Activity activity = (Activity)this.dmapActivity.get();
        if (activity == null) {
            return;
        }
        if (this.poiItemEventListener == null || this.poiItemEventListener.get() == null) {
            return;
        }
        MapPOIItem.CalloutBalloonButtonType calloutBalloonButtonType = MapPOIItem.CalloutBalloonButtonType.MainButton;
        calloutBalloonButtonType = buttonType == 1 ? MapPOIItem.CalloutBalloonButtonType.MainButton : (buttonType == 2 ? MapPOIItem.CalloutBalloonButtonType.LeftSideButton : (buttonType == 3 ? MapPOIItem.CalloutBalloonButtonType.RightSideButton : MapPOIItem.CalloutBalloonButtonType.MainButton));
        final MapPOIItem.CalloutBalloonButtonType calloutBalloonButtonTypeFinal = calloutBalloonButtonType;
        final MapView mapView = this;
        activity.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                if (MapView.this.poiItemEventListener == null) {
                    return;
                }
                POIItemEventListener listener = (POIItemEventListener)MapView.this.poiItemEventListener.get();
                if (listener == null) {
                    return;
                }
                for (MapPOIItem poiItem : MapView.this.poiItems) {
                    if (poiItem.getId() != poiMarkerId) continue;
                    if (poiItem.getLeftSideButtonResourceIdOnCalloutBalloon() == 0 && poiItem.getRightSideButtonResourceIdOnCalloutBalloon() == 0) {
                        listener.onCalloutBalloonOfPOIItemTouched(mapView, poiItem);
                    }
                    listener.onCalloutBalloonOfPOIItemTouched(mapView, poiItem, calloutBalloonButtonTypeFinal);
                }
            }
        });
    }

    void onDraggablePOIItemMoved(final int poiMarkerId, final double newMapPointX, final double newMapPointY) {
        Activity activity = (Activity)this.dmapActivity.get();
        if (activity == null) {
            return;
        }
        if (this.poiItemEventListener == null || this.poiItemEventListener.get() == null) {
            return;
        }
        final MapView mapView = this;
        activity.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                if (MapView.this.poiItemEventListener == null) {
                    return;
                }
                POIItemEventListener listener = (POIItemEventListener)MapView.this.poiItemEventListener.get();
                if (listener == null) {
                    return;
                }
                for (MapPOIItem poiItem : MapView.this.poiItems) {
                    if (poiItem.getId() != poiMarkerId) continue;
                    listener.onDraggablePOIItemMoved(mapView, poiItem, MapPoint.mapPointWithWCONGCoord(newMapPointX, newMapPointY));
                }
            }
        });
    }

    public static enum CurrentLocationTrackingMode {
        TrackingModeOff,
        TrackingModeOnWithoutHeading,
        TrackingModeOnWithHeading,
        TrackingModeOnWithoutHeadingWithoutMapMoving,
        TrackingModeOnWithHeadingWithoutMapMoving,
        TrackingModeOnWithMarkerHeadingWithoutMapMoving;

    }

    public static enum MapTileMode {
        Standard,
        HD,
        HD2X;

    }

    public static enum MapType {
        Standard,
        Satellite,
        Hybrid;

    }

    public static interface POIItemEventListener {
        public void onPOIItemSelected(MapView var1, MapPOIItem var2);

        @Deprecated
        public void onCalloutBalloonOfPOIItemTouched(MapView var1, MapPOIItem var2);

        public void onCalloutBalloonOfPOIItemTouched(MapView var1, MapPOIItem var2, MapPOIItem.CalloutBalloonButtonType var3);

        public void onDraggablePOIItemMoved(MapView var1, MapPOIItem var2, MapPoint var3);
    }

    public static interface CurrentLocationEventListener {
        public void onCurrentLocationUpdate(MapView var1, MapPoint var2, float var3);

        public void onCurrentLocationDeviceHeadingUpdate(MapView var1, float var2);

        public void onCurrentLocationUpdateFailed(MapView var1);

        public void onCurrentLocationUpdateCancelled(MapView var1);
    }

    public static interface MapViewEventListener {
        public void onMapViewInitialized(MapView var1);

        public void onMapViewCenterPointMoved(MapView var1, MapPoint var2);

        public void onMapViewZoomLevelChanged(MapView var1, int var2);

        public void onMapViewSingleTapped(MapView var1, MapPoint var2);

        public void onMapViewDoubleTapped(MapView var1, MapPoint var2);

        public void onMapViewLongPressed(MapView var1, MapPoint var2);

        public void onMapViewDragStarted(MapView var1, MapPoint var2);

        public void onMapViewDragEnded(MapView var1, MapPoint var2);

        public void onMapViewMoveFinished(MapView var1, MapPoint var2);
    }

    public static interface OpenAPIKeyAuthenticationResultListener {
        public void onDaumMapOpenAPIKeyAuthenticationResult(MapView var1, int var2, String var3);
    }
}

