/*
 * Decompiled with CFR 0.152.
 */
package net.daum.mf.map.n.api;

import android.util.Log;
import net.daum.android.map.MapBuildSettings;
import net.daum.android.map.MapLibraryNativeConfig;

public class NativeMapLibraryLoader {
    public static final String classPath = "net.daum.android.map.MapLibraryConfigImpl";
    private static boolean isLoaded = false;

    public static void loadLibrary() {
        if (!isLoaded) {
            MapLibraryNativeConfig instance = null;
            try {
                Class<MapLibraryNativeConfig> clazz = Class.forName(classPath).asSubclass(MapLibraryNativeConfig.class);
                if (clazz == null && !MapBuildSettings.getInstance().isDistribution()) {
                    Log.e((String)NativeMapLibraryLoader.class.getName(), (String)"Please add a NativeMapLibraryLoader implementation class : net.daum.android.map.MapLibraryConfigImpl");
                }
                instance = clazz.newInstance();
            }
            catch (Exception e) {
                throw new IllegalStateException(e);
            }
            MapLibraryNativeConfig config = instance;
            for (String name : config.getLibraryNames()) {
                try {
                    System.loadLibrary(name);
                    isLoaded = true;
                    break;
                }
                catch (UnsatisfiedLinkError ex) {
                    Log.e((String)NativeMapLibraryLoader.class.getName(), (String)("Can`t load " + name + ".so file"));
                }
            }
            if (!isLoaded) {
                throw new UnsatisfiedLinkError();
            }
        }
    }
}

