/*
 * Decompiled with CFR 0.152.
 */
package net.daum.mf.map.api;

import android.graphics.Bitmap;
import android.view.View;
import java.util.Date;
import net.daum.android.map.MapEngineManager;
import net.daum.android.map.util.BitmapUtils;
import net.daum.mf.map.api.MapPoint;
import net.daum.mf.map.n.api.NativeMapCoord;
import net.daum.mf.map.n.api.internal.NativePOIItemMarkerManager;
import net.daum.mf.map.task.MapTaskManager;

public class MapPOIItem {
    private String itemName = null;
    private MapPoint mapPoint = null;
    private MarkerType markerType = MarkerType.BluePin;
    private MarkerType selectedMarkerType = null;
    private ShowAnimationType showAnimationType = ShowAnimationType.NoAnimation;
    private boolean showCalloutBalloonOnTouch = true;
    private boolean showDisclosureButtonOnCalloutBalloon = true;
    private int leftSideButtonResourceIdOnCalloutBalloon = 0;
    private int rightSideButtonResourceIdOnCalloutBalloon = 0;
    private boolean draggable = false;
    private int tag = 0;
    private Object userObject = null;
    private int customImageResourceId = 0;
    private int customSelectedImageResourceId = 0;
    private float customImageAnchorRatioFromTopLeftOriginX = -1.0f;
    private float customImageAnchorRatioFromTopLeftOriginY = -1.0f;
    private ImageOffset customImageAnchorPointOffset = null;
    private View customCalloutBalloonView = null;
    private View customPressedCalloutBalloonView = null;
    private Bitmap customCalloutBalloonBitmap;
    private Bitmap customPressedCalloutBalloonBitmap;
    private Bitmap customImageBitmap = null;
    private Bitmap customSelectedImageBitmap = null;
    private boolean customImageAutoscale = true;
    private boolean moveToCenterOnSelect = true;
    private int id = -1;
    private float alpha = 1.0f;
    private float rotation = 0.0f;
    long createdTime = -1L;
    static final String CUSTOM_CALLOUT_BALLOON_IMAGE_DIR = "image/custom_info_window";
    static final String CUSTOM_PRESSED_CALLOUT_BALLOON_IMAGE_DIR = "image/custom_pressed_info_window";

    public void setRotation(final float rotation) {
        this.rotation = rotation;
        Runnable task = new Runnable(){

            @Override
            public void run() {
                int mapComponentId = MapPOIItem.this.getId();
                NativePOIItemMarkerManager.setRotation(mapComponentId, rotation);
            }
        };
        MapTaskManager.getInstance().queueTask(task, MapEngineManager.getInstance().getStopGlSwap());
    }

    public void setAlpha(final float alpha) {
        this.alpha = alpha;
        Runnable task = new Runnable(){

            @Override
            public void run() {
                int mapComponentId = MapPOIItem.this.getId();
                NativePOIItemMarkerManager.setAlpha(mapComponentId, alpha);
            }
        };
        MapTaskManager.getInstance().queueTask(task, MapEngineManager.getInstance().getStopGlSwap());
    }

    public float getAlpha() {
        return this.alpha;
    }

    public float getRotation() {
        return this.rotation;
    }

    public String getItemName() {
        return this.itemName;
    }

    public void setItemName(String itemName) {
        this.itemName = itemName;
        final int mapComponentId = this.getId();
        final String name = itemName;
        Runnable task = new Runnable(){

            @Override
            public void run() {
                NativePOIItemMarkerManager.setName(mapComponentId, name);
            }
        };
        MapTaskManager.getInstance().queueTask(task, MapEngineManager.getInstance().getStopGlSwap());
    }

    public MapPoint getMapPoint() {
        return this.mapPoint;
    }

    public void setMapPoint(MapPoint mapPoint) {
        this.mapPoint = mapPoint;
        MapPoint.PlainCoordinate mapPointWCONG = mapPoint.getMapPointWCONGCoord();
        final NativeMapCoord nativeMapPoint = new NativeMapCoord(mapPointWCONG.x, mapPointWCONG.y, 2);
        final int mapComponentId = this.getId();
        Runnable task = new Runnable(){

            @Override
            public void run() {
                NativePOIItemMarkerManager.setCoord(mapComponentId, nativeMapPoint);
            }
        };
        MapTaskManager.getInstance().queueTask(task, MapEngineManager.getInstance().getStopGlSwap());
    }

    public void moveWithAnimation(MapPoint mapPoint, Boolean animate) {
        this.mapPoint = mapPoint;
        MapPoint.PlainCoordinate mapPointWCONG = mapPoint.getMapPointWCONGCoord();
        final Boolean useAnimation = animate;
        final NativeMapCoord nativeMapPoint = new NativeMapCoord(mapPointWCONG.x, mapPointWCONG.y, 2);
        final int mapComponentId = this.getId();
        Runnable task = new Runnable(){

            @Override
            public void run() {
                NativePOIItemMarkerManager.moveWithAnimation(mapComponentId, nativeMapPoint, useAnimation);
            }
        };
        MapTaskManager.getInstance().queueTask(task, MapEngineManager.getInstance().getStopGlSwap());
    }

    public MarkerType getMarkerType() {
        return this.markerType;
    }

    public void setMarkerType(MarkerType markerType) {
        this.markerType = markerType;
    }

    public MarkerType getSelectedMarkerType() {
        return this.selectedMarkerType;
    }

    public void setSelectedMarkerType(MarkerType markerType) {
        this.selectedMarkerType = markerType;
    }

    public ShowAnimationType getShowAnimationType() {
        return this.showAnimationType;
    }

    public void setShowAnimationType(ShowAnimationType showAnimationType) {
        this.showAnimationType = showAnimationType;
    }

    public boolean isShowCalloutBalloonOnTouch() {
        return this.showCalloutBalloonOnTouch;
    }

    public void setShowCalloutBalloonOnTouch(boolean showCalloutBalloonOnTouch) {
        this.showCalloutBalloonOnTouch = showCalloutBalloonOnTouch;
    }

    public boolean isShowDisclosureButtonOnCalloutBalloon() {
        return this.showDisclosureButtonOnCalloutBalloon;
    }

    public void setShowDisclosureButtonOnCalloutBalloon(boolean showDisclosureButtonOnCalloutBalloon) {
        this.showDisclosureButtonOnCalloutBalloon = showDisclosureButtonOnCalloutBalloon;
    }

    public void setLeftSideButtonResourceIdOnCalloutBalloon(int imageResourceId) {
        this.leftSideButtonResourceIdOnCalloutBalloon = imageResourceId;
    }

    public void setRightSideButtonResourceIdOnCalloutBalloon(int imageResourceId) {
        this.rightSideButtonResourceIdOnCalloutBalloon = imageResourceId;
    }

    public int getLeftSideButtonResourceIdOnCalloutBalloon() {
        return this.leftSideButtonResourceIdOnCalloutBalloon;
    }

    public int getRightSideButtonResourceIdOnCalloutBalloon() {
        return this.rightSideButtonResourceIdOnCalloutBalloon;
    }

    public boolean isDraggable() {
        return this.draggable;
    }

    public void setDraggable(boolean draggable) {
        this.draggable = draggable;
    }

    public int getTag() {
        return this.tag;
    }

    public void setTag(int tag) {
        this.tag = tag;
    }

    public Object getUserObject() {
        return this.userObject;
    }

    public void setUserObject(Object userObject) {
        this.userObject = userObject;
    }

    public int getCustomImageResourceId() {
        return this.customImageResourceId;
    }

    public int getCustomSelectedImageResourceId() {
        return this.customSelectedImageResourceId;
    }

    public Bitmap getCustomImageBitmap() {
        return this.customImageBitmap;
    }

    public Bitmap getCustomSelectedImageBitmap() {
        return this.customSelectedImageBitmap;
    }

    public void setCustomImageBitmap(Bitmap bm) {
        this.customImageBitmap = bm;
    }

    public void setCustomSelectedImageBitmap(Bitmap bm) {
        this.customSelectedImageBitmap = bm;
    }

    public void setCustomImageResourceId(int imageResourceId) {
        this.customImageResourceId = imageResourceId;
    }

    public void setCustomSelectedImageResourceId(int imageResourceId) {
        this.customSelectedImageResourceId = imageResourceId;
    }

    public void setCustomImageAnchor(float ratioFromTopLeftOriginX, float ratioFromTopLeftOriginY) {
        this.customImageAnchorRatioFromTopLeftOriginX = ratioFromTopLeftOriginX;
        this.customImageAnchorRatioFromTopLeftOriginY = ratioFromTopLeftOriginY;
    }

    public float getCustomImageAnchorRatioFromTopLeftOriginX() {
        return this.customImageAnchorRatioFromTopLeftOriginX;
    }

    public float getCustomImageAnchorRatioFromTopLeftOriginY() {
        return this.customImageAnchorRatioFromTopLeftOriginY;
    }

    public ImageOffset getCustomImageAnchorPointOffset() {
        return this.customImageAnchorPointOffset;
    }

    public void setCustomImageAnchorPointOffset(ImageOffset customImageAnchorPointOffset) {
        this.customImageAnchorPointOffset = customImageAnchorPointOffset;
    }

    public void setCustomCalloutBalloon(View view) {
        this.customCalloutBalloonView = view;
        this.customCalloutBalloonBitmap = BitmapUtils.createBitmapFromView(view);
    }

    public View getCustomCalloutBalloon() {
        return this.customCalloutBalloonView;
    }

    public Bitmap getCustomCalloutBalloonBitmap() {
        return this.customCalloutBalloonBitmap;
    }

    public void setCustomPressedCalloutBalloon(View view) {
        this.customPressedCalloutBalloonView = view;
        this.customPressedCalloutBalloonBitmap = BitmapUtils.createBitmapFromView(view);
    }

    public void setCustomCalloutBalloonBitmap(Bitmap customCalloutBalloonBitmap) {
        this.customCalloutBalloonBitmap = customCalloutBalloonBitmap;
    }

    public void setCustomPressedCalloutBalloonBitmap(Bitmap customPressedCalloutBalloonBitmap) {
        this.customPressedCalloutBalloonBitmap = customPressedCalloutBalloonBitmap;
    }

    public Bitmap getCustomPressedCalloutBalloonBitmap() {
        return this.customPressedCalloutBalloonBitmap;
    }

    public View getCustomPressedCalloutBalloon() {
        return this.customPressedCalloutBalloonView;
    }

    public boolean isCustomImageAutoscale() {
        return this.customImageAutoscale;
    }

    public void setCustomImageAutoscale(boolean enableAutoscale) {
        this.customImageAutoscale = enableAutoscale;
    }

    int getId() {
        return this.id;
    }

    void setId(int id) {
        this.id = id;
    }

    String getCustomImageResourcePath() {
        if (this.customImageResourceId == 0) {
            return null;
        }
        return String.format("res:%d", this.customImageResourceId);
    }

    String getCustomSelectedImageResourcePath() {
        if (this.customSelectedImageResourceId == 0) {
            return null;
        }
        return String.format("res:%d", this.customSelectedImageResourceId);
    }

    long getCreatedTime() {
        if (this.createdTime == -1L) {
            this.createdTime = new Date().getTime() + (long)this.hashCode();
        }
        return this.createdTime;
    }

    private String getCustomImageNameWithPrefix(String prefix) {
        return prefix + "_" + this.getTag() + "_" + this.getCreatedTime();
    }

    String getCustomImageFileName() {
        return this.getCustomImageNameWithPrefix("customImage_") + ".png";
    }

    String getCustomSelectedImageFileName() {
        return this.getCustomImageNameWithPrefix("customImage_") + "_selected.png";
    }

    String getCustomCalloutBalloonImageFileName() {
        return this.getCustomImageNameWithPrefix("customCalloutImage_") + ".png";
    }

    String getCustomPressedCalloutBalloonImageFileName() {
        return this.getCustomImageNameWithPrefix("customCalloutImage_") + "_pressed.png";
    }

    public boolean isMoveToCenterOnSelect() {
        return this.moveToCenterOnSelect;
    }

    public void setMoveToCenterOnSelect(boolean moveToCenterOnSelect) {
        this.moveToCenterOnSelect = moveToCenterOnSelect;
    }

    public static enum CalloutBalloonButtonType {
        MainButton,
        LeftSideButton,
        RightSideButton;

    }

    public static class ImageOffset {
        public int offsetX;
        public int offsetY;

        public ImageOffset(int offsetX, int offsetY) {
            this.offsetX = offsetX;
            this.offsetY = offsetY;
        }
    }

    public static enum ShowAnimationType {
        NoAnimation,
        DropFromHeaven,
        SpringFromGround;

    }

    public static enum MarkerType {
        BluePin,
        RedPin,
        YellowPin,
        CustomImage;

    }
}

