/*
 * Decompiled with CFR 0.152.
 */
package net.daum.mf.map.common.net;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.List;
import net.daum.mf.map.common.net.KeyValuePair;

public class UrlEncodeUtils {
    public static final String CONTENT_TYPE = "application/x-www-form-urlencoded";
    private static final String PARAMETER_SEPARATOR = "&";
    private static final String NAME_VALUE_SEPARATOR = "=";

    public static String format(List<KeyValuePair> parameters, String encoding) {
        StringBuilder result = new StringBuilder();
        for (KeyValuePair parameter : parameters) {
            String encodedValue;
            String encodedName = UrlEncodeUtils.encode(parameter.getName(), encoding);
            String value = parameter.getValue();
            String string = encodedValue = value != null ? UrlEncodeUtils.encode(value, encoding) : "";
            if (result.length() > 0) {
                result.append(PARAMETER_SEPARATOR);
            }
            result.append(encodedName);
            result.append(NAME_VALUE_SEPARATOR);
            result.append(encodedValue);
        }
        return result.toString();
    }

    private static String encode(String content, String encoding) {
        try {
            return URLEncoder.encode(content, encoding != null ? encoding : "ISO-8859-1");
        }
        catch (UnsupportedEncodingException problem) {
            throw new IllegalArgumentException(problem);
        }
    }
}

