/*
 * Decompiled with CFR 0.152.
 */
package net.daum.mf.map.n.api;

import android.os.Process;
import android.util.Log;
import java.util.HashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import net.daum.android.map.MapBuildSettings;
import net.daum.mf.map.n.api.NativeMapLibraryLoader;
import net.daum.mf.map.n.api.NativeThread;

public class NativePlatformThread {
    private static HashMap<Integer, PlatformThread> ThreadMap;

    public static native void onPlatformThreadLoopNative(int var0);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void startThread(int threadId, int sleepTimePerLoop) {
        HashMap<Integer, PlatformThread> hashMap = ThreadMap;
        synchronized (hashMap) {
            PlatformThread thread = ThreadMap.get(new Integer(threadId));
            if (thread == null) {
                thread = new PlatformThread(threadId, sleepTimePerLoop);
                ThreadMap.put(new Integer(threadId), thread);
                thread.start();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void cancelThread(int threadId) {
        HashMap<Integer, PlatformThread> hashMap = ThreadMap;
        synchronized (hashMap) {
            PlatformThread thread = ThreadMap.get(new Integer(threadId));
            if (thread != null) {
                if (!MapBuildSettings.getInstance().isDistribution()) {
                    Log.d((String)NativePlatformThread.class.getName(), (String)("Cancelling " + thread.getName()));
                }
                thread.setCancelled();
            }
        }
    }

    static {
        NativeMapLibraryLoader.loadLibrary();
        ThreadMap = new HashMap();
    }

    private static class PlatformThread
    extends NativeThread {
        private int threadId;
        private int sleepTimePerLoop;
        private AtomicBoolean isCanceled;

        public PlatformThread(int threadId, int sleepTimePerLoop) {
            super(String.format("[MapEngine]PlatformThread%d", threadId));
            this.threadId = threadId;
            this.sleepTimePerLoop = sleepTimePerLoop;
            this.isCanceled = new AtomicBoolean(false);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        @Override
        protected void nativeRun() {
            if (!MapBuildSettings.getInstance().isDistribution()) {
                Log.d((String)NativePlatformThread.class.getName(), (String)(super.getName() + " started"));
            }
            Process.setThreadPriority((int)-2);
            try {
                while (!this.isCanceled.get()) {
                    try {
                        NativePlatformThread.onPlatformThreadLoopNative(this.threadId);
                        if (this.sleepTimePerLoop <= 0) continue;
                        Thread.sleep(this.sleepTimePerLoop);
                    }
                    catch (InterruptedException interruptedException) {}
                }
                return;
            }
            catch (RuntimeException e) {
                Log.e((String)NativePlatformThread.class.getName(), (String)("" + e.getMessage()));
                throw e;
            }
            finally {
                HashMap hashMap = ThreadMap;
            }
        }

        public void setCancelled() {
            this.isCanceled.set(true);
        }
    }
}

