/*
 * Decompiled with CFR 0.152.
 */
package net.daum.mf.map.task;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import net.daum.mf.map.task.MainQueueManager;
import net.daum.mf.map.task.WaitQueueManager;

public class MapTaskManager {
    private static MapTaskManager instance = new MapTaskManager();
    private ExecutorService executor = new ThreadPoolExecutor(2, Integer.MAX_VALUE, 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>());

    public static MapTaskManager getInstance() {
        return instance;
    }

    private MapTaskManager() {
    }

    public void execute(Runnable task) {
        this.executor.execute(task);
    }

    public void queueTask(Runnable task, boolean waitQueue) {
        if (waitQueue) {
            WaitQueueManager.getInstance().queueToWaitQueue(task);
        } else {
            MainQueueManager.getInstance().queueToMainQueue(task);
        }
    }
}

