/*
 * Decompiled with CFR 0.152.
 */
package com.nable.nme;

import android.content.Context;
import android.hardware.Camera;
import android.opengl.GLES20;
import android.opengl.GLSurfaceView;
import android.os.Build;
import android.util.Log;
import android.view.Surface;
import android.view.SurfaceHolder;
import android.view.SurfaceView;
import android.view.View;
import com.nable.nme.NableMediaEngine;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import javax.microedition.khronos.egl.EGLConfig;
import javax.microedition.khronos.opengles.GL10;

public class VideoController {
    private static VideoController _singleton = null;
    private static String _tag = "NME_VIDEOCONTROLLER";
    private static SurfaceView m_LocalView = null;
    private static RxGLSurfaceView m_RemoteView = null;
    private static Context m_Context = null;
    private static int m_nWidth;
    private static int m_nHeight;
    private static int m_nFps;
    private static int m_nWidthRx;
    private static int m_nHeightRx;
    private static int m_CameraIndex;
    private static int m_nTxViewState;
    private static int m_nRxViewState;
    private static boolean mTxStart;
    private static boolean mRxStart;
    private static boolean mStartTx;
    private static boolean mStartRx;
    private static boolean mTxSurfaceCreated;
    private static boolean mRxSurfaceCreated;
    private static boolean mTxPaused;
    private static boolean mRxPaused;
    private static boolean mCameraStopping;
    private static CameraManager mCameraManager;
    static SurfaceHolder.Callback surfaceLocalCallback;
    static SurfaceHolder.Callback surfaceRemoteCallback;

    static {
        m_CameraIndex = 1;
        mTxStart = false;
        mRxStart = false;
        mStartTx = false;
        mStartRx = false;
        mTxSurfaceCreated = false;
        mRxSurfaceCreated = false;
        mTxPaused = false;
        mRxPaused = false;
        mCameraStopping = false;
        mCameraManager = new CameraManager();
        surfaceLocalCallback = new SurfaceHolder.Callback(){

            public void surfaceCreated(SurfaceHolder holder) {
                Log.d((String)_tag, (String)String.format("surfaceLocalCallback.surfaceCreated():: ", new Object[0]));
                mTxSurfaceCreated = true;
                m_nTxViewState = 0;
                if (mTxStart) {
                    if (!mCameraStopping) {
                        mCameraManager.startPreview();
                    } else {
                        Log.d((String)_tag, (String)String.format("Camera is stopping!! ", new Object[0]));
                    }
                }
            }

            public void surfaceChanged(SurfaceHolder holder, int format, int width, int height) {
                Log.d((String)_tag, (String)String.format("surfaceLocalCallback.surfaceChanged():: ", new Object[0]));
                m_nTxViewState = 2;
            }

            public void surfaceDestroyed(SurfaceHolder holder) {
                mTxSurfaceCreated = false;
                Log.d((String)_tag, (String)String.format("surfaceLocalCallback.surfaceDestroyed()::", new Object[0]));
                m_nTxViewState = 1;
                if (mTxStart) {
                    if (!mCameraStopping) {
                        mCameraManager.stopPreview();
                    } else {
                        Log.d((String)_tag, (String)String.format("Camera is stopping!! ", new Object[0]));
                    }
                }
            }
        };
        surfaceRemoteCallback = new SurfaceHolder.Callback(){

            public void surfaceCreated(SurfaceHolder holder) {
                Log.d((String)_tag, (String)String.format("surfaceRemoteCallback.surfaceCreated()::", new Object[0]));
                m_nRxViewState = 0;
                VideoController.OnRxSurfaceViewState(0);
            }

            public void surfaceChanged(SurfaceHolder holder, int format, int width, int height) {
                Log.d((String)_tag, (String)String.format("surfaceRemoteCallback.surfaceChanged()::", new Object[0]));
                m_nRxViewState = 2;
                VideoController.OnRxSurfaceViewState(2);
            }

            public void surfaceDestroyed(SurfaceHolder holder) {
                Log.d((String)_tag, (String)String.format("surfaceRemoteCallback.surfaceDestroyed()::", new Object[0]));
                m_nRxViewState = 1;
                VideoController.OnRxSurfaceViewState(1);
            }
        };
    }

    public static synchronized VideoController getSingleton() {
        if (_singleton == null) {
            _singleton = new VideoController();
        }
        return _singleton;
    }

    private VideoController() {
        NableMediaEngine.getSingleton();
    }

    public static int VideoRxCallBack(byte[] y, byte[] u, byte[] v, int length) {
        m_RemoteView.update(y, u, v);
        return 0;
    }

    public static int VideoCAMStart(int width, int height) {
        Log.d((String)_tag, (String)String.format("VideoCAMStart()::Start", new Object[0]));
        VideoController.CameraStart(width, height);
        mStartTx = true;
        return 0;
    }

    public static int CameraStart(int width, int height) {
        Log.d((String)_tag, (String)String.format("CameraStart()::Start", new Object[0]));
        m_nWidth = width;
        m_nHeight = height;
        mCameraManager.StartCamera(width, height);
        mTxStart = true;
        return 0;
    }

    public static boolean pauseCamera() {
        Log.d((String)_tag, (String)String.format("pauseVideo", new Object[0]));
        if (mStartTx) {
            VideoController.CameraStop();
        }
        mTxPaused = true;
        mRxPaused = true;
        return true;
    }

    public static boolean resumeCamera() {
        Log.d((String)_tag, (String)String.format("resumeVideo", new Object[0]));
        if (mStartTx) {
            VideoController.CameraStart(m_nWidth, m_nHeight);
        }
        mTxPaused = false;
        mRxPaused = false;
        return true;
    }

    public static int VideoCAMStop() {
        Log.d((String)_tag, (String)String.format("VideoCAMStop()::Start", new Object[0]));
        mStartTx = false;
        mCameraStopping = true;
        VideoController.CameraStop();
        mCameraStopping = false;
        return 0;
    }

    public static int CameraStop() {
        Log.d((String)_tag, (String)String.format("CameraStop()::Start", new Object[0]));
        if (mCameraManager != null) {
            mCameraManager.deInitCamera();
        }
        mTxStart = false;
        try {
            Thread.sleep(500L, 0);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        return 0;
    }

    public static int SetCamera(int index) {
        Log.d((String)_tag, (String)String.format("SetCamera()::Start %d", index));
        if (m_CameraIndex == index) {
            return 0;
        }
        m_CameraIndex = index;
        mCameraManager.SetCamera(index);
        return 0;
    }

    public static Surface GetRemoteView(int width, int height) {
        Log.d((String)_tag, (String)String.format("GetRemoteView()::Start", new Object[0]));
        m_nWidthRx = width;
        m_nHeightRx = height;
        m_RemoteView.update(m_nWidthRx, m_nHeightRx);
        return m_RemoteView.getHolder().getSurface();
    }

    private static native int OnCAMInput(byte[] var0, int var1);

    private static native int OnRxSurfaceViewState(int var0);

    protected synchronized View createLocalView(Context context) {
        m_Context = context;
        m_LocalView = new SurfaceView(context);
        m_LocalView.getHolder().setType(3);
        m_LocalView.getHolder().addCallback(surfaceLocalCallback);
        return m_LocalView;
    }

    protected synchronized View createRemoteView(Context context) {
        m_RemoteView = new RxGLSurfaceView(context);
        m_RemoteView.getHolder().addCallback(surfaceRemoteCallback);
        return m_RemoteView;
    }

    public static class CameraManager {
        static Camera mCamera = null;
        static int m_Width;
        static int m_Height;
        static int m_CameraIndex;
        static CameraThread Camera_Callback;
        static boolean m_isOpen;

        static {
            m_CameraIndex = 1;
            Camera_Callback = new CameraThread();
            m_isOpen = false;
        }

        public int initCamera() {
            Log.d((String)_tag, (String)String.format("CameraStartThread()::open!!", new Object[0]));
            mCamera = Camera.open((int)m_CameraIndex);
            m_isOpen = true;
            Camera.Parameters parameters = mCamera.getParameters();
            if (m_Height > m_Width) {
                parameters.setPreviewSize(m_Height, m_Width);
            } else {
                parameters.setPreviewSize(m_Width, m_Height);
            }
            parameters.setPreviewFrameRate(15);
            String model = Build.MODEL;
            boolean bflip = false;
            if (model.matches("Nexus 6P")) {
                Log.d((String)_tag, (String)String.format("Model Name :: " + model, new Object[0]));
                bflip = true;
            }
            if (bflip) {
                if (m_CameraIndex == 1) {
                    mCamera.setDisplayOrientation(270);
                } else {
                    mCamera.setDisplayOrientation(90);
                }
            } else {
                mCamera.setDisplayOrientation(90);
            }
            mCamera.setParameters(parameters);
            if (mTxSurfaceCreated && !mTxStart) {
                mCameraManager.startPreview();
            }
            return 0;
        }

        public int startPreview() {
            try {
                Log.d((String)_tag, (String)String.format("SetPreView()::TRY!!", new Object[0]));
                if (m_LocalView != null) {
                    mCamera.setPreviewCallback((Camera.PreviewCallback)Camera_Callback);
                    mCamera.setPreviewDisplay(m_LocalView.getHolder());
                    mCamera.startPreview();
                }
            }
            catch (Exception e) {
                Log.d((String)_tag, (String)String.format("SetPreView()::Failed!!", new Object[0]));
                e.printStackTrace();
            }
            return 1;
        }

        public int stopPreview() {
            if (mCamera != null) {
                try {
                    mCamera.stopPreview();
                }
                catch (Exception e) {
                    Log.d((String)_tag, (String)String.format("stopPreview()::Failed!!", new Object[0]));
                    e.printStackTrace();
                }
            }
            return 1;
        }

        public int deInitCamera() {
            if (mCamera != null) {
                mCamera.setPreviewCallback(null);
                mCamera.release();
                mCamera = null;
                m_isOpen = false;
            }
            return 0;
        }

        public boolean StartCamera(int width, int height) {
            m_Width = width;
            m_Height = height;
            this.initCamera();
            return true;
        }

        public boolean SetCamera(int index) {
            m_CameraIndex = index;
            if (m_isOpen) {
                this.deInitCamera();
                try {
                    Thread.sleep(200L, 0);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                this.StartCamera(m_Width, m_Height);
            }
            return true;
        }
    }

    private static class CameraThread
    implements Camera.PreviewCallback {
        private CameraThread() {
        }

        public void onPreviewFrame(byte[] data, Camera camera) {
            int dataSize = m_nWidth * m_nHeight * 3 / 2;
            VideoController.OnCAMInput(data, dataSize);
        }
    }

    private static class GLRenderer
    implements GLSurfaceView.Renderer {
        private static final String TAG = "MyGLRenderer";
        private int mVideoWidth = -1;
        private int mVideoHeight = -1;
        private ByteBuffer y;
        private ByteBuffer u;
        private ByteBuffer v;
        private boolean isProgBuilt = false;
        private ByteBuffer _vertice_buffer;
        private ByteBuffer _coord_buffer;
        private int _program = -1;
        private int _positionHandle;
        private int _coordHandle;
        private int _yhandle;
        private int _uhandle;
        private int _vhandle;
        private int _ytid = -1;
        private int _utid = -1;
        private int _vtid = -1;
        private int _textureI = 33984;
        private int _textureII = 33985;
        private int _textureIII = 33986;
        private int _tIindex = 0;
        private int _tIIindex = 1;
        private int _tIIIindex = 2;
        private static float[] squareVertices = new float[]{-1.0f, -1.0f, 1.0f, -1.0f, -1.0f, 1.0f, 1.0f, 1.0f};
        private static float[] coordVertices = new float[]{0.0f, 1.0f, 1.0f, 1.0f, 0.0f, 0.0f, 1.0f, 0.0f};
        private static final String VERTEX_SHADER = "attribute vec4 vPosition;\nattribute vec2 a_texCoord;\nvarying vec2 tc;\nvoid main() {\ngl_Position = vPosition;\ntc = a_texCoord;\n}\n";
        private static final String FRAGMENT_SHADER = "precision mediump float;\nuniform sampler2D tex_y;\nuniform sampler2D tex_u;\nuniform sampler2D tex_v;\nvarying vec2 tc;\nvoid main() {\nvec4 c = vec4((texture2D(tex_y, tc).r - 16./255.) * 1.164);\nvec4 U = vec4(texture2D(tex_u, tc).r - 128./255.);\nvec4 V = vec4(texture2D(tex_v, tc).r - 128./255.);\nc += V * vec4(1.596, -0.813, 0, 0);\nc += U * vec4(0, -0.392, 2.017, 0);\nc.a = 1.0;\ngl_FragColor = c;\n}\n";

        private GLRenderer() {
        }

        public void onSurfaceCreated(GL10 unused, EGLConfig config) {
            Log.d((String)_tag, (String)String.format("GLRenderer onSurfaceCreated", new Object[0]));
            GLES20.glClearColor((float)0.1f, (float)0.1f, (float)0.1f, (float)1.0f);
            if (!this.isProgramBuilt()) {
                this.buildProgram();
            }
        }

        public void onSurfaceChanged(GL10 unused, int width, int height) {
            Log.d((String)_tag, (String)String.format("GLRenderer onSurfaceChanged", new Object[0]));
            GLES20.glViewport((int)0, (int)0, (int)width, (int)height);
            float ratio = (float)width / (float)height;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onDrawFrame(GL10 unused) {
            GLRenderer gLRenderer = this;
            synchronized (gLRenderer) {
                if (this.y != null) {
                    this.y.position(0);
                    this.u.position(0);
                    this.v.position(0);
                    this.buildTextures(this.y, this.u, this.v, this.mVideoWidth, this.mVideoHeight);
                    GLES20.glClearColor((float)0.1f, (float)0.1f, (float)0.1f, (float)1.0f);
                    GLES20.glClear((int)16384);
                    this.drawFrame();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void update(int w, int h) {
            Log.d((String)_tag, (String)String.format("GLRenderer update %d, %d", w, h));
            if (w > 0 && h > 0 && w != this.mVideoWidth && h != this.mVideoHeight) {
                this.mVideoWidth = w;
                this.mVideoHeight = h;
                int yarraySize = w * h;
                int uvarraySize = yarraySize / 4;
                GLRenderer gLRenderer = this;
                synchronized (gLRenderer) {
                    this.y = ByteBuffer.allocate(yarraySize);
                    this.u = ByteBuffer.allocate(uvarraySize);
                    this.v = ByteBuffer.allocate(uvarraySize);
                    byte a = 127;
                    int i = 0;
                    while (i < uvarraySize) {
                        this.u.put(i, a);
                        this.v.put(i, a);
                        ++i;
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void update(byte[] ydata, byte[] udata, byte[] vdata) {
            GLRenderer gLRenderer = this;
            synchronized (gLRenderer) {
                this.y.clear();
                this.u.clear();
                this.v.clear();
                this.y.put(ydata, 0, ydata.length);
                this.u.put(udata, 0, udata.length);
                this.v.put(vdata, 0, vdata.length);
            }
        }

        public static int loadShader(int type, String shaderCode) {
            int shader = GLES20.glCreateShader((int)type);
            if (shader != 0) {
                GLES20.glShaderSource((int)shader, (String)shaderCode);
                GLES20.glCompileShader((int)shader);
                int[] compiled = new int[1];
                GLES20.glGetShaderiv((int)shader, (int)35713, (int[])compiled, (int)0);
                if (compiled[0] == 0) {
                    GLES20.glDeleteShader((int)shader);
                    shader = 0;
                }
            }
            Log.d((String)_tag, (String)String.format("GLRenderer loadShader", new Object[0]));
            return shader;
        }

        public static void checkGlError(String glOperation) {
            int error = GLES20.glGetError();
            if (error != 0) {
                Log.e((String)TAG, (String)(String.valueOf(glOperation) + ": glError " + error));
                throw new RuntimeException(String.valueOf(glOperation) + ": glError " + error);
            }
        }

        public boolean isProgramBuilt() {
            return this.isProgBuilt;
        }

        public void buildProgram() {
            this.createBuffers(squareVertices, coordVertices);
            if (this._program <= 0) {
                this._program = this.createProgram(VERTEX_SHADER, FRAGMENT_SHADER);
            }
            Log.d((String)_tag, (String)String.format("_program %d", this._program));
            this._positionHandle = GLES20.glGetAttribLocation((int)this._program, (String)"vPosition");
            GLRenderer.checkGlError("glGetAttribLocation vPosition");
            if (this._positionHandle == -1) {
                throw new RuntimeException("Could not get attribute location for vPosition");
            }
            this._coordHandle = GLES20.glGetAttribLocation((int)this._program, (String)"a_texCoord");
            GLRenderer.checkGlError("glGetAttribLocation a_texCoord");
            if (this._coordHandle == -1) {
                throw new RuntimeException("Could not get attribute location for a_texCoord");
            }
            this._yhandle = GLES20.glGetUniformLocation((int)this._program, (String)"tex_y");
            GLRenderer.checkGlError("glGetUniformLocation tex_y");
            if (this._yhandle == -1) {
                throw new RuntimeException("Could not get uniform location for tex_y");
            }
            this._uhandle = GLES20.glGetUniformLocation((int)this._program, (String)"tex_u");
            GLRenderer.checkGlError("glGetUniformLocation tex_u");
            if (this._uhandle == -1) {
                throw new RuntimeException("Could not get uniform location for tex_u");
            }
            this._vhandle = GLES20.glGetUniformLocation((int)this._program, (String)"tex_v");
            GLRenderer.checkGlError("glGetUniformLocation tex_v");
            if (this._vhandle == -1) {
                throw new RuntimeException("Could not get uniform location for tex_v");
            }
            this.isProgBuilt = true;
        }

        public int createProgram(String vertexSource, String fragmentSource) {
            int vertexShader = GLRenderer.loadShader(35633, vertexSource);
            int pixelShader = GLRenderer.loadShader(35632, fragmentSource);
            int program = GLES20.glCreateProgram();
            if (program != 0) {
                GLES20.glAttachShader((int)program, (int)vertexShader);
                GLRenderer.checkGlError("glAttachShader");
                GLES20.glAttachShader((int)program, (int)pixelShader);
                GLRenderer.checkGlError("glAttachShader");
                GLES20.glLinkProgram((int)program);
                int[] linkStatus = new int[1];
                GLES20.glGetProgramiv((int)program, (int)35714, (int[])linkStatus, (int)0);
                if (linkStatus[0] != 1) {
                    GLES20.glDeleteProgram((int)program);
                    program = 0;
                }
            }
            return program;
        }

        private void createBuffers(float[] vert, float[] coord) {
            this._vertice_buffer = ByteBuffer.allocateDirect(vert.length * 4);
            this._vertice_buffer.order(ByteOrder.nativeOrder());
            this._vertice_buffer.asFloatBuffer().put(vert);
            this._vertice_buffer.position(0);
            if (this._coord_buffer == null) {
                this._coord_buffer = ByteBuffer.allocateDirect(coord.length * 4);
                this._coord_buffer.order(ByteOrder.nativeOrder());
                this._coord_buffer.asFloatBuffer().put(coord);
                this._coord_buffer.position(0);
            }
        }

        public void buildTextures(Buffer y, Buffer u, Buffer v, int width, int height) {
            int[] textures;
            boolean videoSizeChanged;
            boolean bl = videoSizeChanged = width != this.mVideoWidth || height != this.mVideoHeight;
            if (videoSizeChanged) {
                this.mVideoWidth = width;
                this.mVideoHeight = height;
            }
            if (this._ytid < 0 || videoSizeChanged) {
                if (this._ytid >= 0) {
                    GLES20.glDeleteTextures((int)1, (int[])new int[]{this._ytid}, (int)0);
                    GLRenderer.checkGlError("glDeleteTextures");
                }
                textures = new int[1];
                GLES20.glGenTextures((int)1, (int[])textures, (int)0);
                GLRenderer.checkGlError("glGenTextures");
                this._ytid = textures[0];
            }
            GLES20.glBindTexture((int)3553, (int)this._ytid);
            GLRenderer.checkGlError("glBindTexture");
            GLES20.glTexImage2D((int)3553, (int)0, (int)6409, (int)this.mVideoWidth, (int)this.mVideoHeight, (int)0, (int)6409, (int)5121, (Buffer)y);
            GLRenderer.checkGlError("glTexImage2D");
            GLES20.glTexParameterf((int)3553, (int)10241, (float)9728.0f);
            GLES20.glTexParameterf((int)3553, (int)10240, (float)9729.0f);
            GLES20.glTexParameteri((int)3553, (int)10242, (int)33071);
            GLES20.glTexParameteri((int)3553, (int)10243, (int)33071);
            if (this._utid < 0 || videoSizeChanged) {
                if (this._utid >= 0) {
                    GLES20.glDeleteTextures((int)1, (int[])new int[]{this._utid}, (int)0);
                    GLRenderer.checkGlError("glDeleteTextures");
                }
                textures = new int[1];
                GLES20.glGenTextures((int)1, (int[])textures, (int)0);
                GLRenderer.checkGlError("glGenTextures");
                this._utid = textures[0];
            }
            GLES20.glBindTexture((int)3553, (int)this._utid);
            GLES20.glTexImage2D((int)3553, (int)0, (int)6409, (int)(this.mVideoWidth / 2), (int)(this.mVideoHeight / 2), (int)0, (int)6409, (int)5121, (Buffer)u);
            GLES20.glTexParameterf((int)3553, (int)10241, (float)9728.0f);
            GLES20.glTexParameterf((int)3553, (int)10240, (float)9729.0f);
            GLES20.glTexParameteri((int)3553, (int)10242, (int)33071);
            GLES20.glTexParameteri((int)3553, (int)10243, (int)33071);
            if (this._vtid < 0 || videoSizeChanged) {
                if (this._vtid >= 0) {
                    GLES20.glDeleteTextures((int)1, (int[])new int[]{this._vtid}, (int)0);
                    GLRenderer.checkGlError("glDeleteTextures");
                }
                textures = new int[1];
                GLES20.glGenTextures((int)1, (int[])textures, (int)0);
                GLRenderer.checkGlError("glGenTextures");
                this._vtid = textures[0];
            }
            GLES20.glBindTexture((int)3553, (int)this._vtid);
            GLES20.glTexImage2D((int)3553, (int)0, (int)6409, (int)(this.mVideoWidth / 2), (int)(this.mVideoHeight / 2), (int)0, (int)6409, (int)5121, (Buffer)v);
            GLES20.glTexParameterf((int)3553, (int)10241, (float)9728.0f);
            GLES20.glTexParameterf((int)3553, (int)10240, (float)9729.0f);
            GLES20.glTexParameteri((int)3553, (int)10242, (int)33071);
            GLES20.glTexParameteri((int)3553, (int)10243, (int)33071);
        }

        public void drawFrame() {
            if (!this.isProgramBuilt()) {
                Log.d((String)_tag, (String)String.format("_program %d isProgramBuilt false", this._program));
                return;
            }
            GLES20.glUseProgram((int)this._program);
            GLRenderer.checkGlError("glUseProgram");
            GLES20.glVertexAttribPointer((int)this._positionHandle, (int)2, (int)5126, (boolean)false, (int)8, (Buffer)this._vertice_buffer);
            GLRenderer.checkGlError("glVertexAttribPointer mPositionHandle");
            GLES20.glEnableVertexAttribArray((int)this._positionHandle);
            GLES20.glVertexAttribPointer((int)this._coordHandle, (int)2, (int)5126, (boolean)false, (int)8, (Buffer)this._coord_buffer);
            GLRenderer.checkGlError("glVertexAttribPointer maTextureHandle");
            GLES20.glEnableVertexAttribArray((int)this._coordHandle);
            GLES20.glActiveTexture((int)this._textureI);
            GLES20.glBindTexture((int)3553, (int)this._ytid);
            GLES20.glUniform1i((int)this._yhandle, (int)this._tIindex);
            GLES20.glActiveTexture((int)this._textureII);
            GLES20.glBindTexture((int)3553, (int)this._utid);
            GLES20.glUniform1i((int)this._uhandle, (int)this._tIIindex);
            GLES20.glActiveTexture((int)this._textureIII);
            GLES20.glBindTexture((int)3553, (int)this._vtid);
            GLES20.glUniform1i((int)this._vhandle, (int)this._tIIIindex);
            GLES20.glDrawArrays((int)5, (int)0, (int)4);
            GLES20.glFinish();
            GLES20.glDisableVertexAttribArray((int)this._positionHandle);
            GLES20.glDisableVertexAttribArray((int)this._coordHandle);
        }
    }

    public class RxGLSurfaceView
    extends GLSurfaceView {
        private final GLRenderer mRenderer;

        public RxGLSurfaceView(Context context) {
            super(context);
            Log.d((String)_tag, (String)String.format("RxGLSurfaceView", new Object[0]));
            this.setEGLContextClientVersion(2);
            this.mRenderer = new GLRenderer();
            this.setRenderer(this.mRenderer);
            this.setRenderMode(0);
        }

        public void update(byte[] ydata, byte[] udata, byte[] vdata) {
            this.mRenderer.update(ydata, udata, vdata);
            this.requestRender();
        }

        public void update(int w, int h) {
            this.mRenderer.update(w, h);
        }
    }

    public class SurfaceState {
        public static final int ON_SURFACE_VIEW_CREATEED = 0;
        public static final int ON_SURFACE_VIEW_DESTROYED = 1;
        public static final int ON_SURFACE_VIEW_CHANGED = 2;
    }
}

