/*
 * Decompiled with CFR 0.152.
 */
package com.nable.alllink;

import com.nable.alllink.AllLinkCallIncomingListener;
import com.nable.alllink.AllLinkCallStateListener;
import com.nable.alllink.AllLinkDataListener;
import com.nable.alllink.AllLinkRecvMessageListener;
import com.nable.alllink.AllLinkRegisterStateListener;
import com.nable.alllink.AllLinkSendMessageResultListener;
import java.util.Map;

public class AllLinkClientSdk {
    private static final String kTag = "AllLinkSDK";
    private static AllLinkClientSdk _singleton = null;
    private static AllLinkRegisterStateListener mRegisterStateListener = null;
    private static AllLinkCallStateListener mCallStateListener = null;
    private static AllLinkCallIncomingListener mCallIncomingListener = null;
    private static AllLinkDataListener mDataListener = null;
    private static AllLinkRecvMessageListener mRecvMessageListener = null;
    private static AllLinkSendMessageResultListener mSendMessageResultListener = null;

    private static native boolean nSetLogger(int var0, String var1);

    private static native boolean nSetIMSConfiguration(String[] var0, String[] var1);

    private static native boolean nSetStunServerAddr(String var0, int var1);

    private static native boolean nSetTurnServerAddr(String var0, int var1);

    private static native boolean nSetICEConfig(int var0, int var1);

    private static native boolean nStart(String var0);

    private static native void nStop();

    private static native boolean nRegister();

    private static native boolean nDeregister();

    private static native int nCreateCall();

    private static native boolean nSetDataListener(int var0);

    private static native boolean nDialUp(int var0, String var1, int var2);

    private static native boolean nAlerting(int var0, int var1);

    private static native boolean nAccept(int var0);

    private static native boolean nMediaStart(int var0, boolean var1, boolean var2);

    private static native boolean nMediaHandling(int var0, int var1, int var2);

    private static native boolean nMediaStop(int var0);

    private static native boolean nHangup(int var0);

    private static native String nGetDataTransferPath(int var0);

    private static native void nPutData(int var0, int var1, byte[] var2, int var3);

    private static native boolean nSendMessage(String var0, String var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static AllLinkClientSdk getSingleton() {
        if (_singleton != null) return _singleton;
        Class<AllLinkClientSdk> clazz = AllLinkClientSdk.class;
        synchronized (AllLinkClientSdk.class) {
            if (_singleton != null) return _singleton;
            _singleton = new AllLinkClientSdk();
            // ** MonitorExit[var0] (shouldn't be in output)
            return _singleton;
        }
    }

    private AllLinkClientSdk() {
        try {
            System.loadLibrary("nxAllLinkClientSDK");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void cbOnRegisterState(int state) {
        if (mRegisterStateListener != null) {
            mRegisterStateListener.onRegisterState(AllLinkRegisterStateListener.RegisterState.get(state));
        }
    }

    private static void cbOnSendMessageResult(String participant_uri, String message, int errorCode) {
        if (mSendMessageResultListener != null) {
            mSendMessageResultListener.onSendMessageResult(participant_uri, message, ErrorCode.get(errorCode));
        }
    }

    private static void cbOnRecvMessage(String participant_uri, String message) {
        if (mRecvMessageListener != null) {
            mRecvMessageListener.onRecvMessage(participant_uri, message);
        }
    }

    private static void cbOnCallState(String participant_uri, int call_id, int state, int code) {
        if (mCallStateListener != null) {
            mCallStateListener.onCallState(participant_uri, call_id, AllLinkCallStateListener.CallState.get(state), ErrorCode.get(code));
        }
    }

    private static void cbOnCallIncoming(String participant_uri, int call_id, int call_type) {
        if (mCallIncomingListener != null) {
            mCallIncomingListener.onCallIncoming(participant_uri, call_id, CallType.get(call_type));
        }
    }

    private static void cbOnData(int call_id, int media_direction, int media_channel, byte[] data, int length) {
        if (mDataListener != null) {
            mDataListener.onData(call_id, MediaDirection.get(media_direction), MediaChannel.get(media_channel), data, length);
        }
    }

    public boolean setLogger(LogLevel logLevel, String logFilePath) {
        boolean ret = false;
        try {
            ret = AllLinkClientSdk.nSetLogger(logLevel.getValue(), logFilePath);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return ret;
    }

    public boolean setIMSConfiguration(Map<String, String> configMap) {
        if (configMap == null) {
            return false;
        }
        boolean ret = false;
        if (configMap.size() > 15) {
            return ret;
        }
        String[] key = new String[configMap.size()];
        key = configMap.keySet().toArray(key);
        String[] value = new String[configMap.size()];
        value = configMap.values().toArray(value);
        try {
            ret = AllLinkClientSdk.nSetIMSConfiguration(key, value);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return ret;
    }

    public boolean setStunServerAddr(String addr, int port) {
        boolean ret = false;
        try {
            ret = AllLinkClientSdk.nSetStunServerAddr(addr, port);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return ret;
    }

    public boolean setTurnServerAddr(String addr, int port) {
        boolean ret = false;
        try {
            ret = AllLinkClientSdk.nSetTurnServerAddr(addr, port);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return ret;
    }

    public boolean setICEConfig(ICEConfig key, int value) {
        boolean ret = false;
        try {
            ret = AllLinkClientSdk.nSetICEConfig(key.getValue(), value);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return ret;
    }

    public boolean start(String localIp) {
        boolean ret = false;
        try {
            ret = AllLinkClientSdk.nStart(localIp);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return ret;
    }

    public void stop() {
        try {
            AllLinkClientSdk.nStop();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean doRegister(AllLinkRegisterStateListener listener) {
        if (listener == null) {
            return false;
        }
        boolean ret = false;
        Class<AllLinkRegisterStateListener> clazz = AllLinkRegisterStateListener.class;
        synchronized (AllLinkRegisterStateListener.class) {
            try {
                ret = AllLinkClientSdk.nRegister();
                if (ret) {
                    mRegisterStateListener = listener;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return ret;
        }
    }

    public boolean setCallIncomingListener(AllLinkCallIncomingListener listener) {
        if (listener == null) {
            return false;
        }
        mCallIncomingListener = listener;
        return true;
    }

    public boolean setCallStateListener(AllLinkCallStateListener listener) {
        if (listener == null) {
            return false;
        }
        mCallStateListener = listener;
        return true;
    }

    public boolean setRecvMessageListener(AllLinkRecvMessageListener listener) {
        if (listener == null) {
            return false;
        }
        mRecvMessageListener = listener;
        return true;
    }

    public boolean deRegister() {
        boolean ret = false;
        try {
            ret = AllLinkClientSdk.nDeregister();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return ret;
    }

    public int createCall() {
        int ret = -1;
        try {
            ret = AllLinkClientSdk.nCreateCall();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setDataListener(int call_id, AllLinkDataListener listener) {
        if (listener == null) {
            return false;
        }
        boolean ret = false;
        Class<AllLinkDataListener> clazz = AllLinkDataListener.class;
        synchronized (AllLinkDataListener.class) {
            try {
                ret = AllLinkClientSdk.nSetDataListener(call_id);
                if (ret) {
                    mDataListener = listener;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return ret;
        }
    }

    public boolean dialUp(int call_id, String participant_uri, CallType call_type) {
        boolean ret = false;
        try {
            ret = AllLinkClientSdk.nDialUp(call_id, participant_uri, call_type.getValue());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return ret;
    }

    public boolean alerting(int call_id, AlertingCode alerting_code) {
        boolean ret = false;
        try {
            ret = AllLinkClientSdk.nAlerting(call_id, alerting_code.getValue());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return ret;
    }

    public boolean accept(int call_id) {
        boolean ret = false;
        try {
            ret = AllLinkClientSdk.nAccept(call_id);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return ret;
    }

    public boolean mediaStart(int call_id, boolean audio_start, boolean video_start) {
        boolean ret = false;
        try {
            ret = AllLinkClientSdk.nMediaStart(call_id, audio_start, video_start);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return ret;
    }

    public boolean mediaHandling(int call_id, int audio_action, int video_action) {
        boolean ret = false;
        try {
            ret = AllLinkClientSdk.nMediaHandling(call_id, audio_action, video_action);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return ret;
    }

    public boolean mediaStop(int call_id) {
        boolean ret = false;
        try {
            ret = AllLinkClientSdk.nMediaStop(call_id);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return ret;
    }

    public boolean hangUp(int call_id) {
        boolean ret = false;
        try {
            ret = AllLinkClientSdk.nHangup(call_id);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return ret;
    }

    public String getDataTransferPath(int call_id) {
        String path = "";
        try {
            path = AllLinkClientSdk.nGetDataTransferPath(call_id);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return path;
    }

    public void putData(int call_id, MediaChannel media_channel, byte[] data) {
        try {
            AllLinkClientSdk.nPutData(call_id, media_channel.getValue(), data, data.length);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public boolean sendMessage(String participant_uri, String message, AllLinkSendMessageResultListener listener) {
        if (listener == null) {
            return false;
        }
        boolean ret = false;
        try {
            ret = AllLinkClientSdk.nSendMessage(participant_uri, message);
            if (ret) {
                mSendMessageResultListener = listener;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return ret;
    }

    public static enum ICEConfig {
        None(0),
        RelayCheckDelay(3);

        private int value;

        private ICEConfig(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public static ICEConfig get(int value) {
            switch (value) {
                case 0: {
                    return None;
                }
                case 3: {
                    return RelayCheckDelay;
                }
            }
            return None;
        }
    }

    public static enum MediaChannel {
        None(0),
        AudioRtp(1),
        AudioRtcp(2),
        VideoRtp(3),
        VideoRtcp(4),
        CustomData(5);

        private int value;

        private MediaChannel(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public static MediaChannel get(int value) {
            switch (value) {
                case 0: {
                    return None;
                }
                case 1: {
                    return AudioRtp;
                }
                case 2: {
                    return AudioRtcp;
                }
                case 3: {
                    return VideoRtp;
                }
                case 4: {
                    return VideoRtcp;
                }
                case 5: {
                    return CustomData;
                }
            }
            return None;
        }
    }

    public static enum MediaDirection {
        Tx(0),
        Rx(1);

        private int value;

        private MediaDirection(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public static MediaDirection get(int value) {
            switch (value) {
                case 0: {
                    return Tx;
                }
                case 1: {
                    return Rx;
                }
            }
            return Tx;
        }
    }

    public static enum MediaAction {
        None(0),
        TxPause(16),
        RxPause(32),
        TxResume(256),
        RxResume(512);

        private int value;

        private MediaAction(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public static MediaAction get(int value) {
            switch (value) {
                case 0: {
                    return None;
                }
                case 16: {
                    return TxPause;
                }
                case 32: {
                    return RxPause;
                }
                case 256: {
                    return TxResume;
                }
                case 512: {
                    return RxResume;
                }
            }
            return None;
        }
    }

    public static enum AlertingCode {
        None(-1),
        LocalRingtone(180),
        RemoteRingtone(183);

        private int value;

        private AlertingCode(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public static AlertingCode get(int value) {
            switch (value) {
                case -1: {
                    return None;
                }
                case 180: {
                    return LocalRingtone;
                }
                case 183: {
                    return RemoteRingtone;
                }
            }
            return None;
        }
    }

    public static enum CallType {
        Default(0),
        AudioOnly(1),
        VideoOnly(2),
        AudioVideo(3);

        private int value;

        private CallType(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public static CallType get(int value) {
            switch (value) {
                case 0: {
                    return Default;
                }
                case 1: {
                    return AudioOnly;
                }
                case 2: {
                    return VideoOnly;
                }
                case 3: {
                    return AudioVideo;
                }
            }
            return Default;
        }
    }

    public static enum ErrorCode {
        None(-1),
        UnKnown(-2),
        DeviceError(400),
        Forbidden(403),
        NotAcceptable(406),
        Timeout(408),
        NotAvailable(480),
        Busy(486),
        ServerError(500),
        KeepAliveError(600);

        private int value;

        private ErrorCode(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public static ErrorCode get(int value) {
            switch (value) {
                case -1: {
                    return None;
                }
                case 400: {
                    return DeviceError;
                }
                case 403: {
                    return Forbidden;
                }
                case 406: {
                    return NotAcceptable;
                }
                case 408: {
                    return Timeout;
                }
                case 480: {
                    return NotAvailable;
                }
                case 486: {
                    return Busy;
                }
                case 500: {
                    return ServerError;
                }
                case 600: {
                    return KeepAliveError;
                }
            }
            return UnKnown;
        }
    }

    public static enum LogLevel {
        Off(-1),
        Verbose(0),
        Debug(1),
        Info(2),
        Warn(3),
        Error(4);

        private int value;

        private LogLevel(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }
    }
}

