/*
 * Decompiled with CFR 0.152.
 */
package android.support.v4.util;

import android.support.v4.util.ArrayMap;
import android.support.v4.util.ContainerHelpers;

public class SimpleArrayMap<K, V> {
    static Object[] mBaseCache;
    static int mBaseCacheSize;
    static Object[] mTwiceBaseCache;
    static int mTwiceBaseCacheSize;
    int[] mHashes = ContainerHelpers.EMPTY_INTS;
    Object[] mArray = ContainerHelpers.EMPTY_OBJECTS;
    int mSize = 0;

    int indexOf(Object key, int hash) {
        int end;
        int N = this.mSize;
        if (N == 0) {
            return -1;
        }
        int index = ContainerHelpers.binarySearch(this.mHashes, N, hash);
        if (index < 0) {
            return index;
        }
        if (key.equals(this.mArray[index << 1])) {
            return index;
        }
        for (end = index + 1; end < N && this.mHashes[end] == hash; ++end) {
            if (!key.equals(this.mArray[end << 1])) continue;
            return end;
        }
        for (int i = index - 1; i >= 0 && this.mHashes[i] == hash; --i) {
            if (!key.equals(this.mArray[i << 1])) continue;
            return i;
        }
        return ~end;
    }

    int indexOfNull() {
        int end;
        int N = this.mSize;
        if (N == 0) {
            return -1;
        }
        int index = ContainerHelpers.binarySearch(this.mHashes, N, 0);
        if (index < 0) {
            return index;
        }
        if (null == this.mArray[index << 1]) {
            return index;
        }
        for (end = index + 1; end < N && this.mHashes[end] == 0; ++end) {
            if (null != this.mArray[end << 1]) continue;
            return end;
        }
        for (int i = index - 1; i >= 0 && this.mHashes[i] == 0; --i) {
            if (null != this.mArray[i << 1]) continue;
            return i;
        }
        return ~end;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private void allocArrays(int size) {
        if (size == 8) {
            Class<ArrayMap> clazz = ArrayMap.class;
            // MONITORENTER : android.support.v4.util.ArrayMap.class
            if (mTwiceBaseCache != null) {
                Object[] array = mTwiceBaseCache;
                this.mArray = array;
                mTwiceBaseCache = (Object[])array[0];
                this.mHashes = (int[])array[1];
                array[1] = null;
                array[0] = null;
                --mTwiceBaseCacheSize;
                // MONITOREXIT : clazz
                return;
            }
            // MONITOREXIT : clazz
        } else if (size == 4) {
            Class<ArrayMap> clazz = ArrayMap.class;
            // MONITORENTER : android.support.v4.util.ArrayMap.class
            if (mBaseCache != null) {
                Object[] array = mBaseCache;
                this.mArray = array;
                mBaseCache = (Object[])array[0];
                this.mHashes = (int[])array[1];
                array[1] = null;
                array[0] = null;
                --mBaseCacheSize;
                // MONITOREXIT : clazz
                return;
            }
            // MONITOREXIT : clazz
        }
        this.mHashes = new int[size];
        this.mArray = new Object[size << 1];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void freeArrays(int[] hashes, Object[] array, int size) {
        if (hashes.length == 8) {
            Class<ArrayMap> clazz = ArrayMap.class;
            synchronized (ArrayMap.class) {
                if (mTwiceBaseCacheSize >= 10) return;
                array[0] = mTwiceBaseCache;
                array[1] = hashes;
                for (int i = (size << 1) - 1; i >= 2; --i) {
                    array[i] = null;
                }
                mTwiceBaseCache = array;
                ++mTwiceBaseCacheSize;
                // ** MonitorExit[var3_3] (shouldn't be in output)
                return;
            }
        }
        if (hashes.length != 4) return;
        Class<ArrayMap> clazz = ArrayMap.class;
        synchronized (ArrayMap.class) {
            if (mBaseCacheSize >= 10) return;
            array[0] = mBaseCache;
            array[1] = hashes;
            for (int i = (size << 1) - 1; i >= 2; --i) {
                array[i] = null;
            }
            mBaseCache = array;
            ++mBaseCacheSize;
            // ** MonitorExit[var3_4] (shouldn't be in output)
            return;
        }
    }

    public V put(K key, V value) {
        int index;
        int hash;
        if (key == null) {
            hash = 0;
            index = this.indexOfNull();
        } else {
            hash = key.hashCode();
            index = this.indexOf(key, hash);
        }
        if (index >= 0) {
            index = (index << 1) + 1;
            Object old = this.mArray[index];
            this.mArray[index] = value;
            return (V)old;
        }
        index ^= 0xFFFFFFFF;
        if (this.mSize >= this.mHashes.length) {
            int n = this.mSize >= 8 ? this.mSize + (this.mSize >> 1) : (this.mSize >= 4 ? 8 : 4);
            int[] ohashes = this.mHashes;
            Object[] oarray = this.mArray;
            this.allocArrays(n);
            if (this.mHashes.length > 0) {
                System.arraycopy(ohashes, 0, this.mHashes, 0, ohashes.length);
                System.arraycopy(oarray, 0, this.mArray, 0, oarray.length);
            }
            SimpleArrayMap.freeArrays(ohashes, oarray, this.mSize);
        }
        if (index < this.mSize) {
            System.arraycopy(this.mHashes, index, this.mHashes, index + 1, this.mSize - index);
            System.arraycopy(this.mArray, index << 1, this.mArray, index + 1 << 1, this.mSize - index << 1);
        }
        this.mHashes[index] = hash;
        this.mArray[index << 1] = key;
        this.mArray[(index << 1) + 1] = value;
        ++this.mSize;
        return null;
    }
}

