/*
 * Decompiled with CFR 0.152.
 */
package com.nable.nme;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;

public class Utility {
    private Utility() {
    }

    public static void yuv420BytetoRGB565Int(byte[] yuvs, int width, int height, int[] rgbs) {
        int lumEnd = width * height;
        int lumPtr = 0;
        int chrPtr = lumEnd;
        int outPtr = 0;
        int lineEnd = width;
        while (true) {
            int Cb;
            int B;
            if (lumPtr == lineEnd) {
                if (lumPtr == lumEnd) break;
                chrPtr = lumEnd + (lumPtr >> 1) / width * width;
                lineEnd += width;
            }
            int Y1 = yuvs[lumPtr++] & 0xFF;
            int Y2 = yuvs[lumPtr++] & 0xFF;
            int Cr = (yuvs[chrPtr++] & 0xFF) - 128;
            if ((B = Y1 + (454 * (Cb = (yuvs[chrPtr++] & 0xFF) - 128) >> 8)) < 0) {
                B = 0;
            } else if (B > 255) {
                B = 255;
            }
            int G = Y1 - (88 * Cb + 183 * Cr >> 8);
            if (G < 0) {
                G = 0;
            } else if (G > 255) {
                G = 255;
            }
            int R = Y1 + (359 * Cr >> 8);
            if (R < 0) {
                R = 0;
            } else if (R > 255) {
                R = 255;
            }
            rgbs[outPtr++] = R << 16 | G << 8 | B;
            B = Y2 + (454 * Cb >> 8);
            if (B < 0) {
                B = 0;
            } else if (B > 255) {
                B = 255;
            }
            G = Y2 - (88 * Cb + 183 * Cr >> 8);
            if (G < 0) {
                G = 0;
            } else if (G > 255) {
                G = 255;
            }
            R = Y2 + (359 * Cr >> 8);
            if (R < 0) {
                R = 0;
            } else if (R > 255) {
                R = 255;
            }
            rgbs[outPtr++] = R << 16 | G << 8 | B;
        }
    }

    public static void YUV420_HHalf(byte[] org, byte[] hhalf, int width, int height) {
        int srcY = 0;
        int dstY = 0;
        int srcUV = width * height;
        int dstUV = (width >> 1) * height;
        int y = 0;
        while (y < height) {
            int x = 0;
            while (x < width) {
                hhalf[dstY++] = org[srcY + x];
                if (x % 4 == 0) {
                    hhalf[dstUV++] = org[srcUV + (x >> 1)];
                    hhalf[dstUV++] = org[srcUV + (x >> 1) + 1];
                }
                x += 2;
            }
            srcY += width;
            srcUV += width >> 1;
            ++y;
        }
    }

    public static void yuv420ByteToRGB24Int_Grayscale(int[] rgb, byte[] yuv420sp, int width, int height) {
        int frameSize = width * height;
        int pix = 0;
        while (pix < frameSize) {
            int pixVal = (0xFF & yuv420sp[pix]) - 16;
            if (pixVal < 0) {
                pixVal = 0;
            }
            if (pixVal > 255) {
                pixVal = 255;
            }
            rgb[pix] = 0xFF000000 | pixVal << 16 | pixVal << 8 | pixVal;
            ++pix;
        }
    }

    public static String intIpToStringIp(int intIp) {
        byte[] bytesSrc = new byte[4];
        InetAddress addressSrc = null;
        Utility.getLittleEndian(intIp, bytesSrc);
        try {
            addressSrc = InetAddress.getByAddress(bytesSrc);
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
        }
        return addressSrc.getHostAddress();
    }

    public static void getLittleEndian(int nValue, byte[] btRet) {
        btRet[3] = (byte)(nValue >>> 24 & 0xFF);
        btRet[2] = (byte)(nValue >>> 16 & 0xFF);
        btRet[1] = (byte)(nValue >>> 8 & 0xFF);
        btRet[0] = (byte)(nValue >>> 0 & 0xFF);
    }

    public static int getBigEndian(byte[] btValue) {
        return ((btValue[3] & 0xFF) << 24) + ((btValue[2] & 0xFF) << 16) + ((btValue[1] & 0xFF) << 8) + ((btValue[0] & 0xFF) << 0);
    }

    public static void saveToFile(String filePath, byte[] btSource, int nSize) {
        File file = new File(filePath);
        FileOutputStream out = null;
        FilterOutputStream bos = null;
        Object is = null;
        try {
            try {
                out = new FileOutputStream(file);
                bos = new BufferedOutputStream(out);
                ((BufferedOutputStream)bos).write(btSource, 0, nSize);
                ((BufferedOutputStream)bos).flush();
            }
            catch (FileNotFoundException fileNotFoundException) {
                try {
                    out.close();
                    bos.close();
                }
                catch (IOException iOException) {
                }
            }
            catch (IOException iOException) {
                try {
                    out.close();
                    bos.close();
                }
                catch (IOException iOException2) {}
            }
        }
        finally {
            try {
                out.close();
                bos.close();
            }
            catch (IOException iOException) {}
        }
    }

    public static String escape(String src) {
        StringBuffer tmp = new StringBuffer();
        tmp.ensureCapacity(src.length() * 6);
        int i = 0;
        while (i < src.length()) {
            char j = src.charAt(i);
            if (Character.isDigit(j) || Character.isLowerCase(j) || Character.isUpperCase(j)) {
                tmp.append(j);
            } else if (j < '\u0100') {
                tmp.append("%");
                if (j < '\u0010') {
                    tmp.append("0");
                }
                tmp.append(Integer.toString(j, 16));
            } else {
                tmp.append("%u");
                tmp.append(Integer.toString(j, 16));
            }
            ++i;
        }
        return tmp.toString();
    }

    public static String unescape(String src) {
        StringBuffer tmp = new StringBuffer();
        tmp.ensureCapacity(src.length());
        int lastPos = 0;
        int pos = 0;
        while (lastPos < src.length()) {
            pos = src.indexOf("%", lastPos);
            if (pos == lastPos) {
                char ch;
                if (src.charAt(pos + 1) == 'u') {
                    ch = (char)Integer.parseInt(src.substring(pos + 2, pos + 6), 16);
                    tmp.append(ch);
                    lastPos = pos + 6;
                    continue;
                }
                ch = (char)Integer.parseInt(src.substring(pos + 1, pos + 3), 16);
                tmp.append(ch);
                lastPos = pos + 3;
                continue;
            }
            if (pos == -1) {
                tmp.append(src.substring(lastPos));
                lastPos = src.length();
                continue;
            }
            tmp.append(src.substring(lastPos, pos));
            lastPos = pos;
        }
        return tmp.toString();
    }
}

