/*
 * Decompiled with CFR 0.152.
 */
package javax.jmdns.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import javax.jmdns.impl.DNSQuestion;
import javax.jmdns.impl.DNSRecord;

public abstract class DNSMessage {
    public static final boolean MULTICAST = true;
    public static final boolean UNICAST = false;
    private int _id;
    boolean _multicast;
    private int _flags;
    protected final List<DNSQuestion> _questions;
    protected final List<DNSRecord> _answers;
    protected final List<DNSRecord> _authoritativeAnswers;
    protected final List<DNSRecord> _additionals;

    protected DNSMessage(int flags, int id, boolean multicast) {
        this._flags = flags;
        this._id = id;
        this._multicast = multicast;
        this._questions = Collections.synchronizedList(new LinkedList());
        this._answers = Collections.synchronizedList(new LinkedList());
        this._authoritativeAnswers = Collections.synchronizedList(new LinkedList());
        this._additionals = Collections.synchronizedList(new LinkedList());
    }

    public int getId() {
        return this._multicast ? 0 : this._id;
    }

    public void setId(int id) {
        this._id = id;
    }

    public int getFlags() {
        return this._flags;
    }

    public void setFlags(int flags) {
        this._flags = flags;
    }

    public boolean isMulticast() {
        return this._multicast;
    }

    public Collection<? extends DNSQuestion> getQuestions() {
        return this._questions;
    }

    public int getNumberOfQuestions() {
        return this.getQuestions().size();
    }

    public Collection<? extends DNSRecord> getAllAnswers() {
        ArrayList<DNSRecord> aList = new ArrayList<DNSRecord>(this._answers.size() + this._authoritativeAnswers.size() + this._additionals.size());
        aList.addAll(this._answers);
        aList.addAll(this._authoritativeAnswers);
        aList.addAll(this._additionals);
        return aList;
    }

    public Collection<? extends DNSRecord> getAnswers() {
        return this._answers;
    }

    public int getNumberOfAnswers() {
        return this.getAnswers().size();
    }

    public Collection<? extends DNSRecord> getAuthorities() {
        return this._authoritativeAnswers;
    }

    public int getNumberOfAuthorities() {
        return this.getAuthorities().size();
    }

    public Collection<? extends DNSRecord> getAdditionals() {
        return this._additionals;
    }

    public int getNumberOfAdditionals() {
        return this.getAdditionals().size();
    }

    public boolean isValidResponseCode() {
        return (this._flags & 0xF) == 0;
    }

    public int getOperationCode() {
        return (this._flags & 0x7800) >> 11;
    }

    public boolean isTruncated() {
        return (this._flags & 0x200) != 0;
    }

    public boolean isAuthoritativeAnswer() {
        return (this._flags & 0x400) != 0;
    }

    public boolean isQuery() {
        return (this._flags & 0x8000) == 0;
    }

    public boolean isResponse() {
        return (this._flags & 0x8000) == 32768;
    }

    public boolean isEmpty() {
        return this.getNumberOfQuestions() + this.getNumberOfAnswers() + this.getNumberOfAuthorities() + this.getNumberOfAdditionals() == 0;
    }

    String print() {
        StringBuffer buf = new StringBuffer(200);
        buf.append(this.toString());
        buf.append("\n");
        for (DNSQuestion question : this._questions) {
            buf.append("\tquestion:      ");
            buf.append(question);
            buf.append("\n");
        }
        for (DNSRecord answer : this._answers) {
            buf.append("\tanswer:        ");
            buf.append(answer);
            buf.append("\n");
        }
        for (DNSRecord answer : this._authoritativeAnswers) {
            buf.append("\tauthoritative: ");
            buf.append(answer);
            buf.append("\n");
        }
        for (DNSRecord answer : this._additionals) {
            buf.append("\tadditional:    ");
            buf.append(answer);
            buf.append("\n");
        }
        return buf.toString();
    }

    protected String print(byte[] data) {
        StringBuilder buf = new StringBuilder(4000);
        int len = data.length;
        for (int off = 0; off < len; off += 32) {
            int n = Math.min(32, len - off);
            if (off < 16) {
                buf.append(' ');
            }
            if (off < 256) {
                buf.append(' ');
            }
            if (off < 4096) {
                buf.append(' ');
            }
            buf.append(Integer.toHexString(off));
            buf.append(':');
            int index = 0;
            for (index = 0; index < n; ++index) {
                if (index % 8 == 0) {
                    buf.append(' ');
                }
                buf.append(Integer.toHexString((data[off + index] & 0xF0) >> 4));
                buf.append(Integer.toHexString((data[off + index] & 0xF) >> 0));
            }
            if (index < 32) {
                for (int i = index; i < 32; ++i) {
                    if (i % 8 == 0) {
                        buf.append(' ');
                    }
                    buf.append("  ");
                }
            }
            buf.append("    ");
            for (index = 0; index < n; ++index) {
                int ch;
                if (index % 8 == 0) {
                    buf.append(' ');
                }
                buf.append((ch = data[off + index] & 0xFF) > 32 && ch < 127 ? (char)ch : (char)'.');
            }
            buf.append("\n");
            if (off + 32 < 2048) continue;
            buf.append("....\n");
            break;
        }
        return buf.toString();
    }
}

