/*
 * Decompiled with CFR 0.152.
 */
package com.nable.nme;

import android.content.Context;
import android.util.Log;
import android.view.View;
import com.nable.nme.NableMediaEngine;
import com.nable.nme.Utility;
import com.nable.nme.VideoController;

public class NableMediaEngine_Video {
    private static NableMediaEngine_Video _singleton = null;
    private static String _tag = "NME_VIDEO";

    public static synchronized NableMediaEngine_Video getSingleton() {
        if (_singleton == null) {
            _singleton = new NableMediaEngine_Video();
        }
        return _singleton;
    }

    private NableMediaEngine_Video() {
        NableMediaEngine.getSingleton();
    }

    public synchronized int createChannel() {
        int ret = -1;
        try {
            ret = NableMediaEngine.nMediaCreateVideo();
        }
        catch (Exception e) {
            Log.e((String)_tag, (String)e.toString());
        }
        return ret;
    }

    public synchronized boolean destroyChannel(int id) {
        boolean ret = false;
        try {
            ret = NableMediaEngine.nMediaDestroyVideo(id);
        }
        catch (Exception e) {
            Log.e((String)_tag, (String)e.toString());
        }
        if (id > 0 && id < NableMediaEngine.MAX_CHANNELID) {
            NableMediaEngine.m_videoRTPListener[id] = null;
            NableMediaEngine.m_videoRTCPListener[id] = null;
        }
        return ret;
    }

    public synchronized void setNegoInfo(int id, int codec, int pt, int width, int height, int frame_rate, int bit_rate, int ip_ver, int src_ip, int dst_ip, int src_port, int dst_port, boolean tx, boolean rx) {
        String src_ip_string = null;
        String dst_ip_string = null;
        src_ip_string = Utility.intIpToStringIp(src_ip);
        dst_ip_string = Utility.intIpToStringIp(dst_ip);
        try {
            NableMediaEngine.nMediaSetVideoNegoInfo(id, codec, pt, width, height, frame_rate, bit_rate, ip_ver, src_ip_string, dst_ip_string, src_port, dst_port, tx, rx);
        }
        catch (Exception e) {
            Log.e((String)_tag, (String)e.toString());
        }
    }

    public synchronized void setNegoInfo(int id, int codec, int pt, int width, int height, int frame_rate, int bit_rate, int ip_ver, String src_ip, String dst_ip, int src_port, int dst_port, boolean tx, boolean rx) {
        try {
            NableMediaEngine.nMediaSetVideoNegoInfo(id, codec, pt, width, height, frame_rate, bit_rate, ip_ver, src_ip, dst_ip, src_port, dst_port, tx, rx);
        }
        catch (Exception e) {
            Log.e((String)_tag, (String)e.toString());
        }
    }

    public synchronized boolean setSecurity(int id, int algorithm, boolean tx_srtcp, boolean rx_srtcp, String tx_hex_master_salt, String rx_hex_master_salt) {
        boolean ret = false;
        try {
            ret = NableMediaEngine.nMediaSetVideoSecurity(id, algorithm, tx_srtcp, rx_srtcp, tx_hex_master_salt, rx_hex_master_salt);
        }
        catch (Exception e) {
            Log.e((String)_tag, (String)e.toString());
        }
        return ret;
    }

    public synchronized boolean startChannel(int id) {
        boolean ret = false;
        try {
            ret = NableMediaEngine.nMediaStartVideo(id);
        }
        catch (Exception e) {
            Log.e((String)_tag, (String)e.toString());
        }
        return ret;
    }

    public synchronized boolean startChannelTx(int id) {
        boolean ret = false;
        try {
            ret = NableMediaEngine.nMediaStartVideoTx(id);
        }
        catch (Exception e) {
            Log.e((String)_tag, (String)e.toString());
        }
        return ret;
    }

    public synchronized boolean startChannelRx(int id) {
        boolean ret = false;
        try {
            ret = NableMediaEngine.nMediaStartVideoRx(id);
        }
        catch (Exception e) {
            Log.e((String)_tag, (String)e.toString());
        }
        return ret;
    }

    public synchronized boolean stopChannel(int id) {
        boolean ret = false;
        try {
            ret = NableMediaEngine.nMediaStopVideo(id);
        }
        catch (Exception e) {
            Log.e((String)_tag, (String)e.toString());
        }
        return ret;
    }

    public synchronized boolean stopChannelTx(int id) {
        boolean ret = false;
        try {
            ret = NableMediaEngine.nMediaStopVideoTx(id);
        }
        catch (Exception e) {
            Log.e((String)_tag, (String)e.toString());
        }
        return ret;
    }

    public synchronized boolean stopChannelRx(int id) {
        boolean ret = false;
        try {
            ret = NableMediaEngine.nMediaStopVideoRx(id);
        }
        catch (Exception e) {
            Log.e((String)_tag, (String)e.toString());
        }
        return ret;
    }

    public synchronized boolean pauseChannelTx(int id) {
        boolean ret = false;
        try {
            ret = NableMediaEngine.nMediaPauseVideoTx(id);
        }
        catch (Exception e) {
            Log.e((String)_tag, (String)e.toString());
        }
        return ret;
    }

    public synchronized boolean pauseChannelRx(int id) {
        boolean ret = false;
        try {
            ret = NableMediaEngine.nMediaPauseVideoRx(id);
        }
        catch (Exception e) {
            Log.e((String)_tag, (String)e.toString());
        }
        return ret;
    }

    public synchronized boolean resumeChannelTx(int id) {
        boolean ret = false;
        try {
            ret = NableMediaEngine.nMediaResumeVideoTx(id);
        }
        catch (Exception e) {
            Log.e((String)_tag, (String)e.toString());
        }
        return ret;
    }

    public synchronized boolean resumeChannelRx(int id) {
        boolean ret = false;
        try {
            ret = NableMediaEngine.nMediaResumeVideoRx(id);
        }
        catch (Exception e) {
            Log.e((String)_tag, (String)e.toString());
        }
        return ret;
    }

    public synchronized boolean setCamera(int cam) {
        boolean ret = false;
        try {
            ret = NableMediaEngine.nMediaSetCamera(cam);
        }
        catch (Exception e) {
            Log.e((String)_tag, (String)e.toString());
        }
        return ret;
    }

    public synchronized int getCamera() {
        int camId = 0;
        try {
            camId = NableMediaEngine.nMediaGetCamera();
        }
        catch (Exception e) {
            Log.e((String)_tag, (String)e.toString());
        }
        return camId;
    }

    public synchronized int getCameraCnt() {
        int cnt = 0;
        try {
            cnt = NableMediaEngine.nMediaGetCameraCnt();
        }
        catch (Exception e) {
            Log.e((String)_tag, (String)e.toString());
        }
        return cnt;
    }

    public synchronized int getCodecCount() {
        int ret = -1;
        try {
            ret = NableMediaEngine.nGetVideoCodecCount();
        }
        catch (Exception e) {
            Log.e((String)_tag, (String)e.toString());
        }
        return ret;
    }

    public synchronized String getCodecName(int codec_id) {
        String ret = "";
        try {
            ret = NableMediaEngine.nGetVideoCodecName(codec_id);
        }
        catch (Exception e) {
            Log.e((String)_tag, (String)e.toString());
        }
        return ret;
    }

    public synchronized View createLocalView(Context context) {
        View view = null;
        try {
            view = VideoController.getSingleton().createLocalView(context);
        }
        catch (Exception e) {
            Log.e((String)_tag, (String)e.toString());
        }
        return view;
    }

    public synchronized View createRemoteView(Context context) {
        View view = null;
        try {
            view = VideoController.getSingleton().createRemoteView(context);
        }
        catch (Exception e) {
            Log.e((String)_tag, (String)e.toString());
        }
        return view;
    }

    public synchronized boolean setKeepAlive(int id, boolean send, int interval) {
        boolean ret = false;
        try {
            ret = NableMediaEngine.nMediaSetVideoKeepAlive(id, send, interval);
        }
        catch (Exception e) {
            Log.e((String)_tag, (String)e.toString());
        }
        return ret;
    }

    public synchronized boolean setProperty(int id, int key, long value) {
        boolean ret = false;
        try {
            ret = NableMediaEngine.nMediaSetVideoProperty(id, key, value);
        }
        catch (Exception e) {
            Log.e((String)_tag, (String)e.toString());
        }
        return ret;
    }

    public synchronized long getProperty(int id, int key) {
        long ret = -1L;
        try {
            ret = NableMediaEngine.nMediaGetVideoProperty(id, key);
        }
        catch (Exception e) {
            Log.e((String)_tag, (String)e.toString());
        }
        return ret;
    }

    public synchronized int getChannelState(int id) {
        int state = 0;
        try {
            state = NableMediaEngine.nMediaGetVideoChannelState(id);
        }
        catch (Exception e) {
            Log.e((String)_tag, (String)e.toString());
        }
        return state;
    }

    public synchronized int getRTCPStatistics(int id, int key) {
        int ret = 0;
        try {
            ret = NableMediaEngine.nMediaGetVideoRTCPStatistics(id, key);
        }
        catch (Exception e) {
            Log.e((String)_tag, (String)e.toString());
        }
        return ret;
    }

    public synchronized boolean setRTCPSend(int nChannelID, boolean send) {
        boolean ret = false;
        try {
            ret = NableMediaEngine.nMediaSetVideoRTCPSend(nChannelID, send);
        }
        catch (Exception e) {
            Log.e((String)_tag, (String)e.toString());
        }
        return ret;
    }

    public synchronized boolean setSocketOption(int id, int protocol, int option, byte[] value) {
        boolean ret = false;
        try {
            ret = NableMediaEngine.nMediaSetVideoSocketOption(id, protocol, option, value, value.length);
        }
        catch (Exception e) {
            Log.e((String)_tag, (String)e.toString());
        }
        return ret;
    }

    public synchronized boolean putData(int id, int protocol, byte[] buffer, int size) {
        boolean ret = false;
        try {
            ret = NableMediaEngine.nMediaPutVideoData(id, protocol, buffer, size);
        }
        catch (Exception e) {
            Log.e((String)_tag, (String)e.toString());
        }
        return ret;
    }

    public synchronized boolean setExtTransportListener(int id, NableMediaEngine.IExtTransportListener rtpListener, NableMediaEngine.IExtTransportListener rtcpListener) {
        boolean ret = false;
        if (id < 0) {
            return false;
        }
        if (id >= NableMediaEngine.MAX_CHANNELID) {
            return false;
        }
        try {
            ret = NableMediaEngine.nMediaSetVideoExtTransportListener(id);
        }
        catch (Exception e) {
            Log.e((String)_tag, (String)e.toString());
        }
        NableMediaEngine.m_videoRTPListener[id] = rtpListener;
        NableMediaEngine.m_videoRTCPListener[id] = rtcpListener;
        return ret;
    }

    public synchronized boolean pauseCamera() {
        boolean ret = false;
        try {
            VideoController.getSingleton();
            ret = VideoController.pauseCamera();
        }
        catch (Exception e) {
            Log.e((String)_tag, (String)e.toString());
        }
        return ret;
    }

    public synchronized boolean resumeCamera() {
        boolean ret = false;
        try {
            VideoController.getSingleton();
            ret = VideoController.resumeCamera();
        }
        catch (Exception e) {
            Log.e((String)_tag, (String)e.toString());
        }
        return ret;
    }

    public static class Camera {
        public static int REAR = 0;
        public static int FRONT = 1;
    }

    public static class Codec {
        public static int H263 = 0;
        public static int H263P = 1;
        public static int H264 = 2;
        public static int VP8 = 3;
    }
}

