/*
 * Decompiled with CFR 0.152.
 */
package com.nable.nme;

import android.util.Log;
import com.nable.nme.NableMediaEngine;
import com.nable.nme.Utility;

public class NableMediaEngine_Audio {
    private static NableMediaEngine_Audio _singleton = null;
    private static String _tag = "NME_AUDIO";

    public static synchronized NableMediaEngine_Audio getSingleton() {
        if (_singleton == null) {
            _singleton = new NableMediaEngine_Audio();
        }
        return _singleton;
    }

    private NableMediaEngine_Audio() {
        NableMediaEngine.getSingleton();
    }

    public synchronized int createChannel() {
        int ret = -1;
        try {
            ret = NableMediaEngine.nMediaCreateAudio();
        }
        catch (Exception e) {
            Log.e((String)_tag, (String)e.toString());
        }
        return ret;
    }

    public synchronized boolean destroyChannel(int id) {
        boolean ret = false;
        try {
            ret = NableMediaEngine.nMediaDestroyAudio(id);
        }
        catch (Exception e) {
            Log.e((String)_tag, (String)e.toString());
        }
        if (id > 0 && id < NableMediaEngine.MAX_CHANNELID) {
            NableMediaEngine.m_dtmfListener[id] = null;
            NableMediaEngine.m_audioRTPListener[id] = null;
            NableMediaEngine.m_audioRTCPListener[id] = null;
            NableMediaEngine.m_audioSendUserCallback[id] = null;
            NableMediaEngine.m_audioPlayUserCallback[id] = null;
            NableMediaEngine.m_audioSendUserEOFCallback[id] = null;
            NableMediaEngine.m_audioPlayUserEOFCallback[id] = null;
        }
        return ret;
    }

    public synchronized void setNegoInfo(int id, int codec, int pt, int ptime, int dtmf_pt, int ip_ver, int src_ip, int dst_ip, int src_port, int dst_port, boolean tx, boolean rx) {
        String src_ip_string = null;
        String dst_ip_string = null;
        src_ip_string = Utility.intIpToStringIp(src_ip);
        dst_ip_string = Utility.intIpToStringIp(dst_ip);
        try {
            NableMediaEngine.nMediaSetAudioNegoInfo(id, codec, pt, ptime, dtmf_pt, ip_ver, src_ip_string, dst_ip_string, src_port, dst_port, tx, rx);
        }
        catch (Exception e) {
            Log.e((String)_tag, (String)e.toString());
        }
    }

    public synchronized void setNegoInfo(int id, int codec, int pt, int ptime, int dtmf_pt, int ip_ver, String src_ip, String dst_ip, int src_port, int dst_port, boolean tx, boolean rx) {
        try {
            NableMediaEngine.nMediaSetAudioNegoInfo(id, codec, pt, ptime, dtmf_pt, ip_ver, src_ip, dst_ip, src_port, dst_port, tx, rx);
        }
        catch (Exception e) {
            Log.e((String)_tag, (String)e.toString());
        }
    }

    public synchronized boolean setSecurity(int id, int algorithm, boolean tx_srtcp, boolean rx_srtcp, String tx_hex_master_salt, String rx_hex_master_salt) {
        boolean ret = false;
        try {
            ret = NableMediaEngine.nMediaSetAudioSecurity(id, algorithm, tx_srtcp, rx_srtcp, tx_hex_master_salt, rx_hex_master_salt);
        }
        catch (Exception e) {
            Log.e((String)_tag, (String)e.toString());
        }
        return ret;
    }

    public synchronized boolean startChannel(int id) {
        boolean ret = false;
        try {
            ret = NableMediaEngine.nMediaStartAudio(id);
        }
        catch (Exception e) {
            Log.e((String)_tag, (String)e.toString());
        }
        return ret;
    }

    public synchronized boolean startChannelTx(int id) {
        boolean ret = false;
        try {
            ret = NableMediaEngine.nMediaStartAudioTx(id);
        }
        catch (Exception e) {
            Log.e((String)_tag, (String)e.toString());
        }
        return ret;
    }

    public synchronized boolean startChannelRx(int id) {
        boolean ret = false;
        try {
            ret = NableMediaEngine.nMediaStartAudioRx(id);
        }
        catch (Exception e) {
            Log.e((String)_tag, (String)e.toString());
        }
        return ret;
    }

    public synchronized boolean stopChannel(int id) {
        boolean ret = false;
        try {
            ret = NableMediaEngine.nMediaStopAudio(id);
        }
        catch (Exception e) {
            Log.e((String)_tag, (String)e.toString());
        }
        return ret;
    }

    public synchronized boolean stopChannelTx(int id) {
        boolean ret = false;
        try {
            ret = NableMediaEngine.nMediaStopAudioTx(id);
        }
        catch (Exception e) {
            Log.e((String)_tag, (String)e.toString());
        }
        return ret;
    }

    public synchronized boolean stopChannelRx(int id) {
        boolean ret = false;
        try {
            ret = NableMediaEngine.nMediaStopAudioRx(id);
        }
        catch (Exception e) {
            Log.e((String)_tag, (String)e.toString());
        }
        return ret;
    }

    public synchronized boolean pauseChannelTx(int id) {
        boolean ret = false;
        try {
            ret = NableMediaEngine.nMediaPauseAudioTx(id);
        }
        catch (Exception e) {
            Log.e((String)_tag, (String)e.toString());
        }
        return ret;
    }

    public synchronized boolean pauseChannelRx(int id) {
        boolean ret = false;
        try {
            ret = NableMediaEngine.nMediaPauseAudioRx(id);
        }
        catch (Exception e) {
            Log.e((String)_tag, (String)e.toString());
        }
        return ret;
    }

    public synchronized boolean resumeChannelTx(int id) {
        boolean ret = false;
        try {
            ret = NableMediaEngine.nMediaResumeAudioTx(id);
        }
        catch (Exception e) {
            Log.e((String)_tag, (String)e.toString());
        }
        return ret;
    }

    public synchronized boolean resumeChannelRx(int id) {
        boolean ret = false;
        try {
            ret = NableMediaEngine.nMediaResumeAudioRx(id);
        }
        catch (Exception e) {
            Log.e((String)_tag, (String)e.toString());
        }
        return ret;
    }

    public synchronized boolean dumpChannel(int id, String save_path) {
        boolean ret = false;
        try {
            ret = NableMediaEngine.nMediaDumpAudio(id, save_path);
        }
        catch (Exception e) {
            Log.e((String)_tag, (String)e.toString());
        }
        return ret;
    }

    public synchronized boolean startRecord(int id, String file_path, int format) {
        boolean ret = false;
        try {
            ret = NableMediaEngine.nMediastartAudioRecord(id, file_path, format);
        }
        catch (Exception e) {
            Log.e((String)_tag, (String)e.toString());
        }
        return ret;
    }

    public synchronized boolean stopRecord(int id) {
        boolean ret = false;
        try {
            ret = NableMediaEngine.nMediastopAudioRecord(id);
        }
        catch (Exception e) {
            Log.e((String)_tag, (String)e.toString());
        }
        return ret;
    }

    public synchronized boolean sendDTMF(int id, int key) {
        boolean ret = false;
        try {
            ret = NableMediaEngine.nMediaSendDTMF(id, key);
        }
        catch (Exception e) {
            Log.e((String)_tag, (String)e.toString());
        }
        return ret;
    }

    public synchronized boolean setVADMode(int id, int cn_pt, int interval) {
        boolean ret = false;
        try {
            ret = NableMediaEngine.nMediaSetVADMode(id, cn_pt, interval);
        }
        catch (Exception e) {
            Log.e((String)_tag, (String)e.toString());
        }
        return ret;
    }

    public synchronized boolean setMute(int id, boolean mute) {
        boolean ret = false;
        try {
            ret = NableMediaEngine.nMediaSetMute(id, mute);
        }
        catch (Exception e) {
            Log.e((String)_tag, (String)e.toString());
        }
        return ret;
    }

    public synchronized boolean setDTMFListener(int id, IDTMFDetectListener Listener) {
        boolean ret = false;
        if (id < 0) {
            return false;
        }
        if (id >= NableMediaEngine.MAX_CHANNELID) {
            return false;
        }
        try {
            ret = NableMediaEngine.nMediaSetDTMFListener(id);
        }
        catch (Exception e) {
            Log.e((String)_tag, (String)e.toString());
        }
        NableMediaEngine.m_dtmfListener[id] = Listener;
        return ret;
    }

    public synchronized boolean putData(int id, int protocol, byte[] buffer, int size) {
        boolean ret = false;
        try {
            ret = NableMediaEngine.nMediaPutAudioData(id, protocol, buffer, size);
        }
        catch (Exception e) {
            Log.e((String)_tag, (String)e.toString());
        }
        return ret;
    }

    public synchronized boolean setExtTransportListener(int id, NableMediaEngine.IExtTransportListener rtpListener, NableMediaEngine.IExtTransportListener rtcpListener) {
        boolean ret = false;
        if (id < 0) {
            return false;
        }
        if (id >= NableMediaEngine.MAX_CHANNELID) {
            return false;
        }
        try {
            ret = NableMediaEngine.nMediaSetAudioExtTransportListener(id);
        }
        catch (Exception e) {
            Log.e((String)_tag, (String)e.toString());
        }
        NableMediaEngine.m_audioRTPListener[id] = rtpListener;
        NableMediaEngine.m_audioRTCPListener[id] = rtcpListener;
        return ret;
    }

    public synchronized int getRTCPStatistics(int id, int key) {
        int ret = -1;
        try {
            ret = NableMediaEngine.nMediaGetAudioRTCPStatistics(id, key);
        }
        catch (Exception e) {
            Log.e((String)_tag, (String)e.toString());
        }
        return ret;
    }

    public synchronized boolean startSendingUserFile(int id, String file_path, int format, boolean loop, IUserDateFileEOFListener listener) {
        boolean ret = false;
        try {
            ret = NableMediaEngine.nMediaStartAudioSendUserFile(id, file_path, format, loop);
        }
        catch (Exception e) {
            Log.e((String)_tag, (String)e.toString());
        }
        NableMediaEngine.m_audioSendUserEOFCallback[id] = listener;
        return ret;
    }

    public synchronized boolean stopSendingUserFile(int id) {
        boolean ret = false;
        try {
            ret = NableMediaEngine.nMediaStopAudioSendUserFile(id);
        }
        catch (Exception e) {
            Log.e((String)_tag, (String)e.toString());
        }
        return ret;
    }

    public synchronized boolean startSendingUserCallback(int id, NableMediaEngine.IUserDataCallback callback) {
        boolean ret = false;
        try {
            ret = NableMediaEngine.nMediaStartAudioSendUserCallback(id);
        }
        catch (Exception e) {
            Log.e((String)_tag, (String)e.toString());
        }
        NableMediaEngine.m_audioSendUserCallback[id] = callback;
        return ret;
    }

    public synchronized boolean stopSendingUserCallback(int id) {
        boolean ret = false;
        try {
            ret = NableMediaEngine.nMediaStopAudioSendUserCallback(id);
        }
        catch (Exception e) {
            Log.e((String)_tag, (String)e.toString());
        }
        return ret;
    }

    public synchronized boolean startPlayingUserFile(int id, String file_path, int format, boolean loop, IUserDateFileEOFListener listener) {
        boolean ret = false;
        try {
            ret = NableMediaEngine.nMediaStartAudioPlayUserFile(id, file_path, format, loop);
        }
        catch (Exception e) {
            Log.e((String)_tag, (String)e.toString());
        }
        NableMediaEngine.m_audioPlayUserEOFCallback[id] = listener;
        return ret;
    }

    public synchronized boolean stopPlayingUserFile(int id) {
        boolean ret = false;
        try {
            ret = NableMediaEngine.nMediaStopAudioPlayUserFile(id);
        }
        catch (Exception e) {
            Log.e((String)_tag, (String)e.toString());
        }
        return ret;
    }

    public synchronized boolean startPlayingUserCallback(int id, NableMediaEngine.IUserDataCallback callback) {
        boolean ret = false;
        try {
            ret = NableMediaEngine.nMediaStartAudioPlayUserCallback(id);
        }
        catch (Exception e) {
            Log.e((String)_tag, (String)e.toString());
        }
        NableMediaEngine.m_audioPlayUserCallback[id] = callback;
        return ret;
    }

    public synchronized boolean stopPlayingUserCallback(int id) {
        boolean ret = false;
        try {
            ret = NableMediaEngine.nMediaStopAudioPlayUserCallback(id);
        }
        catch (Exception e) {
            Log.e((String)_tag, (String)e.toString());
        }
        return ret;
    }

    public synchronized boolean setKeepAlive(int id, boolean send, int interval) {
        boolean ret = false;
        try {
            ret = NableMediaEngine.nMediaSetAudioKeepAlive(id, send, interval);
        }
        catch (Exception e) {
            Log.e((String)_tag, (String)e.toString());
        }
        return ret;
    }

    public synchronized boolean setRTCPSend(int id, boolean send) {
        boolean ret = false;
        try {
            ret = NableMediaEngine.nMediaSetAudioRTCPSend(id, send);
        }
        catch (Exception e) {
            Log.e((String)_tag, (String)e.toString());
        }
        return ret;
    }

    public synchronized boolean setSocketOption(int id, int protocol, int option, byte[] value) {
        boolean ret = false;
        try {
            ret = NableMediaEngine.nMediaSetAudioSocketOption(id, protocol, option, value, value.length);
        }
        catch (Exception e) {
            Log.e((String)_tag, (String)e.toString());
        }
        return ret;
    }

    public synchronized boolean setProperty(int id, int key, long value) {
        boolean ret = false;
        try {
            ret = NableMediaEngine.nMediaSetAudioProperty(id, key, value);
        }
        catch (Exception e) {
            Log.e((String)_tag, (String)e.toString());
        }
        return ret;
    }

    public synchronized long getProperty(int id, int key) {
        long ret = -1L;
        try {
            ret = NableMediaEngine.nMediaGetAudioProperty(id, key);
        }
        catch (Exception e) {
            Log.e((String)_tag, (String)e.toString());
        }
        return ret;
    }

    public synchronized int getChannelState(int id) {
        int state = 0;
        try {
            state = NableMediaEngine.nMediaGetAudioChannelState(id);
        }
        catch (Exception e) {
            Log.e((String)_tag, (String)e.toString());
        }
        return state;
    }

    public synchronized boolean setPath(int path) {
        boolean ret = false;
        try {
            ret = NableMediaEngine.nMediaSetAudioPath(path);
        }
        catch (Exception e) {
            Log.e((String)_tag, (String)e.toString());
        }
        return ret;
    }

    public synchronized int getCodecCount() {
        int ret = -1;
        try {
            ret = NableMediaEngine.nMediaGetAudioCodecCnt();
        }
        catch (Exception e) {
            Log.e((String)_tag, (String)e.toString());
        }
        return ret;
    }

    public synchronized String getCodecName(int codec_id) {
        String ret = "";
        try {
            ret = NableMediaEngine.nMediaGetAudioCodecName(codec_id);
        }
        catch (Exception e) {
            Log.e((String)_tag, (String)e.toString());
        }
        return ret;
    }

    public static class Codec {
        public static int G711U = 0;
        public static int G711A = 1;
        public static int G729 = 2;
        public static int ILBC = 3;
        public static int AMRNB_OA = 4;
        public static int AMRWB_OA = 5;
        public static int AMRNB_BE = 6;
        public static int AMRWB_BE = 7;
        public static int SPEEXNB = 8;
        public static int SPEEXWB = 9;
        public static int SPEEXSWB = 10;
        public static int OPUSNB = 11;
        public static int OPUSWB = 12;
        public static int EVSNB = 13;
        public static int EVSWB = 14;
    }

    public static class DTMF {
        public static int Key0 = 0;
        public static int Key1 = 1;
        public static int Key2 = 2;
        public static int Key3 = 3;
        public static int Key4 = 4;
        public static int Key5 = 5;
        public static int Key6 = 6;
        public static int Key7 = 7;
        public static int Key8 = 8;
        public static int Key9 = 9;
        public static int KeyStar = 10;
        public static int KeyPound = 11;
        public static int KeyA = 12;
        public static int KeyB = 13;
        public static int KeyC = 14;
        public static int KeyD = 15;
    }

    public static interface IDTMFDetectListener {
        public void onReceiveDTMF(int var1, int var2);
    }

    public static interface IUserDateFileEOFListener {
        public void onUserEndoffile(int var1);
    }

    public static class Path {
        public static int Handset = 0;
        public static int Speaker = 1;
        public static int Headset = 2;
        public static int Bluetooth = 3;
    }

    public static class Property {
        public static int BitRate = 0;
        public static int DTMFDuration = 1;
        public static int Voice_Quality = 30001;
    }

    public static class UserFileFormat {
        public static int Wav = 0;
    }
}

