/*
 * Decompiled with CFR 0.152.
 */
package javax.jmdns.impl;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jmdns.impl.DNSMessage;
import javax.jmdns.impl.DNSQuestion;
import javax.jmdns.impl.DNSRecord;
import javax.jmdns.impl.constants.DNSConstants;
import javax.jmdns.impl.constants.DNSLabel;
import javax.jmdns.impl.constants.DNSOptionCode;
import javax.jmdns.impl.constants.DNSRecordClass;
import javax.jmdns.impl.constants.DNSRecordType;
import javax.jmdns.impl.constants.DNSResultCode;

public final class DNSIncoming
extends DNSMessage {
    private static Logger logger = Logger.getLogger(DNSIncoming.class.getName());
    public static boolean USE_DOMAIN_NAME_FORMAT_FOR_SRV_TARGET = true;
    private final DatagramPacket _packet;
    private final long _receivedTime;
    private final MessageInputStream _messageInputStream;
    private int _senderUDPPayload;
    private static final char[] _nibbleToHex = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    public DNSIncoming(DatagramPacket packet) throws IOException {
        super(0, 0, packet.getPort() == DNSConstants.MDNS_PORT);
        this._packet = packet;
        InetAddress source = packet.getAddress();
        this._messageInputStream = new MessageInputStream(packet.getData(), packet.getLength());
        this._receivedTime = System.currentTimeMillis();
        this._senderUDPPayload = 1460;
        try {
            DNSRecord rec;
            int i;
            this.setId(this._messageInputStream.readUnsignedShort());
            this.setFlags(this._messageInputStream.readUnsignedShort());
            if (this.getOperationCode() > 0) {
                throw new IOException("Received a message with a non standard operation code. Currently unsupported in the specification.");
            }
            int numQuestions = this._messageInputStream.readUnsignedShort();
            int numAnswers = this._messageInputStream.readUnsignedShort();
            int numAuthorities = this._messageInputStream.readUnsignedShort();
            int numAdditionals = this._messageInputStream.readUnsignedShort();
            if (logger.isLoggable(Level.FINER)) {
                logger.finer("DNSIncoming() questions:" + numQuestions + " answers:" + numAnswers + " authorities:" + numAuthorities + " additionals:" + numAdditionals);
            }
            if (numQuestions * 5 + (numAnswers + numAuthorities + numAdditionals) * 11 > packet.getLength()) {
                throw new IOException("questions:" + numQuestions + " answers:" + numAnswers + " authorities:" + numAuthorities + " additionals:" + numAdditionals);
            }
            if (numQuestions > 0) {
                for (i = 0; i < numQuestions; ++i) {
                    this._questions.add(this.readQuestion());
                }
            }
            if (numAnswers > 0) {
                for (i = 0; i < numAnswers; ++i) {
                    rec = this.readAnswer(source);
                    if (rec == null) continue;
                    this._answers.add(rec);
                }
            }
            if (numAuthorities > 0) {
                for (i = 0; i < numAuthorities; ++i) {
                    rec = this.readAnswer(source);
                    if (rec == null) continue;
                    this._authoritativeAnswers.add(rec);
                }
            }
            if (numAdditionals > 0) {
                for (i = 0; i < numAdditionals; ++i) {
                    rec = this.readAnswer(source);
                    if (rec == null) continue;
                    this._additionals.add(rec);
                }
            }
            if (this._messageInputStream.available() > 0) {
                throw new IOException("Received a message with the wrong length.");
            }
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "DNSIncoming() dump " + this.print(true) + "\n exception ", e);
            IOException ioe = new IOException("DNSIncoming corrupted message");
            ioe.initCause(e);
            throw ioe;
        }
    }

    private DNSIncoming(int flags, int id, boolean multicast, DatagramPacket packet, long receivedTime) {
        super(flags, id, multicast);
        this._packet = packet;
        this._messageInputStream = new MessageInputStream(packet.getData(), packet.getLength());
        this._receivedTime = receivedTime;
    }

    public DNSIncoming clone() {
        DNSIncoming in = new DNSIncoming(this.getFlags(), this.getId(), this.isMulticast(), this._packet, this._receivedTime);
        in._senderUDPPayload = this._senderUDPPayload;
        in._questions.addAll(this._questions);
        in._answers.addAll(this._answers);
        in._authoritativeAnswers.addAll(this._authoritativeAnswers);
        in._additionals.addAll(this._additionals);
        return in;
    }

    private DNSQuestion readQuestion() {
        String domain = this._messageInputStream.readName();
        DNSRecordType type = DNSRecordType.typeForIndex(this._messageInputStream.readUnsignedShort());
        if (type == DNSRecordType.TYPE_IGNORE) {
            logger.log(Level.SEVERE, "Could not find record type: " + this.print(true));
        }
        int recordClassIndex = this._messageInputStream.readUnsignedShort();
        DNSRecordClass recordClass = DNSRecordClass.classForIndex(recordClassIndex);
        boolean unique = recordClass.isUnique(recordClassIndex);
        return DNSQuestion.newQuestion(domain, type, recordClass, unique);
    }

    private DNSRecord readAnswer(InetAddress source) {
        DNSRecordClass recordClass;
        String domain = this._messageInputStream.readName();
        DNSRecordType type = DNSRecordType.typeForIndex(this._messageInputStream.readUnsignedShort());
        if (type == DNSRecordType.TYPE_IGNORE) {
            logger.log(Level.SEVERE, "Could not find record type. domain: " + domain + "\n" + this.print(true));
        }
        int recordClassIndex = this._messageInputStream.readUnsignedShort();
        DNSRecordClass dNSRecordClass = recordClass = type == DNSRecordType.TYPE_OPT ? DNSRecordClass.CLASS_UNKNOWN : DNSRecordClass.classForIndex(recordClassIndex);
        if (recordClass == DNSRecordClass.CLASS_UNKNOWN && type != DNSRecordType.TYPE_OPT) {
            logger.log(Level.SEVERE, "Could not find record class. domain: " + domain + " type: " + (Object)((Object)type) + "\n" + this.print(true));
        }
        boolean unique = recordClass.isUnique(recordClassIndex);
        int ttl = this._messageInputStream.readInt();
        int len = this._messageInputStream.readUnsignedShort();
        DNSRecord rec = null;
        block1 : switch (type) {
            case TYPE_A: {
                rec = new DNSRecord.IPv4Address(domain, recordClass, unique, ttl, this._messageInputStream.readBytes(len));
                break;
            }
            case TYPE_AAAA: {
                rec = new DNSRecord.IPv6Address(domain, recordClass, unique, ttl, this._messageInputStream.readBytes(len));
                break;
            }
            case TYPE_CNAME: 
            case TYPE_PTR: {
                String service = "";
                service = this._messageInputStream.readName();
                if (service.length() > 0) {
                    rec = new DNSRecord.Pointer(domain, recordClass, unique, ttl, service);
                    break;
                }
                logger.log(Level.WARNING, "PTR record of class: " + (Object)((Object)recordClass) + ", there was a problem reading the service name of the answer for domain:" + domain);
                break;
            }
            case TYPE_TXT: {
                rec = new DNSRecord.Text(domain, recordClass, unique, ttl, this._messageInputStream.readBytes(len));
                break;
            }
            case TYPE_SRV: {
                int priority = this._messageInputStream.readUnsignedShort();
                int weight = this._messageInputStream.readUnsignedShort();
                int port = this._messageInputStream.readUnsignedShort();
                String target = "";
                target = USE_DOMAIN_NAME_FORMAT_FOR_SRV_TARGET ? this._messageInputStream.readName() : this._messageInputStream.readNonNameString();
                rec = new DNSRecord.Service(domain, recordClass, unique, ttl, priority, weight, port, target);
                break;
            }
            case TYPE_HINFO: {
                StringBuilder buf = new StringBuilder();
                buf.append(this._messageInputStream.readUTF(len));
                int index = buf.indexOf(" ");
                String cpu = (index > 0 ? buf.substring(0, index) : buf.toString()).trim();
                String os = (index > 0 ? buf.substring(index + 1) : "").trim();
                rec = new DNSRecord.HostInformation(domain, recordClass, unique, ttl, cpu, os);
                break;
            }
            case TYPE_OPT: {
                DNSResultCode extendedResultCode = DNSResultCode.resultCodeForFlags(this.getFlags(), ttl);
                int version = (ttl & 0xFF0000) >> 16;
                if (version == 0) {
                    this._senderUDPPayload = recordClassIndex;
                    while (this._messageInputStream.available() > 0) {
                        int optionCodeInt = 0;
                        DNSOptionCode optionCode = null;
                        if (this._messageInputStream.available() < 2) {
                            logger.log(Level.WARNING, "There was a problem reading the OPT record. Ignoring.");
                            break block1;
                        }
                        optionCodeInt = this._messageInputStream.readUnsignedShort();
                        optionCode = DNSOptionCode.resultCodeForFlags(optionCodeInt);
                        int optionLength = 0;
                        if (this._messageInputStream.available() < 2) {
                            logger.log(Level.WARNING, "There was a problem reading the OPT record. Ignoring.");
                            break block1;
                        }
                        optionLength = this._messageInputStream.readUnsignedShort();
                        byte[] optiondata = new byte[]{};
                        if (this._messageInputStream.available() >= optionLength) {
                            optiondata = this._messageInputStream.readBytes(optionLength);
                        }
                        switch (optionCode) {
                            case Owner: {
                                byte ownerVersion = 0;
                                byte ownerSequence = 0;
                                byte[] ownerPrimaryMacAddress = null;
                                byte[] ownerWakeupMacAddress = null;
                                byte[] ownerPassword = null;
                                try {
                                    ownerVersion = optiondata[0];
                                    ownerSequence = optiondata[1];
                                    ownerWakeupMacAddress = ownerPrimaryMacAddress = new byte[]{optiondata[2], optiondata[3], optiondata[4], optiondata[5], optiondata[6], optiondata[7]};
                                    if (optiondata.length > 8) {
                                        ownerWakeupMacAddress = new byte[]{optiondata[8], optiondata[9], optiondata[10], optiondata[11], optiondata[12], optiondata[13]};
                                    }
                                    if (optiondata.length == 18) {
                                        ownerPassword = new byte[]{optiondata[14], optiondata[15], optiondata[16], optiondata[17]};
                                    }
                                    if (optiondata.length == 22) {
                                        ownerPassword = new byte[]{optiondata[14], optiondata[15], optiondata[16], optiondata[17], optiondata[18], optiondata[19], optiondata[20], optiondata[21]};
                                    }
                                }
                                catch (Exception exception) {
                                    logger.warning("Malformed OPT answer. Option code: Owner data: " + this._hexString(optiondata));
                                }
                                if (!logger.isLoggable(Level.FINE)) break;
                                logger.fine("Unhandled Owner OPT version: " + ownerVersion + " sequence: " + ownerSequence + " MAC address: " + this._hexString(ownerPrimaryMacAddress) + (ownerWakeupMacAddress != ownerPrimaryMacAddress ? " wakeup MAC address: " + this._hexString(ownerWakeupMacAddress) : "") + (ownerPassword != null ? " password: " + this._hexString(ownerPassword) : ""));
                                break;
                            }
                            case LLQ: 
                            case NSID: 
                            case UL: {
                                if (!logger.isLoggable(Level.FINE)) break;
                                logger.log(Level.FINE, "There was an OPT answer. Option code: " + (Object)((Object)optionCode) + " data: " + this._hexString(optiondata));
                                break;
                            }
                            case Unknown: {
                                logger.log(Level.WARNING, "There was an OPT answer. Not currently handled. Option code: " + optionCodeInt + " data: " + this._hexString(optiondata));
                                break;
                            }
                        }
                    }
                    break;
                }
                logger.log(Level.WARNING, "There was an OPT answer. Wrong version number: " + version + " result code: " + (Object)((Object)extendedResultCode));
                break;
            }
            default: {
                if (logger.isLoggable(Level.FINER)) {
                    logger.finer("DNSIncoming() unknown type:" + (Object)((Object)type));
                }
                this._messageInputStream.skip(len);
            }
        }
        if (rec != null) {
            rec.setRecordSource(source);
        }
        return rec;
    }

    String print(boolean dump) {
        StringBuilder buf = new StringBuilder();
        buf.append(this.print());
        if (dump) {
            byte[] data = new byte[this._packet.getLength()];
            System.arraycopy(this._packet.getData(), 0, data, 0, data.length);
            buf.append(this.print(data));
        }
        return buf.toString();
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append(this.isQuery() ? "dns[query," : "dns[response,");
        if (this._packet.getAddress() != null) {
            buf.append(this._packet.getAddress().getHostAddress());
        }
        buf.append(':');
        buf.append(this._packet.getPort());
        buf.append(", length=");
        buf.append(this._packet.getLength());
        buf.append(", id=0x");
        buf.append(Integer.toHexString(this.getId()));
        if (this.getFlags() != 0) {
            buf.append(", flags=0x");
            buf.append(Integer.toHexString(this.getFlags()));
            if ((this.getFlags() & 0x8000) != 0) {
                buf.append(":r");
            }
            if ((this.getFlags() & 0x400) != 0) {
                buf.append(":aa");
            }
            if ((this.getFlags() & 0x200) != 0) {
                buf.append(":tc");
            }
        }
        if (this.getNumberOfQuestions() > 0) {
            buf.append(", questions=");
            buf.append(this.getNumberOfQuestions());
        }
        if (this.getNumberOfAnswers() > 0) {
            buf.append(", answers=");
            buf.append(this.getNumberOfAnswers());
        }
        if (this.getNumberOfAuthorities() > 0) {
            buf.append(", authorities=");
            buf.append(this.getNumberOfAuthorities());
        }
        if (this.getNumberOfAdditionals() > 0) {
            buf.append(", additionals=");
            buf.append(this.getNumberOfAdditionals());
        }
        if (this.getNumberOfQuestions() > 0) {
            buf.append("\nquestions:");
            for (DNSQuestion question : this._questions) {
                buf.append("\n\t");
                buf.append(question);
            }
        }
        if (this.getNumberOfAnswers() > 0) {
            buf.append("\nanswers:");
            for (DNSRecord record : this._answers) {
                buf.append("\n\t");
                buf.append(record);
            }
        }
        if (this.getNumberOfAuthorities() > 0) {
            buf.append("\nauthorities:");
            for (DNSRecord record : this._authoritativeAnswers) {
                buf.append("\n\t");
                buf.append(record);
            }
        }
        if (this.getNumberOfAdditionals() > 0) {
            buf.append("\nadditionals:");
            for (DNSRecord record : this._additionals) {
                buf.append("\n\t");
                buf.append(record);
            }
        }
        buf.append("]");
        return buf.toString();
    }

    void append(DNSIncoming that) {
        if (!(this.isQuery() && this.isTruncated() && that.isQuery())) {
            throw new IllegalArgumentException();
        }
        this._questions.addAll(that.getQuestions());
        this._answers.addAll(that.getAnswers());
        this._authoritativeAnswers.addAll(that.getAuthorities());
        this._additionals.addAll(that.getAdditionals());
    }

    public int elapseSinceArrival() {
        return (int)(System.currentTimeMillis() - this._receivedTime);
    }

    public int getSenderUDPPayload() {
        return this._senderUDPPayload;
    }

    private String _hexString(byte[] bytes) {
        StringBuilder result = new StringBuilder(2 * bytes.length);
        for (int i = 0; i < bytes.length; ++i) {
            int b = bytes[i] & 0xFF;
            result.append(_nibbleToHex[b / 16]);
            result.append(_nibbleToHex[b % 16]);
        }
        return result.toString();
    }

    public static class MessageInputStream
    extends ByteArrayInputStream {
        private static Logger logger1 = Logger.getLogger(MessageInputStream.class.getName());
        final Map<Integer, String> _names = new HashMap<Integer, String>();

        public MessageInputStream(byte[] buffer, int length) {
            this(buffer, 0, length);
        }

        public MessageInputStream(byte[] buffer, int offset, int length) {
            super(buffer, offset, length);
        }

        public int readByte() {
            return this.read();
        }

        public int readUnsignedByte() {
            return this.read() & 0xFF;
        }

        public int readUnsignedShort() {
            return this.readUnsignedByte() << 8 | this.readUnsignedByte();
        }

        public int readInt() {
            return this.readUnsignedShort() << 16 | this.readUnsignedShort();
        }

        public byte[] readBytes(int len) {
            byte[] bytes = new byte[len];
            this.read(bytes, 0, len);
            return bytes;
        }

        public String readUTF(int len) {
            StringBuilder buffer = new StringBuilder(len);
            for (int index = 0; index < len; ++index) {
                int ch = this.readUnsignedByte();
                switch (ch >> 4) {
                    case 0: 
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: {
                        break;
                    }
                    case 12: 
                    case 13: {
                        ch = (ch & 0x1F) << 6 | this.readUnsignedByte() & 0x3F;
                        ++index;
                        break;
                    }
                    case 14: {
                        ch = (ch & 0xF) << 12 | (this.readUnsignedByte() & 0x3F) << 6 | this.readUnsignedByte() & 0x3F;
                        ++index;
                        ++index;
                        break;
                    }
                    default: {
                        ch = (ch & 0x3F) << 4 | this.readUnsignedByte() & 0xF;
                        ++index;
                    }
                }
                buffer.append((char)ch);
            }
            return buffer.toString();
        }

        protected synchronized int peek() {
            return this.pos < this.count ? this.buf[this.pos] & 0xFF : -1;
        }

        public String readName() {
            HashMap<Integer, StringBuilder> names = new HashMap<Integer, StringBuilder>();
            StringBuilder buffer = new StringBuilder();
            boolean finished = false;
            block5: while (!finished) {
                int len = this.readUnsignedByte();
                if (len == 0) {
                    finished = true;
                    break;
                }
                switch (DNSLabel.labelForByte(len)) {
                    case Standard: {
                        int offset = this.pos - 1;
                        String label = this.readUTF(len) + ".";
                        buffer.append(label);
                        for (StringBuilder previousLabel : names.values()) {
                            previousLabel.append(label);
                        }
                        names.put(offset, new StringBuilder(label));
                        continue block5;
                    }
                    case Compressed: {
                        int index = DNSLabel.labelValue(len) << 8 | this.readUnsignedByte();
                        String compressedLabel = this._names.get(index);
                        if (compressedLabel == null) {
                            logger1.severe("bad domain name: possible circular name detected. Bad offset: 0x" + Integer.toHexString(index) + " at 0x" + Integer.toHexString(this.pos - 2));
                            compressedLabel = "";
                        }
                        buffer.append(compressedLabel);
                        for (StringBuilder previousLabel : names.values()) {
                            previousLabel.append(compressedLabel);
                        }
                        finished = true;
                        continue block5;
                    }
                    case Extended: {
                        logger1.severe("Extended label are not currently supported.");
                        continue block5;
                    }
                }
                logger1.severe("unsupported dns label type: '" + Integer.toHexString(len & 0xC0) + "'");
            }
            for (Integer index : names.keySet()) {
                this._names.put(index, ((StringBuilder)names.get(index)).toString());
            }
            return buffer.toString();
        }

        public String readNonNameString() {
            int len = this.readUnsignedByte();
            return this.readUTF(len);
        }
    }
}

