/*
 * Decompiled with CFR 0.152.
 */
package javax.jmdns.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.jmdns.impl.DNSEntry;
import javax.jmdns.impl.constants.DNSRecordClass;
import javax.jmdns.impl.constants.DNSRecordType;

public class DNSCache
extends ConcurrentHashMap<String, List<DNSEntry>> {
    private static final long serialVersionUID = 3024739453186759259L;
    public static final DNSCache EmptyCache = new _EmptyCache();

    public DNSCache() {
        this(1024);
    }

    public DNSCache(DNSCache map) {
        this(map != null ? map.size() : 1024);
        if (map != null) {
            this.putAll(map);
        }
    }

    public DNSCache(int initialCapacity) {
        super(initialCapacity);
    }

    @Override
    protected Object clone() throws CloneNotSupportedException {
        return new DNSCache(this);
    }

    public Collection<DNSEntry> allValues() {
        ArrayList<DNSEntry> allValues = new ArrayList<DNSEntry>();
        for (List entry : this.values()) {
            if (entry == null) continue;
            allValues.addAll(entry);
        }
        return allValues;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<? extends DNSEntry> getDNSEntryList(String name) {
        Collection<? extends DNSEntry> entryList = this._getDNSEntryList(name);
        if (entryList != null) {
            Collection<? extends DNSEntry> collection = entryList;
            synchronized (collection) {
                entryList = new ArrayList<DNSEntry>(entryList);
            }
        } else {
            entryList = Collections.emptyList();
        }
        return entryList;
    }

    private Collection<? extends DNSEntry> _getDNSEntryList(String name) {
        return (Collection)this.get(name != null ? name.toLowerCase() : null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DNSEntry getDNSEntry(DNSEntry dnsEntry) {
        Collection<? extends DNSEntry> entryList;
        DNSEntry result = null;
        if (dnsEntry != null && (entryList = this._getDNSEntryList(dnsEntry.getKey())) != null) {
            Collection<? extends DNSEntry> collection = entryList;
            synchronized (collection) {
                for (DNSEntry dNSEntry : entryList) {
                    if (!dNSEntry.isSameEntry(dnsEntry)) continue;
                    result = dNSEntry;
                    break;
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DNSEntry getDNSEntry(String name, DNSRecordType type, DNSRecordClass recordClass) {
        DNSEntry result = null;
        Collection<? extends DNSEntry> entryList = this._getDNSEntryList(name);
        if (entryList != null) {
            Collection<? extends DNSEntry> collection = entryList;
            synchronized (collection) {
                for (DNSEntry dNSEntry : entryList) {
                    if (!dNSEntry.matchRecordType(type) || !dNSEntry.matchRecordClass(recordClass)) continue;
                    result = dNSEntry;
                    break;
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<? extends DNSEntry> getDNSEntryList(String name, DNSRecordType type, DNSRecordClass recordClass) {
        Collection<? extends DNSEntry> entryList = this._getDNSEntryList(name);
        if (entryList != null) {
            Collection<? extends DNSEntry> collection = entryList;
            synchronized (collection) {
                entryList = new ArrayList<DNSEntry>(entryList);
                Iterator<? extends DNSEntry> i = entryList.iterator();
                while (i.hasNext()) {
                    DNSEntry testDNSEntry = i.next();
                    if (testDNSEntry.matchRecordType(type) && testDNSEntry.matchRecordClass(recordClass)) continue;
                    i.remove();
                }
            }
        } else {
            entryList = Collections.emptyList();
        }
        return entryList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addDNSEntry(DNSEntry dnsEntry) {
        boolean result = false;
        if (dnsEntry != null) {
            List entryList = (List)this.get(dnsEntry.getKey());
            if (entryList == null) {
                this.putIfAbsent(dnsEntry.getKey(), new ArrayList());
                entryList = (List)this.get(dnsEntry.getKey());
            }
            List list = entryList;
            synchronized (list) {
                entryList.add(dnsEntry);
            }
            result = true;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeDNSEntry(DNSEntry dnsEntry) {
        List entryList;
        boolean result = false;
        if (dnsEntry != null && (entryList = (List)this.get(dnsEntry.getKey())) != null) {
            List list = entryList;
            synchronized (list) {
                entryList.remove(dnsEntry);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean replaceDNSEntry(DNSEntry newDNSEntry, DNSEntry existingDNSEntry) {
        boolean result = false;
        if (newDNSEntry != null && existingDNSEntry != null && newDNSEntry.getKey().equals(existingDNSEntry.getKey())) {
            List entryList = (List)this.get(newDNSEntry.getKey());
            if (entryList == null) {
                this.putIfAbsent(newDNSEntry.getKey(), new ArrayList());
                entryList = (List)this.get(newDNSEntry.getKey());
            }
            List list = entryList;
            synchronized (list) {
                entryList.remove(existingDNSEntry);
                entryList.add(newDNSEntry);
            }
            result = true;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized String toString() {
        StringBuffer aLog = new StringBuffer(2000);
        aLog.append("\t---- cache ----");
        for (String key : this.keySet()) {
            aLog.append("\n\t\t");
            aLog.append("\n\t\tname '");
            aLog.append(key);
            aLog.append("' ");
            List entryList = (List)this.get(key);
            if (entryList != null && !entryList.isEmpty()) {
                List list = entryList;
                synchronized (list) {
                    for (DNSEntry entry : entryList) {
                        aLog.append("\n\t\t\t");
                        aLog.append(entry.toString());
                    }
                    continue;
                }
            }
            aLog.append(" no entries");
        }
        return aLog.toString();
    }

    static final class _EmptyCache
    extends DNSCache {
        private static final long serialVersionUID = 8487377323074567224L;

        _EmptyCache() {
        }

        @Override
        public int size() {
            return 0;
        }

        @Override
        public boolean isEmpty() {
            return true;
        }

        @Override
        public boolean containsKey(Object key) {
            return false;
        }

        @Override
        public boolean containsValue(Object value) {
            return false;
        }

        @Override
        public List<DNSEntry> get(Object key) {
            return null;
        }

        @Override
        public Set<String> keySet() {
            return Collections.emptySet();
        }

        @Override
        public Collection<List<DNSEntry>> values() {
            return Collections.emptySet();
        }

        @Override
        public boolean equals(Object o) {
            return o instanceof Map && ((Map)o).size() == 0;
        }

        @Override
        public List<DNSEntry> put(String key, List<DNSEntry> value) {
            return null;
        }

        @Override
        public int hashCode() {
            return 0;
        }
    }
}

