/*
 * Decompiled with CFR 0.152.
 */
package com.softforum.xecure.crypto;

import com.softforum.xecure.core.CoreWrapper;
import com.softforum.xecure.util.XDetailData;
import com.softforum.xecure.util.XDetailDataParser;
import com.softforum.xecure.util.XUtil;
import java.util.ArrayList;

public class CertMgr {
    private static volatile CertMgr mUniqueCertMgrInstance;
    private int mMediaID = 0;
    private String mSubjectDN = null;

    private CertMgr() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static CertMgr getInstance() {
        if (null != mUniqueCertMgrInstance) return mUniqueCertMgrInstance;
        Class<CertMgr> clazz = CertMgr.class;
        synchronized (CertMgr.class) {
            if (null != mUniqueCertMgrInstance) return mUniqueCertMgrInstance;
            mUniqueCertMgrInstance = new CertMgr();
            // ** MonitorExit[var0] (shouldn't be in output)
            return mUniqueCertMgrInstance;
        }
    }

    public String getCertTree(int aMediaID, int aCertType, int aMediaType, int aContentLevel, String aSearchValue, String aSearchSerial) {
        this.getMediaList(100, 0, 1);
        return CoreWrapper.getCertTree(aMediaID, aCertType, aMediaType, aContentLevel, aSearchValue, aSearchSerial);
    }

    public int verifyCert(int aMediaID, int aCertType, String aSubjectDN, int aVerifyOption) {
        return CoreWrapper.verifyCert(aMediaID, aCertType, aSubjectDN, aVerifyOption);
    }

    public int deleteCertificate(int aMediaID, int aCertType, String aIssuerRDN, String aCertSerial) {
        return CoreWrapper.deleteCertificate(aMediaID, aCertType, aIssuerRDN, aCertSerial);
    }

    public int deleteCertificateWithSubjectDN(int aMediaID, int aCertType, String aSubjectDN) {
        return CoreWrapper.deleteCertificateWithSubjectDN(aMediaID, aCertType, aSubjectDN);
    }

    public String getPolicyID(int aMediaID, int aCertType, String aIssuerDN, String aCertSerial) {
        String aCertListString = CoreWrapper.getCertTree(aMediaID, 2, 24, 5, aIssuerDN, aCertSerial);
        ArrayList<XDetailData> aCertListArray = XDetailDataParser.parse(aCertListString, 3);
        if (aCertListArray.isEmpty()) {
            return null;
        }
        return aCertListArray.get(0).getValue(1);
    }

    public String getPolicyIDWithSubjectDN(int aMediaID, int aCertType, String aSubjectDN) {
        String aCertListString = CoreWrapper.getCertTree(aMediaID, 2, 14, 5, aSubjectDN, null);
        ArrayList<XDetailData> aCertListArray = XDetailDataParser.parse(aCertListString, 3);
        if (aCertListArray.isEmpty()) {
            return null;
        }
        return aCertListArray.get(0).getValue(1);
    }

    public int verifyCertOwner(int aMediaID, int aSearchCondition, String aSubjectDN, String aPassword, String aIDNum) {
        int res = 0;
        byte[] aBytePassword = null;
        byte[] aByteIDNum = null;
        aBytePassword = aPassword.getBytes();
        aByteIDNum = aIDNum.getBytes();
        res = this.verifyCertOwner(aMediaID, aSearchCondition, aSubjectDN, aBytePassword, aByteIDNum);
        XUtil.resetByteArray(aBytePassword, aByteIDNum);
        aPassword = null;
        aIDNum = null;
        return res;
    }

    public int verifyCertOwnerOrigin(int aMediaID, int aSearchCondition, String aSubjectDN, String aPassword, String aIDNum) {
        int res = 0;
        byte[] aBytePassword = null;
        byte[] aByteIDNum = null;
        aBytePassword = aPassword.getBytes();
        aByteIDNum = aIDNum.getBytes();
        res = this.verifyCertOwnerOrigin(aMediaID, aSearchCondition, aSubjectDN, aBytePassword, aByteIDNum);
        XUtil.resetByteArray(aBytePassword, aByteIDNum);
        aPassword = null;
        aIDNum = null;
        return res;
    }

    public int verifyCertOwner(int aMediaID, int aSearchCondition, String aSubjectDN, byte[] aPassword, byte[] aIDNum) {
        int res = 0;
        res = CoreWrapper.verifyCertOwner(aMediaID, aSearchCondition, aSubjectDN, aPassword, aIDNum);
        return res;
    }

    public int verifyCertOwnerOrigin(int aMediaID, int aSearchCondition, String aSubjectDN, byte[] aPassword, byte[] aIDNum) {
        int res = 0;
        res = CoreWrapper.verifyCertOwnerOrigin(aMediaID, aSearchCondition, aSubjectDN, aPassword, aIDNum);
        return res;
    }

    public int verifyCertOwner(int aMediaID, String aSubjectDN, byte[] aPasswordKey, String aEncryptedPassword, String aEncryptedIDNumber) {
        int aResult = 0;
        aResult = CoreWrapper.verifyCertOwnerWithKDF(aMediaID, aSubjectDN, aPasswordKey, aEncryptedPassword, aEncryptedIDNumber);
        return aResult;
    }

    public int verifyCertOwnerOrigin(int aMediaID, String aSubjectDN, byte[] aPasswordKey, String aEncryptedPassword, String aEncryptedIDNumber) {
        int aResult = 0;
        aResult = CoreWrapper.verifyCertOwnerOriginWithKDF(aMediaID, aSubjectDN, aPasswordKey, aEncryptedPassword, aEncryptedIDNumber);
        return aResult;
    }

    public int verifyCertOwner(int aMediaID, String aIssuerRDN, String aCertSerial, byte[] aPasswordKey, String aEncryptedPassword, String aEncryptedIDNumber) {
        int aResult = 0;
        aResult = CoreWrapper.verifyCertOwnerWithIssuerRDNWithKDF(aMediaID, aIssuerRDN, aCertSerial, aPasswordKey, aEncryptedPassword, aEncryptedIDNumber);
        return aResult;
    }

    public int verifyCertOwnerOrigin(int aMediaID, String aIssuerRDN, String aCertSerial, byte[] aPasswordKey, String aEncryptedPassword, String aEncryptedIDNumber) {
        int aResult = 0;
        aResult = CoreWrapper.verifyCertOwnerOriginWithIssuerRDNWithKDF(aMediaID, aIssuerRDN, aCertSerial, aPasswordKey, aEncryptedPassword, aEncryptedIDNumber);
        return aResult;
    }

    public int changePassword(int aMediaID, String aSubjectDN, String aOldPassword, String aNewPassword) {
        int res = 0;
        byte[] aByteOldPassword = null;
        byte[] aByteNewPassword = null;
        aByteOldPassword = aOldPassword.getBytes();
        aByteNewPassword = aNewPassword.getBytes();
        res = this.changePassword(aMediaID, aSubjectDN, aByteOldPassword, aByteNewPassword);
        XUtil.resetByteArray(aByteOldPassword, aByteNewPassword);
        aOldPassword = null;
        aNewPassword = null;
        return res;
    }

    public int changePassword(int aMediaID, String aSubjectDN, byte[] aOldPassword, byte[] aNewPassword) {
        int res = 0;
        res = CoreWrapper.changeCertPassword(aMediaID, aSubjectDN, aOldPassword, aNewPassword);
        return res;
    }

    public int changePassword(int aMediaID, String aSubjectDN, byte[] aPasswordKey, String aOldEncryptedPassword, String aNewEncryptedPassword) {
        int aResult = 0;
        aResult = CoreWrapper.changeCertPasswordWithKDF(aMediaID, aSubjectDN, aPasswordKey, aOldEncryptedPassword, aNewEncryptedPassword);
        return aResult;
    }

    public int changePassword(int aMediaID, String aIssuerRDN, String aCertSerial, byte[] aPasswordKey, String aOldEncryptedPassword, String aNewEncryptedPassword) {
        int aResult = 0;
        aResult = CoreWrapper.changeCertPasswordWithIssuerRDNWithKDF(aMediaID, aIssuerRDN, aCertSerial, aPasswordKey, aOldEncryptedPassword, aNewEncryptedPassword);
        return aResult;
    }

    public int importCert(int aMediaID, String aPassword, String aPFXPassword, String aPFXPath, String aSignCertPath, String aSignKeyPath, String aKMCertPath, String aKMKeyPath) {
        return CoreWrapper.importCert(aMediaID, aPassword, aPFXPassword, aPFXPath, aSignCertPath, aSignKeyPath, aKMCertPath, aKMKeyPath);
    }

    public int importCert(int aMediaID, byte[] aPasswordKey, String aEncryptedPassword, String aEncryptedPFXPassword, String aPFXPath, String aSignCertPath, String aSignKeyPath, String aKMCertPath, String aKMKeyPath) {
        int aResult = 0;
        aResult = CoreWrapper.importCertWithKDF(aMediaID, aPasswordKey, aEncryptedPassword, aEncryptedPFXPassword, aPFXPath, aSignCertPath, aSignKeyPath, aKMCertPath, aKMKeyPath);
        return aResult;
    }

    public int importCertificateWithDer(int aMediaID, String aPKCS5Password, String aSignatureCertPath, String aSignatureKeyPath, String aKMCertPath, String aKMKeyPath, int isSameCertificate) {
        return CoreWrapper.importCertificateWithDer(aMediaID, aPKCS5Password, aSignatureCertPath, aSignatureKeyPath, aKMCertPath, aKMKeyPath, isSameCertificate);
    }

    public int importCertificateWithDer(int aMediaID, byte[] aPasswordKey, String aEncryptedPassword, String aSignatureCertPath, String aSignatureKeyPath, String aKMCertPath, String aKMKeyPath, int isSameCertificate) {
        int aResult = 0;
        aResult = CoreWrapper.importCertificateWithDerWithKDF(aMediaID, aPasswordKey, aEncryptedPassword, aSignatureCertPath, aSignatureKeyPath, aKMCertPath, aKMKeyPath, isSameCertificate);
        return aResult;
    }

    public String importCertSubjectDN(int aMediaID, String aSignCertPath, String aSignKeyPath, String aKMCertPath, String aKMKeyPath) {
        String aSubjectRDN = null;
        aSubjectRDN = CoreWrapper.importCertSubjectDN(aMediaID, aSignCertPath, aSignKeyPath, aKMCertPath, aKMKeyPath);
        return aSubjectRDN;
    }

    public int exportCert(int aMediaID, String aSubjectDN, String aPKCS8Password, String aPKCS12Password, String aStorePath) {
        int aResult = 0;
        byte[] aBytePKCS8Password = null;
        byte[] aBytePKCS12Password = null;
        aBytePKCS8Password = aPKCS8Password.getBytes();
        aBytePKCS12Password = aPKCS12Password.getBytes();
        aResult = this.exportCert(aMediaID, aSubjectDN, aBytePKCS8Password, aBytePKCS12Password, aStorePath);
        XUtil.resetByteArray(aBytePKCS8Password, aBytePKCS12Password);
        aPKCS8Password = null;
        aPKCS12Password = null;
        return aResult;
    }

    public int exportCert(int aMediaID, String aSubjectDN, byte[] aPKCS8Password, byte[] aPKCS12Password, String aStorePath) {
        int aResult = 0;
        aResult = CoreWrapper.exportCert(aMediaID, aSubjectDN, aPKCS8Password, aPKCS12Password, aStorePath);
        return aResult;
    }

    public int exportCert(int aMediaID, String aSubjectDN, byte[] aPasswordKey, String aEncryptedPKCS8Password, String aEncryptedPKCS12Password, String aStorePath) {
        int aResult = 0;
        aResult = CoreWrapper.exportCertWithKDF(aMediaID, aSubjectDN, aPasswordKey, aEncryptedPKCS8Password, aEncryptedPKCS12Password, aStorePath);
        return aResult;
    }

    public int exportRawCert(int aMediaID, String aSubjectDN) {
        int aResult = 0;
        this.mMediaID = aMediaID;
        this.mSubjectDN = aSubjectDN;
        return aResult;
    }

    public byte[] getExportRawSignCert() {
        byte[] aResult = null;
        aResult = CoreWrapper.getExportRawSignCert(this.mMediaID, this.mSubjectDN);
        return aResult;
    }

    public byte[] getExportRawSignKey() {
        byte[] aResult = null;
        aResult = CoreWrapper.getExportRawSignKey(this.mMediaID, this.mSubjectDN);
        return aResult;
    }

    public byte[] getExportRawKmCert() {
        byte[] aResult = null;
        aResult = CoreWrapper.getExportRawKmCert(this.mMediaID, this.mSubjectDN);
        return aResult;
    }

    public byte[] getExportRawKmKey() {
        byte[] aResult = null;
        aResult = CoreWrapper.getExportRawKmKey(this.mMediaID, this.mSubjectDN);
        return aResult;
    }

    public String verifyRootCaCert(int aMediaID, int aSearchCondition, String aSubjectDN) {
        return CoreWrapper.verifyRootCaCert(aMediaID, aSearchCondition, aSubjectDN);
    }

    public int verifyPassword(int aMediaID, int aSearchCondition, String aSubjectDN, String aPassword) {
        int res = 0;
        byte[] aPlainData = null;
        aPlainData = aPassword.getBytes();
        res = this.verifyPassword(aMediaID, aSearchCondition, aSubjectDN, aPlainData);
        XUtil.resetByteArray(new byte[][]{aPlainData});
        aPassword = null;
        return res;
    }

    public int verifyPassword(int aMediaID, int aSearchCondition, String aSubjectDN, byte[] aPassword) {
        int res = 0;
        res = CoreWrapper.verifyPassword(aMediaID, aSearchCondition, aSubjectDN, aPassword);
        return res;
    }

    public int verifyPassword(int aMediaID, String aSubjectDN, byte[] aPasswordKey, String aEncryptedPassword) {
        int aResult = 0;
        aResult = CoreWrapper.verifyPasswordWithKDF(aMediaID, aSubjectDN, aPasswordKey, aEncryptedPassword);
        return aResult;
    }

    public int verifyPassword(int aMediaID, String aIssuerRDN, String aCertSerial, byte[] aPasswordKey, String aEncryptedPassword) {
        int aResult = 0;
        aResult = CoreWrapper.verifyPasswordWithIssuerRDNWithKDF(aMediaID, aIssuerRDN, aCertSerial, aPasswordKey, aEncryptedPassword);
        return aResult;
    }

    public int verifyPasswordOrigin(int aMediaID, int aSearchCondition, String aSubjectDN, String aPassword) {
        int res = 0;
        byte[] aPlainData = null;
        aPlainData = aPassword.getBytes();
        res = this.verifyPasswordOrigin(aMediaID, aSearchCondition, aSubjectDN, aPlainData);
        XUtil.resetByteArray(new byte[][]{aPlainData});
        aPassword = null;
        return res;
    }

    public int verifyPasswordOrigin(int aMediaID, int aSearchCondition, String aSubjectDN, byte[] aPassword) {
        int res = 0;
        res = CoreWrapper.verifyPasswordOrigin(aMediaID, aSearchCondition, aSubjectDN, aPassword);
        return res;
    }

    public int verifyPasswordOrigin(int aMediaID, String aSubjectDN, byte[] aPasswordKey, String aEncryptedPassword) {
        int aResult = 0;
        aResult = CoreWrapper.verifyPasswordOriginWithKDF(aMediaID, aSubjectDN, aPasswordKey, aEncryptedPassword);
        return aResult;
    }

    public int verifyPasswordOrigin(int aMediaID, String aIssuerRDN, String aCertSerial, byte[] aPasswordKey, String aEncryptedPassword) {
        int aResult = 0;
        aResult = CoreWrapper.verifyPasswordOriginWithIssuerRDNWithKDF(aMediaID, aIssuerRDN, aCertSerial, aPasswordKey, aEncryptedPassword);
        return aResult;
    }

    public int hasCachedData(long aSessionID, String aXgateAddr) {
        return CoreWrapper.hasCachedData(aXgateAddr, aSessionID);
    }

    public int clearCachedData(String aData, int aOption) {
        return CoreWrapper.clearCachedData(aData, aOption);
    }

    public int putCACert(int mediaID, String name, String url) {
        return CoreWrapper.putCACert(mediaID, name, url);
    }

    public boolean hasCertificate(String aFullRDN) {
        int aMediaType;
        if (null == aFullRDN || "".equals(aFullRDN)) {
            aFullRDN = "";
            aMediaType = 0;
        } else {
            aMediaType = 14;
        }
        String aCertTree = this.getCertTree(101, 2, aMediaType, 0, aFullRDN.trim(), null);
        return null != aCertTree && !"".equals(aCertTree);
    }

    public String getMediaList(int aMediaType, int aReturnType, int aOption) {
        return CoreWrapper.getMediaList(aMediaType, aReturnType, aOption);
    }

    public int setIssuerConvertTable(String policy, String convertedPol, String comment, int language) {
        return CoreWrapper.setIssuerConvertTable(policy, convertedPol, comment, language);
    }

    public int checkValidCertPair(int aMediaID, String aSubjectDN) {
        int aResult = 0;
        aResult = CoreWrapper.checkValidCertPair(aMediaID, aSubjectDN);
        return aResult;
    }
}

