/*
 * Decompiled with CFR 0.152.
 */
package com.softforum.xecure.util;

import android.content.Context;
import android.content.res.AssetManager;
import android.net.wifi.WifiManager;
import android.telephony.TelephonyManager;
import com.softforum.xecure.core.CoreWrapper;
import com.softforum.xecure.util.XSLog;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Enumeration;

public class XUtil {
    public static final int PASSWORD_FORMAT_OK = 0;
    public static final int PASSWORD_FORMAT_LENGTH_ERROR = 1;
    public static final int PASSWORD_FORMAT_SYNTAX_ERROR = 2;
    public static final int NEWPASSWORD_FORMAT_LENGTH_ERROR = 3;
    public static final int NEWPASSWORD_FORMAT_SYNTAX_ERROR = 4;
    public static final int NEWPASSWORD_FORMAT_INVALID_ERROR = 5;
    public static final int PASSWORD_CHECK_OPTION_EIGHT_ALP_NUM = 0;
    public static final int PASSWORD_CHECK_OPTION_NINE_ALP_NUM_SC = 1;
    public static final int PASSWORD_CHECK_OPTION_TEN_ALP_NUM_SC = 2;
    public static final String RESOURCE_PATH = "res";
    public static final String[] RESOUCE_DIRECTORY_LIST = new String[]{"res/certstorage", "res/certstorage/ca", "res/certstorage/ca/84eef6bc2f9b207298a0a4c676cf61b757aa6628", "res/certstorage/ca/5578e97a76f02507041458c94b23ea9e11d775d6", "res/certstorage/ca/52bdebb8f1d906dcc6775f5109572db5d4db69eb", "res/certstorage/ca/0678bdd32b2aa0e6126bee8cd323cb5ca0c7ea27", "res/certstorage/ca/03fa3e5aa4df9ef779646a2b165bb17c31b0009e", "res/certstorage/ca/cf8d89dc72cd3304a7e89c5982863b589b0168ee", "res/certstorage/ca/420eeba3c13b048d6b8ea07e0a92046bafaaf437", "res/certstorage/ca/a2a1039f746597eb7775c96e0bff8313630e9fc8", "res/certstorage/ca/23cc091fa9604fe1ee13589f69f7f9082345d911", "res/certstorage/ca/132d9ccab674d76a0c1925170730d90cfb8e1e80", "res/certstorage/ca/ef57983243311fb938c9b9f4dd66e2321acdd95c", "res/certstorage/ca/30c538d409e70d253249ccc9e99079732f03c88a", "res/certstorage/ca/0a22c999c9a1372490e1be6013e4aff15ae33eb8", "res/certstorage/ca/7daae7bdec91ae498717722019288e93c36a3309", "res/certstorage/ca/68c0ed51a6f6e4d41ba0da0c6ac1f517dc18567e", "res/certstorage/user", "res/certstorage/user/fdab6f9715e56c241bb70182555056ef15f2171f", "res/certstorage/root", "res/certstorage/root/cc22a24b26870ae00fcada35ed6904bcc43c68d2", "res/certstorage/root/5e8d54cd0953a9279f79a5ee62b6702271a08bd9", "res/certstorage/root/4b975cbd73ec36b25f552ad964800c73e892383e", "res/certstorage/root/0ef12e12c6f31a2ea28b9028473313fccdd888c6", "res/certstorage/root/ef6ae6aa613c3d225296fc08dff93cca47512ce0", "res/certstorage/root/143f06757a32fb4a04efe58ae847a92e28462f81", "res/config"};
    public static final String[] RESOURCE_FILE_LIST = new String[]{"res/certstorage/ca/84eef6bc2f9b207298a0a4c676cf61b757aa6628/cert_2712.der", "res/certstorage/ca/5578e97a76f02507041458c94b23ea9e11d775d6/cert.der", "res/certstorage/ca/5578e97a76f02507041458c94b23ea9e11d775d6/cert_03.der", "res/certstorage/ca/52bdebb8f1d906dcc6775f5109572db5d4db69eb/cert.der", "res/certstorage/ca/52bdebb8f1d906dcc6775f5109572db5d4db69eb/cert_1002.der", "res/certstorage/ca/0678bdd32b2aa0e6126bee8cd323cb5ca0c7ea27/cert_101d.der", "res/certstorage/ca/03fa3e5aa4df9ef779646a2b165bb17c31b0009e/cert.der", "res/certstorage/ca/03fa3e5aa4df9ef779646a2b165bb17c31b0009e/cert_02.der", "res/certstorage/ca/cf8d89dc72cd3304a7e89c5982863b589b0168ee/cert_101f.der", "res/certstorage/ca/420eeba3c13b048d6b8ea07e0a92046bafaaf437/cert_1003.der", "res/certstorage/ca/420eeba3c13b048d6b8ea07e0a92046bafaaf437/cert.der", "res/certstorage/ca/a2a1039f746597eb7775c96e0bff8313630e9fc8/cert_101e.der", "res/certstorage/ca/23cc091fa9604fe1ee13589f69f7f9082345d911/cert_1004.der", "res/certstorage/ca/23cc091fa9604fe1ee13589f69f7f9082345d911/cert.der", "res/certstorage/ca/132d9ccab674d76a0c1925170730d90cfb8e1e80/cert_101c.der", "res/certstorage/ca/ef57983243311fb938c9b9f4dd66e2321acdd95c/cert_1020.der", "res/certstorage/ca/30c538d409e70d253249ccc9e99079732f03c88a/cert.der", "res/certstorage/ca/30c538d409e70d253249ccc9e99079732f03c88a/cert_1009.der", "res/certstorage/ca/0a22c999c9a1372490e1be6013e4aff15ae33eb8/cert.der", "res/certstorage/ca/0a22c999c9a1372490e1be6013e4aff15ae33eb8/cert_07.der", "res/certstorage/ca/7daae7bdec91ae498717722019288e93c36a3309/cert_2713.der", "res/certstorage/ca/68c0ed51a6f6e4d41ba0da0c6ac1f517dc18567e/cert_100a.der", "res/certstorage/ca/68c0ed51a6f6e4d41ba0da0c6ac1f517dc18567e/cert.der", "res/certstorage/user/fdab6f9715e56c241bb70182555056ef15f2171f/cert.der", "res/certstorage/user/fdab6f9715e56c241bb70182555056ef15f2171f/key.der", "res/certstorage/newroot.der", "res/certstorage/info.xul", "res/certstorage/newmndca.der", "res/certstorage/calist.ini", "res/certstorage/root/cc22a24b26870ae00fcada35ed6904bcc43c68d2/cert.der", "res/certstorage/root/cc22a24b26870ae00fcada35ed6904bcc43c68d2/cert_01.der", "res/certstorage/root/5e8d54cd0953a9279f79a5ee62b6702271a08bd9/cert.der", "res/certstorage/root/5e8d54cd0953a9279f79a5ee62b6702271a08bd9/cert_01.der", "res/certstorage/root/4b975cbd73ec36b25f552ad964800c73e892383e/cert_01.der", "res/certstorage/root/0ef12e12c6f31a2ea28b9028473313fccdd888c6/cert_48479209034cb66f1005525650458b7b.der", "res/certstorage/root/ef6ae6aa613c3d225296fc08dff93cca47512ce0/cert.der", "res/certstorage/root/ef6ae6aa613c3d225296fc08dff93cca47512ce0/cert_04.der", "res/certstorage/root/143f06757a32fb4a04efe58ae847a92e28462f81/cert.der", "res/certstorage/root/143f06757a32fb4a04efe58ae847a92e28462f81/cert_02.der", "res/config/policy.tbl", "res/config/xecureweb.cfg", "res/config/xecureweberror.cfg", "res/config/BankCode.tbl", "res/config/policy_en.tbl", "res/config/issuer.tbl", "res/preference.cfg"};

    public static boolean checkResourcesUpdate(Context context) {
        String aPackageBuildTime = "";
        String aInstalledBuildTime = "";
        String aLine = "";
        File anOldResourcePath = context.getFileStreamPath("resources");
        if (anOldResourcePath.exists()) {
            anOldResourcePath.renameTo(context.getFileStreamPath(".softforum"));
        }
        try {
            AssetManager aAssetManager = context.getAssets();
            BufferedReader aReader = new BufferedReader(new InputStreamReader(aAssetManager.open("res/preference.cfg")));
            while ((aLine = aReader.readLine()) != null) {
                if (!aLine.trim().startsWith("build_time")) continue;
                aPackageBuildTime = aLine.substring(aLine.indexOf(61) + 1).trim();
                break;
            }
            aReader.close();
            File aPrefFile = new File(context.getFileStreamPath(RESOURCE_PATH), "preference.cfg");
            if (!aPrefFile.exists()) {
                return true;
            }
            aReader = new BufferedReader(new FileReader(aPrefFile));
            while ((aLine = aReader.readLine()) != null) {
                if (!aLine.trim().startsWith("build_time")) continue;
                aInstalledBuildTime = aLine.substring(aLine.indexOf(61) + 1).trim();
                break;
            }
            aReader.close();
        }
        catch (IOException e) {
            XSLog.e("[Fail checkResourcesUpdate.]");
        }
        if (aInstalledBuildTime.equals("")) {
            return true;
        }
        return aInstalledBuildTime.compareTo(aPackageBuildTime) < 0;
    }

    public static boolean deleteDirectory(File path) {
        if (path.exists() && path.isDirectory()) {
            File[] files = path.listFiles();
            for (int i = 0; i < files.length; ++i) {
                if (files[i].isDirectory()) {
                    XUtil.deleteDirectory(files[i]);
                    continue;
                }
                files[i].delete();
            }
        }
        return path.delete();
    }

    private static void initializeXecureConfig(Context context, boolean checkUpdate) {
        BufferedInputStream aBufferInputStream = null;
        BufferedOutputStream aBufferOutputStream = null;
        int BUFFER_SIZE = 2048;
        int aCount = 0;
        byte[] aBuffer = new byte[2048];
        AssetManager aAssetManager = context.getAssets();
        try {
            if (checkUpdate && !XUtil.checkResourcesUpdate(context)) {
                XSLog.d("XUtil::initializeXecureConfig Resources have been found.");
                return;
            }
            XSLog.d("XUtil::initializeXecureConfig Copy Files");
            XUtil.deleteDirectory(new File(context.getFileStreamPath(RESOURCE_PATH) + "/certstorage"));
            XUtil.deleteDirectory(new File(context.getFileStreamPath(RESOURCE_PATH) + "/config"));
            XUtil.deleteDirectory(new File(context.getFileStreamPath(RESOURCE_PATH) + "/preference.cfg"));
            for (String aTemporaryPath : RESOUCE_DIRECTORY_LIST) {
                String aTargetDirectoryPath = context.getFileStreamPath("") + "/" + aTemporaryPath;
                try {
                    new File(aTargetDirectoryPath).mkdirs();
                    XSLog.d("XUtil::initializeXecureConfig mkdir [" + aTargetDirectoryPath + "]");
                }
                catch (Exception e) {
                    XSLog.d("XUtil::initializeXecureConfig mkdir fail [" + aTargetDirectoryPath + "]");
                }
            }
            for (String aTemporaryPath : RESOURCE_FILE_LIST) {
                String aTargetFilePath = context.getFileStreamPath("") + "/" + aTemporaryPath;
                try {
                    aBufferInputStream = new BufferedInputStream(aAssetManager.open(aTemporaryPath), 2048);
                    aBufferOutputStream = new BufferedOutputStream(new FileOutputStream(new File(aTargetFilePath)), 2048);
                    XSLog.d("XUtil::initializeXecureConfig copy [" + aTargetFilePath + "]");
                    while ((aCount = aBufferInputStream.read(aBuffer, 0, 2048)) != -1) {
                        aBufferOutputStream.write(aBuffer, 0, aCount);
                    }
                    aBufferInputStream.close();
                    aBufferOutputStream.close();
                }
                catch (FileNotFoundException e) {
                    XSLog.d("XUtil::initializeXecureConfig copy fail [" + aTargetFilePath + "]");
                }
            }
        }
        catch (Exception e) {
            XSLog.e("[Fail initializeXecureConfig.]");
        }
    }

    public static void initializeXecureCoreConfig(Context context, boolean checkUpdate) {
        XUtil.initializeXecureConfig(context, checkUpdate);
        CoreWrapper.load();
    }

    public static void initializeXecureCoreConfig(Context context) {
        XUtil.initializeXecureConfig(context, true);
    }

    public static void destroyXecureCore() {
        CoreWrapper.destroy();
    }

    public static String getCNFromRDN(String aRDN) {
        String[] aElementArray;
        for (String aElement : aElementArray = aRDN.split(",")) {
            if (aElement.startsWith("cn=")) {
                return aElement.substring(3);
            }
            if (!aElement.startsWith("ou=")) continue;
            return aElement.substring(3);
        }
        return "";
    }

    public static int checkPasswordFormat(byte[] aPassword) {
        boolean isContainsChar = false;
        boolean isContainsNum = false;
        int aLength = aPassword.length;
        if (aLength < 8 || aLength > 1024) {
            return 1;
        }
        for (int i = 0; i < aLength; ++i) {
            char c = (char)aPassword[i];
            if (c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || "~!@#$%^&*()_+|{}:\"<>?`-=\\[];',./'".indexOf(c) != -1) {
                isContainsChar = true;
            }
            if (Character.isDigit(c)) {
                isContainsNum = true;
            }
            if (!isContainsChar || !isContainsNum) continue;
            return 0;
        }
        return 2;
    }

    public static int checkPasswordFormat(String aPassword) {
        boolean isContainsChar = false;
        boolean isContainsNum = false;
        int aLength = aPassword.length();
        if (aLength < 8 || aLength > 1024) {
            return 1;
        }
        for (int i = 0; i < aLength; ++i) {
            char c = aPassword.charAt(i);
            if (c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || "~!@#$%^&*()_+|{}:\"<>?`-=\\[];',./'".indexOf(c) != -1) {
                isContainsChar = true;
            }
            if (Character.isDigit(c)) {
                isContainsNum = true;
            }
            if (!isContainsChar || !isContainsNum) continue;
            return 0;
        }
        return 2;
    }

    public static int newCheckPasswordFormat(byte[] pPassword) {
        char aChar;
        int aIndex;
        int aLength = 0;
        boolean aIsValid = false;
        String aPassword = null;
        aPassword = new String(pPassword, 0, pPassword.length);
        aLength = aPassword.length();
        if (aLength < 10 || aLength > 1024) {
            return 3;
        }
        for (aIndex = 0; aIndex < aLength; ++aIndex) {
            aChar = aPassword.charAt(aIndex);
            if ((aChar < 'a' || aChar > 'z') && (aChar < 'A' || aChar > 'Z')) continue;
            aIsValid = true;
            break;
        }
        if (!aIsValid) {
            return 4;
        }
        aIsValid = false;
        for (aIndex = 0; aIndex < aLength; ++aIndex) {
            aChar = aPassword.charAt(aIndex);
            if (aChar < '0' || aChar > '9') continue;
            aIsValid = true;
            break;
        }
        if (!aIsValid) {
            return 4;
        }
        aIsValid = false;
        for (aIndex = 0; aIndex < aLength; ++aIndex) {
            aChar = aPassword.charAt(aIndex);
            if ("\"'\\|".indexOf(aChar) == -1) continue;
            return 5;
        }
        for (aIndex = 0; aIndex < aLength; ++aIndex) {
            aChar = aPassword.charAt(aIndex);
            if ("~!@#$%^&*()_+-={}[];:,.<>/?".indexOf(aChar) != -1) {
                aIsValid = true;
                break;
            }
            if (aChar != ' ') continue;
            aIsValid = true;
            break;
        }
        if (!aIsValid) {
            return 4;
        }
        return 0;
    }

    public static int newCheckPasswordFormat(String pPassword) {
        char aChar;
        int aIndex;
        boolean aIsValid = false;
        int aLength = pPassword.length();
        if (aLength < 10 || aLength > 1024) {
            return 3;
        }
        for (aIndex = 0; aIndex < aLength; ++aIndex) {
            aChar = pPassword.charAt(aIndex);
            if ((aChar < 'a' || aChar > 'z') && (aChar < 'A' || aChar > 'Z')) continue;
            aIsValid = true;
            break;
        }
        if (!aIsValid) {
            return 4;
        }
        aIsValid = false;
        for (aIndex = 0; aIndex < aLength; ++aIndex) {
            aChar = pPassword.charAt(aIndex);
            if (aChar < '0' || aChar > '9') continue;
            aIsValid = true;
            break;
        }
        if (!aIsValid) {
            return 4;
        }
        aIsValid = false;
        for (aIndex = 0; aIndex < aLength; ++aIndex) {
            aChar = pPassword.charAt(aIndex);
            if ("\"'\\|".indexOf(aChar) == -1) continue;
            return 5;
        }
        for (aIndex = 0; aIndex < aLength; ++aIndex) {
            aChar = pPassword.charAt(aIndex);
            if ("~!@#$%^&*()_+-={}[];:,.<>/?".indexOf(aChar) != -1) {
                aIsValid = true;
                break;
            }
            if (aChar != ' ') continue;
            aIsValid = true;
            break;
        }
        if (!aIsValid) {
            return 4;
        }
        return 0;
    }

    public static int checkPassword(String aEncryptedPassword, byte[] aPasswordKey, int aCheckOption) {
        int aResult = 0;
        int aCheckPasswordResult = 0;
        int aInputLength = 0;
        aInputLength = CoreWrapper.getInputLengthWithKDF(aEncryptedPassword, aPasswordKey);
        aCheckPasswordResult = CoreWrapper.checkPasswordWithKDF(aEncryptedPassword, aPasswordKey, aCheckOption);
        switch (aCheckOption) {
            case 0: {
                if (aInputLength < 8 || aInputLength > 1024) {
                    aResult = 1;
                    break;
                }
                if (aCheckPasswordResult == 0) break;
                aResult = 2;
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                if (aInputLength < 10 || aInputLength > 1024) {
                    aResult = 3;
                    break;
                }
                if (aCheckPasswordResult == 0) break;
                aResult = 4;
            }
        }
        return aResult;
    }

    public static int getInputLength(String aEncryptedPassword, byte[] aPasswordKey) {
        int aInputLength = 0;
        aInputLength = CoreWrapper.getInputLengthWithKDF(aEncryptedPassword, aPasswordKey);
        return aInputLength;
    }

    public static String decryptPassword(String aEncryptedPassword, byte[] aPasswordKey) {
        String aDecrytPassword = null;
        aDecrytPassword = CoreWrapper.decryptPassword(aEncryptedPassword, aPasswordKey);
        return aDecrytPassword;
    }

    public static String getHWInfo(Context aContext, int aOption) {
        boolean aHDD_SERIAL = true;
        int aMAC_ADDRESS = 2;
        int aPC_IP_ADDRESS = 4;
        int aDEVICE_ID = 8;
        int aPHONE_NUMBER = 16;
        int aSUBSCRIBER_ID = 32;
        int aINFO_ALL = 256;
        boolean aIsAppended = false;
        StringBuilder aBuilder = new StringBuilder();
        TelephonyManager aTelephonyManager = (TelephonyManager)aContext.getSystemService("phone");
        if (0 != (2 & aOption) || 0 != (0x100 & aOption)) {
            aBuilder.append("MAC=" + XUtil.getMacAddress(aContext));
            aIsAppended = true;
        }
        if (0 != (4 & aOption) || 0 != (0x100 & aOption)) {
            if (aIsAppended) {
                aBuilder.append("&");
            }
            aBuilder.append("IP=" + XUtil.getLocalIpAddress(aContext));
            aIsAppended = true;
        }
        if (0 != (8 & aOption) || 0 != (0x100 & aOption)) {
            if (aIsAppended) {
                aBuilder.append("&");
            }
            aBuilder.append("SystemID=" + aTelephonyManager.getDeviceId());
            aIsAppended = true;
        }
        if (0 != (0x20 & aOption) || 0 != (0x100 & aOption)) {
            if (aIsAppended) {
                aBuilder.append("&");
            }
            aBuilder.append("SubscriberID=" + aTelephonyManager.getSubscriberId());
            aIsAppended = true;
        }
        if (0 != (0x10 & aOption) || 0 != (0x100 & aOption)) {
            if (aIsAppended) {
                aBuilder.append("&");
            }
            aBuilder.append("PhoneNumber=" + aTelephonyManager.getLine1Number());
            aIsAppended = true;
        }
        return aBuilder.toString();
    }

    private static String getLocalIpAddress(Context aContext) {
        try {
            Enumeration<NetworkInterface> aNetworkInterfacesEnum = NetworkInterface.getNetworkInterfaces();
            while (aNetworkInterfacesEnum.hasMoreElements()) {
                NetworkInterface aNetWorkInterface = aNetworkInterfacesEnum.nextElement();
                Enumeration<InetAddress> aInetAddressesEnum = aNetWorkInterface.getInetAddresses();
                while (aInetAddressesEnum.hasMoreElements()) {
                    InetAddress aInetAddress = aInetAddressesEnum.nextElement();
                    if (aInetAddress.isLoopbackAddress()) continue;
                    return aInetAddress.getHostAddress();
                }
            }
        }
        catch (SocketException e) {
            XSLog.e("[Fail getLocalIpAddress.]");
        }
        return null;
    }

    private static String getMacAddress(Context aContext) {
        WifiManager aWifiManager = (WifiManager)aContext.getSystemService("wifi");
        String aMacAddress = aWifiManager.getConnectionInfo().getMacAddress();
        return aMacAddress != null ? aMacAddress : "";
    }

    public static boolean isRootedDevice() {
        String[] aPathArray;
        String aPathEnv = System.getenv("PATH");
        for (String aPath : aPathArray = aPathEnv.split(":")) {
            File aSuFile = new File(aPath + "/su");
            if (!aSuFile.exists()) continue;
            XSLog.e("Checking Rooted This device has been rooted!");
            return true;
        }
        return false;
    }

    public static void resetByteArray(byte[] ... arg) {
        for (int aIndex = 0; aIndex < arg.length; ++aIndex) {
            if (arg[aIndex] != null) {
                for (int i = 0; i < arg[aIndex].length; ++i) {
                    arg[aIndex][i] = 0;
                }
            }
            arg[aIndex] = null;
        }
    }

    public static String getSearchHashValue(String aCertInfo, String aFileHash) {
        String aResult = "";
        String[] aCertInfoArray = null;
        String[] aHashAlgDescArray = null;
        String[] aFileHashArray = null;
        String[] aHashValueArray = null;
        String aHashAlg = null;
        if (aCertInfo == null || aCertInfo == "" || aFileHash == null || aFileHash == "") {
            return aResult;
        }
        aCertInfoArray = aCertInfo.split("\\$");
        aHashAlgDescArray = aCertInfoArray[3].split("\\+");
        aHashAlg = aHashAlgDescArray[0].trim().toLowerCase();
        if (aHashAlg == null || aHashAlg == "") {
            return aResult;
        }
        aFileHashArray = aFileHash.split("\\$");
        for (int i = 0; i < aFileHashArray.length && (aHashValueArray = aFileHashArray[i].split("\\|")).length >= 2; ++i) {
            if (!aHashValueArray[0].trim().toLowerCase().equals(aHashAlg)) continue;
            aResult = aHashValueArray[1];
            break;
        }
        return aResult;
    }

    public static String getVersion() {
        String aXSVersion = null;
        aXSVersion = CoreWrapper.getVersion();
        return aXSVersion;
    }

    public static void setLogLevel(int pLogLevel) {
        CoreWrapper.setLogLevel(pLogLevel);
    }

    public static String asHex(byte[] bytes) {
        StringBuffer sb = new StringBuffer(bytes.length * 2);
        for (int i = 0; i < bytes.length; ++i) {
            if ((bytes[i] & 0xFF) < 16) {
                sb.append('0');
            }
            sb.append(Integer.toString(bytes[i] & 0xFF, 16));
        }
        return sb.toString();
    }

    public static String sha256Encrypt(String planText) {
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-256");
            md.update(planText.getBytes());
            byte[] byteData = md.digest();
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < byteData.length; ++i) {
                sb.append(Integer.toString((byteData[i] & 0xFF) + 256, 16).substring(1));
            }
            StringBuffer hexString = new StringBuffer();
            for (int i = 0; i < byteData.length; ++i) {
                String hex = Integer.toHexString(0xFF & byteData[i]);
                if (hex.length() == 1) {
                    hexString.append('0');
                }
                hexString.append(hex);
            }
            return hexString.toString();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException();
        }
    }

    public static String makeHash(String str) {
        String SHA = "";
        try {
            MessageDigest sh = MessageDigest.getInstance("SHA-256");
            sh.update(str.getBytes());
            byte[] byteData = sh.digest();
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < byteData.length; ++i) {
                sb.append(Integer.toString((byteData[i] & 0xFF) + 256, 16).substring(1));
            }
            SHA = sb.toString();
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
            SHA = null;
        }
        return SHA;
    }

    public static byte[] makeHashReturnByte(String str) {
        byte[] byteData = null;
        byte[] euc_kr = null;
        try {
            euc_kr = str.getBytes("EUC-KR");
        }
        catch (UnsupportedEncodingException e1) {
            e1.printStackTrace();
        }
        try {
            MessageDigest sh = MessageDigest.getInstance("SHA-256");
            sh.update(euc_kr);
            byteData = sh.digest();
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
            byteData = null;
        }
        return byteData;
    }

    public static byte[] hexStringToByteArray(String s) {
        int len = s.length();
        byte[] data = new byte[len / 2];
        for (int i = 0; i < len; i += 2) {
            data[i / 2] = (byte)((Character.digit(s.charAt(i), 16) << 4) + Character.digit(s.charAt(i + 1), 16));
        }
        return data;
    }

    public static byte[] encodeUTF8(byte[] pData) {
        byte[] aEncodeUTF8 = null;
        aEncodeUTF8 = CoreWrapper.encodeUTF8(pData);
        return aEncodeUTF8;
    }
}

