/*
 * Decompiled with CFR 0.152.
 */
package com.softforum.xecure.certshare;

import android.app.Activity;
import android.app.ListActivity;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AdapterView;
import android.widget.LinearLayout;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.Spinner;
import android.widget.SpinnerAdapter;
import com.softforum.sample.R;
import com.softforum.xecure.XecureSmart;
import com.softforum.xecure.crypto.CertMgr;
import com.softforum.xecure.keypad.SignCertPasswordWindowWithXK;
import com.softforum.xecure.ui.crypto.SignCertPasswordWindow;
import com.softforum.xecure.ui.transkey.SignCertPasswordWindowWithTransKey;
import com.softforum.xecure.util.EnvironmentConfig;
import com.softforum.xecure.util.ImageTextSpinnerAdapter;
import com.softforum.xecure.util.XDetailData;
import com.softforum.xecure.util.XDetailDataParser;
import com.softforum.xecure.util.XDetailDataRowAdapter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.StringTokenizer;

public class SelectExportCertListWithCertShare
extends ListActivity {
    public static final int mExportCertificateID = 72800;
    private int mMediaID = XecureSmart.mDefaultMediaID;
    private final int MEDIA_SDCARD = 0;
    private final int MEDIA_APPDATA = 1;
    private ArrayList<XDetailData> mXCertDataList = null;

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.select_export_cert_by_xcs);
        if (EnvironmentConfig.mSDCardOnlyUse) {
            this.mMediaID = 101;
        } else if (EnvironmentConfig.mAppDataOnlyUse) {
            this.mMediaID = 1401;
        }
        this.mXCertDataList = new ArrayList();
        if (!EnvironmentConfig.mSDCardAppDataUse) {
            View aView = this.findViewById(R.id.select_media);
            aView.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(0, 0));
            aView.setVisibility(4);
            this.setUserCertItems(this.mMediaID);
        } else {
            this.setSpinner();
        }
    }

    private void setSpinner() {
        Spinner aSelectStorage = null;
        ImageTextSpinnerAdapter aSpinnerAdapter = null;
        HashMap<String, Object> aItem = null;
        ArrayList<HashMap<String, Object>> aItemList = null;
        final SelectExportCertListWithCertShare aContext = this;
        aSelectStorage = (Spinner)this.findViewById(R.id.select_media);
        aItemList = new ArrayList<HashMap<String, Object>>();
        aItem = new HashMap<String, Object>();
        aItem.put("image", R.drawable.sdcard);
        aItem.put("text", "SDCard");
        aItemList.add(aItem);
        aItem = new HashMap();
        aItem.put("image", R.drawable.icon);
        aItem.put("text", "\uc571\ub370\uc774\ud130");
        aItemList.add(aItem);
        aSpinnerAdapter = new ImageTextSpinnerAdapter((Context)this, aItemList);
        aSelectStorage.setAdapter((SpinnerAdapter)aSpinnerAdapter);
        aSelectStorage.setOnItemSelectedListener(new AdapterView.OnItemSelectedListener(){

            public void onItemSelected(AdapterView<?> parent, View view, int position, long id2) {
                switch (position) {
                    case 0: {
                        SelectExportCertListWithCertShare.this.mMediaID = 101;
                        break;
                    }
                    case 1: {
                        SelectExportCertListWithCertShare.this.mMediaID = 1401;
                    }
                }
                aContext.setUserCertItems(SelectExportCertListWithCertShare.this.mMediaID);
            }

            public void onNothingSelected(AdapterView<?> arg0) {
            }
        });
    }

    private void setUserCertItems(int pMediaID) {
        int aMediaID = 0;
        int aSearchCondition = 0;
        String aCertList = null;
        String aMediaList = null;
        StringTokenizer aMediaListTokenizer = null;
        CertMgr aCertMgr = null;
        aMediaID = pMediaID;
        if (this.mXCertDataList.size() > 0) {
            this.mXCertDataList.clear();
        }
        aSearchCondition = 0;
        if (EnvironmentConfig.mExcludeExpiredCert) {
            aSearchCondition = 25;
        }
        aCertMgr = CertMgr.getInstance();
        aMediaList = aCertMgr.getMediaList(aMediaID - 1, 1, 1);
        aMediaListTokenizer = new StringTokenizer(aMediaList, "\t\n");
        while (aMediaListTokenizer.hasMoreTokens()) {
            aMediaID = Integer.parseInt(aMediaListTokenizer.nextToken());
            aCertList = aCertMgr.getCertTree(aMediaID, 2, aSearchCondition, 5, "", null);
            this.mXCertDataList.addAll(XDetailDataParser.parse((String)aCertList, (int)3, (int)aMediaID));
        }
        this.setListAdapter((ListAdapter)new XDetailDataRowAdapter((Activity)this, this.mXCertDataList));
    }

    protected void onListItemClick(ListView l, View v, int position, long id2) {
        XDetailData aSelectedCert = null;
        Intent aIntent = null;
        super.onListItemClick(l, v, position, id2);
        aSelectedCert = this.mXCertDataList.get(position);
        if (EnvironmentConfig.mBasicKeyUsage) {
            aIntent = new Intent((Context)this, SignCertPasswordWindow.class);
        } else if (EnvironmentConfig.mMTransKeyUsage) {
            aIntent = new Intent((Context)this, SignCertPasswordWindowWithTransKey.class);
        } else if (EnvironmentConfig.mXecureKeypadFullViewUsage || EnvironmentConfig.mXecureKeypadNormalViewUsage) {
            aIntent = new Intent((Context)this, SignCertPasswordWindowWithXK.class);
        }
        aIntent.putExtra("sign_cert_password_media_id_key", this.mMediaID);
        aIntent.putExtra("call_mode_key", "call_mode_export_certificate_certshare");
        aIntent.putExtra("sign_cert_password_selected_cert_data_key", aSelectedCert.getValueArray());
        this.startActivityForResult(aIntent, 70510);
    }

    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        int aResultFromThat = -1;
        Intent aIntent = null;
        if (data != null) {
            aResultFromThat = data.getIntExtra("xecure_smart_result_key", -1);
            if (aResultFromThat == 24) {
                this.setResult(0);
                this.finish();
            } else {
                aIntent = new Intent();
                aIntent.putExtra("xecure_smart_result_key", aResultFromThat);
                this.setResult(-1, aIntent);
                this.finish();
            }
        }
    }
}

