/*
 * Decompiled with CFR 0.152.
 */
package com.softforum.xecure.ui.crypto;

import android.app.Activity;
import android.app.ListActivity;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.nfc.NfcAdapter;
import android.nfc.Tag;
import android.nfc.tech.IsoDep;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.os.Parcelable;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AdapterView;
import android.widget.LinearLayout;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.Spinner;
import android.widget.SpinnerAdapter;
import android.widget.Toast;
import com.consortium.smartusim.SmartUsim;
import com.consortium.smartusim.SmartUsimListener;
import com.consortium.smartusim.SmartUsimResultCode;
import com.softforum.sample.R;
import com.softforum.xecure.XecureSmart;
import com.softforum.xecure.crypto.CertMgr;
import com.softforum.xecure.crypto.ICCardMgr;
import com.softforum.xecure.keypad.SignCertPasswordWindowWithXK;
import com.softforum.xecure.keypad.UsimSignCertPasswordWindowWithXK;
import com.softforum.xecure.keypad.XecureSmartChangePasswordWithXK;
import com.softforum.xecure.ui.XTopView;
import com.softforum.xecure.ui.crypto.InputPinWindow;
import com.softforum.xecure.ui.crypto.PKCS11Password;
import com.softforum.xecure.ui.crypto.SignCertPasswordWindow;
import com.softforum.xecure.ui.crypto.XecureSmartChangePassword;
import com.softforum.xecure.ui.transkey.SignCertPasswordWindowWithTransKey;
import com.softforum.xecure.ui.transkey.UsimSignCertPasswordWindowWithTranskey;
import com.softforum.xecure.ui.transkey.XecureSmartChangePasswordWithTransKey;
import com.softforum.xecure.usim.SmartUsimParcelable;
import com.softforum.xecure.usim.UsimSignCertPasswordWindow;
import com.softforum.xecure.usim.UsimUtil;
import com.softforum.xecure.util.BlockerActivityResult;
import com.softforum.xecure.util.BlockerActivityUtil;
import com.softforum.xecure.util.EnvironmentConfig;
import com.softforum.xecure.util.ImageTextSpinnerAdapter;
import com.softforum.xecure.util.XDetailData;
import com.softforum.xecure.util.XDetailDataParser;
import com.softforum.xecure.util.XDetailDataRowAdapter;
import com.softforum.xecure.util.XDetailDataRowAdapterUSIM;
import com.softforum.xecure.util.XSLog;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.StringTokenizer;
import kr.or.kftc.mobiletoken_lib.device_control.TokenControl;
import kr.or.kftc.smartcard.SecurityToken;

public class SignCertSelectWindow
extends ListActivity {
    public static final int mSignCertSelectWindowID = 70500;
    public static final int mSignCertSelectWindowCallBackID = 70501;
    public static final String mPluginSessionIDKey = "plugin_session_id_key";
    public static final String mXaddrKey = "xaddr_key";
    public static final String mMediaIDKey = "media_id_key";
    public static final String mCertTypeKey = "cert_type_key";
    public static final String mMediaTypeKey = "media_type_key";
    public static final String mSearchValueKey = "search_value_key";
    public static final String mCertSerialKey = "search_serial_key";
    public static final String mCallModeKey = "call_mode_key";
    public static final String mCallModeSign = "call_mode_sign";
    public static final String mCallModeFilsSignInfo = "call_mode_file_sign_info";
    public static final String mCallModeEnvelop = "call_mode_envelop";
    public static final String mCallModeDecryption = "call_mode_decryption";
    public static final String mCallModeRenew = "call_mode_renew";
    public static final String mCallModeRevoke = "call_mode_revoke";
    public static final String mCallModeBlockEncCallBack = "call_mode_blockenc_callback";
    public static final String mPainTextKey = "sign_plain_text_data";
    public static final String mSignOption = "sign_option";
    private int MEDIA_SDCARD;
    private int MEDIA_APPDATA;
    private BlockerActivityResult mBlockerParam;
    private int mMediaID;
    private String mSearchValue;
    private String mSearchSerial;
    private String mPainText;
    private int mSignOptionValue;
    private byte[] mInputedPassword;
    private byte[] mInputedOldPassword;
    private String mSelectedSubjectRDN;
    private String mSelectedIssuerRDN;
    private String mSelectedCertSerial;
    private String mSignFileCertInfo;
    private byte[] mRandomValue = null;
    private String mEncryptedData = null;
    private String mNewEncryptedData = null;
    private String mCallMode;
    private SmartUsim mSmartUsim = null;
    private final int END_BIND = 101;
    private final int flag_JOIN = 102;
    private String mUsimSignCertResult;
    private int MEDIA_DREAMSECURITY_USIM;
    private int MEDIA_RAONSECURE_USIM;
    private final String serverAddress = "58.229.178.45";
    private final int serverPort = 25189;
    public Handler mHandler = new Handler();
    static final String TAG = SecurityToken.class.getSimpleName();
    private IsoDep isoDep;
    private NfcAdapter mNfcAdapter;
    private TokenControl mToken;
    private String mPinValue = "11111111";
    private int MEDIA_ICCARD;
    private int mSelectICCardIndex;
    private ICCardMgr mICCardMgr = null;
    public SmartUsimListener smartUsimListener = new SmartUsimListener(){

        public void onSmartUsimResult(int requestCode, SmartUsimResultCode resultCode) {
            switch (requestCode) {
                case 3: {
                    if (resultCode.getResultCode() == 0) {
                        if (!UsimUtil.mSamrtUsimBindSwitch) break;
                        SignCertSelectWindow.this.mSmartUsim.bindService("58.229.178.45", 25189);
                        UsimUtil.mSamrtUsimBindSwitch = false;
                        break;
                    }
                    SignCertSelectWindow.this.showToast("\uc2a4\ub9c8\ud2b8\uc778\uc99d\uc571\uc774 \uc124\uce58\ub418\uc9c0 \uc54a\uc558\uc2b5\ub2c8\ub2e4.\n\ud655\uc778 \ud6c4 \uc774\uc6a9\ud574 \uc8fc\uc2dc\uae30 \ubc14\ub78d\ub2c8\ub2e4.\n[" + resultCode.getResultCode() + "]");
                    break;
                }
                case 1: {
                    if (resultCode.getResultCode() == 0) {
                        SignCertSelectWindow.this.setInit();
                        break;
                    }
                    SignCertSelectWindow.this.showToast("\ubc14\uc778\ub4dc \uc2e4\ud328\uacf5\ud1b5 /Vendor \ucf54\ub4dc : " + resultCode.getResultCode() + "(" + resultCode.getResultCodeVendor() + ")");
                }
            }
        }
    };

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.crypto_sign_cert_select_window);
        this.mICCardMgr = new ICCardMgr();
        Intent receivedIntent = this.getIntent();
        this.mMediaID = receivedIntent.getIntExtra(mMediaIDKey, -1);
        this.mSearchValue = receivedIntent.getStringExtra(mSearchValueKey);
        this.mSearchSerial = receivedIntent.getStringExtra(mCertSerialKey);
        this.mPainText = receivedIntent.getStringExtra(mPainTextKey);
        this.mSignOptionValue = receivedIntent.getIntExtra(mSignOption, -1);
        this.mCallMode = receivedIntent.getStringExtra(mCallModeKey);
        if (EnvironmentConfig.mICCardUse) {
            this.mNfcAdapter = NfcAdapter.getDefaultAdapter((Context)this);
        }
        this.mBlockerParam = BlockerActivityUtil.getParam((Context)this, (Intent)receivedIntent);
        XTopView aTopView = (XTopView)this.findViewById(R.id.top_view);
        if (this.mCallMode.equals(mCallModeBlockEncCallBack)) {
            aTopView.setDescription(this.getString(R.string.sign_cert_select_window_logon_desc));
        } else if (this.mCallMode.equals(mCallModeSign) || this.mCallMode.equals(mCallModeFilsSignInfo)) {
            aTopView.setDescription(this.getString(R.string.sign_cert_select_window_sign_desc));
        } else if (this.mCallMode.equals(mCallModeEnvelop)) {
            aTopView.setDescription(this.getString(R.string.sign_cert_select_window_encrypt_desc));
        } else if (this.mCallMode.equals(mCallModeDecryption)) {
            aTopView.setDescription(this.getString(R.string.sign_cert_select_window_decrypt_desc));
        } else if (this.mCallMode.equals(mCallModeRenew)) {
            aTopView.setDescription(this.getString(R.string.sign_cert_select_window_renew_desc));
        } else if (this.mCallMode.equals(mCallModeRevoke)) {
            aTopView.setDescription(this.getString(R.string.sign_cert_select_window_revoke_desc));
        }
        if (!EnvironmentConfig.mSDCardAppDataUse && (this.mSignOptionValue & 4) != 0) {
            View aView = this.findViewById(R.id.select_media);
            aView.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(0, 0));
            aView.setVisibility(4);
            this.setUserCertItems(this.mMediaID);
        } else if (!EnvironmentConfig.mSDCardAppDataUse && this.mCallMode.equals(mCallModeEnvelop) || !EnvironmentConfig.mSDCardAppDataUse && this.mCallMode.equals(mCallModeFilsSignInfo)) {
            View aView = this.findViewById(R.id.select_media);
            aView.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(0, 0));
            aView.setVisibility(4);
            this.setUserCertItems(this.mMediaID);
        } else {
            this.setSpinner();
        }
    }

    protected void onListItemClick(ListView l, View v, int position, long id2) {
        int aMediaID = 0;
        String aCertList = null;
        String aMediaList = null;
        StringTokenizer aMediaListTokenizer = null;
        XDetailData aSelectedCert = null;
        ArrayList aXCertDataList = new ArrayList();
        CertMgr aCertMgr = null;
        int aSearchCondition = 0;
        Intent aIntent = null;
        super.onListItemClick(l, v, position, id2);
        aMediaID = this.mMediaID;
        if (this.mSearchValue.equals("")) {
            aSearchCondition = 0;
            if (EnvironmentConfig.mExcludeExpiredCert) {
                aSearchCondition = 25;
            }
        } else {
            aSearchCondition = 20;
        }
        if (aMediaID == 901 || aMediaID == 902) {
            int certCount = this.mSmartUsim.getCertCount();
            if (certCount > 0) {
                aCertList = UsimUtil.ConvertDreamCertToXS(certCount);
                aXCertDataList.addAll(XDetailDataParser.parse((String)aCertList, (int)4, (int)aMediaID));
            }
        } else if (aMediaID == 903) {
            if (!this.mCallMode.equals(mCallModeEnvelop)) {
                this.mToken.Connect();
                Bundle requestBundle = new Bundle();
                requestBundle.putString("REQUEST_ACTION", "GET_CERTIFICATE_LIST");
                int aCertificateCount = 0;
                Bundle responseBundle = new Bundle();
                this.mToken.Transmit(requestBundle, responseBundle);
                if (responseBundle.getString("RESULT_CODE").equals("0000")) {
                    aCertificateCount = responseBundle.getInt("CERT_COUNT");
                } else {
                    String errMsg = responseBundle.getString("ERROR_MESSAGE");
                    Toast.makeText((Context)this, (CharSequence)errMsg, (int)1).show();
                }
                if (aCertificateCount > 0) {
                    for (int index = 1; index <= aCertificateCount; ++index) {
                        requestBundle.putString("REQUEST_ACTION", "GET_CERTIFICATE");
                        requestBundle.putInt("CERTIFICATE_INDEX", index);
                        this.mToken.Transmit(requestBundle, responseBundle);
                        if (!responseBundle.getString("RESULT_CODE").equals("0000")) {
                            String errMsg = responseBundle.getString("ERROR_MESSAGE");
                            Toast.makeText((Context)this, (CharSequence)errMsg, (int)1).show();
                            break;
                        }
                        byte[] a = responseBundle.getByteArray("CERTIFICATE");
                        aCertList = aCertList + this.mICCardMgr.makeCertificateListFromByteArray(a, 5);
                    }
                }
                aXCertDataList.addAll(XDetailDataParser.parse((String)aCertList, (int)3, (int)this.mMediaID));
            }
        } else {
            aCertMgr = CertMgr.getInstance();
            aMediaList = aCertMgr.getMediaList(aMediaID - 1, 1, 0);
            aMediaListTokenizer = new StringTokenizer(aMediaList, "\t\n");
            while (aMediaListTokenizer.hasMoreTokens()) {
                aMediaID = Integer.parseInt(aMediaListTokenizer.nextToken());
                aCertList = aCertMgr.getCertTree(aMediaID, 2, aSearchCondition, 5, this.mSearchValue, this.mSearchSerial);
                aXCertDataList.addAll(XDetailDataParser.parse((String)aCertList, (int)3, (int)aMediaID));
            }
        }
        aSelectedCert = (XDetailData)aXCertDataList.get(position);
        this.mSelectICCardIndex = position + 1;
        if (this.mMediaID == 401) {
            this.startActivityForResult(new Intent((Context)this, PKCS11Password.class), 90000);
        } else if (aMediaID == 901 || aMediaID == 902) {
            if (!this.mCallMode.equals(mCallModeEnvelop)) {
                SmartUsimParcelable aSmartUsimParcelable = null;
                aSmartUsimParcelable = new SmartUsimParcelable(this.mSmartUsim);
                if (EnvironmentConfig.mBasicKeyUsage) {
                    aIntent = new Intent((Context)this, UsimSignCertPasswordWindow.class);
                    aIntent.putExtra("Position", position);
                    aIntent.putExtra("SmartUsim", (Parcelable)aSmartUsimParcelable);
                    aIntent.putExtra(mCallModeKey, mCallModeRenew);
                    aIntent.putExtra(mPainTextKey, this.mPainText);
                    aIntent.putExtra("parsed_xdetail_data_key", aSelectedCert.getValueArray());
                    this.startActivityForResult(aIntent, 160000);
                } else if (EnvironmentConfig.mMTransKeyUsage) {
                    aIntent = new Intent((Context)this, UsimSignCertPasswordWindowWithTranskey.class);
                    aIntent.putExtra("Position", position);
                    aIntent.putExtra("SmartUsim", (Parcelable)aSmartUsimParcelable);
                    aIntent.putExtra(mCallModeKey, mCallModeRenew);
                    aIntent.putExtra(mPainTextKey, this.mPainText);
                    aIntent.putExtra("parsed_xdetail_data_key", aSelectedCert.getValueArray());
                    this.startActivityForResult(aIntent, 160000);
                } else if (EnvironmentConfig.mXecureKeypadFullViewUsage || EnvironmentConfig.mXecureKeypadNormalViewUsage) {
                    aIntent = new Intent((Context)this, UsimSignCertPasswordWindowWithXK.class);
                    aIntent.putExtra("Position", position);
                    aIntent.putExtra("SmartUsim", (Parcelable)aSmartUsimParcelable);
                    aIntent.putExtra(mCallModeKey, mCallModeRenew);
                    aIntent.putExtra(mPainTextKey, this.mPainText);
                    aIntent.putExtra("parsed_xdetail_data_key", aSelectedCert.getValueArray());
                    this.startActivityForResult(aIntent, 160000);
                }
            }
        } else if (aMediaID == 903) {
            aIntent = new Intent((Context)this, InputPinWindow.class);
            aIntent.putExtra("sign_cert_password_selected_cert_data_key", aSelectedCert.getValueArray());
            aIntent.putExtra("sign_cert_index", this.mSelectICCardIndex);
            this.startActivityForResult(aIntent, 70600);
        } else {
            this.mInputedPassword = null;
            this.mSelectedSubjectRDN = aSelectedCert.getValue(2);
            if (this.mCallMode.equals(mCallModeFilsSignInfo)) {
                this.mSelectedIssuerRDN = aSelectedCert.getValue(5);
                this.mSelectedCertSerial = aSelectedCert.getValue(6);
                this.mSelectedSubjectRDN = aSelectedCert.getValue(2);
                aCertMgr = CertMgr.getInstance();
                aMediaList = aCertMgr.getMediaList(aMediaID - 1, 1, 0);
                this.mSignFileCertInfo = aCertList = aCertMgr.getCertTree(aMediaID, 2, 24, 0, this.mSelectedIssuerRDN, this.mSelectedCertSerial);
            }
            if (this.mCallMode.equals(mCallModeEnvelop)) {
                this.passValuesToParent();
                this.finish();
            } else if (this.mCallMode.equals(mCallModeRenew)) {
                if (EnvironmentConfig.mBasicKeyUsage) {
                    aIntent = new Intent((Context)this, XecureSmartChangePassword.class);
                } else if (EnvironmentConfig.mMTransKeyUsage) {
                    aIntent = new Intent((Context)this, XecureSmartChangePasswordWithTransKey.class);
                } else if (EnvironmentConfig.mXecureKeypadFullViewUsage || EnvironmentConfig.mXecureKeypadNormalViewUsage) {
                    aIntent = new Intent((Context)this, XecureSmartChangePasswordWithXK.class);
                }
                aIntent.putExtra("xecure_smart_changepw_media_id_key", this.mMediaID);
                aIntent.putExtra("xecure_smart_changepw_data_key", aSelectedCert.getValueArray());
                aIntent.putExtra(mCallModeKey, mCallModeRenew);
                this.startActivityForResult(aIntent, 78000);
            } else if (!this.mCallMode.equals(mCallModeEnvelop)) {
                if (EnvironmentConfig.mBasicKeyUsage) {
                    aIntent = new Intent((Context)this, SignCertPasswordWindow.class);
                } else if (EnvironmentConfig.mMTransKeyUsage) {
                    aIntent = new Intent((Context)this, SignCertPasswordWindowWithTransKey.class);
                } else if (EnvironmentConfig.mXecureKeypadFullViewUsage || EnvironmentConfig.mXecureKeypadNormalViewUsage) {
                    aIntent = new Intent((Context)this, SignCertPasswordWindowWithXK.class);
                }
                aIntent.putExtra(mCallModeKey, this.mCallMode);
                aIntent.putExtra("sign_cert_password_media_id_key", this.mMediaID);
                aIntent.putExtra("sign_cert_password_selected_cert_data_key", aSelectedCert.getValueArray());
                this.startActivityForResult(aIntent, 70510);
            }
        }
    }

    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        switch (requestCode) {
            case 101: {
                this.endUnBind();
                break;
            }
            case 102: {
                if (resultCode != -1) break;
                this.setInit();
            }
        }
        if (requestCode == 90000 && resultCode == 100) {
            ((Spinner)this.findViewById(R.id.select_media)).setSelection(this.MEDIA_SDCARD, true);
        }
        if (requestCode == 70510 && resultCode == -1) {
            if (EnvironmentConfig.mMTransKeyEncryptionUsage || EnvironmentConfig.mXecureKeypadEncryptionUsage) {
                this.mRandomValue = data.getByteArrayExtra("sign_cert_password_random_value_key");
                this.mEncryptedData = data.getStringExtra("sign_cert_password_e_ncrypted_data_key");
            } else {
                this.mInputedPassword = data.getByteArrayExtra("sign_cert_password_password_key");
            }
        }
        if (requestCode == 70600 && resultCode == -1) {
            this.mInputedPassword = data.getByteArrayExtra("sign_cert_password_password_key");
            this.passValuesToParentWithICCard();
            this.finish();
        }
        if (requestCode == 160000 && resultCode == -1) {
            this.mUsimSignCertResult = data.getStringExtra("sign_usim_cert_result");
        }
        if (requestCode == 78000 && resultCode == -1) {
            if (EnvironmentConfig.mMTransKeyEncryptionUsage || EnvironmentConfig.mXecureKeypadEncryptionUsage) {
                this.mRandomValue = data.getByteArrayExtra("sign_cert_password_random_value_key");
                this.mEncryptedData = data.getStringExtra("sign_cert_password_e_ncrypted_data_key");
                this.mNewEncryptedData = data.getStringExtra("sign_cert_password_new_e_ncrypted_data_key");
            } else {
                this.mInputedOldPassword = data.getByteArrayExtra("old_cert_password_password_key");
                this.mInputedPassword = data.getByteArrayExtra("sign_cert_password_password_key");
            }
        }
        if (-1 == resultCode) {
            this.passValuesToParent();
            this.finish();
        } else if (2 == resultCode) {
            this.mBlockerParam.setBlockerResult(2);
            this.finish();
        } else if (3 == resultCode) {
            this.mBlockerParam.setBlockerResult(3);
            this.finish();
        }
    }

    private void passValuesToParentWithICCard() {
        Intent aIntent = new Intent();
        aIntent.putExtra(mMediaIDKey, this.mMediaID);
        aIntent.putExtra("password_key", this.mInputedPassword);
        XecureSmart.setmToken(this.isoDep, this.mSelectICCardIndex);
        this.mToken.Disconnect();
        this.mBlockerParam.setBlockerResult(-1, aIntent);
    }

    private void passValuesToParent() {
        Intent aIntent = new Intent();
        aIntent.putExtra(mMediaIDKey, this.mMediaID);
        aIntent.putExtra("subject_rdn_key", this.mSelectedSubjectRDN);
        if (this.mCallMode.equals(mCallModeFilsSignInfo)) {
            aIntent.putExtra("issuer_rdn_key", this.mSelectedIssuerRDN);
            aIntent.putExtra("cert_serial_key", this.mSelectedCertSerial);
            aIntent.putExtra("subject_rdn_key", this.mSelectedSubjectRDN);
            aIntent.putExtra("sign_file_cert_info", this.mSignFileCertInfo);
        }
        if (EnvironmentConfig.mMTransKeyEncryptionUsage || EnvironmentConfig.mXecureKeypadEncryptionUsage) {
            aIntent.putExtra("random_value_key", this.mRandomValue);
            aIntent.putExtra("e_ncrypted_data_key", this.mEncryptedData);
            if (this.mCallMode.equals(mCallModeRenew)) {
                aIntent.putExtra("new_e_ncrypted_data_key", this.mNewEncryptedData);
            }
        } else {
            aIntent.putExtra("password_key", this.mInputedPassword);
            if (this.mCallMode.equals(mCallModeRenew)) {
                aIntent.putExtra("old_password_key", this.mInputedOldPassword);
            }
        }
        if (this.mMediaID == 901 || this.mMediaID == 902) {
            aIntent.putExtra("usim_sign_cert_result", this.mUsimSignCertResult);
        }
        this.mBlockerParam.setBlockerResult(-1, aIntent);
    }

    private void setSpinner() {
        if (EnvironmentConfig.mSDCardOnlyUse || EnvironmentConfig.mAppDataOnlyUse) {
            if (!EnvironmentConfig.mUsimUse) {
                View aView = this.findViewById(R.id.select_media);
                aView.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(0, 0));
                aView.setVisibility(4);
                this.setUserCertItems(this.mMediaID);
            } else if (!(!EnvironmentConfig.mUsimUse || this.mSearchSerial != null && this.mSearchSerial.length() >= 1 || (this.mSignOptionValue & 4) != 0 || (this.mSignOptionValue & 0x800000) != 0 || this.mCallMode.equals(mCallModeEnvelop) || this.mCallMode.equals(mCallModeFilsSignInfo))) {
                if (EnvironmentConfig.mSDCardOnlyUse) {
                    this.MEDIA_SDCARD = 0;
                    this.MEDIA_DREAMSECURITY_USIM = 1;
                    this.MEDIA_RAONSECURE_USIM = 2;
                    Spinner aSelectStorage = (Spinner)this.findViewById(R.id.select_media);
                    ArrayList<HashMap<String, Object>> aItemList = new ArrayList<HashMap<String, Object>>();
                    HashMap<String, Object> aItem = new HashMap<String, Object>();
                    aItem.put("image", R.drawable.sdcard);
                    aItem.put("text", "SDCard");
                    aItemList.add(aItem);
                    aItem = new HashMap();
                    aItem.put("image", R.drawable.usim_dream);
                    aItem.put("text", "\uc720\uc2ec(\ub4dc\ub9bc)");
                    aItemList.add(aItem);
                    ImageTextSpinnerAdapter aAdapter = new ImageTextSpinnerAdapter((Context)this, aItemList);
                    aSelectStorage.setAdapter((SpinnerAdapter)aAdapter);
                    final SignCertSelectWindow aContext = this;
                    aSelectStorage.setOnItemSelectedListener(new AdapterView.OnItemSelectedListener(){

                        public void onItemSelected(AdapterView<?> parent, View view, int position, long id2) {
                            if (position == SignCertSelectWindow.this.MEDIA_SDCARD) {
                                SignCertSelectWindow.this.mMediaID = 101;
                            } else if (position == SignCertSelectWindow.this.MEDIA_DREAMSECURITY_USIM) {
                                SignCertSelectWindow.this.mMediaID = 901;
                            } else if (position == SignCertSelectWindow.this.MEDIA_RAONSECURE_USIM) {
                                SignCertSelectWindow.this.mMediaID = 902;
                            }
                            aContext.setUserCertItems(SignCertSelectWindow.this.mMediaID);
                        }

                        public void onNothingSelected(AdapterView<?> arg0) {
                        }
                    });
                } else if (EnvironmentConfig.mAppDataOnlyUse) {
                    this.MEDIA_APPDATA = 0;
                    this.MEDIA_DREAMSECURITY_USIM = 1;
                    this.MEDIA_RAONSECURE_USIM = 2;
                    Spinner aSelectStorage = (Spinner)this.findViewById(R.id.select_media);
                    ArrayList<HashMap<String, Object>> aItemList = new ArrayList<HashMap<String, Object>>();
                    HashMap<String, Object> aItem = new HashMap<String, Object>();
                    aItem.put("image", R.drawable.icon);
                    aItem.put("text", "\uc571\ub370\uc774\ud130");
                    aItemList.add(aItem);
                    aItem = new HashMap();
                    aItem.put("image", R.drawable.usim_dream);
                    aItem.put("text", "\uc720\uc2ec(\ub4dc\ub9bc)");
                    aItemList.add(aItem);
                    ImageTextSpinnerAdapter aAdapter = new ImageTextSpinnerAdapter((Context)this, aItemList);
                    aSelectStorage.setAdapter((SpinnerAdapter)aAdapter);
                    final SignCertSelectWindow aContext = this;
                    aSelectStorage.setOnItemSelectedListener(new AdapterView.OnItemSelectedListener(){

                        public void onItemSelected(AdapterView<?> parent, View view, int position, long id2) {
                            if (position == SignCertSelectWindow.this.MEDIA_APPDATA) {
                                SignCertSelectWindow.this.mMediaID = 1401;
                            } else if (position == SignCertSelectWindow.this.MEDIA_DREAMSECURITY_USIM) {
                                SignCertSelectWindow.this.mMediaID = 901;
                            } else if (position == SignCertSelectWindow.this.MEDIA_RAONSECURE_USIM) {
                                SignCertSelectWindow.this.mMediaID = 902;
                            }
                            aContext.setUserCertItems(SignCertSelectWindow.this.mMediaID);
                        }

                        public void onNothingSelected(AdapterView<?> arg0) {
                        }
                    });
                }
            } else if (this.mSearchSerial.length() > 1) {
                View aView = this.findViewById(R.id.select_media);
                aView.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(0, 0));
                aView.setVisibility(4);
                this.setUserCertItems(this.mMediaID);
            } else if ((this.mSignOptionValue & 0x800000) != 0) {
                View aView = this.findViewById(R.id.select_media);
                aView.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(0, 0));
                aView.setVisibility(4);
                this.setUserCertItems(this.mMediaID);
            }
        } else {
            this.MEDIA_SDCARD = 0;
            this.MEDIA_APPDATA = 1;
            if (EnvironmentConfig.mICCardUse && !EnvironmentConfig.mUsimUse) {
                this.MEDIA_ICCARD = 2;
            } else if (!EnvironmentConfig.mICCardUse && EnvironmentConfig.mUsimUse) {
                this.MEDIA_DREAMSECURITY_USIM = 2;
                this.MEDIA_RAONSECURE_USIM = 3;
            } else if (EnvironmentConfig.mICCardUse && EnvironmentConfig.mUsimUse) {
                this.MEDIA_DREAMSECURITY_USIM = 2;
                this.MEDIA_RAONSECURE_USIM = 3;
                this.MEDIA_ICCARD = 4;
            }
            Spinner aSelectStorage = (Spinner)this.findViewById(R.id.select_media);
            ArrayList<HashMap<String, Object>> aItemList = new ArrayList<HashMap<String, Object>>();
            HashMap<String, Object> aItem = new HashMap<String, Object>();
            aItem.put("image", R.drawable.sdcard);
            aItem.put("text", "SDCard");
            aItemList.add(aItem);
            aItem = new HashMap();
            aItem.put("image", R.drawable.icon);
            aItem.put("text", "\uc571\ub370\uc774\ud130");
            aItemList.add(aItem);
            if (!(this.mSearchSerial != null && this.mSearchSerial.length() >= 1 || (this.mSignOptionValue & 4) != 0 || (this.mSignOptionValue & 0x800000) != 0 || this.mCallMode.equals(mCallModeEnvelop) || !EnvironmentConfig.mUsimUse || this.mCallMode.equals(mCallModeFilsSignInfo))) {
                aItem = new HashMap();
                aItem.put("image", R.drawable.usim_dream);
                aItem.put("text", "\uc720\uc2ec(\ub4dc\ub9bc)");
                aItemList.add(aItem);
            }
            if (EnvironmentConfig.mICCardUse) {
                aItem = new HashMap();
                aItem.put("image", R.drawable.usim_dream);
                aItem.put("text", "ICCARD");
                aItemList.add(aItem);
            }
            ImageTextSpinnerAdapter aAdapter = new ImageTextSpinnerAdapter((Context)this, aItemList);
            aSelectStorage.setAdapter((SpinnerAdapter)aAdapter);
            final SignCertSelectWindow aContext = this;
            aSelectStorage.setOnItemSelectedListener(new AdapterView.OnItemSelectedListener(){

                public void onItemSelected(AdapterView<?> parent, View view, int position, long id2) {
                    if (position == SignCertSelectWindow.this.MEDIA_SDCARD) {
                        SignCertSelectWindow.this.mMediaID = 101;
                    } else if (position == SignCertSelectWindow.this.MEDIA_APPDATA) {
                        SignCertSelectWindow.this.mMediaID = 1401;
                    } else if (position == SignCertSelectWindow.this.MEDIA_DREAMSECURITY_USIM) {
                        SignCertSelectWindow.this.mMediaID = 901;
                    } else if (position == SignCertSelectWindow.this.MEDIA_RAONSECURE_USIM) {
                        SignCertSelectWindow.this.mMediaID = 902;
                    } else if (position == SignCertSelectWindow.this.MEDIA_ICCARD) {
                        SignCertSelectWindow.this.mMediaID = 903;
                    }
                    aContext.setUserCertItems(SignCertSelectWindow.this.mMediaID);
                }

                public void onNothingSelected(AdapterView<?> arg0) {
                }
            });
        }
    }

    private void setUserCertItems(int pMediaID) {
        int aMediaID = 0;
        String aCertList = null;
        String aMediaList = null;
        ArrayList<XDetailData> aXCertDataList = new ArrayList<XDetailData>();
        StringTokenizer aMediaListTokenizer = null;
        int aSearchCondition = 0;
        boolean isMember = false;
        aMediaID = pMediaID;
        if (aMediaID == 901 || aMediaID == 902) {
            SmartUsimResultCode userResult;
            block23: {
                if (!UsimUtil.mSamrtUsimBindSwitch) {
                    this.endUnBind();
                }
                if (aMediaID == 901) {
                    this.mSmartUsim = SmartUsim.getInstance((Context)this, (SmartUsimListener)this.smartUsimListener, (String)"www.softforum.com", (String)"cpCode", (int)2);
                } else if (aMediaID == 902) {
                    this.mSmartUsim = SmartUsim.getInstance((Context)this, (SmartUsimListener)this.smartUsimListener, (String)"www.softforum.com", (String)"cpCode", (int)1);
                }
                try {
                    isMember = this.mSmartUsim.isMember();
                }
                catch (NoClassDefFoundError e) {
                    userResult = this.mSmartUsim.getLastError();
                    if (userResult.getResultCode() == 2001) break block23;
                    this.showToast("\uc11c\ube44\uc2a4 \ubd88\uac00\ub2a5 \uc0ac\uc6a9\uc790" + userResult.getResultCode() + "/" + userResult.getResultCodeVendor());
                    this.emptyCertList(aMediaID);
                    return;
                }
            }
            if (!isMember && (userResult = this.mSmartUsim.getLastError()).getResultCode() != 2001) {
                this.showToast("\uc11c\ube44\uc2a4 \ubd88\uac00\ub2a5 \uc0ac\uc6a9\uc790" + userResult.getResultCode() + "/" + userResult.getResultCodeVendor());
                this.emptyCertList(aMediaID);
                return;
            }
            boolean isInstall = this.mSmartUsim.isInstalled();
            if (!isInstall) {
                this.mSmartUsim.install();
                this.emptyCertList(aMediaID);
                return;
            }
            if (UsimUtil.mSamrtUsimBindSwitch) {
                this.mSmartUsim.bindService("58.229.178.45", 25189);
                UsimUtil.mSamrtUsimBindSwitch = false;
            }
        } else if (aMediaID == 903) {
            if (this.mNfcAdapter.isEnabled()) {
                if (this.mNfcAdapter != null && this.mNfcAdapter.isEnabled()) {
                    String[][] techList = new String[][]{{IsoDep.class.getName()}};
                    PendingIntent pendingIntent = PendingIntent.getActivity((Context)this, (int)0, (Intent)new Intent((Context)this, ((Object)((Object)this)).getClass()).addFlags(0x20000000), (int)0);
                    this.mNfcAdapter.enableForegroundDispatch((Activity)this, pendingIntent, null, techList);
                    Toast.makeText((Context)this, (CharSequence)"\uc2a4\ub9c8\ud2b8\ud3f0\uc5d0 \ubcf4\uc548\ud1a0\ud070\uc744 \ud130\uce58\ud558\uc138\uc694.", (int)1).show();
                }
            } else if (Build.VERSION.SDK_INT > 16) {
                this.startActivity(new Intent("android.settings.NFC_SETTINGS"));
            } else {
                this.startActivity(new Intent("android.settings.WIRELESS_SETTINGS"));
            }
        } else {
            if (!UsimUtil.mSamrtUsimBindSwitch) {
                this.endUnBind();
            }
            CertMgr aCertMgr = CertMgr.getInstance();
            if (this.mSearchValue.equals("")) {
                aSearchCondition = 0;
                if (EnvironmentConfig.mExcludeExpiredCert) {
                    aSearchCondition = 25;
                }
            } else {
                aSearchCondition = 20;
            }
            aMediaList = aCertMgr.getMediaList(aMediaID - 1, 1, 1);
            aMediaListTokenizer = new StringTokenizer(aMediaList, "\t\n");
            while (aMediaListTokenizer.hasMoreTokens()) {
                aMediaID = Integer.parseInt(aMediaListTokenizer.nextToken());
                aCertList = aCertMgr.getCertTree(aMediaID, 2, aSearchCondition, 5, this.mSearchValue, this.mSearchSerial);
                aXCertDataList.addAll(XDetailDataParser.parse((String)aCertList, (int)3, (int)aMediaID));
            }
            this.setListAdapter((ListAdapter)new XDetailDataRowAdapter((Activity)this, aXCertDataList));
        }
    }

    private void setInit() {
        boolean isPossible = false;
        isPossible = this.mSmartUsim.isPossibleService();
        SmartUsimResultCode countResult = this.mSmartUsim.getLastError();
        String aCertList = null;
        ArrayList<XDetailData> aXCertDataList = new ArrayList<XDetailData>();
        int aMediaID = this.mMediaID;
        if (isPossible) {
            int certCount = this.mSmartUsim.getCertCount();
            if (certCount < 0) {
                countResult = this.mSmartUsim.getLastError();
                this.showToast("\uc778\uc99d\uc11c \uac2f\uc218\uc5d0 \uc624\ub958\uac00 \ubc1c\uc0dd\ud558\uc600\uc2b5\ub2c8\ub2e4.(" + countResult.getResultCode() + "/" + countResult.getResultCodeVendor() + ")");
                this.emptyCertList(aMediaID);
                return;
            }
            if (certCount == 0) {
                this.emptyCertList(aMediaID);
            } else {
                UsimUtil.setUsim(this.mSmartUsim);
                aCertList = UsimUtil.ConvertDreamCertToXS(certCount);
                aXCertDataList.addAll(XDetailDataParser.parse((String)aCertList, (int)4, (int)aMediaID));
                this.setListAdapter((ListAdapter)new XDetailDataRowAdapterUSIM((Activity)this, aXCertDataList));
            }
        } else {
            SmartUsimResultCode suResult = this.mSmartUsim.getLastError();
            if (suResult.getResultCodeVendor() == 3001) {
                this.mSmartUsim.joinService(102);
            } else if (suResult.getResultCode() == 3002) {
                this.emptyCertList(aMediaID);
                this.endUnBind();
                this.showToast("\uc2a4\ub9c8\ud2b8\uacf5\uc778\uc778\uc99d \uc571 \uc5c5\ub370\uc774\ud2b8\uac00 \ud544\uc694\ud569\ub2c8\ub2e4.(" + suResult.getResultCodeVendor() + ")");
                this.mSmartUsim.install();
            } else if (suResult.getResultCode() == 3001) {
                this.showToast("\ud5c8\uac00\ub418\uc9c0 \uc54a\uc740 \uc571\uc774 \uc811\uadfc\ud558\uc600\uc2b5\ub2c8\ub2e4." + suResult.getResultCode() + "(" + suResult.getResultCodeVendor() + ")");
                this.emptyCertList(aMediaID);
                this.endUnBind();
            } else {
                this.showToast(suResult.getResultCode() + "(" + suResult.getResultCodeVendor() + ")");
                this.emptyCertList(aMediaID);
                this.endUnBind();
            }
        }
    }

    private void emptyCertList(int pMediaID) {
        String aCertList = "";
        ArrayList<XDetailData> aXCertDataList = new ArrayList<XDetailData>();
        aXCertDataList.addAll(XDetailDataParser.parse((String)aCertList, (int)3, (int)pMediaID));
        this.setListAdapter((ListAdapter)new XDetailDataRowAdapter((Activity)this, aXCertDataList));
    }

    private void endUnBind() {
        try {
            UsimUtil.mSamrtUsimBindSwitch = true;
            this.mSmartUsim.unbindService();
            this.mSmartUsim = null;
        }
        catch (Exception e) {
            XSLog.e((String)e.getMessage());
        }
    }

    public void showToast(final String message) {
        this.mHandler.post(new Runnable(){

            @Override
            public void run() {
                Toast.makeText((Context)SignCertSelectWindow.this, (CharSequence)message, (int)1).show();
            }
        });
    }

    public void getICCardCertificateList() {
        Bundle requestBundle = new Bundle();
        requestBundle.putString("REQUEST_ACTION", "GET_CERTIFICATE_LIST");
        int aCertificateCount = 0;
        String aCertList = "";
        ArrayList<XDetailData> aXCertDataList = new ArrayList<XDetailData>();
        Bundle responseBundle = new Bundle();
        this.mToken.Transmit(requestBundle, responseBundle);
        if (responseBundle.getString("RESULT_CODE").equals("0000")) {
            aCertificateCount = responseBundle.getInt("CERT_COUNT");
        } else {
            String errMsg = responseBundle.getString("ERROR_MESSAGE");
            Toast.makeText((Context)this, (CharSequence)errMsg, (int)1).show();
        }
        if (aCertificateCount > 0) {
            for (int index = 1; index <= aCertificateCount; ++index) {
                requestBundle.putString("REQUEST_ACTION", "GET_CERTIFICATE");
                requestBundle.putInt("CERTIFICATE_INDEX", index);
                this.mToken.Transmit(requestBundle, responseBundle);
                if (!responseBundle.getString("RESULT_CODE").equals("0000")) {
                    String errMsg = responseBundle.getString("ERROR_MESSAGE");
                    Toast.makeText((Context)this, (CharSequence)errMsg, (int)1).show();
                    break;
                }
                byte[] a = responseBundle.getByteArray("CERTIFICATE");
                aCertList = aCertList + this.mICCardMgr.makeCertificateListFromByteArray(a, 5);
            }
        }
        aXCertDataList.addAll(XDetailDataParser.parse((String)aCertList, (int)3, (int)this.mMediaID));
        this.setListAdapter((ListAdapter)new XDetailDataRowAdapter((Activity)this, aXCertDataList));
    }

    public void onBackPressed() {
        if (!UsimUtil.mSamrtUsimBindSwitch) {
            this.endUnBind();
        }
        if (EnvironmentConfig.mICCardUse && this.mToken != null) {
            this.mToken.Disconnect();
        }
        this.finish();
    }

    public void finish() {
        BlockerActivityUtil.finishBlockerActivity((Object)this.mBlockerParam);
        super.finish();
    }

    protected void onNewIntent(Intent intent) {
        super.onNewIntent(intent);
        try {
            this.emptyCertList(this.mMediaID);
            Tag mTag = (Tag)intent.getParcelableExtra("android.nfc.extra.TAG");
            if (mTag != null) {
                this.isoDep = IsoDep.get((Tag)mTag);
                this.mToken = new TokenControl(this.isoDep);
                if (this.mToken == null) {
                    return;
                }
                if (this.mToken.Connect()) {
                    this.mToken.SetDebug(true);
                    Toast.makeText((Context)this, (CharSequence)"NFC \ubcf4\uc548\ud1a0\ud070 \uc5f0\uacb0 \uc131\uacf5", (int)0).show();
                    if (this.mMediaID == 903) {
                        this.getICCardCertificateList();
                    }
                    this.mToken.Disconnect();
                } else {
                    Toast.makeText((Context)this, (CharSequence)"NFC \ubcf4\uc548\ud1a0\ud070 \uc5f0\uacb0 \uc2e4\ud328", (int)1).show();
                }
            }
        }
        catch (Exception e) {
            XSLog.i((String)"[Fail to connect ICCard.]");
        }
    }

    protected void onPause() {
        super.onPause();
        if (EnvironmentConfig.mICCardUse && this.mToken != null && this.mNfcAdapter != null && this.mNfcAdapter.isEnabled()) {
            this.mNfcAdapter.disableForegroundDispatch((Activity)this);
        }
    }
}

