/*
 * Decompiled with CFR 0.152.
 */
package com.softforum.xecure.usim;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.Intent;
import android.os.Bundle;
import android.view.View;
import android.widget.Button;
import android.widget.EditText;
import android.widget.ImageView;
import android.widget.TextView;
import com.consortium.smartusim.SmartUsim;
import com.consortium.smartusim.SmartUsimResultCode;
import com.softforum.sample.R;
import com.softforum.xecure.ui.XTopView;
import com.softforum.xecure.usim.SmartUsimParcelable;
import com.softforum.xecure.util.XDetailData;
import com.softforum.xecure.util.XUtil;

public class UsimSignCertPasswordWindow
extends Activity {
    public static final int mSignCertPasswordWindowUsimID = 160000;
    private SmartUsim mSmartUsim = null;
    private int mCertPosition = -1;
    private byte[] mSmartPassword = null;
    XTopView mTopView = null;
    private int m_P_assW_ordTryCount = 0;
    public static final int RESULT_PASSWD_FAIL = 3;
    private String mPlainText;
    public static final String mParsedXDetailDataKey = "parsed_xdetail_data_key";
    private XDetailData mSelectedData;
    private int mDetailDataCertSubjectKey = 2;
    private int mDetailDataCertIssuerKey = 6;
    private int mDetailDataCertToKey = 5;
    private byte[] mUsimCertSignResult;
    private String mUsimCertSignResultString;
    public static final String mUsimCertSignResultKey = "sign_usim_cert_result";

    protected void onCreate(Bundle pSavedInstanceState) {
        super.onCreate(pSavedInstanceState);
        this.setContentView(R.layout.usim_sign_cert_password_window);
        Intent aIntent = null;
        SmartUsimParcelable aSmartUsimParcelable = null;
        aIntent = this.getIntent();
        aSmartUsimParcelable = (SmartUsimParcelable)aIntent.getParcelableExtra("SmartUsim");
        this.mSmartUsim = aSmartUsimParcelable.getSmartUsim();
        this.mCertPosition = aIntent.getIntExtra("Position", 0);
        this.mPlainText = aIntent.getStringExtra("sign_plain_text_data");
        String[] aStringArrayExtra = this.getIntent().getStringArrayExtra(mParsedXDetailDataKey);
        this.mSelectedData = new XDetailData(aStringArrayExtra, 4);
        ImageView aIcon = (ImageView)this.findViewById(R.id.icon);
        TextView aMainMsg = (TextView)this.findViewById(R.id.main_msg);
        TextView aSubMsg1 = (TextView)this.findViewById(R.id.sub_msg1);
        TextView aSubMsg2 = (TextView)this.findViewById(R.id.sub_msg2);
        if ("0".equals(this.mSelectedData.getValue(0))) {
            aIcon.setImageResource(R.drawable.cert_state_normal);
        } else if ("1".equals(this.mSelectedData.getValue(0))) {
            aIcon.setImageResource(R.drawable.cert_state_update);
        } else if ("2".equals(this.mSelectedData.getValue(0))) {
            aIcon.setImageResource(R.drawable.cert_state_revoke);
        }
        aMainMsg.setText((CharSequence)this.mSelectedData.getValue(this.mDetailDataCertSubjectKey));
        aSubMsg1.setText((CharSequence)(this.mSelectedData.getKeyText(this.mDetailDataCertIssuerKey) + " : " + this.mSelectedData.getValue(this.mDetailDataCertIssuerKey)));
        aSubMsg2.setText((CharSequence)(this.mSelectedData.getKeyText(this.mDetailDataCertToKey) + " : " + this.mSelectedData.getValue(this.mDetailDataCertToKey)));
        Button aOKButton = (Button)this.findViewById(R.id.top_right_button);
        aOKButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                UsimSignCertPasswordWindow.this.onOKButtonClick(v);
            }
        });
    }

    @SuppressLint(value={"NewApi"})
    private void onOKButtonClick(View v) {
        this.mTopView = (XTopView)this.findViewById(R.id.top_view);
        EditText aSmartPasswordEditText = (EditText)this.findViewById(R.id.smart_password_edittext);
        this.mSmartPassword = aSmartPasswordEditText.getText().toString().getBytes();
        if (this.mSmartPassword.length == 0) {
            this.mTopView.setDescription(this.getString(R.string.plugin_input_nothing));
            return;
        }
        this.mUsimCertSignResult = this.mSmartUsim.sign(this.mCertPosition, this.mSmartPassword, 2, this.mPlainText.getBytes(), null);
        if (this.mUsimCertSignResult != null) {
            this.mUsimCertSignResultString = XUtil.asHex((byte[])this.mUsimCertSignResult);
        }
        if (this.mUsimCertSignResult == null || this.mUsimCertSignResult.length < 1) {
            SmartUsimResultCode failResult = this.mSmartUsim.getLastError();
            if (failResult.getResultCode() == 5001) {
                this.mTopView.setDescription(this.getString(R.string.message_password_pin_incorrect));
                if (++this.m_P_assW_ordTryCount >= 3) {
                    this.setResult(3);
                    this.endUnBind();
                    this.finish();
                }
                return;
            }
            this.mTopView.setDescription(this.getString(R.string.message_password_pin_incorrect));
            if (++this.m_P_assW_ordTryCount >= 3) {
                this.setResult(3);
                this.endUnBind();
                this.finish();
            }
            return;
        }
        Intent aIntent = new Intent();
        aIntent.putExtra(mUsimCertSignResultKey, this.mUsimCertSignResultString);
        this.setResult(-1, aIntent);
        this.endUnBind();
        this.finish();
    }

    private void endUnBind() {
        this.mSmartUsim.unbindService();
    }
}

