/*
 * Decompiled with CFR 0.152.
 */
package com.softforum.xecure.yessign;

import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.content.pm.Signature;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.AsyncTask;
import android.os.Build;
import android.os.Bundle;
import com.softforum.sample.R;
import com.softforum.xecure.util.XSLog;
import com.softforum.xecure.yessign.Base64;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.SignatureException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.X509EncodedKeySpec;
import java.util.ArrayList;
import java.util.List;
import java.util.Scanner;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;

public class YessignApplicationUtil {
    private static final String SERVER_APPLICATION_LIST_REAL = "https://www.yessign.or.kr";
    private static final String FILE_APPLICATION_LIST = "yessign-cert-client.txt";
    private static final String FILE_APPLICATION_LIST_SIG = "yessign-cert-client-sig.txt";
    private static final String PUBKEY_APPLICATION_LIST_REAL = "MIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAprDM6HH5rtaSWC1ZIQft6pRX8e8nj8fIa+LZJ3RYM1Zf9BCNLbpjYZzTKsWsIUis/4X04cHI8b2D7LzKWZP5S7muPH/APyZB4gk05rW3J+3gPccegKwr0IWrBJiBvsrBBgAoyjFEZcBrgdmZAdjwM8RVPzo7+lXzCdprJ0ql91ksnI/SHmp96ilEf3jgxXsqqaZcrQWfHOw2qObmTtA/oVt2vQF112Hq4tvVJztJxfPqGBJ/iNE8Lq08A0V9zUBWU1kc+xQL1ihTBq3AmdwVh+kIyxOBUwYGdt4lGkh0zjus8btlwg1uGVyRjXuwfDgoRy2Qovyq3Aw4LdFFcnfaHwIDAQAB";
    private static final String PUBKEY_APPLICATION_LIST_TEST = "MIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEA8xNGlJtVEONrpCv1bgDm2t5q00FLrcreiKkhtzJH0y9la9WCY+SesvAeivdoKJ4nVmkUb82p9BheMKKjVtRRQf8TzSSN83IPkS0hGsSvXNnElUwAdBJq4NaKHPr+Esp1NegrfuJeDDMjFTHvHhbxYO0svMHsSMjVNfM2/W+vpQiB07QfJDotPAtTUxncv/nCqsWwXH2MV4/wG/1rHYpapvUAnGcM9PvKuicXRECKSZkSbPTf40J0jufTSWN52n2KYHM/ziXfd0hDL3kzy6r3cfu11FY1aIuJQwvtmiftffXfKZEshdgoB1Ph4Ut8EDs2H1tIahtIt69EcpEiZXj03QIDAQAB";
    private static final String ELEMENT_APPLICATION_LIST = "GW-APP";
    private static final int CONNECT_TIMEOUT = 5000;
    private static final int READ_TIMEOUT = 5000;
    private static final String FILE_PREFIX_REAL = "real-";
    private static final String FILE_PREFIX_TEST = "test-";

    public static void queryTrustedApplicationList(Context context, boolean testConfiguration, OnCompleteListener<byte[]> listener) {
        URL signatureUrl;
        URL listUrl;
        try {
            listUrl = new URL("https://www.yessign.or.kr/yessign-cert-client.txt");
            signatureUrl = new URL("https://www.yessign.or.kr/yessign-cert-client-sig.txt");
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
        final Context fContext = context;
        final boolean fTestConfiguration = testConfiguration;
        final OnCompleteListener<byte[]> fListener = listener;
        new AsyncTask<URL, Void, List<byte[]>>(){
            private Exception exception;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected List<byte[]> doInBackground(URL ... urls) {
                if (!YessignApplicationUtil.checkNetworkStatus(fContext)) {
                    this.exception = new IOException(fContext.getString(R.string.message_fail_internet_connection));
                    return null;
                }
                ArrayList<byte[]> result = new ArrayList<byte[]>();
                HttpURLConnection[] connections = new HttpURLConnection[urls.length];
                try {
                    for (int i = 0; i < urls.length; ++i) {
                        connections[i] = (HttpURLConnection)urls[i].openConnection();
                        connections[i].setConnectTimeout(5000);
                        connections[i].setReadTimeout(5000);
                        connections[i].setUseCaches(false);
                        if (connections[i].getResponseCode() != 200) {
                            throw new IOException(fContext.getString(R.string.message_response_code) + connections[i].getResponseCode());
                        }
                        result.add(this.queryFile(connections[i]));
                    }
                }
                catch (IOException e) {
                    this.exception = new IOException(fContext.getString(R.string.message_fail_fetch_trusted_app_list) + e.getMessage());
                    List<byte[]> list = null;
                    return list;
                }
                finally {
                    for (int i = 0; i < urls.length; ++i) {
                        if (connections[i] == null) continue;
                        connections[i].disconnect();
                    }
                }
                return result;
            }

            protected void onPostExecute(List<byte[]> result) {
                byte[] list = null;
                Exception exception = this.exception;
                if (result != null) {
                    if (YessignApplicationUtil.isValidTrustApplicationList(result.get(0), result.get(1), fTestConfiguration)) {
                        list = result.get(0);
                    } else {
                        result = null;
                        exception = new IOException(fContext.getString(R.string.message_invalid_trusted_app_list_signature));
                    }
                }
                if (list == null) {
                    byte[] tempSignature;
                    byte[] tempList;
                    try {
                        String prefix = !fTestConfiguration ? YessignApplicationUtil.FILE_PREFIX_REAL : YessignApplicationUtil.FILE_PREFIX_TEST;
                        tempList = YessignApplicationUtil.loadFile(fContext, prefix + YessignApplicationUtil.FILE_APPLICATION_LIST);
                        tempSignature = YessignApplicationUtil.loadFile(fContext, prefix + YessignApplicationUtil.FILE_APPLICATION_LIST_SIG);
                    }
                    catch (IOException e) {
                        fListener.onComplete(null, exception);
                        return;
                    }
                    if (!YessignApplicationUtil.isValidTrustApplicationList(tempList, tempSignature, fTestConfiguration)) {
                        fListener.onComplete(null, exception);
                        return;
                    }
                    list = tempList;
                }
                if (result != null) {
                    try {
                        String prefix = !fTestConfiguration ? YessignApplicationUtil.FILE_PREFIX_REAL : YessignApplicationUtil.FILE_PREFIX_TEST;
                        YessignApplicationUtil.saveFile(fContext, prefix + YessignApplicationUtil.FILE_APPLICATION_LIST, result.get(0));
                        YessignApplicationUtil.saveFile(fContext, prefix + YessignApplicationUtil.FILE_APPLICATION_LIST_SIG, result.get(1));
                    }
                    catch (IOException e) {
                        XSLog.e((String)e.getMessage());
                    }
                }
                fListener.onComplete(list, null);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private byte[] queryFile(HttpURLConnection connection) throws IOException {
                byte[] data = new byte[4096];
                InputStream is = null;
                ByteArrayOutputStream bos = null;
                byte[] result = null;
                try {
                    int read;
                    is = connection.getInputStream();
                    bos = new ByteArrayOutputStream();
                    while ((read = is.read(data, 0, data.length)) != -1) {
                        bos.write(data, 0, read);
                    }
                    result = bos.toByteArray();
                }
                catch (IOException e) {
                    XSLog.e((String)"queryFile read Error");
                }
                finally {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (IOException e) {
                            XSLog.e((String)"InputStream close error");
                        }
                    }
                    if (bos != null) {
                        try {
                            bos.close();
                        }
                        catch (IOException e) {
                            XSLog.e((String)"ByteArrayOutputStream close error");
                        }
                    }
                }
                return result;
            }
        }.execute((Object[])new URL[]{listUrl, signatureUrl});
    }

    public static Intent getExplicitIntent(Context context, byte[] trustedApplicationList, Intent intent, String packageName) {
        String trustedPackageName = null;
        List resolveInfoList = context.getPackageManager().queryIntentActivities(intent, 0);
        for (ResolveInfo resolveInfo : resolveInfoList) {
            if (packageName != null && !resolveInfo.activityInfo.packageName.equals(packageName)) continue;
            Signature[] signatures = null;
            try {
                signatures = context.getPackageManager().getPackageInfo((String)resolveInfo.activityInfo.packageName, (int)64).signatures;
            }
            catch (PackageManager.NameNotFoundException e) {
                throw new RuntimeException(e);
            }
            if (!YessignApplicationUtil.isTrustedApplication(trustedApplicationList, resolveInfo.activityInfo.packageName, signatures) || YessignApplicationUtil.isMasterKeyExploitApplication(context, resolveInfo.activityInfo.packageName)) continue;
            trustedPackageName = resolveInfo.activityInfo.packageName;
        }
        if (trustedPackageName == null) {
            return null;
        }
        Intent targetIntent = (Intent)intent.clone();
        targetIntent.setPackage(trustedPackageName);
        return targetIntent;
    }

    public static boolean checkReceivedIntent(Context context, byte[] trustedApplicationList, String packageName, Intent intent) {
        Signature[] signatures = null;
        try {
            signatures = context.getPackageManager().getPackageInfo((String)packageName, (int)64).signatures;
        }
        catch (PackageManager.NameNotFoundException e) {
            throw new RuntimeException(e);
        }
        return YessignApplicationUtil.isTrustedApplication(trustedApplicationList, packageName, signatures) && !YessignApplicationUtil.isMasterKeyExploitApplication(context, packageName);
    }

    public static boolean checkNetworkStatus(Context context) {
        ConnectivityManager connManager = (ConnectivityManager)context.getSystemService("connectivity");
        if (connManager == null) {
            return false;
        }
        NetworkInfo networkInfo = connManager.getActiveNetworkInfo();
        return networkInfo != null && networkInfo.isConnected();
    }

    private static boolean isValidTrustApplicationList(byte[] list, byte[] signature, boolean testConfiguration) {
        byte[] signatureBytes;
        String pubkeyApplicationList = !testConfiguration ? PUBKEY_APPLICATION_LIST_REAL : PUBKEY_APPLICATION_LIST_TEST;
        try {
            signatureBytes = Base64.decode(new String(signature));
        }
        catch (IllegalArgumentException e) {
            return false;
        }
        try {
            KeyFactory kf = KeyFactory.getInstance("RSA");
            X509EncodedKeySpec ks = new X509EncodedKeySpec(Base64.decode(pubkeyApplicationList));
            PublicKey pubKey = kf.generatePublic(ks);
            java.security.Signature sig = java.security.Signature.getInstance("SHA256withRSA");
            sig.initVerify(pubKey);
            sig.update(list);
            return sig.verify(signatureBytes);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        catch (InvalidKeySpecException e) {
            throw new RuntimeException(e);
        }
        catch (InvalidKeyException e) {
            throw new RuntimeException(e);
        }
        catch (SignatureException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void saveFile(Context context, String filename, byte[] data) throws IOException {
        FileOutputStream fos = null;
        try {
            fos = context.openFileOutput(filename, 0);
            fos.write(data);
        }
        catch (IOException e) {
            XSLog.e((String)"saveFile error");
        }
        finally {
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException e) {
                    XSLog.e((String)"FileOutputStream close error");
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] loadFile(Context context, String filename) throws IOException {
        FileInputStream fis = null;
        ByteArrayOutputStream bos = null;
        byte[] result = null;
        try {
            int bytesRead;
            fis = context.openFileInput(filename);
            bos = new ByteArrayOutputStream();
            byte[] b = new byte[4096];
            while ((bytesRead = fis.read(b)) != -1) {
                bos.write(b, 0, bytesRead);
            }
            result = bos.toByteArray();
        }
        catch (IOException e) {
            XSLog.e((String)"loadFile Read Error");
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException e) {
                    XSLog.e((String)"FileInputStream close error");
                }
            }
            if (bos != null) {
                try {
                    bos.close();
                }
                catch (IOException e) {
                    XSLog.e((String)"ByteArrayOutputStream close error");
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean isTrustedApplication(byte[] list, String packageName, Signature[] signatures) {
        ArrayList<String> digestList = new ArrayList<String>();
        try {
            MessageDigest md = MessageDigest.getInstance("SHA256");
            for (Signature signature : signatures) {
                digestList.add(Base64.encodeToString(md.digest(signature.toByteArray())));
            }
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        try (Scanner scanner = null;){
            scanner = new Scanner(new String(list));
            while (scanner.hasNextLine()) {
                String[] tokens;
                String line = scanner.nextLine().trim();
                if (line.length() == 0 || line.startsWith("#") || (tokens = line.split(";", -1)).length < 3 || !tokens[0].equals(ELEMENT_APPLICATION_LIST)) continue;
                if (!tokens[1].equals(packageName) || !digestList.contains(tokens[2])) continue;
                int n = 1;
                return n != 0;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean isMasterKeyExploitApplication(Context context, String packageName) {
        PackageInfo packageInfo;
        if (Build.VERSION.SDK_INT >= 18) {
            return false;
        }
        try {
            packageInfo = context.getPackageManager().getPackageInfo(packageName, 0);
        }
        catch (PackageManager.NameNotFoundException e) {
            throw new RuntimeException(e);
        }
        boolean aResult = true;
        RandomAccessFile raf = null;
        ZipFile zf = null;
        try {
            raf = new RandomAccessFile(packageInfo.applicationInfo.publicSourceDir, "r");
            zf = new ZipFile(packageInfo.applicationInfo.publicSourceDir);
            aResult = YessignApplicationUtil.readZipFileEntryCount(raf) != zf.size();
        }
        catch (IOException e) {
            aResult = false;
        }
        finally {
            try {
                if (raf != null) {
                    raf.close();
                }
                if (zf != null) {
                    zf.close();
                }
            }
            catch (IOException e) {
                aResult = false;
            }
        }
        return aResult;
    }

    private static int readZipFileEntryCount(RandomAccessFile raf) throws IOException {
        block6: {
            long LOCSIG = 67324752L;
            long ENDSIG = 101010256L;
            int ENDHDR = 22;
            long scanOffset = raf.length() - 22L;
            if (scanOffset < 0L) {
                throw new ZipException("File too short to be a zip file: " + raf.length());
            }
            raf.seek(0L);
            int headerMagic = Integer.reverseBytes(raf.readInt());
            if ((long)headerMagic == 101010256L) {
                throw new ZipException("Empty zip archive not supported");
            }
            if ((long)headerMagic != 67324752L) {
                throw new ZipException("Not a zip archive");
            }
            long stopOffset = scanOffset - 65536L;
            if (stopOffset < 0L) {
                stopOffset = 0L;
            }
            do {
                raf.seek(scanOffset);
                if ((long)Integer.reverseBytes(raf.readInt()) == 101010256L) break block6;
            } while (--scanOffset >= stopOffset);
            throw new ZipException("End Of Central Directory signature not found");
        }
        byte[] eocd = new byte[18];
        raf.readFully(eocd);
        int diskNumber = eocd[0] & 0xFF | (eocd[1] & 0xFF) << 8;
        int diskWithCentralDir = eocd[2] & 0xFF | (eocd[3] & 0xFF) << 8;
        int numEntries = eocd[4] & 0xFF | (eocd[5] & 0xFF) << 8;
        int totalNumEntries = eocd[6] & 0xFF | (eocd[7] & 0xFF) << 8;
        if (numEntries != totalNumEntries || diskNumber != 0 || diskWithCentralDir != 0) {
            throw new ZipException("Spanned archives not supported");
        }
        return numEntries;
    }

    public static String getCertSubjectDn(byte[] cert) {
        try {
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            X509Certificate x509Cert = (X509Certificate)cf.generateCertificate(new ByteArrayInputStream(cert));
            return x509Cert.getSubjectDN().getName();
        }
        catch (CertificateException e) {
            throw new RuntimeException(e);
        }
    }

    public static void printIntent(String message, Intent intent) {
        StringBuilder builder = new StringBuilder();
        builder.append(message).append("|").append(intent.getDataString()).append("|");
        Bundle extras = intent.getExtras();
        if (extras != null) {
            for (String key : extras.keySet()) {
                Object value = extras.get(key);
                if (value instanceof String) {
                    builder.append(key).append(":").append((String)value).append("|");
                    continue;
                }
                if (!(value instanceof byte[])) continue;
                builder.append(key).append(":").append(Base64.encodeToString((byte[])value)).append("|");
            }
        }
        XSLog.d((String)builder.toString());
    }

    public static interface OnCompleteListener<T> {
        public void onComplete(T var1, Exception var2);
    }
}

