/*
 * Decompiled with CFR 0.152.
 */
package com.lumensoft.ks;

import com.lumensoft.ks.KSException;
import com.lumensoft.ks.KSSeed;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;

public class KSUtil {
    public static void saveFile(String string, byte[] byArray) throws IOException {
        FileOutputStream fileOutputStream = new FileOutputStream(string, true);
        fileOutputStream.write(byArray);
        if (fileOutputStream != null) {
            fileOutputStream.close();
        }
    }

    public static void saveFileAppend(String string, byte[] byArray, boolean bl) throws IOException {
        FileOutputStream fileOutputStream = new FileOutputStream(string, bl);
        fileOutputStream.write(byArray);
        if (fileOutputStream != null) {
            fileOutputStream.close();
        }
    }

    public static byte[] readFile(String string) throws IOException {
        FileInputStream fileInputStream = null;
        File file = new File(string);
        int n2 = (int)file.length();
        byte[] byArray = new byte[n2];
        fileInputStream = new FileInputStream(string);
        fileInputStream.read(byArray);
        if (fileInputStream != null) {
            fileInputStream.close();
        }
        return byArray;
    }

    public static byte[] encryptSeed(byte[] byArray, byte[] byArray2, byte[] byArray3) {
        byte[] byArray4 = null;
        int n2 = byArray.length;
        int n3 = 16 - n2 % 16;
        byte[] byArray5 = new byte[n2 + n3];
        System.arraycopy(byArray, 0, byArray5, 0, n2);
        int n4 = 0;
        while (n4 < n3) {
            byArray5[n2 + n4] = (byte)n3;
            ++n4;
        }
        try {
            KSSeed kSSeed = new KSSeed();
            byArray4 = kSSeed.CBCEncrypt(byArray5, byArray2, byArray3);
        }
        catch (KSException kSException) {
            kSException.printStackTrace();
        }
        return byArray4;
    }

    public static byte[] decryptSeed(byte[] byArray, byte[] byArray2, byte[] byArray3) {
        byte[] byArray4 = null;
        try {
            KSSeed kSSeed = new KSSeed();
            byte[] byArray5 = kSSeed.CBCDecrypt(byArray, byArray2, byArray3);
            byte by = byArray5[byArray5.length - 1];
            if (by > 16) {
                System.out.println("invalid padding");
            }
            byArray4 = new byte[byArray5.length - by];
            System.arraycopy(byArray5, 0, byArray4, 0, byArray5.length - by);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return byArray4;
    }

    public static byte[] encryptSeedNoPadding(byte[] byArray, byte[] byArray2, byte[] byArray3) {
        byte[] byArray4 = null;
        int n2 = byArray.length;
        int n3 = n2 % 16;
        if (n3 != 0) {
            System.out.println("invalid block size!!!!");
            return null;
        }
        try {
            KSSeed kSSeed = new KSSeed();
            byArray4 = kSSeed.CBCEncrypt(byArray, byArray2, byArray3);
        }
        catch (KSException kSException) {
            kSException.printStackTrace();
        }
        return byArray4;
    }

    public static byte[] decryptSeedNoPadding(byte[] byArray, byte[] byArray2, byte[] byArray3) {
        byte[] byArray4 = null;
        try {
            KSSeed kSSeed = new KSSeed();
            byArray4 = kSSeed.CBCDecrypt(byArray, byArray2, byArray3);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return byArray4;
    }

    public static byte[] a(int n2) {
        int n3 = 0;
        byte[] byArray = new byte[4];
        byArray[n3++] = (byte)(n2 >>> 24 & 0xFF);
        byArray[n3++] = (byte)(n2 >>> 16 & 0xFF);
        byArray[n3++] = (byte)(n2 >>> 8 & 0xFF);
        byArray[n3++] = (byte)(n2 & 0xFF);
        return byArray;
    }

    public static char a(int n2, int n3) {
        if (n2 >= n3 || n2 < 0) {
            return '\u0000';
        }
        if (n3 < 2 || n3 > 36) {
            return '\u0000';
        }
        if (n2 < 10) {
            return (char)(48 + n2);
        }
        return (char)(87 + n2);
    }

    public static boolean a(byte[] byArray, byte[] byArray2) {
        int n2 = byArray.length;
        int n3 = byArray2.length;
        if (n2 != n3) {
            return false;
        }
        int n4 = 0;
        while (n4 < n2) {
            if (byArray[n4] != byArray2[n4]) {
                return false;
            }
            ++n4;
        }
        return true;
    }

    public static String getVersion() {
        return "Ver 1.5.1";
    }

    public static String makeCertFilePath(String string) {
        String string2 = null;
        String string3 = null;
        File file = null;
        string3 = string.contains("/signCert.der") ? string.replace("/signCert.der", "") : (string.contains("/signPri.key") ? string.replace("/signPri.key", "") : string);
        file = new File(String.valueOf(string3) + "/signCert.der");
        if (file.exists() && string3.indexOf("NPKI") > -1) {
            string2 = String.valueOf(string3) + "/signCert.der";
        } else if (string3.indexOf("GPKI") > -1) {
            string2 = string3.contains("_sig.key") ? string3.replace("_sig.key", "_sig.cer") : string3;
        }
        return string2;
    }

    public static String makeKeyFilePath(String string) {
        String string2 = null;
        String string3 = null;
        File file = null;
        string3 = string.contains("/signCert.der") ? string.replace("/signCert.der", "") : (string.contains("/signPri.key") ? string.replace("/signPri.key", "") : string);
        file = new File(String.valueOf(string3) + "/signPri.key");
        if (file.exists() && string3.indexOf("NPKI") > -1) {
            string2 = String.valueOf(string3) + "/signPri.key";
        } else if (string3.indexOf("GPKI") > -1) {
            string2 = string3.contains("_sig.cer") ? string3.replace("_sig.cer", "_sig.key") : string3;
        }
        return string2;
    }

    public static void a(byte[] byArray) {
        int n2 = 0;
        while (n2 < byArray.length) {
            byArray[n2] = 126;
            ++n2;
        }
    }

    public static boolean isValidPassword(byte[] byArray) throws KSException {
        if (byArray.length < 10) {
            throw new KSException(-1501);
        }
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        byte[] byArray2 = byArray;
        int n2 = byArray.length;
        int n3 = 0;
        while (n3 < n2) {
            byte by = byArray2[n3];
            if (by == 39 || by == 92 || by == 124 || by == 34) {
                throw new KSException(-1505);
            }
            if (by >= 97 && by <= 122) {
                bl2 = true;
            }
            if (by >= 65 && by <= 90) {
                bl2 = true;
            }
            if (by >= 48 && by <= 57) {
                bl = true;
            }
            if (by >= 32 && by <= 47) {
                bl3 = true;
            }
            if (by >= 58 && by <= 64) {
                bl3 = true;
            }
            if (by >= 91 && by <= 96) {
                bl3 = true;
            }
            if (by >= 123 && by <= 126) {
                bl3 = true;
            }
            ++n3;
        }
        if (!bl2) {
            throw new KSException(-1502);
        }
        if (!bl) {
            throw new KSException(-1503);
        }
        if (!bl3) {
            throw new KSException(-1504);
        }
        return bl && bl2 && bl3;
    }
}

