/*
 * Decompiled with CFR 0.152.
 */
package com.softforum.xecurekeypad;

import android.app.Activity;
import android.content.Context;
import android.os.CountDownTimer;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.view.inputmethod.InputMethodManager;
import android.widget.EditText;
import android.widget.ImageButton;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.softforum.xecurekeypad.XKKeypadCustomInterface;

public class XKKeypadTopLayout
extends LinearLayout {
    private LinearLayout mImageViewLayout = null;
    private ImageButton mPreviousButton = null;
    private ImageButton mNextButton = null;
    private ImageView mInputImageView = null;
    private TextView mTimerTextView = null;
    private RestTimeCountDownTimer mSessionTimer = null;
    private XKKeypadCustomInterface mXKKeypadCustomInterface = null;
    private Context mContext = null;
    private boolean mUseDefineHeight = false;

    public XKKeypadTopLayout(Context aContext) {
        super(aContext);
        this.mContext = aContext;
    }

    public XKKeypadTopLayout(Context aContext, AttributeSet aAttributeSet) {
        super(aContext, aAttributeSet);
        this.mContext = aContext;
    }

    private void setOnClickPreviousButton(final Activity aCurrentActivity, final Activity aCallerActivity, final EditText aEditText) {
        this.mPreviousButton.setClickable(true);
        this.mPreviousButton.setEnabled(true);
        this.mPreviousButton.setContentDescription((CharSequence)"\uc774\uc804");
        this.mPreviousButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                String aEditTextClassName = null;
                String aClassName = null;
                String[] aSplitStringArray = null;
                aEditTextClassName = aEditText.getClass().toString();
                aSplitStringArray = aEditTextClassName.split("\\.");
                aClassName = aSplitStringArray[aSplitStringArray.length - 1];
                aEditText.setFocusableInTouchMode(true);
                aEditText.setFocusable(true);
                if (aClassName.equals("EditText")) {
                    aEditText.setOnFocusChangeListener(new View.OnFocusChangeListener(){

                        public void onFocusChange(View v, boolean hasFocus) {
                            aCallerActivity.getWindow().setSoftInputMode(5);
                            ((InputMethodManager)aCallerActivity.getSystemService("input_method")).showSoftInput(v, 0);
                        }
                    });
                }
                aEditText.requestFocus();
                aCurrentActivity.finish();
            }
        });
    }

    public void setPreviousButtonEvent(Activity aCurrentActivity, Activity aCallerActivity, View aView, int aPreviousEditTextID) {
        EditText aEditText = null;
        aEditText = (EditText)aView.findViewById(aPreviousEditTextID);
        this.setOnClickPreviousButton(aCurrentActivity, aCallerActivity, aEditText);
    }

    public void setPreviousButtonEvent(Activity aCurrentActivity, Activity aCallerActivity, int aPreviousEditTextID) {
        EditText aEditText = null;
        aEditText = (EditText)aCallerActivity.findViewById(aPreviousEditTextID);
        this.setOnClickPreviousButton(aCurrentActivity, aCallerActivity, aEditText);
    }

    private void setOnClickNextButton(final Activity aCurrentActivity, final Activity aCallerActivity, final EditText aEditText) {
        this.mNextButton.setClickable(true);
        this.mNextButton.setEnabled(true);
        this.mNextButton.setContentDescription((CharSequence)"\ub2e4\uc74c");
        this.mNextButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                String aEditTextClassName = null;
                String aClassName = null;
                String[] aSplitStringArray = null;
                aEditTextClassName = aEditText.getClass().toString();
                aSplitStringArray = aEditTextClassName.split("\\.");
                aClassName = aSplitStringArray[aSplitStringArray.length - 1];
                aEditText.setFocusableInTouchMode(true);
                aEditText.setFocusable(true);
                if (aClassName.equals("EditText")) {
                    aEditText.setOnFocusChangeListener(new View.OnFocusChangeListener(){

                        public void onFocusChange(View v, boolean hasFocus) {
                            aCallerActivity.getWindow().setSoftInputMode(5);
                            ((InputMethodManager)aCallerActivity.getSystemService("input_method")).showSoftInput(v, 0);
                        }
                    });
                }
                aEditText.requestFocus();
                aCurrentActivity.finish();
            }
        });
    }

    public void setNextButtonEvent(Activity aCurrentActivity, Activity aCallerActivity, View aView, int aNextEditTextID) {
        EditText aEditText = null;
        aEditText = (EditText)aView.findViewById(aNextEditTextID);
        this.setOnClickNextButton(aCurrentActivity, aCallerActivity, aEditText);
    }

    public void setNextButtonEvent(Activity aCurrentActivity, Activity aCallerActivity, int aNextEditTextID) {
        EditText aEditText = null;
        aEditText = (EditText)aCallerActivity.findViewById(aNextEditTextID);
        this.setOnClickNextButton(aCurrentActivity, aCallerActivity, aEditText);
    }

    public TextView getTimerTextView() {
        return this.mTimerTextView;
    }

    public ImageView getInputImageView() {
        return this.mInputImageView;
    }

    public ImageButton getPreviousButton() {
        return this.mPreviousButton;
    }

    public ImageButton getNextButton() {
        return this.mNextButton;
    }

    public void setButtonInvisible() {
        this.mPreviousButton.setVisibility(4);
        this.mNextButton.setVisibility(4);
    }

    public void setPreviousButtonDisable() {
        this.mPreviousButton.setClickable(false);
        this.mPreviousButton.setFocusable(false);
        this.mPreviousButton.setFocusableInTouchMode(false);
        this.mPreviousButton.setBackgroundResource(this.mContext.getResources().getIdentifier("prev_button_disable", "drawable", this.mContext.getPackageName()));
    }

    public void setNextButtonDisable() {
        this.mNextButton.setClickable(false);
        this.mNextButton.setFocusable(false);
        this.mNextButton.setFocusableInTouchMode(false);
        this.mNextButton.setBackgroundResource(this.mContext.getResources().getIdentifier("next_button_disable", "drawable", this.mContext.getPackageName()));
    }

    public void setAboveKeypad(int aKeypadID) {
        RelativeLayout.LayoutParams aLayoutParams = null;
        aLayoutParams = (RelativeLayout.LayoutParams)this.getLayoutParams();
        aLayoutParams.addRule(2, aKeypadID);
        this.setLayoutParams((ViewGroup.LayoutParams)aLayoutParams);
    }

    public void initKeypadTopLayout() {
        LinearLayout.LayoutParams aLayoutParams = null;
        ViewGroup.LayoutParams aMainLayoutParams = null;
        aMainLayoutParams = this.getLayoutParams();
        if (aMainLayoutParams.height != -2) {
            this.mUseDefineHeight = true;
        }
        this.mPreviousButton = new ImageButton(this.mContext);
        this.mNextButton = new ImageButton(this.mContext);
        aLayoutParams = new LinearLayout.LayoutParams(50, -1, 1.0f);
        this.mPreviousButton.setLayoutParams((ViewGroup.LayoutParams)aLayoutParams);
        this.mPreviousButton.setAdjustViewBounds(true);
        this.mPreviousButton.setBackgroundResource(this.mContext.getResources().getIdentifier("prev_button", "drawable", this.mContext.getPackageName()));
        this.mPreviousButton.setPadding(0, 0, 0, 0);
        this.mPreviousButton.setClickable(false);
        this.mPreviousButton.setEnabled(false);
        this.mNextButton.setLayoutParams((ViewGroup.LayoutParams)aLayoutParams);
        this.mNextButton.setAdjustViewBounds(true);
        this.mNextButton.setBackgroundResource(this.mContext.getResources().getIdentifier("next_button", "drawable", this.mContext.getPackageName()));
        this.mNextButton.setPadding(0, 0, 0, 0);
        this.mNextButton.setClickable(false);
        this.mNextButton.setEnabled(false);
        this.addView((View)this.mPreviousButton);
        this.addView((View)this.mNextButton);
        this.mInputImageView = new ImageView(this.mContext);
        aLayoutParams = new LinearLayout.LayoutParams(-2, -1);
        this.mInputImageView.setLayoutParams((ViewGroup.LayoutParams)aLayoutParams);
        this.mImageViewLayout = new LinearLayout(this.mContext);
        aLayoutParams = new LinearLayout.LayoutParams(-2, -1, 8.0f);
        this.mImageViewLayout.setGravity(17);
        this.mImageViewLayout.setLayoutParams((ViewGroup.LayoutParams)aLayoutParams);
        this.mImageViewLayout.addView((View)this.mInputImageView);
        this.addView((View)this.mImageViewLayout);
        this.mTimerTextView = new TextView(this.mContext);
        aLayoutParams = new LinearLayout.LayoutParams(-2, -1);
        this.mTimerTextView.setLayoutParams((ViewGroup.LayoutParams)aLayoutParams);
        this.mTimerTextView.setTextColor(-16777216);
        this.mTimerTextView.setGravity(85);
        this.addView((View)this.mTimerTextView);
    }

    public void resizeKeypadTopLayout() {
        ViewGroup.LayoutParams aLayoutParams = null;
        int aLayoutHeight = 0;
        aLayoutParams = this.getLayoutParams();
        try {
            if (!this.mUseDefineHeight) {
                aLayoutHeight = this.mContext.getResources().getDisplayMetrics().heightPixels * 7 / 100;
            }
            aLayoutParams.height = aLayoutHeight;
            this.setLayoutParams(aLayoutParams);
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void refreshSessionTimer(int aStartTime) {
        if (this.mSessionTimer != null) {
            this.mSessionTimer.cancel();
        } else {
            this.mSessionTimer = new RestTimeCountDownTimer(aStartTime * 1000, 1000L);
        }
        this.mSessionTimer.start();
    }

    public void endSessionTimer() {
        if (this.mSessionTimer != null) {
            this.mSessionTimer.cancel();
        }
    }

    public void setXKKeypadCustomInterface(XKKeypadCustomInterface pXKKeypadCustomInterface) {
        this.mXKKeypadCustomInterface = pXKKeypadCustomInterface;
    }

    private class RestTimeCountDownTimer
    extends CountDownTimer {
        public RestTimeCountDownTimer(long aStartTime, long aInterval) {
            super(aStartTime, aInterval);
        }

        public void onFinish() {
            XKKeypadTopLayout.this.mTimerTextView.setText((CharSequence)"\ubcf4\uc548 \uc138\uc158 \ub9cc\ub8cc");
            if (XKKeypadTopLayout.this.mXKKeypadCustomInterface != null) {
                XKKeypadTopLayout.this.mXKKeypadCustomInterface.onFinishSessionTime(XKKeypadTopLayout.this.mContext);
            }
        }

        public void onTick(long aCurrentSecond) {
            String aRestTime = new String();
            int aSecond = (int)(aCurrentSecond / 1000L);
            int aMinute = aSecond / 60;
            aSecond %= 60;
            aRestTime = String.valueOf(aRestTime) + "\ubcf4\uc548 \uc138\uc158 ";
            if (aMinute != 0) {
                aRestTime = String.valueOf(aRestTime) + aMinute + " : ";
                aRestTime = aSecond < 10 ? String.valueOf(aRestTime) + "0" + aSecond : String.valueOf(aRestTime) + aSecond;
            } else {
                aRestTime = aSecond < 10 ? String.valueOf(aRestTime) + "0" + aSecond + "\ucd08" : String.valueOf(aRestTime) + aSecond + "\ucd08";
            }
            XKKeypadTopLayout.this.mTimerTextView.setText((CharSequence)aRestTime);
        }
    }
}

