/*
 * Decompiled with CFR 0.152.
 */
package com.softforum.xecurekeypad;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.os.Handler;
import android.util.DisplayMetrics;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.EditText;
import android.widget.ImageButton;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.PopupWindow;
import android.widget.RelativeLayout;
import com.softforum.xecurekeypad.XKCoreWrapper;
import com.softforum.xecurekeypad.XKEditText;
import com.softforum.xecurekeypad.XKKeyButton;
import com.softforum.xecurekeypad.XKKeypadInterface;
import com.softforum.xecurekeypad.XKKeypadResources;
import com.softforum.xecurekeypad.XKKeypadTopLayout;
import java.util.ArrayList;
import java.util.Timer;
import java.util.TimerTask;

public class XKQwertySymbolKeypad {
    private final int QWERTY_KEYPAD_SHIFT_INDEX = 33;
    private final int QWERTY_KEYPAD_SPACE_INDEX = 42;
    private final int QWERTY_KEYPAD_DELETE_INDEX = 43;
    private final int QWERTY_KEYPAD_REFRESH_INDEX = 44;
    private final int QWERTY_KEYPAD_SYMBOL_INDEX = 45;
    private final int QWERTY_KEYPAD_COMPLETE_INDEX = 47;
    private final int QWERTY_KEYPAD_FUNCTION_KEY_COUNT = 6;
    private final int QWERTY_KEYPAD_NUMBER_KEY_COUNT = 10;
    private final int QWERTY_KEYPAD_QWERTY_KEY_COUNT = 26;
    private final int QWERTY_KEYPAD_SYMBOL_KEY_COUNT = 32;
    private final int QWERTY_KEYPAD_NUMBER_BLANK_COUNT = 1;
    private final int QWERTY_KEYPAD_QWERTY_BLANK_COUNT = 5;
    private final int QWERTY_KEYPAD_SYMBOL_FIRST_LINE_BLANK_COUNT = 1;
    private final int QWERTY_KEYPAD_SYMBOL_SECOND_LINE_BLANK_COUNT = 3;
    private final int QWERTY_KEYPAD_SYMBOL_THIRD_LINE_BLANK_COUNT = 3;
    private final int QWERTY_KEYPAD_SYMBOL_FOURTH_LINE_BLANK_COUNT = 3;
    private final int QWERTY_KEYPAD_SYMBOL_BLANK_COUNT = 10;
    private final int QWERTY_KEYPAD_KEY_COUNT = 36;
    private final int QWERTY_KEYPAD_BLANK_COUNT = 6;
    private int mXKViewType = 0;
    private int mKeypadRowCount = 0;
    private int mKeypadColumnCount = 0;
    private int[] mXKKeypadIndex = null;
    private int mXKKeypadHeight = 0;
    private int mXKKeyWidth = 0;
    private int mXKKeyHeight = 0;
    private int mXKKeyWidthMargin = 0;
    private int mXKKeyHeightMargin = 0;
    private int mPopupWindowBackgroundID = 0;
    private String[] mXKKeypadIndexText = null;
    private boolean mSymbolMode = false;
    private boolean mShiftMode = false;
    private ImageView mInputImageView = null;
    private Drawable mXKBlankLogoImage = null;
    private XKEditText mXKEditText = null;
    private EditText mDummyEditText = null;
    private StringBuffer mDummyBuffer = new StringBuffer();
    private XKCoreWrapper mXKCoreWrapper = null;
    private XKKeypadInterface mXKKeypadInterface = null;
    private XKKeypadResources mXKKeypadResources = null;
    private XKKeypadTopLayout mXKKeypadTopLayout = null;
    private Timer mInputKeyTimer = null;
    private PopupWindow mXKPopupWindow = null;
    private ArrayList<LinearLayout> mKeypadLayoutList = null;
    private ArrayList<XKKeyButton> mXKKeyList = null;
    private String mAddSymbolLine = null;
    private int mAddSymbolCount = 11;
    private XKKeyButton mShiftButton = null;
    private XKKeyButton mDeleteButton = null;
    private XKKeyButton mRefreshButton = null;
    private XKKeyButton mSymbolButton = null;
    private XKKeyButton mCompleteButton = null;
    private Context mContext = null;
    private Activity mActivity = null;

    public XKQwertySymbolKeypad(Context pContext) {
        this.mContext = pContext;
        this.mActivity = (Activity)this.mContext;
    }

    public void initKeypad() {
        int aRowCount = 0;
        ImageButton aCancelButton = null;
        LinearLayout aKeypadRowLayout = null;
        RelativeLayout.LayoutParams aRowLayoutParams = null;
        this.mXKViewType = this.mXKEditText.getKeypadViewType();
        this.mXKKeypadResources = new XKKeypadResources(this.mActivity);
        this.mXKKeypadInterface = new XKKeypadInterface(this.mXKEditText, this.mXKCoreWrapper);
        this.mXKKeypadInterface.clearIndex();
        this.mXKKeypadTopLayout = (XKKeypadTopLayout)this.mActivity.findViewById(this.mActivity.getResources().getIdentifier("xk_keypad_top_layout", "id", this.mActivity.getPackageName()));
        if (this.mXKKeypadTopLayout != null) {
            this.mInputImageView = this.mXKKeypadTopLayout.getInputImageView();
            this.mInputImageView.setImageResource(this.mXKKeypadResources.getClickedSpaceImageID());
        }
        if (this.mXKViewType == 1 && (aCancelButton = (ImageButton)this.mActivity.findViewById(this.mActivity.getResources().getIdentifier("cancel_button", "id", this.mActivity.getPackageName()))) != null) {
            aCancelButton.setContentDescription((CharSequence)"\ub2eb\uae30");
            aCancelButton.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    Intent aIntent = null;
                    if (XKQwertySymbolKeypad.this.mInputKeyTimer != null) {
                        XKQwertySymbolKeypad.this.mInputKeyTimer.cancel();
                        XKQwertySymbolKeypad.this.mInputKeyTimer.purge();
                        XKQwertySymbolKeypad.this.mInputKeyTimer = null;
                    }
                    XKQwertySymbolKeypad.this.mXKKeypadInterface.clearIndex();
                    if (XKQwertySymbolKeypad.this.mXKEditText.getE2EURL() != null) {
                        XKQwertySymbolKeypad.this.mXKKeypadTopLayout.endSessionTimer();
                    }
                    aIntent = XKQwertySymbolKeypad.this.mActivity.getIntent();
                    XKQwertySymbolKeypad.this.mActivity.setResult(0, aIntent);
                    XKQwertySymbolKeypad.this.mActivity.finish();
                }
            });
        }
        this.mKeypadLayoutList = new ArrayList();
        this.mKeypadRowCount = 6;
        this.mKeypadColumnCount = 11;
        this.initKeypadButton();
        aRowCount = 0;
        while (aRowCount < this.mKeypadRowCount) {
            aKeypadRowLayout = new LinearLayout(this.mContext);
            aRowLayoutParams = new RelativeLayout.LayoutParams(-1, -2);
            if (aRowCount != 0) {
                aRowLayoutParams.addRule(3, this.mKeypadLayoutList.get(aRowCount - 1).getId());
            }
            aRowLayoutParams.topMargin = this.mXKKeyHeightMargin;
            aKeypadRowLayout.setId(aRowLayoutParams.hashCode());
            aKeypadRowLayout.setLayoutParams((ViewGroup.LayoutParams)aRowLayoutParams);
            if (aRowCount == this.mKeypadRowCount - 1) {
                aKeypadRowLayout.setPadding(this.mXKKeyWidthMargin, 0, this.mXKKeyWidthMargin, this.mXKKeyHeightMargin);
            } else {
                aKeypadRowLayout.setPadding(this.mXKKeyWidthMargin, 0, this.mXKKeyWidthMargin, 0);
            }
            this.mKeypadLayoutList.add(aKeypadRowLayout);
            ++aRowCount;
        }
    }

    private void initKeypadButton() {
        int aDeviceHeight = 0;
        int aDeviceWidth = 0;
        int aHeightPercent = 0;
        int aXKKeypadHeight = 0;
        int aXKKeypadWidth = 0;
        float aWidthMarginPercent = 0.0f;
        float aHeightMarginPercent = 0.0f;
        DisplayMetrics aDisplayMetrics = null;
        int aTotalKeySize = 0;
        int aKeyCount = 0;
        int aSpaceButtonIndex = 0;
        LinearLayout.LayoutParams aKeyButtonLayoutParams = null;
        LinearLayout.LayoutParams aFunctionKeyButtonLayoutParams = null;
        XKKeyButton aXKKeyButton = null;
        aWidthMarginPercent = 1.0f;
        aHeightMarginPercent = 0.5f;
        aHeightPercent = 45;
        aDisplayMetrics = new DisplayMetrics();
        this.mActivity.getWindowManager().getDefaultDisplay().getMetrics(aDisplayMetrics);
        aDeviceWidth = aDisplayMetrics.widthPixels;
        aDeviceHeight = aDisplayMetrics.heightPixels;
        this.mXKKeyWidthMargin = (int)((float)aDeviceWidth * aWidthMarginPercent) / 100;
        this.mXKKeyHeightMargin = (int)((float)aDeviceHeight * aHeightMarginPercent) / 100;
        this.mXKKeypadHeight = aXKKeypadHeight = aDeviceHeight * aHeightPercent / 100;
        this.mXKKeyHeight = (aXKKeypadHeight -= (this.mKeypadRowCount + 1) * this.mXKKeyHeightMargin) / this.mKeypadRowCount;
        aXKKeypadWidth = aDeviceWidth - (this.mKeypadColumnCount + 1) * this.mXKKeyWidthMargin;
        this.mXKKeyWidth = aXKKeypadWidth / this.mKeypadColumnCount;
        this.mXKKeyList = new ArrayList();
        aFunctionKeyButtonLayoutParams = new LinearLayout.LayoutParams(-2, this.mXKKeyHeight);
        aFunctionKeyButtonLayoutParams.weight = 1.0f;
        aFunctionKeyButtonLayoutParams.gravity = 17;
        this.mRefreshButton = new XKKeyButton(this.mContext);
        this.mDeleteButton = new XKKeyButton(this.mContext);
        this.mCompleteButton = new XKKeyButton(this.mContext);
        this.mShiftButton = new XKKeyButton(this.mContext);
        this.mSymbolButton = new XKKeyButton(this.mContext);
        aFunctionKeyButtonLayoutParams.rightMargin = this.mXKKeyWidthMargin;
        this.mRefreshButton.setLayoutParams((ViewGroup.LayoutParams)aFunctionKeyButtonLayoutParams);
        this.mShiftButton.setLayoutParams((ViewGroup.LayoutParams)aFunctionKeyButtonLayoutParams);
        this.mSymbolButton.setLayoutParams((ViewGroup.LayoutParams)aFunctionKeyButtonLayoutParams);
        aFunctionKeyButtonLayoutParams = new LinearLayout.LayoutParams(-2, this.mXKKeyHeight);
        aFunctionKeyButtonLayoutParams.weight = 1.0f;
        aFunctionKeyButtonLayoutParams.gravity = 17;
        aFunctionKeyButtonLayoutParams.rightMargin = 0;
        aFunctionKeyButtonLayoutParams.leftMargin = this.mXKKeyWidthMargin;
        this.mCompleteButton.setLayoutParams((ViewGroup.LayoutParams)aFunctionKeyButtonLayoutParams);
        this.mDeleteButton.setLayoutParams((ViewGroup.LayoutParams)aFunctionKeyButtonLayoutParams);
        aTotalKeySize = 43 + this.mAddSymbolCount;
        aSpaceButtonIndex = 42 + this.mAddSymbolCount;
        aKeyCount = 0;
        while (aKeyCount < aTotalKeySize) {
            aKeyButtonLayoutParams = new LinearLayout.LayoutParams(-2, this.mXKKeyHeight);
            aKeyButtonLayoutParams.weight = 1.0f;
            aKeyButtonLayoutParams.gravity = 17;
            aKeyButtonLayoutParams.leftMargin = aKeyCount % this.mKeypadColumnCount == 0 || aKeyCount == aSpaceButtonIndex ? 0 : this.mXKKeyWidthMargin;
            aXKKeyButton = new XKKeyButton(this.mContext);
            aXKKeyButton.initKeyButton();
            aXKKeyButton.setLayoutParams((ViewGroup.LayoutParams)aKeyButtonLayoutParams);
            this.mXKKeyList.add(aXKKeyButton);
            ++aKeyCount;
        }
    }

    public void setXKKeypad() {
        int aRowCount = 0;
        int aRealIndexCount = 0;
        int aIndexCount = 0;
        int aTotalCount = 0;
        int aAddSymbolButtonCount = 0;
        String aE2EURL = null;
        LinearLayout aKeypadRowLayout = null;
        aE2EURL = this.mXKEditText.getE2EURL();
        if (aE2EURL != null) {
            this.mXKKeypadTopLayout.refreshSessionTimer(this.mXKCoreWrapper.getE2ESessionTime());
        }
        aAddSymbolButtonCount = this.mAddSymbolCount;
        aTotalCount = 48 + aAddSymbolButtonCount;
        while (aIndexCount < aTotalCount) {
            aKeypadRowLayout = this.mKeypadLayoutList.get(aRowCount);
            if (aIndexCount == 33 + aAddSymbolButtonCount) {
                aKeypadRowLayout.addView((View)this.mShiftButton);
            } else if (aIndexCount == 46 + aAddSymbolButtonCount) {
                aKeypadRowLayout.addView((View)this.mXKKeyList.get(42 + aAddSymbolButtonCount));
                ++aRealIndexCount;
            } else if (aIndexCount == 43 + aAddSymbolButtonCount) {
                aKeypadRowLayout.addView((View)this.mDeleteButton);
            } else if (aIndexCount == 44 + aAddSymbolButtonCount) {
                aKeypadRowLayout.addView((View)this.mRefreshButton);
            } else if (aIndexCount == 45 + aAddSymbolButtonCount) {
                aKeypadRowLayout.addView((View)this.mSymbolButton);
            } else if (aIndexCount == 47 + aAddSymbolButtonCount) {
                aKeypadRowLayout.addView((View)this.mCompleteButton);
            } else {
                aKeypadRowLayout.addView((View)this.mXKKeyList.get(aRealIndexCount));
                ++aRealIndexCount;
            }
            if (++aIndexCount % this.mKeypadColumnCount != 0) continue;
            ++aRowCount;
        }
    }

    public void setXKKeypadButtonImage() {
        if (this.mSymbolMode) {
            this.setNumberButtonImages();
            this.setSymbolButtonImages();
            this.setFunctionButtonImages();
        } else {
            this.setSymbolButtonImages();
            this.setNumberButtonImages();
            this.setCharacterButtonImages();
            this.setFunctionButtonImages();
        }
        this.setClickedEvent();
    }

    private void clearButtonFocus() {
        int aIndexCount = 0;
        XKKeyButton aXKKeyButton = null;
        aIndexCount = 0;
        while (aIndexCount < this.mXKKeyList.size()) {
            aXKKeyButton = this.mXKKeyList.get(aIndexCount);
            aXKKeyButton.clearFocus();
            ++aIndexCount;
        }
    }

    public void setFirstButtonFocus() {
        int aIndexCount = 0;
        XKKeyButton aXKKeyButton = null;
        aIndexCount = 0;
        while (aIndexCount < this.mXKKeyList.size()) {
            aXKKeyButton = this.mXKKeyList.get(aIndexCount);
            if (aXKKeyButton.getIndex() != -1) {
                aXKKeyButton.requestFocus();
                break;
            }
            ++aIndexCount;
        }
    }

    private void setClickedEvent() {
        int aIndexCount = 0;
        XKKeyButton aXKKeyButton = null;
        aIndexCount = 0;
        while (aIndexCount < this.mXKKeyList.size()) {
            aXKKeyButton = this.mXKKeyList.get(aIndexCount);
            if (aXKKeyButton.getIndex() == -1) {
                aXKKeyButton.setOnClickListener(null);
                aXKKeyButton.setFocusable(false);
                aXKKeyButton.setFocusableInTouchMode(false);
                aXKKeyButton.setClickable(false);
            } else {
                aXKKeyButton.setFocusable(true);
                aXKKeyButton.setFocusableInTouchMode(true);
                aXKKeyButton.setClickable(true);
                aXKKeyButton.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View pView) {
                        int aXKInputMaxLength = XKQwertySymbolKeypad.this.mXKEditText.getKeypadMaxLength();
                        TimerTask aInputKeyTimerTask = null;
                        final Handler aHandler = new Handler();
                        XKKeyButton aXKKeyButton = (XKKeyButton)pView;
                        if (XKQwertySymbolKeypad.this.mXKCoreWrapper.getIndexCount() == aXKInputMaxLength) {
                            return;
                        }
                        if (XKQwertySymbolKeypad.this.mInputKeyTimer != null) {
                            XKQwertySymbolKeypad.this.mInputKeyTimer.cancel();
                            XKQwertySymbolKeypad.this.mInputKeyTimer.purge();
                            XKQwertySymbolKeypad.this.mInputKeyTimer = null;
                        }
                        XKQwertySymbolKeypad.this.mInputKeyTimer = new Timer();
                        aInputKeyTimerTask = new TimerTask(){

                            @Override
                            public void run() {
                                aHandler.post(new Runnable(){

                                    @Override
                                    public void run() {
                                        if (XKQwertySymbolKeypad.this.mXKKeypadTopLayout != null) {
                                            XKQwertySymbolKeypad.this.mInputImageView.setImageResource(XKQwertySymbolKeypad.this.mXKKeypadResources.getClickedSpaceImageID());
                                        }
                                    }
                                });
                            }
                        };
                        XKQwertySymbolKeypad.this.mInputKeyTimer.schedule(aInputKeyTimerTask, 5000L);
                        if (XKQwertySymbolKeypad.this.mXKKeypadTopLayout != null) {
                            XKQwertySymbolKeypad.this.mInputImageView.setImageResource(aXKKeyButton.getClickedImageID());
                        }
                        XKQwertySymbolKeypad.this.mXKKeypadInterface.getIndexData(aXKKeyButton);
                        if (XKQwertySymbolKeypad.this.mXKViewType == 1) {
                            XKQwertySymbolKeypad.this.mDummyBuffer.append("*");
                            XKQwertySymbolKeypad.this.mDummyEditText.setText((CharSequence)XKQwertySymbolKeypad.this.mDummyBuffer);
                        }
                    }
                });
                aXKKeyButton.setOnTouchListener(new View.OnTouchListener(){

                    public boolean onTouch(View pView, MotionEvent pMotionEvent) {
                        int aAction = 0;
                        XKKeyButton aXKKeyButton = (XKKeyButton)pView;
                        aAction = pMotionEvent.getAction();
                        if (pMotionEvent.getPointerCount() > 1) {
                            return false;
                        }
                        if (aAction == 0 && aXKKeyButton.getIndex() != -1) {
                            if (XKQwertySymbolKeypad.this.mXKPopupWindow == null) {
                                XKQwertySymbolKeypad.this.showPopupWindow(aXKKeyButton);
                            }
                        } else if (aAction == 1) {
                            if (XKQwertySymbolKeypad.this.mXKPopupWindow != null) {
                                XKQwertySymbolKeypad.this.mXKPopupWindow.dismiss();
                                XKQwertySymbolKeypad.this.mXKPopupWindow = null;
                            }
                            aXKKeyButton.performClick();
                        }
                        return true;
                    }
                });
            }
            ++aIndexCount;
        }
        this.mRefreshButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                String aE2EURL = null;
                if (XKQwertySymbolKeypad.this.mXKViewType == 1) {
                    XKQwertySymbolKeypad.this.mDummyBuffer.setLength(0);
                    XKQwertySymbolKeypad.this.mDummyEditText.setText((CharSequence)XKQwertySymbolKeypad.this.mDummyBuffer);
                }
                XKQwertySymbolKeypad.this.mXKKeypadInterface.clearIndex();
                XKQwertySymbolKeypad.this.makeXKKeypadIndex();
                XKQwertySymbolKeypad.this.setXKKeypadButtonImage();
                XKQwertySymbolKeypad.this.clearButtonFocus();
                XKQwertySymbolKeypad.this.setFirstButtonFocus();
                if (XKQwertySymbolKeypad.this.mXKKeypadTopLayout != null) {
                    XKQwertySymbolKeypad.this.mInputImageView.setImageResource(XKQwertySymbolKeypad.this.mXKKeypadResources.getClickedSpaceImageID());
                    aE2EURL = XKQwertySymbolKeypad.this.mXKEditText.getE2EURL();
                    if (aE2EURL != null) {
                        XKQwertySymbolKeypad.this.mXKKeypadTopLayout.refreshSessionTimer(XKQwertySymbolKeypad.this.mXKCoreWrapper.getE2ESessionTime());
                    }
                }
            }
        });
        this.mDeleteButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                int aInputLength = 0;
                if (XKQwertySymbolKeypad.this.mXKViewType == 1 && (aInputLength = XKQwertySymbolKeypad.this.mDummyBuffer.length()) > 0) {
                    XKQwertySymbolKeypad.this.mDummyBuffer.deleteCharAt(aInputLength - 1);
                    XKQwertySymbolKeypad.this.mDummyEditText.setText((CharSequence)XKQwertySymbolKeypad.this.mDummyBuffer);
                }
                XKQwertySymbolKeypad.this.mXKKeypadInterface.deleteIndex();
                if (XKQwertySymbolKeypad.this.mXKKeypadTopLayout != null) {
                    XKQwertySymbolKeypad.this.mInputImageView.setImageResource(XKQwertySymbolKeypad.this.mXKKeypadResources.getClickedSpaceImageID());
                }
            }
        });
        this.mDeleteButton.setOnLongClickListener(new View.OnLongClickListener(){

            public boolean onLongClick(View v) {
                if (XKQwertySymbolKeypad.this.mXKViewType == 1) {
                    XKQwertySymbolKeypad.this.mDummyBuffer.setLength(0);
                    XKQwertySymbolKeypad.this.mDummyEditText.setText((CharSequence)XKQwertySymbolKeypad.this.mDummyBuffer);
                }
                if (XKQwertySymbolKeypad.this.mXKKeypadTopLayout != null) {
                    XKQwertySymbolKeypad.this.mInputImageView.setImageResource(XKQwertySymbolKeypad.this.mXKKeypadResources.getClickedSpaceImageID());
                }
                XKQwertySymbolKeypad.this.mXKKeypadInterface.clearIndex();
                return false;
            }
        });
        this.mCompleteButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                String aE2EURL = null;
                Intent aIntent = null;
                aE2EURL = XKQwertySymbolKeypad.this.mXKEditText.getE2EURL();
                if (XKQwertySymbolKeypad.this.mXKKeypadTopLayout != null && aE2EURL != null) {
                    XKQwertySymbolKeypad.this.mXKKeypadTopLayout.endSessionTimer();
                }
                aIntent = XKQwertySymbolKeypad.this.mActivity.getIntent();
                XKQwertySymbolKeypad.this.mActivity.setResult(-1, aIntent);
                XKQwertySymbolKeypad.this.mActivity.finish();
            }
        });
        this.mShiftButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (XKQwertySymbolKeypad.this.mSymbolMode) {
                    return;
                }
                XKQwertySymbolKeypad.this.mShiftMode = !XKQwertySymbolKeypad.this.mShiftMode;
                XKQwertySymbolKeypad.this.setXKKeypadButtonImage();
                if (XKQwertySymbolKeypad.this.mXKKeypadTopLayout != null) {
                    XKQwertySymbolKeypad.this.mInputImageView.setImageResource(XKQwertySymbolKeypad.this.mXKKeypadResources.getClickedSpaceImageID());
                }
            }
        });
        this.mSymbolButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                XKQwertySymbolKeypad.this.mSymbolMode = !XKQwertySymbolKeypad.this.mSymbolMode;
                XKQwertySymbolKeypad.this.setXKKeypadButtonImage();
                XKQwertySymbolKeypad.this.clearButtonFocus();
                XKQwertySymbolKeypad.this.setFirstButtonFocus();
                if (XKQwertySymbolKeypad.this.mXKKeypadTopLayout != null) {
                    XKQwertySymbolKeypad.this.mInputImageView.setImageResource(XKQwertySymbolKeypad.this.mXKKeypadResources.getClickedSpaceImageID());
                }
            }
        });
    }

    private void showPopupWindow(XKKeyButton pXKKeyButton) {
        int aIndex = 0;
        int aPopupKeyHeight = 0;
        int aPopupKeyWidth = 0;
        int aPopupPositionX = 0;
        int aPopupPositionY = 0;
        int aAnimationStyle = 0;
        int aOrientation = 0;
        Drawable aClickedImage = null;
        Drawable aBackgrounImage = null;
        LinearLayout aPopupWindowLayout = null;
        ImageView aClickedImageView = null;
        LinearLayout.LayoutParams aLayoutParams = null;
        LinearLayout.LayoutParams aImageViewLayoutParams = null;
        aIndex = this.mXKKeyList.indexOf((Object)pXKKeyButton);
        if (aIndex == 42 + this.mAddSymbolCount) {
            return;
        }
        aPopupWindowLayout = new LinearLayout(this.mContext);
        aLayoutParams = new LinearLayout.LayoutParams(-2, -1);
        aPopupWindowLayout.setLayoutParams((ViewGroup.LayoutParams)aLayoutParams);
        aPopupWindowLayout.setGravity(49);
        aPopupWindowLayout.setPadding(0, 10, 0, 0);
        aClickedImage = this.resizeBackgroundImage(pXKKeyButton.getClickedImageID(), this.mXKKeyWidth, this.mXKKeyHeight);
        aClickedImageView = new ImageView(this.mContext);
        aImageViewLayoutParams = new LinearLayout.LayoutParams(-2, -2);
        aClickedImageView.setLayoutParams((ViewGroup.LayoutParams)aImageViewLayoutParams);
        aClickedImageView.setBackgroundDrawable(aClickedImage);
        aPopupWindowLayout.addView((View)aClickedImageView);
        this.mXKPopupWindow = new PopupWindow((View)aPopupWindowLayout);
        aOrientation = this.mActivity.getResources().getConfiguration().orientation;
        if (aOrientation == 2) {
            aPopupKeyHeight = this.mXKKeyHeight * 2;
            aPopupKeyWidth = this.mXKKeyWidth * 65 / 100;
            aPopupKeyWidth += this.mXKKeyWidth;
        } else {
            aPopupKeyHeight = this.mXKKeyHeight * 2;
            aPopupKeyWidth = this.mXKKeyWidth * 2;
        }
        aPopupPositionY = 0 - aPopupKeyHeight;
        this.mXKPopupWindow.setHeight(aPopupKeyHeight);
        this.mXKPopupWindow.setWidth(aPopupKeyWidth);
        if (aIndex % this.mKeypadColumnCount == 0 && aIndex != 33 + this.mAddSymbolCount) {
            this.mPopupWindowBackgroundID = this.mXKKeypadResources.getQwertyLeftMagImageID();
            aPopupPositionX = 0;
        } else if (aIndex % this.mKeypadColumnCount == this.mKeypadColumnCount - 1) {
            this.mPopupWindowBackgroundID = this.mXKKeypadResources.getQwertyRightMagImageID();
            aPopupPositionX = aOrientation == 2 ? 0 - (aPopupKeyWidth - this.mXKKeyWidth) : 0 - this.mXKKeyWidth;
        } else {
            this.mPopupWindowBackgroundID = this.mXKKeypadResources.getQwertyCenterMagImageID();
            aPopupPositionX = aOrientation == 2 ? 0 - (aPopupKeyWidth - this.mXKKeyWidth) / 2 : 0 - this.mXKKeyWidth / 2;
        }
        aBackgrounImage = this.resizeBackgroundImage(this.mPopupWindowBackgroundID, aPopupKeyWidth, aPopupKeyHeight);
        aPopupWindowLayout.setBackgroundDrawable(aBackgrounImage);
        this.mXKPopupWindow.setContentView((View)aPopupWindowLayout);
        aAnimationStyle = this.mActivity.getResources().getIdentifier("XKKeypadAnimations.PopupWindow", "style", this.mActivity.getPackageName());
        this.mXKPopupWindow.setAnimationStyle(aAnimationStyle);
        this.mXKPopupWindow.showAsDropDown((View)pXKKeyButton, aPopupPositionX, aPopupPositionY);
    }

    private void setNumberButtonImages() {
        int aIndexCount = 0;
        int aRealIndex = 0;
        int aRealTextIndex = 0;
        int aStartIndex = 0;
        int aEndIndex = 0;
        int[] aNumberQwertyImagesIDs = null;
        int[] aClickedNumberQwertyImageIDs = null;
        Drawable aNumberButtonDrawable = null;
        Drawable aBlankDrawable = null;
        if (this.mSymbolMode) {
            aStartIndex = 0;
            aEndIndex = 11;
        } else {
            aStartIndex = this.mAddSymbolCount;
            aEndIndex = 11 + this.mAddSymbolCount;
        }
        aNumberQwertyImagesIDs = this.mXKKeypadResources.getNumberQwertyImageIDs();
        aClickedNumberQwertyImageIDs = this.mXKKeypadResources.getClickedNumberQwertyImageIDs();
        aIndexCount = aStartIndex;
        while (aIndexCount < aEndIndex) {
            this.mXKKeyList.get(aIndexCount).setSymbolMode(this.mSymbolMode);
            if (this.mXKKeyList.get(aIndexCount).getIndex() == -1) {
                aBlankDrawable = this.mXKBlankLogoImage != null ? this.mXKBlankLogoImage : this.resizeBackgroundImage(this.mXKKeypadResources.getBlankImageID(), this.mXKKeyWidth, this.mXKKeyHeight);
                if (aBlankDrawable == null) {
                    this.mXKKeyList.get(aIndexCount).setWidth(this.mXKKeyWidth);
                    this.mXKKeyList.get(aIndexCount).setHeight(this.mXKKeyHeight);
                }
                this.mXKKeyList.get(aIndexCount).setBackgroundDrawable(aBlankDrawable);
                this.mXKKeyList.get(aIndexCount).setContentDescription(null);
            } else {
                aNumberButtonDrawable = this.resizeBackgroundImage(aNumberQwertyImagesIDs[aRealIndex], this.mXKKeyWidth, this.mXKKeyHeight);
                this.mXKKeyList.get(aIndexCount).setBackgroundDrawable(aNumberButtonDrawable);
                this.mXKKeyList.get(aIndexCount).setClickedImageID(aClickedNumberQwertyImageIDs[aRealIndex]);
                this.mXKKeyList.get(aIndexCount).setContentDescription(this.mXKKeypadIndexText[aRealTextIndex]);
                ++aRealIndex;
                ++aRealTextIndex;
            }
            ++aIndexCount;
        }
    }

    private void setCharacterButtonImages() {
        int aIndexCount = 0;
        int aRealIndex = 0;
        int aRealTextIndex = 0;
        int aStartIndex = 0;
        int aEndIndex = 0;
        int[] aQwertyImageIDs = null;
        int[] aClickedQwertyImageIDs = null;
        Drawable aCharaterButtonDrawable = null;
        Drawable aBlankDrawable = null;
        aStartIndex = 11 + this.mAddSymbolCount;
        aEndIndex = 42 + this.mAddSymbolCount;
        if (this.mShiftMode) {
            aQwertyImageIDs = this.mXKKeypadResources.getUpperQwertyImageIDs();
            aClickedQwertyImageIDs = this.mXKKeypadResources.getClickedUpperQwertyImageIDs();
            aRealTextIndex = 36;
        } else {
            aQwertyImageIDs = this.mXKKeypadResources.getLowerQwertyImageIDs();
            aClickedQwertyImageIDs = this.mXKKeypadResources.getClickedLowerQwertyImageIDs();
            aRealTextIndex = 10;
        }
        aIndexCount = aStartIndex;
        while (aIndexCount < aEndIndex) {
            this.mXKKeyList.get(aIndexCount).setShiftMode(this.mShiftMode);
            this.mXKKeyList.get(aIndexCount).setSymbolMode(this.mSymbolMode);
            if (this.mXKKeyList.get(aIndexCount).getIndex() == -1) {
                aBlankDrawable = this.mXKBlankLogoImage != null ? this.mXKBlankLogoImage : this.resizeBackgroundImage(this.mXKKeypadResources.getBlankImageID(), this.mXKKeyWidth, this.mXKKeyHeight);
                if (aBlankDrawable == null) {
                    this.mXKKeyList.get(aIndexCount).setWidth(this.mXKKeyWidth);
                    this.mXKKeyList.get(aIndexCount).setHeight(this.mXKKeyHeight);
                }
                this.mXKKeyList.get(aIndexCount).setBackgroundDrawable(aBlankDrawable);
                this.mXKKeyList.get(aIndexCount).setContentDescription(null);
            } else {
                aCharaterButtonDrawable = this.resizeBackgroundImage(aQwertyImageIDs[aRealIndex], this.mXKKeyWidth, this.mXKKeyHeight);
                this.mXKKeyList.get(aIndexCount).setBackgroundDrawable(aCharaterButtonDrawable);
                this.mXKKeyList.get(aIndexCount).setClickedImageID(aClickedQwertyImageIDs[aRealIndex]);
                this.mXKKeyList.get(aIndexCount).setContentDescription(this.mXKKeypadIndexText[aRealTextIndex]);
                ++aRealIndex;
                ++aRealTextIndex;
            }
            ++aIndexCount;
        }
    }

    private void setSymbolButtonImages() {
        int aIndexCount = 0;
        int aRealIndex = 0;
        int aRealTextIndex = 0;
        int aStartIndex = 0;
        int aEndIndex = 0;
        int[] aSymbolImageIDs = null;
        int[] aClickedSymbolImageIDs = null;
        Drawable aSymbolButtonDrawable = null;
        Drawable aBlankDrawable = null;
        if (this.mSymbolMode) {
            aStartIndex = this.mAddSymbolCount;
            aEndIndex = 42 + this.mAddSymbolCount;
        } else {
            aRealIndex = 0;
            aStartIndex = 0;
            aEndIndex = this.mAddSymbolCount;
        }
        aRealTextIndex = 62 + aRealIndex;
        aSymbolImageIDs = this.mXKKeypadResources.getSymbolImageIDs();
        aClickedSymbolImageIDs = this.mXKKeypadResources.getClickedSymbolImageIDs();
        aIndexCount = aStartIndex;
        while (aIndexCount < aEndIndex) {
            this.mXKKeyList.get(aIndexCount).setSymbolMode(this.mSymbolMode);
            if (this.mXKKeyList.get(aIndexCount).getIndex() == -1) {
                aBlankDrawable = this.mXKBlankLogoImage != null ? this.mXKBlankLogoImage : this.resizeBackgroundImage(this.mXKKeypadResources.getBlankImageID(), this.mXKKeyWidth, this.mXKKeyHeight);
                if (aBlankDrawable == null) {
                    this.mXKKeyList.get(aIndexCount).setWidth(this.mXKKeyWidth);
                    this.mXKKeyList.get(aIndexCount).setHeight(this.mXKKeyHeight);
                }
                this.mXKKeyList.get(aIndexCount).setBackgroundDrawable(aBlankDrawable);
                this.mXKKeyList.get(aIndexCount).setContentDescription(null);
            } else {
                aSymbolButtonDrawable = this.resizeBackgroundImage(aSymbolImageIDs[aRealIndex], this.mXKKeyWidth, this.mXKKeyHeight);
                this.mXKKeyList.get(aIndexCount).setBackgroundDrawable(aSymbolButtonDrawable);
                this.mXKKeyList.get(aIndexCount).setClickedImageID(aClickedSymbolImageIDs[aRealIndex]);
                this.mXKKeyList.get(aIndexCount).setContentDescription(this.mXKKeypadIndexText[aRealTextIndex]);
                ++aRealIndex;
                ++aRealTextIndex;
            }
            ++aIndexCount;
        }
    }

    private void setFunctionButtonImages() {
        int aFunctionButtonWidth = 0;
        Drawable aFunctionButtonDrawable = null;
        aFunctionButtonWidth = this.mXKKeyWidth * 2 + this.mXKKeyWidthMargin;
        aFunctionButtonDrawable = this.resizeBackgroundImage(this.mXKKeypadResources.getRefreshImageID(), aFunctionButtonWidth, this.mXKKeyHeight);
        this.mRefreshButton.setBackgroundDrawable(aFunctionButtonDrawable);
        this.mRefreshButton.setContentDescription("\ub9ac\ud504\ub808\uc26c");
        aFunctionButtonDrawable = this.resizeBackgroundImage(this.mXKKeypadResources.getSymbolImageID(), aFunctionButtonWidth, this.mXKKeyHeight);
        this.mSymbolButton.setBackgroundDrawable(aFunctionButtonDrawable);
        this.mSymbolButton.setContentDescription("\ud2b9\uc218\ubb38\uc790 \uc804\ud658");
        aFunctionButtonWidth = this.mXKKeyWidth * 3 + this.mXKKeyWidthMargin * 2;
        aFunctionButtonDrawable = this.resizeBackgroundImage(this.mXKKeypadResources.getCloseImageID(), aFunctionButtonWidth, this.mXKKeyHeight);
        this.mCompleteButton.setBackgroundDrawable(aFunctionButtonDrawable);
        this.mCompleteButton.setContentDescription("\uc5d4\ud130");
        aFunctionButtonWidth = this.mXKKeyWidth * 4 + this.mXKKeyWidthMargin * 3;
        aFunctionButtonDrawable = this.resizeBackgroundImage(this.mXKKeypadResources.getSpaceImageID(), aFunctionButtonWidth, this.mXKKeyHeight);
        this.mXKKeyList.get(42 + this.mAddSymbolCount).setBackgroundDrawable(aFunctionButtonDrawable);
        this.mXKKeyList.get(42 + this.mAddSymbolCount).setClickedImageID(this.mXKKeypadResources.getClickedSpaceImageID());
        this.mXKKeyList.get(42 + this.mAddSymbolCount).setContentDescription("\uc2a4\ud398\uc774\uc2a4");
        aFunctionButtonDrawable = this.resizeBackgroundImage(this.mXKKeypadResources.getShiftImageID(), this.mXKKeyWidth, this.mXKKeyHeight);
        this.mShiftButton.setBackgroundDrawable(aFunctionButtonDrawable);
        this.mShiftButton.setContentDescription("\ub300\uc18c\ubb38\uc790 \uc804\ud658");
        aFunctionButtonDrawable = this.resizeBackgroundImage(this.mXKKeypadResources.getDeleteImageID(), this.mXKKeyWidth, this.mXKKeyHeight);
        this.mDeleteButton.setBackgroundDrawable(aFunctionButtonDrawable);
        this.mDeleteButton.setContentDescription("\ubc31\uc2a4\ud398\uc774\uc2a4");
    }

    private Drawable resizeBackgroundImage(int pImageID, int pWidth, int pHeight) {
        Bitmap aBitmapImage = null;
        Bitmap aResizedBitmap = null;
        BitmapFactory.Options aBitmapOption = null;
        BitmapDrawable aResizedDrawable = null;
        try {
            aBitmapOption = new BitmapFactory.Options();
            aBitmapOption.inPreferredConfig = Bitmap.Config.ARGB_8888;
            aBitmapImage = BitmapFactory.decodeResource((Resources)this.mActivity.getResources(), (int)pImageID, (BitmapFactory.Options)aBitmapOption);
            aResizedBitmap = Bitmap.createScaledBitmap((Bitmap)aBitmapImage, (int)pWidth, (int)pHeight, (boolean)true);
            aResizedDrawable = new BitmapDrawable(this.mActivity.getResources(), aResizedBitmap);
        }
        catch (NullPointerException aException) {
            aResizedDrawable = null;
        }
        return aResizedDrawable;
    }

    public int makeXKKeypadIndex() {
        int aResult = 0;
        int aXKType = 0;
        int aXKKeypadIndexLength = 0;
        String aE2EURL = null;
        aXKKeypadIndexLength = 95;
        this.mXKKeypadIndex = new int[aXKKeypadIndexLength];
        aE2EURL = this.mXKEditText.getE2EURL();
        aResult = aE2EURL != null ? this.mXKKeypadInterface.makeIndexE2E(this.mXKKeypadIndex, aXKKeypadIndexLength, aXKType, aE2EURL) : this.mXKKeypadInterface.makeIndex(this.mXKKeypadIndex, aXKKeypadIndexLength, aXKType);
        this.setQwertySymbolKeyIndex(this.mXKKeypadIndex);
        this.mXKKeypadIndexText = new String[aXKKeypadIndexLength];
        aResult = this.mXKKeypadInterface.getIndexText(this.mXKKeypadIndexText, aXKKeypadIndexLength, aXKType);
        return aResult;
    }

    private void setQwertySymbolKeyIndex(int[] pKeyIndex) {
        int aKeyCount = 0;
        int aKeyTotalCount = 0;
        int aAddBlankCount = 0;
        int aBlankIndex = 0;
        int aRealIndex = 0;
        int aAddSymbolRealIndex = 0;
        int aAddNumberRealIndex = 0;
        int aSymbolRealIndex = 0;
        int aIndex = 0;
        int aShiftOffIndex = 0;
        int aSymbolIndex = 0;
        int[] aQwertyBlankIndex = null;
        int[] aSymbolBlankIndex = null;
        aAddSymbolRealIndex = 62;
        aAddBlankCount = 1;
        aQwertyBlankIndex = new int[6 + aAddBlankCount];
        aSymbolBlankIndex = new int[11];
        aKeyCount = 0;
        while (aKeyCount < this.mXKKeyList.size()) {
            this.mXKKeyList.get(aKeyCount).initKeyButton();
            ++aKeyCount;
        }
        this.mXKKeypadInterface.initRandom();
        this.setBlankIndex(aQwertyBlankIndex, 0, 10, aBlankIndex, aAddBlankCount);
        this.setBlankIndex(aQwertyBlankIndex, 11, 21, aBlankIndex += aAddBlankCount, 1);
        this.setBlankIndex(aQwertyBlankIndex, 22, 32, ++aBlankIndex, 1);
        this.setBlankIndex(aQwertyBlankIndex, 33, 43, ++aBlankIndex, 2);
        this.setBlankIndex(aQwertyBlankIndex, 44, 52, aBlankIndex += 2, 2);
        aSymbolBlankIndex[0] = this.mXKKeypadInterface.getRandom(0, 10);
        aSymbolBlankIndex[1] = this.mXKKeypadInterface.getRandom(11, 21);
        aSymbolBlankIndex[2] = this.mXKKeypadInterface.getRandom(22, 32);
        do {
            aSymbolBlankIndex[3] = this.mXKKeypadInterface.getRandom(22, 32);
        } while (aSymbolBlankIndex[3] == aSymbolBlankIndex[2]);
        do {
            aSymbolBlankIndex[4] = this.mXKKeypadInterface.getRandom(22, 32);
        } while (aSymbolBlankIndex[4] == aSymbolBlankIndex[2] || aSymbolBlankIndex[4] == aSymbolBlankIndex[3]);
        aSymbolBlankIndex[5] = this.mXKKeypadInterface.getRandom(33, 43);
        do {
            aSymbolBlankIndex[6] = this.mXKKeypadInterface.getRandom(33, 43);
        } while (aSymbolBlankIndex[6] == aSymbolBlankIndex[5]);
        do {
            aSymbolBlankIndex[7] = this.mXKKeypadInterface.getRandom(33, 43);
        } while (aSymbolBlankIndex[7] == aSymbolBlankIndex[5] || aSymbolBlankIndex[7] == aSymbolBlankIndex[6]);
        aSymbolBlankIndex[8] = this.mXKKeypadInterface.getRandom(44, 52);
        do {
            aSymbolBlankIndex[9] = this.mXKKeypadInterface.getRandom(44, 52);
        } while (aSymbolBlankIndex[9] == aSymbolBlankIndex[8]);
        do {
            aSymbolBlankIndex[10] = this.mXKKeypadInterface.getRandom(44, 52);
        } while (aSymbolBlankIndex[10] == aSymbolBlankIndex[8] || aSymbolBlankIndex[10] == aSymbolBlankIndex[9]);
        aSymbolRealIndex = 62;
        aKeyTotalCount = 42 + this.mAddSymbolCount + 1;
        aKeyCount = 0;
        while (aKeyCount < aKeyTotalCount) {
            if (this.isBlankIndex(aQwertyBlankIndex, 6 + aAddBlankCount, aKeyCount)) {
                aIndex = -1;
                aShiftOffIndex = -1;
            } else if (aKeyCount == 42 + this.mAddSymbolCount) {
                aIndex = pKeyIndex[aSymbolRealIndex];
            } else if (aKeyCount < this.mAddSymbolCount) {
                aIndex = pKeyIndex[aAddSymbolRealIndex];
                aShiftOffIndex = pKeyIndex[aAddSymbolRealIndex];
                ++aAddSymbolRealIndex;
            } else {
                aIndex = pKeyIndex[aRealIndex];
                aShiftOffIndex = pKeyIndex[aRealIndex + 26];
                ++aRealIndex;
            }
            if (this.isBlankIndex(aSymbolBlankIndex, 11, aKeyCount)) {
                aSymbolIndex = -1;
            } else if (aKeyCount < this.mAddSymbolCount) {
                aSymbolIndex = pKeyIndex[aAddNumberRealIndex];
                ++aAddNumberRealIndex;
            } else {
                aSymbolIndex = pKeyIndex[aSymbolRealIndex];
                ++aSymbolRealIndex;
            }
            this.mXKKeyList.get(aKeyCount).setIndex(aIndex, aShiftOffIndex, aSymbolIndex);
            ++aKeyCount;
        }
    }

    private void setBlankIndex(int[] pBlankIndexArray, int pStartNumber, int pEndNumber, int pStartIndex, int pCount) {
        int aIndexCount = 0;
        int aRandomNumber = 0;
        ArrayList<Integer> aBlankIdexArray = null;
        aBlankIdexArray = new ArrayList<Integer>();
        aIndexCount = 0;
        while (aIndexCount < pCount) {
            while (aBlankIdexArray.indexOf(aRandomNumber = this.mXKKeypadInterface.getRandom(pStartNumber, pEndNumber)) != -1) {
            }
            aBlankIdexArray.add(aRandomNumber);
            ++aIndexCount;
        }
        aIndexCount = 0;
        while (aIndexCount < pCount) {
            pBlankIndexArray[pStartIndex + aIndexCount] = (Integer)aBlankIdexArray.get(aIndexCount);
            ++aIndexCount;
        }
    }

    public void changeConfiguration() {
        int aDeviceHeight = 0;
        int aDeviceWidth = 0;
        int aHeightPercent = 0;
        int aXKKeypadHeight = 0;
        int aXKKeypadWidth = 0;
        int aIndexCount = 0;
        int aRowCount = 0;
        float aWidthMarginPercent = 0.0f;
        float aHeightMarginPercent = 0.0f;
        LinearLayout aKeypadRowLayout = null;
        DisplayMetrics aDisplayMetrics = null;
        LinearLayout.LayoutParams aXKButtonLayoutParams = null;
        RelativeLayout.LayoutParams aRowLayoutParams = null;
        aWidthMarginPercent = 1.0f;
        aHeightMarginPercent = 0.5f;
        aHeightPercent = 45;
        aDisplayMetrics = new DisplayMetrics();
        this.mActivity.getWindowManager().getDefaultDisplay().getMetrics(aDisplayMetrics);
        aDeviceWidth = aDisplayMetrics.widthPixels;
        aDeviceHeight = aDisplayMetrics.heightPixels;
        this.mXKKeyWidthMargin = (int)((float)aDeviceWidth * aWidthMarginPercent) / 100;
        this.mXKKeyHeightMargin = (int)((float)aDeviceHeight * aHeightMarginPercent) / 100;
        this.mXKKeypadHeight = aXKKeypadHeight = aDeviceHeight * aHeightPercent / 100;
        this.mXKKeyHeight = (aXKKeypadHeight -= (this.mKeypadRowCount + 1) * this.mXKKeyHeightMargin) / this.mKeypadRowCount;
        aXKKeypadWidth = aDeviceWidth - (this.mKeypadColumnCount + 1) * this.mXKKeyWidthMargin;
        this.mXKKeyWidth = aXKKeypadWidth / this.mKeypadColumnCount;
        aRowCount = 0;
        while (aRowCount < this.mKeypadLayoutList.size()) {
            aKeypadRowLayout = this.mKeypadLayoutList.get(aRowCount);
            aRowLayoutParams = (RelativeLayout.LayoutParams)aKeypadRowLayout.getLayoutParams();
            aRowLayoutParams.topMargin = this.mXKKeyHeightMargin;
            aKeypadRowLayout.setLayoutParams((ViewGroup.LayoutParams)aRowLayoutParams);
            if (aRowCount == this.mKeypadRowCount - 1) {
                aKeypadRowLayout.setPadding(this.mXKKeyWidthMargin, 0, this.mXKKeyWidthMargin, this.mXKKeyHeightMargin);
            } else {
                aKeypadRowLayout.setPadding(this.mXKKeyWidthMargin, 0, this.mXKKeyWidthMargin, 0);
            }
            ++aRowCount;
        }
        aIndexCount = 0;
        while (aIndexCount < this.mXKKeyList.size()) {
            aXKButtonLayoutParams = (LinearLayout.LayoutParams)this.mXKKeyList.get(aIndexCount).getLayoutParams();
            aXKButtonLayoutParams.height = this.mXKKeyHeight;
            aXKButtonLayoutParams.leftMargin = aIndexCount % this.mKeypadColumnCount == 0 || aIndexCount == 42 + this.mAddSymbolCount ? 0 : this.mXKKeyWidthMargin;
            this.mXKKeyList.get(aIndexCount).setLayoutParams((ViewGroup.LayoutParams)aXKButtonLayoutParams);
            ++aIndexCount;
        }
        aXKButtonLayoutParams = (LinearLayout.LayoutParams)this.mRefreshButton.getLayoutParams();
        aXKButtonLayoutParams.height = this.mXKKeyHeight;
        aXKButtonLayoutParams.rightMargin = this.mXKKeyWidthMargin;
        this.mRefreshButton.setLayoutParams((ViewGroup.LayoutParams)aXKButtonLayoutParams);
        aXKButtonLayoutParams = (LinearLayout.LayoutParams)this.mShiftButton.getLayoutParams();
        aXKButtonLayoutParams.height = this.mXKKeyHeight;
        aXKButtonLayoutParams.rightMargin = this.mXKKeyWidthMargin;
        this.mShiftButton.setLayoutParams((ViewGroup.LayoutParams)aXKButtonLayoutParams);
        aXKButtonLayoutParams = (LinearLayout.LayoutParams)this.mSymbolButton.getLayoutParams();
        aXKButtonLayoutParams.height = this.mXKKeyHeight;
        aXKButtonLayoutParams.rightMargin = this.mXKKeyWidthMargin;
        this.mSymbolButton.setLayoutParams((ViewGroup.LayoutParams)aXKButtonLayoutParams);
        aXKButtonLayoutParams = (LinearLayout.LayoutParams)this.mDeleteButton.getLayoutParams();
        aXKButtonLayoutParams.height = this.mXKKeyHeight;
        aXKButtonLayoutParams.leftMargin = this.mXKKeyWidthMargin;
        this.mDeleteButton.setLayoutParams((ViewGroup.LayoutParams)aXKButtonLayoutParams);
        aXKButtonLayoutParams = (LinearLayout.LayoutParams)this.mCompleteButton.getLayoutParams();
        aXKButtonLayoutParams.height = this.mXKKeyHeight;
        aXKButtonLayoutParams.leftMargin = this.mXKKeyWidthMargin;
        this.mCompleteButton.setLayoutParams((ViewGroup.LayoutParams)aXKButtonLayoutParams);
        this.setXKKeypadButtonImage();
    }

    private boolean isBlankIndex(int[] aBlankIndexArray, int aArrayLength, int aValue) {
        boolean aIsBlank = false;
        int aBlankIndexCount = 0;
        aBlankIndexCount = 0;
        while (aBlankIndexCount < aArrayLength) {
            if (aBlankIndexArray[aBlankIndexCount] == aValue) {
                aIsBlank = true;
                break;
            }
            ++aBlankIndexCount;
        }
        return aIsBlank;
    }

    public int getXKKeypadHeight() {
        return this.mXKKeypadHeight;
    }

    public ArrayList<LinearLayout> getXKKeypadLayoutList() {
        return this.mKeypadLayoutList;
    }

    public void setXKEditText(XKEditText pXKEditText) {
        this.mXKEditText = pXKEditText;
    }

    public void setXKEditText(XKEditText pXKEditText, EditText pDummyEditText) {
        this.mXKEditText = pXKEditText;
        this.mDummyEditText = pDummyEditText;
    }

    public void setXKCoreWrapper(XKCoreWrapper pXKCoreWrapper) {
        this.mXKCoreWrapper = pXKCoreWrapper;
    }

    public void setXKBlankLogoImage(Drawable pXKBlankLogoImage) {
        this.mXKBlankLogoImage = pXKBlankLogoImage;
    }
}

