/*
 * Decompiled with CFR 0.152.
 */
package com.google.gson;

import com.google.gson.JsonElement;
import com.google.gson.internal.$Gson$Preconditions;
import com.google.gson.internal.LazilyParsedNumber;
import java.math.BigDecimal;
import java.math.BigInteger;

public final class JsonPrimitive
extends JsonElement {
    private static final Class<?>[] a = new Class[]{Integer.TYPE, Long.TYPE, Short.TYPE, Float.TYPE, Double.TYPE, Byte.TYPE, Boolean.TYPE, Character.TYPE, Integer.class, Long.class, Short.class, Float.class, Double.class, Byte.class, Boolean.class, Character.class};
    private Object b;

    public JsonPrimitive(Boolean bool) {
        this.a(bool);
    }

    public JsonPrimitive(Number number) {
        this.a(number);
    }

    public JsonPrimitive(String string) {
        this.a(string);
    }

    public JsonPrimitive(Character c2) {
        this.a(c2);
    }

    JsonPrimitive(Object primitive) {
        this.a(primitive);
    }

    void a(Object primitive) {
        if (primitive instanceof Character) {
            char c2 = ((Character)primitive).charValue();
            this.b = String.valueOf(c2);
        } else {
            $Gson$Preconditions.checkArgument(primitive instanceof Number || JsonPrimitive.b(primitive));
            this.b = primitive;
        }
    }

    public boolean isBoolean() {
        return this.b instanceof Boolean;
    }

    Boolean a() {
        return (Boolean)this.b;
    }

    public boolean getAsBoolean() {
        if (this.isBoolean()) {
            return this.a();
        }
        return Boolean.parseBoolean(this.getAsString());
    }

    public boolean isNumber() {
        return this.b instanceof Number;
    }

    public Number getAsNumber() {
        return this.b instanceof String ? new LazilyParsedNumber((String)this.b) : (Number)this.b;
    }

    public boolean isString() {
        return this.b instanceof String;
    }

    public String getAsString() {
        if (this.isNumber()) {
            return this.getAsNumber().toString();
        }
        if (this.isBoolean()) {
            return this.a().toString();
        }
        return (String)this.b;
    }

    public double getAsDouble() {
        return this.isNumber() ? this.getAsNumber().doubleValue() : Double.parseDouble(this.getAsString());
    }

    public BigDecimal getAsBigDecimal() {
        return this.b instanceof BigDecimal ? (BigDecimal)this.b : new BigDecimal(this.b.toString());
    }

    public BigInteger getAsBigInteger() {
        return this.b instanceof BigInteger ? (BigInteger)this.b : new BigInteger(this.b.toString());
    }

    public float getAsFloat() {
        return this.isNumber() ? this.getAsNumber().floatValue() : Float.parseFloat(this.getAsString());
    }

    public long getAsLong() {
        return this.isNumber() ? this.getAsNumber().longValue() : Long.parseLong(this.getAsString());
    }

    public short getAsShort() {
        return this.isNumber() ? this.getAsNumber().shortValue() : Short.parseShort(this.getAsString());
    }

    public int getAsInt() {
        return this.isNumber() ? this.getAsNumber().intValue() : Integer.parseInt(this.getAsString());
    }

    public byte getAsByte() {
        return this.isNumber() ? this.getAsNumber().byteValue() : Byte.parseByte(this.getAsString());
    }

    public char getAsCharacter() {
        return this.getAsString().charAt(0);
    }

    private static boolean b(Object target) {
        if (target instanceof String) {
            return true;
        }
        Class<?> classOfPrimitive = target.getClass();
        for (Class<?> standardPrimitive : a) {
            if (!standardPrimitive.isAssignableFrom(classOfPrimitive)) continue;
            return true;
        }
        return false;
    }

    public int hashCode() {
        if (this.b == null) {
            return 31;
        }
        if (JsonPrimitive.a(this)) {
            long value = this.getAsNumber().longValue();
            return (int)(value ^ value >>> 32);
        }
        if (this.b instanceof Number) {
            long value = Double.doubleToLongBits(this.getAsNumber().doubleValue());
            return (int)(value ^ value >>> 32);
        }
        return this.b.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        JsonPrimitive other = (JsonPrimitive)obj;
        if (this.b == null) {
            return other.b == null;
        }
        if (JsonPrimitive.a(this) && JsonPrimitive.a(other)) {
            return this.getAsNumber().longValue() == other.getAsNumber().longValue();
        }
        if (this.b instanceof Number && other.b instanceof Number) {
            double b2;
            double a2 = this.getAsNumber().doubleValue();
            return a2 == (b2 = other.getAsNumber().doubleValue()) || Double.isNaN(a2) && Double.isNaN(b2);
        }
        return this.b.equals(other.b);
    }

    private static boolean a(JsonPrimitive primitive) {
        if (primitive.b instanceof Number) {
            Number number = (Number)primitive.b;
            return number instanceof BigInteger || number instanceof Long || number instanceof Integer || number instanceof Short || number instanceof Byte;
        }
        return false;
    }
}

