/*
 * Decompiled with CFR 0.152.
 */
package com.google.gson;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.JsonSyntaxException;
import java.lang.reflect.Type;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class a
implements JsonDeserializer<Date>,
JsonSerializer<Date> {
    private final DateFormat a;
    private final DateFormat b;
    private final DateFormat c;

    a() {
        this(DateFormat.getDateTimeInstance(2, 2, Locale.US), DateFormat.getDateTimeInstance(2, 2));
    }

    a(String datePattern) {
        this(new SimpleDateFormat(datePattern, Locale.US), new SimpleDateFormat(datePattern));
    }

    a(int style) {
        this(DateFormat.getDateInstance(style, Locale.US), DateFormat.getDateInstance(style));
    }

    public a(int dateStyle, int timeStyle) {
        this(DateFormat.getDateTimeInstance(dateStyle, timeStyle, Locale.US), DateFormat.getDateTimeInstance(dateStyle, timeStyle));
    }

    a(DateFormat enUsFormat, DateFormat localFormat) {
        this.a = enUsFormat;
        this.b = localFormat;
        this.c = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'", Locale.US);
        this.c.setTimeZone(TimeZone.getTimeZone("UTC"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JsonElement a(Date src, Type typeOfSrc, JsonSerializationContext context) {
        DateFormat dateFormat = this.b;
        synchronized (dateFormat) {
            String dateFormatAsString = this.a.format(src);
            return new JsonPrimitive(dateFormatAsString);
        }
    }

    public Date a(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        if (!(json instanceof JsonPrimitive)) {
            throw new JsonParseException("The date should be a string value");
        }
        Date date = this.a(json);
        if (typeOfT == Date.class) {
            return date;
        }
        if (typeOfT == Timestamp.class) {
            return new Timestamp(date.getTime());
        }
        if (typeOfT == java.sql.Date.class) {
            return new java.sql.Date(date.getTime());
        }
        throw new IllegalArgumentException(this.getClass() + " cannot deserialize to " + typeOfT);
    }

    private Date a(JsonElement json) {
        DateFormat dateFormat = this.b;
        synchronized (dateFormat) {
            try {
                return this.b.parse(json.getAsString());
            }
            catch (ParseException ignored) {
                try {
                    return this.a.parse(json.getAsString());
                }
                catch (ParseException ignored2) {
                    try {
                        return this.c.parse(json.getAsString());
                    }
                    catch (ParseException e) {
                        throw new JsonSyntaxException(json.getAsString(), e);
                    }
                }
            }
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(a.class.getSimpleName());
        sb.append('(').append(this.b.getClass().getSimpleName()).append(')');
        return sb.toString();
    }

    @Override
    public /* synthetic */ JsonElement serialize(Object x0, Type x1, JsonSerializationContext x2) {
        return this.a((Date)x0, x1, x2);
    }

    @Override
    public /* synthetic */ Object deserialize(JsonElement x0, Type x1, JsonDeserializationContext x2) throws JsonParseException {
        return this.a(x0, x1, x2);
    }
}

