/*
 * Decompiled with CFR 0.152.
 */
package com.google.gson.internal.bind;

import com.google.gson.FieldNamingStrategy;
import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.internal.$Gson$Types;
import com.google.gson.internal.ConstructorConstructor;
import com.google.gson.internal.Excluder;
import com.google.gson.internal.ObjectConstructor;
import com.google.gson.internal.Primitives;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.util.LinkedHashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ReflectiveTypeAdapterFactory
implements TypeAdapterFactory {
    private final ConstructorConstructor a;
    private final FieldNamingStrategy b;
    private final Excluder c;

    public ReflectiveTypeAdapterFactory(ConstructorConstructor constructorConstructor, FieldNamingStrategy fieldNamingPolicy, Excluder excluder) {
        this.a = constructorConstructor;
        this.b = fieldNamingPolicy;
        this.c = excluder;
    }

    public boolean excludeField(Field f, boolean serialize) {
        return !this.c.excludeClass(f.getType(), serialize) && !this.c.excludeField(f, serialize);
    }

    private String a(Field f) {
        SerializedName serializedName = f.getAnnotation(SerializedName.class);
        return serializedName == null ? this.b.translateName(f) : serializedName.value();
    }

    @Override
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
        Class<T> raw = type.getRawType();
        if (!Object.class.isAssignableFrom(raw)) {
            return null;
        }
        ObjectConstructor<T> constructor = this.a.getConstructor(type);
        return new Adapter(constructor, this.a(gson, type, raw));
    }

    private a a(final Gson context, final Field field, String name, final TypeToken<?> fieldType, boolean serialize, boolean deserialize) {
        final boolean isPrimitive = Primitives.isPrimitive(fieldType.getRawType());
        return new a(name, serialize, deserialize){
            final TypeAdapter<?> a;
            {
                super(x0, x1, x2);
                this.a = context.getAdapter(fieldType);
            }

            void a(JsonWriter writer, Object value) throws IOException, IllegalAccessException {
                Object fieldValue = field.get(value);
                com.google.gson.internal.bind.a t = new com.google.gson.internal.bind.a(context, this.a, fieldType.getType());
                ((TypeAdapter)t).write(writer, fieldValue);
            }

            void a(JsonReader reader, Object value) throws IOException, IllegalAccessException {
                Object fieldValue = this.a.read(reader);
                if (fieldValue != null || !isPrimitive) {
                    field.set(value, fieldValue);
                }
            }
        };
    }

    private Map<String, a> a(Gson context, TypeToken<?> type, Class<?> raw) {
        LinkedHashMap<String, a> result = new LinkedHashMap<String, a>();
        if (raw.isInterface()) {
            return result;
        }
        Type declaredType = type.getType();
        while (raw != Object.class) {
            Field[] fields;
            for (Field field : fields = raw.getDeclaredFields()) {
                boolean serialize = this.excludeField(field, true);
                boolean deserialize = this.excludeField(field, false);
                if (!serialize && !deserialize) continue;
                field.setAccessible(true);
                Type fieldType = $Gson$Types.resolve(type.getType(), raw, field.getGenericType());
                a boundField = this.a(context, field, this.a(field), TypeToken.get(fieldType), serialize, deserialize);
                a previous = result.put(boundField.g, boundField);
                if (previous == null) continue;
                throw new IllegalArgumentException(declaredType + " declares multiple JSON fields named " + previous.g);
            }
            type = TypeToken.get($Gson$Types.resolve(type.getType(), raw, raw.getGenericSuperclass()));
            raw = type.getRawType();
        }
        return result;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public final class Adapter<T>
    extends TypeAdapter<T> {
        private final ObjectConstructor<T> b;
        private final Map<String, a> c;

        private Adapter(ObjectConstructor<T> constructor, Map<String, a> boundFields) {
            this.b = constructor;
            this.c = boundFields;
        }

        @Override
        public T read(JsonReader in) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
                return null;
            }
            T instance = this.b.construct();
            try {
                in.beginObject();
                while (in.hasNext()) {
                    String name = in.nextName();
                    a field = this.c.get(name);
                    if (field == null || !field.i) {
                        in.skipValue();
                        continue;
                    }
                    field.a(in, instance);
                }
            }
            catch (IllegalStateException e) {
                throw new JsonSyntaxException(e);
            }
            catch (IllegalAccessException e) {
                throw new AssertionError((Object)e);
            }
            in.endObject();
            return instance;
        }

        @Override
        public void write(JsonWriter out, T value) throws IOException {
            if (value == null) {
                out.nullValue();
                return;
            }
            out.beginObject();
            try {
                for (a boundField : this.c.values()) {
                    if (!boundField.h) continue;
                    out.name(boundField.g);
                    boundField.a(out, value);
                }
            }
            catch (IllegalAccessException e) {
                throw new AssertionError();
            }
            out.endObject();
        }
    }

    static abstract class a {
        final String g;
        final boolean h;
        final boolean i;

        protected a(String name, boolean serialized, boolean deserialized) {
            this.g = name;
            this.h = serialized;
            this.i = deserialized;
        }

        abstract void a(JsonWriter var1, Object var2) throws IOException, IllegalAccessException;

        abstract void a(JsonReader var1, Object var2) throws IOException, IllegalAccessException;
    }
}

