/*
 * Decompiled with CFR 0.152.
 */
package com.skp.smarttouch.sem.std;

import android.content.Context;
import com.skp.smarttouch.sem.AbstractSEM;
import com.skp.smarttouch.sem.tools.AppletFeatures;
import com.skp.smarttouch.sem.tools.common.STIllegarNopKeyException;
import com.skp.smarttouch.sem.tools.common.STIllegarSmartCardException;
import com.skp.smarttouch.sem.tools.common.STIllegarStateException;
import com.skp.smarttouch.sem.tools.dao.mtouch.MobileTouchCoupon;
import com.skp.smarttouch.sem.tools.dao.mtouch.MobileTouchMembership;
import com.skp.smarttouch.sem.tools.dao.mtouch.MobileTouchTicket;
import com.skp.smarttouch.sem.tools.network.WorkerPoolExecutor;
import java.util.ArrayList;
import java.util.List;
import kr.co.skplanet.utils.LOG;
import kr.co.skplanet.utils.Util;

public class MobileTouch
extends AbstractSEM
implements AppletFeatures {
    public static final String COMPONENT_ID = "STD_MBT";
    private static MobileTouch a = null;
    private a b = null;

    private MobileTouch(Context context, String compId) {
        super(context, compId);
        LOG.info(">> MobileTouch()");
        LOG.info("++ context : [%s]", context);
        LOG.info("++ compId : [%s]", compId);
        this.b = new a();
    }

    public static MobileTouch getInstance(Context context) {
        LOG.info(">> getInstance()");
        LOG.info("++ context : [%s]", context);
        if (a == null) {
            a = new MobileTouch(context, COMPONENT_ID);
        }
        return a;
    }

    @Override
    public void finalize() {
        LOG.info(">> finalize()");
        super.finalize();
    }

    public List<MobileTouchMembership> getMembershipByAll() {
        LOG.info(">> getMembershipByAll()");
        ArrayList<MobileTouchMembership> listMemberships = null;
        try {
            if (this.m_strNopKey == null || this.m_strNopKey.length() < 1) {
                throw new STIllegarNopKeyException("***** invalid nopkey");
            }
            this.a();
            if (WorkerPoolExecutor.getInstance().isWorking()) {
                throw new Exception("***** smartcard is working");
            }
            listMemberships = new ArrayList<MobileTouchMembership>();
            int i = 0;
            while (i < 31) {
                MobileTouchMembership membership = this.a((byte)(i + 1));
                if (membership != null && membership.getAffiliateID() != -1) {
                    listMemberships.add(membership);
                    membership.dumpToLogcat();
                }
                ++i;
            }
        }
        catch (Exception e) {
            LOG.error(e);
        }
        return listMemberships;
    }

    public List<MobileTouchCoupon> getCouponByAll() {
        LOG.info(">> getCouponByAll()");
        List<MobileTouchCoupon> listCoupons = null;
        try {
            if (this.m_strNopKey == null || this.m_strNopKey.length() < 1) {
                throw new STIllegarNopKeyException("***** invalid nopkey");
            }
            this.a();
            if (WorkerPoolExecutor.getInstance().isWorking()) {
                throw new Exception("***** smartcard is working");
            }
            listCoupons = this.a((byte)2, (byte)-1, (byte)-1, (byte)0);
            if (listCoupons != null && listCoupons.size() > 0) {
                for (MobileTouchCoupon c2 : listCoupons) {
                    c2.dumpToLogcat();
                }
            }
        }
        catch (Exception e) {
            LOG.error(e);
            listCoupons = null;
        }
        return listCoupons;
    }

    public List<MobileTouchTicket> getTicketByAll() {
        LOG.info(">> getTicketByAll()");
        List<MobileTouchTicket> listTickets = null;
        try {
            if (this.m_strNopKey == null || this.m_strNopKey.length() < 1) {
                throw new STIllegarNopKeyException("***** invalid nopkey");
            }
            this.a();
            if (WorkerPoolExecutor.getInstance().isWorking()) {
                throw new Exception("***** smartcard is working");
            }
            listTickets = this.b((byte)2, (byte)-1, (byte)-1, (byte)0);
            if (listTickets != null && listTickets.size() > 0) {
                for (MobileTouchTicket t : listTickets) {
                    t.dumpToLogcat();
                }
            }
        }
        catch (Exception e) {
            LOG.error(e);
            listTickets = null;
        }
        return listTickets;
    }

    private void a() throws Exception {
        LOG.info(">> beforeExecute()");
        if (this.m_oGlobalRepository == null) {
            throw new STIllegarStateException("***** component state is not connected !!");
        }
        this.m_oSmartcard = this.m_oGlobalRepository.getISmartcard();
        if (this.getState() != 50) {
            throw new STIllegarStateException("***** component state is not connected !!");
        }
        if (this.m_oSmartcard == null) {
            throw new STIllegarSmartCardException("***** smartcard is not available !!");
        }
        this.m_oGlobalRepository.checkPermissionComponents(this.getCompID());
    }

    private MobileTouchMembership a(int recordNo) {
        LOG.info(">> processGetMembership()");
        LOG.info("++ recordNo : [%s]", recordNo);
        MobileTouchMembership membership = null;
        byte[] response = null;
        try {
            try {
                if (recordNo < 0) {
                    throw new Exception("##### invalid recordNo #####");
                }
                if (this.m_oSmartcard.connect() < 0) {
                    throw new Exception("[connect] failed");
                }
                response = this.b.a();
                response = this.b.a((byte)12, (byte)recordNo);
                membership = MobileTouchMembership.getParsingMembershipObject(response);
            }
            catch (Exception e) {
                LOG.error(e);
                membership = null;
                if (this.m_oSmartcard != null) {
                    this.m_oSmartcard.disconnect();
                }
            }
        }
        finally {
            if (this.m_oSmartcard != null) {
                this.m_oSmartcard.disconnect();
            }
        }
        return membership;
    }

    private List<MobileTouchCoupon> a(byte p2, byte partnerID, byte affiliateID, byte status) {
        LOG.info(">> processGetCoupon()");
        ArrayList<MobileTouchCoupon> listCoupons = null;
        byte[] response = null;
        try {
            try {
                if (this.m_oSmartcard.connect() <= 0) {
                    throw new Exception("[connect] failed");
                }
                response = this.b.a();
                response = this.b.a((byte)2, p2, partnerID, status, affiliateID);
                listCoupons = new ArrayList<MobileTouchCoupon>();
                byte[] baCouponIdx = new byte[response.length - 2];
                System.arraycopy(response, 0, baCouponIdx, 0, response.length - 2);
                byte[] byArray = baCouponIdx;
                int n = baCouponIdx.length;
                int n2 = 0;
                while (n2 < n) {
                    block12: {
                        MobileTouchCoupon coupon;
                        block13: {
                            byte byCouponIdx;
                            block11: {
                                byCouponIdx = byArray[n2];
                                if (p2 != 0) break block11;
                                if (byCouponIdx == -1) break block12;
                                response = this.b.a((byte)20, byCouponIdx);
                                break block13;
                            }
                            response = this.b.a((byte)20, byCouponIdx);
                        }
                        byte[] baCouponData = new byte[response.length - 2];
                        System.arraycopy(response, 0, baCouponData, 0, response.length - 2);
                        if (baCouponData[0] != -1 && (coupon = MobileTouchCoupon.getParsingCouponObject(baCouponData)) != null) {
                            listCoupons.add(coupon);
                        }
                    }
                    ++n2;
                }
            }
            catch (Exception e) {
                LOG.error(e);
                listCoupons = null;
                if (this.m_oSmartcard != null) {
                    this.m_oSmartcard.disconnect();
                }
            }
        }
        finally {
            if (this.m_oSmartcard != null) {
                this.m_oSmartcard.disconnect();
            }
        }
        return listCoupons;
    }

    private List<MobileTouchTicket> b(byte p2, byte partnerID, byte affiliateID, byte status) {
        LOG.info(">> processGetTicket()");
        LOG.info("++ p2 : [%s]", p2);
        LOG.info("++ partnerID : [%s]", partnerID);
        LOG.info("++ affiliateID : [%s]", affiliateID);
        LOG.info("++ status : [%s]", status);
        ArrayList<MobileTouchTicket> listTickets = null;
        byte[] response = null;
        try {
            try {
                if (this.m_oSmartcard.connect() < 0) {
                    throw new Exception("[connect] failed");
                }
                response = this.b.a();
                response = this.b.a((byte)5, p2, partnerID, status, affiliateID);
                listTickets = new ArrayList<MobileTouchTicket>();
                byte[] baIndexOfTicket = new byte[response.length - 2];
                System.arraycopy(response, 0, baIndexOfTicket, 0, response.length - 2);
                byte[] byArray = baIndexOfTicket;
                int n = baIndexOfTicket.length;
                int n2 = 0;
                while (n2 < n) {
                    block12: {
                        MobileTouchTicket ticket;
                        block13: {
                            byte byTicketIdx;
                            block11: {
                                byTicketIdx = byArray[n2];
                                if (p2 != 0) break block11;
                                if (byTicketIdx == -1) break block12;
                                response = this.b.a((byte)44, byTicketIdx);
                                break block13;
                            }
                            response = this.b.a((byte)44, byTicketIdx);
                        }
                        byte[] baTicketData = new byte[response.length - 2];
                        System.arraycopy(response, 0, baTicketData, 0, response.length - 2);
                        if (baTicketData[0] != -1 && (ticket = MobileTouchTicket.getParsingTicketObject(baTicketData)) != null) {
                            listTickets.add(ticket);
                        }
                    }
                    ++n2;
                }
            }
            catch (Exception e) {
                LOG.error(e);
                if (this.m_oSmartcard != null) {
                    this.m_oSmartcard.disconnect();
                }
            }
        }
        finally {
            if (this.m_oSmartcard != null) {
                this.m_oSmartcard.disconnect();
            }
        }
        return listTickets;
    }

    private class a {
        public static final byte a = 12;
        public static final byte b = 20;
        public static final byte c = 2;
        public static final byte d = 44;
        public static final byte e = 5;

        private a() {
        }

        public byte[] a() throws Exception {
            LOG.info("###########################################################");
            LOG.info("## select ");
            LOG.info("###########################################################");
            byte[] response = MobileTouch.this.m_oSmartcard.cmdSELECT(AID_MOBILETOUCH_SMARTPAY);
            LOG.info("++ response : [%s]", Util.byteArrayToHexString(response));
            if (!MobileTouch.this.m_oSmartcard.isResponseSuccess(response)) {
                throw new Exception("[select] failed");
            }
            return response;
        }

        public byte[] a(byte bySearchSfi, byte p2, byte partnerID, byte status, byte affiliateID) throws Exception {
            LOG.info("###########################################################");
            LOG.info("## searchRecord ");
            LOG.info("###########################################################");
            byte[] cmdRecord = null;
            byte[] response = null;
            switch (p2) {
                case 0: {
                    cmdRecord = new byte[]{-96, -94, bySearchSfi, 0};
                    break;
                }
                case 1: {
                    cmdRecord = new byte[]{-96, -94, bySearchSfi, 1, 1, partnerID};
                    break;
                }
                case 2: {
                    cmdRecord = new byte[]{-96, -94, bySearchSfi, 2, 1, status};
                    break;
                }
                case 3: {
                    cmdRecord = new byte[]{-96, -94, bySearchSfi, 3, 2, partnerID, status};
                    break;
                }
                case 4: {
                    cmdRecord = new byte[]{-96, -94, bySearchSfi, 4, 2, partnerID, affiliateID};
                    break;
                }
                case 5: {
                    cmdRecord = new byte[]{-96, -94, bySearchSfi, 5, 3, partnerID, affiliateID, status};
                }
            }
            response = MobileTouch.this.m_oSmartcard.transmit(cmdRecord);
            if (!MobileTouch.this.m_oSmartcard.isResponseSuccess(response)) {
                throw new Exception("[searchRecord] failed");
            }
            return response;
        }

        public byte[] a(byte byReadSfi, byte byRecordNo) throws Exception {
            LOG.info("###########################################################");
            LOG.info("## Read Record ");
            LOG.info("###########################################################");
            byte[] cmdRecord = null;
            byte[] response = null;
            cmdRecord = new byte[5];
            cmdRecord[0] = 0;
            cmdRecord[1] = -78;
            cmdRecord[2] = byRecordNo;
            cmdRecord[3] = byReadSfi;
            if (byReadSfi == 12) {
                cmdRecord[4] = 44;
            } else if (byReadSfi == 20) {
                cmdRecord[4] = 69;
            } else if (byReadSfi == 44) {
                cmdRecord[4] = 94;
            } else {
                throw new Exception("##### sfi is invalidate #####");
            }
            response = MobileTouch.this.m_oSmartcard.transmit(cmdRecord);
            if (!MobileTouch.this.m_oSmartcard.isResponseSuccess(response)) {
                throw new Exception("[readRecord] failed");
            }
            return response;
        }

        public byte[] a(byte byReadSfi, byte byRecordNo, byte[] baCouponData) throws Exception {
            LOG.info("###########################################################");
            LOG.info("## Update Record ");
            LOG.info("###########################################################");
            byte[] cmdRecord = null;
            byte[] response = null;
            cmdRecord = new byte[74];
            cmdRecord[0] = 0;
            cmdRecord[1] = -36;
            cmdRecord[2] = byRecordNo;
            cmdRecord[3] = byReadSfi;
            if (byReadSfi == 12) {
                cmdRecord[4] = 44;
            } else if (byReadSfi == 20) {
                cmdRecord[4] = 69;
            } else if (byReadSfi == 44) {
                cmdRecord[4] = 94;
            } else {
                throw new Exception("##### sfi is invalidate #####");
            }
            System.arraycopy(baCouponData, 0, cmdRecord, 5, baCouponData.length);
            response = MobileTouch.this.m_oSmartcard.transmit(cmdRecord);
            if (!MobileTouch.this.m_oSmartcard.isResponseSuccess(response)) {
                throw new Exception("[readRecord] failed");
            }
            return response;
        }
    }
}

