/*
 * Decompiled with CFR 0.152.
 */
package com.skp.smarttouch.sem.std;

import android.content.Context;
import com.skp.smarttouch.sem.AbstractSEM;
import com.skp.smarttouch.sem.tools.common.APIResultCode;
import com.skp.smarttouch.sem.tools.common.APITypeCode;
import com.skp.smarttouch.sem.tools.common.STIllegarNopKeyException;
import com.skp.smarttouch.sem.tools.common.STIllegarSmartCardException;
import com.skp.smarttouch.sem.tools.common.STIllegarStateException;
import com.skp.smarttouch.sem.tools.dao.SEMDispatchData;
import com.skp.smarttouch.sem.tools.dao.SEMResultData;
import com.skp.smarttouch.sem.tools.network.AbstractWorker;
import com.skp.smarttouch.sem.tools.network.WorkerPoolExecutor;
import com.skp.smarttouch.sem.tools.smartcard.AbstractSmartcard;
import kr.co.skplanet.utils.BinaryUtil;
import kr.co.skplanet.utils.LOG;
import kr.co.skplanet.utils.Util;

public class MoblieCredit
extends AbstractSEM
implements AbstractWorker.OnWorkerListener {
    public static final String COMPONENT_ID = "STD_MCD";
    private static MoblieCredit a = null;
    private static final byte[] b = new byte[]{50, 80, 65, 89, 46, 83, 89, 83, 46, 68, 68, 70, 48, 49};
    private static final int c = 10;
    public static final byte BYTE_PAYMENT_SYS_NOEXIST = 0;
    public static final byte BYTE_PAYMENT_SYS_EXIST = 15;
    public static final byte BYTE_PAYMENT_SYS_MASTER = -1;
    public static final byte BYTE_TAG_FCI_TEMPLATE = -91;
    private String[] d;
    private String e;
    private int f;
    private byte[][] g = new byte[10][2];

    private MoblieCredit(Context context, String compId) {
        super(context, compId);
        LOG.info(">> Credit()");
        LOG.info("++ context : [%s]", context);
        LOG.info("++ compId : [%s]", compId);
    }

    public static MoblieCredit getInstance(Context context) {
        LOG.info(">> getInstance()");
        LOG.info("++ context : [%s]", context);
        if (a == null) {
            a = new MoblieCredit(context, COMPONENT_ID);
        }
        return a;
    }

    @Override
    public void finalize() {
        LOG.info(">> finalize()");
        super.finalize();
    }

    @Override
    public void onTerminateFromWorker(final APITypeCode api, final APIResultCode result, final Object resultData) {
        LOG.info(">> onTerminateFromWorker()");
        LOG.info(new Object[]{"++ api : [%s]", api});
        LOG.info(new Object[]{"++ result : [%s]", result});
        LOG.info("++ resultData : [%s]", resultData);
        if (this.m_onSEManagerConnection != null) {
            this.m_oHandler.post(new Runnable(){

                @Override
                public void run() {
                    SEMResultData objSEMResultData = SEMResultData.getInstance();
                    objSEMResultData.setType(api);
                    objSEMResultData.setResultCode(result);
                    objSEMResultData.setData(resultData);
                    MoblieCredit.this.m_onSEManagerConnection.onResultAPI(objSEMResultData);
                }
            });
        }
    }

    @Override
    public void onDispatchFromWorker(final APITypeCode api, final String status, final String message) {
        LOG.info(">> onDispatchFromWorker()");
        LOG.info(new Object[]{"++ api : [%s]", api});
        LOG.info("++ status : [%s]", status);
        LOG.info("++ message : [%s]", message);
        if (this.m_onSEManagerConnection != null) {
            this.m_oHandler.post(new Runnable(){

                @Override
                public void run() {
                    SEMDispatchData dispatch = SEMDispatchData.getInstance();
                    dispatch.setType(api);
                    dispatch.setStatus(status);
                    dispatch.setMessage(message);
                    MoblieCredit.this.m_onSEManagerConnection.onDispatchAPI(dispatch);
                }
            });
        }
    }

    public String[] getCreditCards() {
        LOG.info(">> getCreditCards()");
        this.d = null;
        this.e = null;
        byte[] response = null;
        try {
            try {
                if (this.m_strNopKey == null || this.m_strNopKey.length() < 1) {
                    throw new STIllegarNopKeyException("***** invalid nopkey");
                }
                this.a();
                if (WorkerPoolExecutor.getInstance().isWorking()) {
                    throw new Exception("***** smartcard is working");
                }
                if (this.m_oSmartcard.connect() < 0) {
                    throw new Exception("[ smartCard.connect() failed ]");
                }
                response = this.m_oSmartcard.cmdSELECT(b);
                if (response != null) {
                    this.b();
                    int i = 0;
                    while (i < 10) {
                        this.b(this.g[i]);
                        ++i;
                    }
                }
            }
            catch (Exception e) {
                LOG.error(e);
                this.d = null;
                if (this.m_oSmartcard != null) {
                    this.m_oSmartcard.disconnect();
                }
            }
        }
        finally {
            if (this.m_oSmartcard != null) {
                this.m_oSmartcard.disconnect();
            }
        }
        return this.d;
    }

    public String getMainCard() {
        LOG.info(">> getMainCard()");
        this.e = null;
        try {
            try {
                if (this.m_strNopKey == null || this.m_strNopKey.length() < 1) {
                    throw new STIllegarNopKeyException("***** invalid nopkey");
                }
                this.a();
                if (WorkerPoolExecutor.getInstance().isWorking()) {
                    throw new Exception("***** smartcard is working");
                }
                if (this.m_oSmartcard.connect() < 0) {
                    throw new Exception("[ smartCard.connect() failed ]");
                }
                this.a(b);
            }
            catch (Exception e) {
                LOG.error(e);
                this.e = null;
                if (this.m_oSmartcard != null) {
                    this.m_oSmartcard.disconnect();
                }
            }
        }
        finally {
            if (this.m_oSmartcard != null) {
                this.m_oSmartcard.disconnect();
            }
        }
        return this.e;
    }

    public boolean setMainCard(String aid) {
        LOG.info(">> setMainCard()");
        LOG.info("++ aid : [%s]", aid);
        boolean bResult = true;
        try {
            try {
                if (aid == null || aid.length() < 1) {
                    throw new IllegalArgumentException("***** aid is invalid !!");
                }
                if (this.m_strNopKey == null || this.m_strNopKey.length() < 1) {
                    throw new STIllegarNopKeyException("***** invalid nopkey");
                }
                this.a();
                if (WorkerPoolExecutor.getInstance().isWorking()) {
                    throw new Exception("***** smartcard is working");
                }
                if (this.m_oSmartcard.connect() < 0) {
                    throw new Exception("[ smartCard.connect() failed ]");
                }
                this.m_oSmartcard.cmdSELECT(b);
                int ret = this.c(BinaryUtil.parseHexString(aid));
                if (ret != 0) {
                    throw new Exception("[ CreditcardManager::setMainCard : FALSE!!!! ]");
                }
            }
            catch (Exception e) {
                LOG.error(e);
                bResult = false;
                if (this.m_oSmartcard != null) {
                    this.m_oSmartcard.disconnect();
                }
            }
        }
        finally {
            if (this.m_oSmartcard != null) {
                this.m_oSmartcard.disconnect();
            }
        }
        return bResult;
    }

    private void a(String aid) throws Exception {
        LOG.info(">> beforeExecute()");
        this.a();
        this.m_oGlobalRepository.checkPermissionApplets(aid);
    }

    private void a() throws Exception {
        LOG.info(">> beforeExecute()");
        if (this.m_oGlobalRepository == null) {
            throw new STIllegarStateException("***** component state is not connected !!");
        }
        this.m_oSmartcard = this.m_oGlobalRepository.getISmartcard();
        if (this.getState() != 50) {
            throw new STIllegarStateException("***** component state is not connected !!");
        }
        if (this.m_oSmartcard == null) {
            throw new STIllegarSmartCardException("***** smartcard is not available !!");
        }
        this.m_oGlobalRepository.checkPermissionComponents(this.getCompID());
    }

    private boolean a(byte[] aid) {
        LOG.info(">> cmdSELECTandGetMain()");
        LOG.info("++ aid : [%s]", Util.byteArrayToHexString(aid));
        boolean ret = false;
        byte[] response = this.m_oSmartcard.cmdSELECT(aid);
        if (response.length > 27) {
            this.e = BinaryUtil.toHexString(response, 27, response[26]);
            ret = true;
        } else {
            this.e = null;
        }
        return ret;
    }

    private boolean b() {
        LOG.info(">> cmdGETDATAforPaymentSysStatus()");
        boolean ret = false;
        byte[] byArray = new byte[5];
        byArray[1] = -54;
        byArray[2] = 1;
        byArray[4] = 20;
        byte[] cmdGetData = byArray;
        byte[] response = this.m_oSmartcard.transmit(cmdGetData);
        if (this.m_oSmartcard.isResponseSuccess(response)) {
            int idx;
            this.f = 0;
            int i = 0;
            while (i < 10) {
                idx = i * 2 + 1;
                if (response[idx] == 15 || response[idx] == -1) {
                    ++this.f;
                }
                ++i;
            }
            LOG.info("++ mCardCount : [%s]", this.f);
            LOG.info("++ cmdGETDATAforPaymentSysStatus : [%s]", Util.byteArrayToHexString(response));
            this.d = new String[this.f];
            int j = 0;
            while (j < 10) {
                idx = j * 2;
                this.g[j][0] = response[idx];
                this.g[j][1] = response[idx + 1];
                ++j;
            }
            ret = true;
        }
        return ret;
    }

    private boolean b(byte[] status) {
        LOG.info(">> cmdGETDATAforPaymentSysByIndex()");
        LOG.info("++ status : [%s]", Util.byteArrayToHexString(status));
        boolean ret = false;
        if (status[1] == 0) {
            return false;
        }
        int aidIndex = status[0] - 1;
        byte[] byArray = new byte[5];
        byArray[1] = -54;
        byArray[2] = 1;
        byte[] cmdGetDataFirst = byArray;
        byte[] byArray2 = new byte[5];
        byArray2[1] = -54;
        byArray2[2] = 1;
        byte[] cmdGetDataSecond = byArray2;
        cmdGetDataFirst[3] = status[0];
        cmdGetDataSecond[3] = status[0];
        byte[] response = this.m_oSmartcard.transmit(cmdGetDataFirst);
        if (response != null) {
            if (response[0] == 108) {
                cmdGetDataSecond[4] = response[1];
                byte lenRes = cmdGetDataSecond[4];
                LOG.info("++ lenRes : [%s]", lenRes);
                response = this.m_oSmartcard.transmit(cmdGetDataSecond);
                if (response != null) {
                    if (response[lenRes] == AbstractSmartcard.RESULT_SUCCESS[0] && response[lenRes + 1] == AbstractSmartcard.RESULT_SUCCESS[1]) {
                        byte lenAID = response[8];
                        LOG.info("++ lenAID : [%s]", lenAID);
                        LOG.info("++ aidIndex : [%s]", aidIndex);
                        this.d[aidIndex] = "";
                        this.d[aidIndex] = BinaryUtil.toHexString(response, 9, lenAID);
                        LOG.info("++ mCardAids[" + aidIndex + "] SUCCESS!!");
                        if (status[1] == -1) {
                            this.e = this.d[aidIndex];
                            LOG.info("++ mCardAids[" + aidIndex + "] is MAINCARD!!");
                        }
                        ret = true;
                    } else {
                        LOG.info("++ cmdGETDATAforPaymentSysByIndex-2\n" + BinaryUtil.toHexString(response, 0, response.length));
                    }
                }
            } else if (response[0] == -91) {
                byte lenAID = response[8];
                LOG.info("++ lenAID : [%s]", lenAID);
                LOG.info("++ aidIndex : [%s]", aidIndex);
                this.d[aidIndex] = "";
                this.d[aidIndex] = BinaryUtil.toHexString(response, 9, lenAID);
                LOG.info("++ mCardAids[" + aidIndex + "] SUCCESS!!");
                if (status[1] == -1) {
                    this.e = this.d[aidIndex];
                    LOG.info("++ mCardAids[" + aidIndex + "] is MAINCARD!!");
                }
                ret = true;
            } else {
                LOG.info("++ cmdGETDATAforPaymentSysByIndex-1\n" + BinaryUtil.toHexString(response, 0, response.length));
                ret = true;
            }
        }
        return ret;
    }

    private int c(byte[] aid) {
        LOG.info(">> cmdPUTDATAforSetMainCard()");
        LOG.info("++ aid : [%s]", Util.byteArrayToHexString(aid));
        int ret = -8;
        int aidLen = aid.length;
        byte[] cmdPutData = new byte[5 + aidLen];
        cmdPutData[0] = 0;
        cmdPutData[1] = -38;
        cmdPutData[2] = 0;
        cmdPutData[3] = 0;
        cmdPutData[4] = (byte)aidLen;
        int i = 0;
        while (i < aidLen) {
            cmdPutData[5 + i] = aid[i];
            ++i;
        }
        byte[] response = this.m_oSmartcard.transmit(cmdPutData);
        if (response != null) {
            LOG.info("++ cmdPUTDATAforSetMainCard : [%s]", Util.byteArrayToHexString(response));
            if (response[0] == AbstractSmartcard.RESULT_SUCCESS[0] && response[1] == AbstractSmartcard.RESULT_SUCCESS[1]) {
                ret = 0;
            } else if (response[0] == AbstractSmartcard.ERROR_LENGTH[0] && response[1] == AbstractSmartcard.ERROR_LENGTH[1]) {
                ret = -8;
            } else if (response[0] == AbstractSmartcard.ERROR_P1P2[0] && response[1] == AbstractSmartcard.ERROR_P1P2[1]) {
                ret = -8;
            } else if (response[0] == AbstractSmartcard.ERROR_NOT_FOUND_AID[0] && response[1] == AbstractSmartcard.ERROR_NOT_FOUND_AID[1]) {
                ret = -8;
            }
        }
        return ret;
    }
}

