/*
 * Decompiled with CFR 0.152.
 */
package com.skp.smarttouch.sem.tools.smartcard;

import android.content.Context;
import android.os.RemoteException;
import com.skp.smarttouch.sem.tools.smartcard.AbstractSmartcard;
import com.sktelecom.smartcard.ISmartcard;
import java.util.concurrent.Semaphore;
import kr.co.skplanet.utils.LOG;
import kr.co.skplanet.utils.Util;

public class SmartcardPhone
extends AbstractSmartcard {
    private final Semaphore a = new Semaphore(1);

    public SmartcardPhone(Context context, ISmartcard cardService) {
        super(context, cardService);
    }

    @Override
    public void setSmartcard(ISmartcard cardService) {
        super.setSmartcard(cardService);
    }

    public boolean isEnable() {
        boolean bRet = false;
        if (this.mCard != null) {
            bRet = true;
        }
        return bRet;
    }

    @Override
    public int getChannel() {
        int channel = -1;
        if (this.mCard != null) {
            try {
                channel = this.mCard.getChannel();
            }
            catch (RemoteException e) {
                e.printStackTrace();
            }
        }
        return channel;
    }

    @Override
    public byte[] getATR() {
        byte[] atr = null;
        if (this.mCard != null) {
            byte[] buf = new byte[256];
            try {
                int ret = this.mCard.getATR(buf);
                if (ret > 0) {
                    atr = new byte[ret];
                    System.arraycopy(buf, 0, atr, 0, ret);
                }
            }
            catch (RemoteException e) {
                e.printStackTrace();
            }
        }
        return atr;
    }

    @Override
    public int connect() {
        int rCode = 0;
        if (this.mCard == null) {
            LOG.error("connect() fail! : mCard is null!");
            return -3;
        }
        try {
            rCode = this.mCard.connect();
            LOG.verbose("connect() return  " + rCode);
        }
        catch (RemoteException e) {
            LOG.error("connect() Error : " + e.toString());
        }
        if (rCode > 0) {
            try {
                this.a.acquire();
                LOG.debug("connect() =============> semaphore acquire");
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        return rCode;
    }

    @Override
    public int disconnect() {
        int rCode = 0;
        if (this.mCard == null) {
            LOG.error("disconnect() fail! : mCard is null");
            return -3;
        }
        try {
            if (this.getChannel() > 0) {
                LOG.verbose("disconnect() : Channel = " + this.getChannel());
                rCode = this.mCard.disconnect();
                LOG.verbose("disconnect() : return " + rCode);
            } else {
                LOG.verbose("disconnect() : cancel (not connected) ");
            }
        }
        catch (RemoteException e) {
            LOG.verbose("disconnect() Error : " + e.toString());
        }
        this.a.release();
        LOG.debug("disconnect() =============> semaphore release");
        return rCode;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public byte[] transmit(byte[] command) {
        int rCode = -8;
        byte[] tempRes = new byte[258];
        byte[] response = null;
        int channel = -1;
        if (this.mCard == null) {
            LOG.error("transmit() is fail!! : mCard is null!");
            return null;
        }
        if (command == null) {
            LOG.error("transmit() is fail!! : command is null");
            return null;
        }
        if (!this.hasPermissionForSelect(command)) {
            LOG.error("do not have permission to select command !!");
            return null;
        }
        channel = this.getChannel();
        if (channel < 0) {
            return null;
        }
        Util.DumpPacket("Smartcard::transmit", command, command.length);
        command[0] = (byte)(command[0] & 0xFC);
        command[0] = (byte)(command[0] | channel);
        Util.DumpPacket("transmit() command", command, command.length);
        try {
            rCode = this.mCard.transmit(command, tempRes);
            if (rCode <= 0) {
                LOG.error("transmit() error!!! return " + rCode);
                return response;
            }
            if (rCode == 2 && tempRes[0] == 97) {
                byte[] byArray = new byte[5];
                byArray[1] = -64;
                byte[] cmdReadMore = byArray;
                cmdReadMore[4] = tempRes[1];
                Util.MEMSET(tempRes, 0, (byte)0, 258);
                rCode = this.mCard.transmit(cmdReadMore, tempRes);
                if (rCode < 0) {
                    LOG.error("transmit() error!! Fail to read more....(61 xx)");
                    return null;
                }
            }
            response = new byte[rCode];
            System.arraycopy(tempRes, 0, response, 0, rCode);
            Util.DumpPacket("transmit() response", response, response.length);
            return response;
        }
        catch (RemoteException e) {
            LOG.verbose("trasmit() Error : " + e.toString());
        }
        return response;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public byte[] transmit(String compId, byte[] command) {
        LOG.warning(">> transmit()");
        LOG.warning("++ compId : [%s]", compId);
        int rCode = -8;
        byte[] tempRes = new byte[258];
        byte[] response = null;
        int channel = -1;
        if (this.mCard == null) {
            LOG.error("transmit() is fail!! : mCard is null!");
            return null;
        }
        if (command == null) {
            LOG.error("transmit() is fail!! : command is null");
            return null;
        }
        if (!("STD_TRP".equalsIgnoreCase(compId) || "STD_TWR".equalsIgnoreCase(compId) || this.hasPermissionForSelect(command))) {
            LOG.error("do not have permission to select command !!");
            return null;
        }
        channel = this.getChannel();
        if (channel < 0) {
            return null;
        }
        Util.DumpPacket("Smartcard::transmit", command, command.length);
        command[0] = (byte)(command[0] & 0xFC);
        command[0] = (byte)(command[0] | channel);
        Util.DumpPacket("transmit() command", command, command.length);
        try {
            rCode = this.mCard.transmit(command, tempRes);
            if (rCode <= 0) {
                LOG.error("transmit() error!!! return " + rCode);
                return response;
            }
            if (rCode == 2 && tempRes[0] == 97) {
                byte[] byArray = new byte[5];
                byArray[1] = -64;
                byte[] cmdReadMore = byArray;
                cmdReadMore[4] = tempRes[1];
                Util.MEMSET(tempRes, 0, (byte)0, 258);
                rCode = this.mCard.transmit(cmdReadMore, tempRes);
                if (rCode < 0) {
                    LOG.error("transmit() error!! Fail to read more....(61 xx)");
                    return null;
                }
            }
            response = new byte[rCode];
            System.arraycopy(tempRes, 0, response, 0, rCode);
            Util.DumpPacket("transmit() response", response, response.length);
            return response;
        }
        catch (RemoteException e) {
            LOG.verbose("trasmit() Error : " + e.toString());
        }
        return response;
    }

    @Override
    public boolean isResponseSuccess(byte[] res) {
        if (res == null) {
            LOG.error("isResponseSuccess() fail!! : response is null");
            return false;
        }
        int len = res.length;
        byte[] SW = new byte[]{res[len - 2], res[len - 1]};
        Util.DumpPacket("isResponseSuccess", SW, 2);
        return SW[0] == RESULT_SUCCESS[0] && SW[1] == RESULT_SUCCESS[1];
    }

    @Override
    public byte[] cmdSELECT(byte[] aid) {
        int aidLen = aid.length;
        byte[] cmdSelect = new byte[5 + aidLen];
        cmdSelect[0] = 0;
        cmdSelect[1] = -92;
        cmdSelect[2] = 4;
        cmdSelect[3] = 0;
        cmdSelect[4] = (byte)aidLen;
        int i = 0;
        while (i < aidLen) {
            cmdSelect[5 + i] = aid[i];
            ++i;
        }
        return this.transmit(cmdSelect);
    }

    @Override
    public byte[] cmdSELECT(String compId, byte[] aid) {
        int aidLen = aid.length;
        byte[] cmdSelect = new byte[5 + aidLen];
        cmdSelect[0] = 0;
        cmdSelect[1] = -92;
        cmdSelect[2] = 4;
        cmdSelect[3] = 0;
        cmdSelect[4] = (byte)aidLen;
        int i = 0;
        while (i < aidLen) {
            cmdSelect[5 + i] = aid[i];
            ++i;
        }
        return this.transmit(compId, cmdSelect);
    }

    public boolean requestSmartcardStatus() {
        int nCnt = 3;
        while (nCnt > 0) {
            if (this.isEnable()) {
                return true;
            }
            --nCnt;
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        return false;
    }
}

