/*
 * Decompiled with CFR 0.152.
 */
package kr.co.skplanet.utils;

import java.io.UnsupportedEncodingException;

public class StringUtil {
    public static String format(short src, int width) {
        return StringUtil.format(src, width, '0', false);
    }

    public static String format(short src, int width, char fillChar, boolean leftJustify) {
        byte[] b2 = Short.toString(src).getBytes();
        return StringUtil.format(b2, width, fillChar, leftJustify);
    }

    public static String format(int src, int width) {
        return StringUtil.format(src, width, '0', false);
    }

    public static String format(int src, int width, char fillChar, boolean leftJustify) {
        byte[] b2 = Integer.toString(src).getBytes();
        return StringUtil.format(b2, width, fillChar, leftJustify);
    }

    public static String format(float src, int width) {
        return StringUtil.format(src, width, '0', false);
    }

    public static String format(float src, int width, char fillChar, boolean leftJustify) {
        byte[] b2 = Float.toString(src).getBytes();
        return StringUtil.format(b2, width, fillChar, leftJustify);
    }

    public static String format(double src, int width) {
        return StringUtil.format(src, width, '0', false);
    }

    public static String format(double src, int width, char fillChar, boolean leftJustify) {
        byte[] b2 = Double.toString(src).getBytes();
        return StringUtil.format(b2, width, fillChar, leftJustify);
    }

    public static String format(String src, int width) {
        return StringUtil.format(src, width, ' ', true);
    }

    public static String format(String src, int width, String charset) throws UnsupportedEncodingException {
        return StringUtil.format(src, width, ' ', true, charset);
    }

    public static String format(String src, int width, char fillChar, boolean leftJustify) {
        byte[] b2 = null;
        if (src != null) {
            b2 = src.getBytes();
        }
        return StringUtil.format(b2, width, fillChar, leftJustify);
    }

    public static String format(String src, int width, char fillChar, boolean leftJustify, String charset) throws UnsupportedEncodingException {
        byte[] b2 = null;
        if (src != null) {
            b2 = src.getBytes(charset);
        }
        return StringUtil.format(b2, width, fillChar, leftJustify, charset);
    }

    public static String format(byte[] src, int width, char fillChar, boolean leftJustify) {
        byte[] b2 = new byte[width];
        if (src == null) {
            int i = 0;
            while (i < width) {
                b2[i] = (byte)fillChar;
                ++i;
            }
        } else if (leftJustify) {
            int i = 0;
            int j = 0;
            while (i < width) {
                b2[i] = i < src.length ? src[j++] : (byte)fillChar;
                ++i;
            }
        } else {
            int i = 0;
            int j = 0;
            while (i < width) {
                b2[i] = i < width - src.length ? (byte)fillChar : src[j++];
                ++i;
            }
        }
        return new String(b2);
    }

    public static String format(byte[] origin, int start, int width, char fillChar, boolean leftJustify) {
        byte[] b2 = new byte[width];
        byte[] src = new byte[width];
        int len = start + width;
        int k = start;
        int l = 0;
        while (k < len) {
            src[l] = origin[k];
            ++k;
            ++l;
        }
        if (src == null) {
            // empty if block
        }
        if (leftJustify) {
            int i = 0;
            int j = 0;
            while (i < width) {
                b2[i] = i < src.length ? src[j++] : (byte)fillChar;
                ++i;
            }
        } else {
            int i = 0;
            int j = 0;
            while (i < width) {
                b2[i] = i < width - src.length ? (byte)fillChar : src[j++];
                ++i;
            }
        }
        return new String(b2);
    }

    public static String format(byte[] src, int width, char fillChar, boolean leftJustify, String charset) throws UnsupportedEncodingException {
        byte[] b2 = new byte[width];
        if (src == null) {
            int i = 0;
            while (i < width) {
                b2[i] = (byte)fillChar;
                ++i;
            }
        } else if (leftJustify) {
            int i = 0;
            int j = 0;
            while (i < width) {
                b2[i] = i < src.length ? src[j++] : (byte)fillChar;
                ++i;
            }
        } else {
            int i = 0;
            int j = 0;
            while (i < width) {
                b2[i] = i < width - src.length ? (byte)fillChar : src[j++];
                ++i;
            }
        }
        return new String(b2, 0, b2.length, charset);
    }

    public static String trimHan(String src, int size) {
        if (src == null || size <= 0) {
            return "";
        }
        byte[] srcBytes = src.getBytes();
        int len = srcBytes.length;
        if (size >= len) {
            return src;
        }
        byte[] dstBytes = new byte[size];
        int hanCnt = 0;
        int i = 0;
        while (i < size) {
            dstBytes[i] = srcBytes[i];
            if ((dstBytes[i] & 0xFF) > 127) {
                ++hanCnt;
            }
            ++i;
        }
        if (hanCnt % 2 != 0 && (dstBytes[size - 1] & 0xFF) > 127) {
            --size;
        }
        return new String(dstBytes, 0, size);
    }

    public static String dump(byte[] b2, int off, int len) {
        StringBuffer sb = new StringBuffer();
        int line = len / 16 + 1;
        int i = 0;
        while (i < line) {
            String s;
            sb.append(StringUtil.format(Integer.toHexString(i * 16), 8, '0', false));
            sb.append(' ');
            int j = 0;
            while (j < 8) {
                int k = i * 16 + j * 2;
                if (k < len) {
                    s = Integer.toHexString(b2[off + k + 0] & 0xFF);
                    sb.append(StringUtil.format(s, 2, '0', false));
                } else {
                    sb.append("00");
                }
                if (k + 1 < len) {
                    s = Integer.toHexString(b2[off + k + 1] & 0xFF);
                    sb.append(StringUtil.format(s, 2, '0', false));
                } else {
                    sb.append("00");
                }
                sb.append(' ');
                ++j;
            }
            sb.append(' ');
            StringBuffer sb2 = new StringBuffer();
            int j2 = 0;
            while (j2 < 16) {
                int k = i * 16 + j2;
                if (k < len) {
                    char c2 = (char)(b2[off + k] & 0xFF);
                    if (c2 < ' ') {
                        sb2.append('.');
                    } else {
                        sb2.append(c2);
                    }
                } else {
                    sb2.append('.');
                }
                ++j2;
            }
            s = sb2.toString();
            sb.append(s);
            sb.append('\n');
            ++i;
        }
        sb.append(len);
        sb.append('\n');
        return sb.toString();
    }

    public static String dump(byte[] b2, int off, int len, String charset) throws UnsupportedEncodingException {
        StringBuffer sb = new StringBuffer();
        int line = len / 16 + 1;
        int i = 0;
        while (i < line) {
            String s;
            sb.append(StringUtil.format(Integer.toHexString(i * 16), 8, '0', false));
            sb.append(' ');
            int j = 0;
            while (j < 8) {
                int k = i * 16 + j * 2;
                if (k < len) {
                    s = Integer.toHexString(b2[off + k + 0] & 0xFF);
                    sb.append(StringUtil.format(s, 2, '0', false));
                } else {
                    sb.append("00");
                }
                if (k + 1 < len) {
                    s = Integer.toHexString(b2[off + k + 1] & 0xFF);
                    sb.append(StringUtil.format(s, 2, '0', false));
                } else {
                    sb.append("00");
                }
                sb.append(' ');
                ++j;
            }
            sb.append(' ');
            StringBuffer sb2 = new StringBuffer();
            int j2 = 0;
            while (j2 < 16) {
                int k = i * 16 + j2;
                if (k < len) {
                    char c2 = (char)(b2[off + k] & 0xFF);
                    if (c2 < ' ') {
                        sb2.append('.');
                    } else {
                        sb2.append(c2);
                    }
                } else {
                    sb2.append('.');
                }
                ++j2;
            }
            s = new String(sb2.toString().getBytes("8859_1"), charset);
            sb.append(s);
            sb.append('\n');
            ++i;
        }
        sb.append(len);
        sb.append('\n');
        return sb.toString();
    }

    public static int parseInt(String value) {
        if (value == null) {
            return 0;
        }
        String v = "";
        int radix = 10;
        if (value.startsWith("0x") || value.startsWith("0X")) {
            radix = 16;
            v = value.substring(2);
        } else {
            radix = 10;
            v = value;
        }
        return Integer.parseInt(v, radix);
    }

    public static Object toObject(String value, Class clazz) {
        Object ret = null;
        if (value == null) {
            return null;
        }
        if (clazz == String.class) {
            ret = value.trim();
        } else if (clazz == Short.class) {
            ret = new Short(value);
        } else if (clazz == Integer.class) {
            ret = new Integer(value);
        } else if (clazz == Byte.class) {
            ret = Byte.decode(value);
        }
        return ret;
    }

    public static String convertMDN(String mdn) {
        String convertedMdn = mdn.length() == 10 ? String.valueOf(mdn.substring(0, 3)) + "0" + mdn.substring(3) : mdn;
        return convertedMdn;
    }

    public static String nvl(String src) {
        if (src == null) {
            return "";
        }
        return src;
    }

    public static int binaryToDeci(String binaryString) throws Exception {
        int binaryToDeci = 0;
        int index = 1;
        int bit = 0;
        int i = binaryString.length() - 1;
        while (i >= 0) {
            bit = Character.getNumericValue(binaryString.charAt(i));
            if (bit != 0 && bit != 1) {
                throw new Exception("It's not binary");
            }
            binaryToDeci += bit * index;
            index *= 2;
            --i;
        }
        return binaryToDeci;
    }

    public static String deciToHexDeci(int decimal) throws Exception {
        String deciToHexDeci = null;
        try {
            deciToHexDeci = Integer.toHexString(0x100 | decimal).substring(1).toUpperCase();
        }
        catch (Exception e) {
            throw new Exception("It's not decimal To HexaDecimal");
        }
        return deciToHexDeci;
    }

    public static String deciToHexDeci(String decimal) throws Exception {
        StringBuffer deciToHexDeci = new StringBuffer();
        try {
            int dec = decimal.length();
            int i = 0;
            while (i < dec) {
                deciToHexDeci.append(StringUtil.deciToHexDeci(Integer.parseInt((String)decimal.subSequence(i, i + 1))));
                ++i;
            }
        }
        catch (Exception e) {
            throw new Exception("It's not decimal To HexaDecimal");
        }
        return deciToHexDeci.toString();
    }

    public static String getRandomString(int len) {
        int maxlen = String.valueOf(Integer.MAX_VALUE).length();
        if (len > maxlen) {
            len = maxlen;
        }
        int max = Integer.parseInt("999999999".substring(0, len).toString());
        int min = Integer.parseInt("100000000".substring(0, len).toString());
        double d = Math.random();
        int r = (int)(d * (double)(max - min + 1)) + min;
        return String.valueOf(r);
    }

    public static String lPad(String pData, int length) {
        return StringUtil.lPad(pData, length, ' ');
    }

    public static String lPad(String pData, int length, char fillChar) {
        return StringUtil.a(pData, 1, length, fillChar);
    }

    public static String rPad(String pData, int length) {
        return StringUtil.rPad(pData, length, ' ');
    }

    public static String rPad(String pData, int length, char fillChar) {
        return StringUtil.a(pData, 0, length, fillChar);
    }

    private static String a(String data, int align, int fillSize, char fillChar) {
        StringBuffer rtnBuf = new StringBuffer();
        if (data == null) {
            data = "";
        }
        byte[] bytes = null;
        try {
            bytes = data.trim().getBytes("EUC-KR");
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (bytes == null) {
            return "";
        }
        int len = bytes.length;
        if (len < fillSize) {
            if (align == 0) {
                rtnBuf.append(data);
                int i = len;
                while (i < fillSize) {
                    rtnBuf.append(fillChar);
                    ++i;
                }
            } else {
                int i = len;
                while (i < fillSize) {
                    rtnBuf.append(fillChar);
                    ++i;
                }
                rtnBuf.append(data);
            }
        } else if (align == 0) {
            rtnBuf.append(new String(bytes, 0, fillSize));
        } else {
            rtnBuf.append(new String(bytes, len - fillSize, fillSize));
        }
        return rtnBuf.toString();
    }
}

