/*
 * Decompiled with CFR 0.152.
 */
package com.softforum.xecure.keypad;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.view.View;
import android.widget.Button;
import android.widget.ImageView;
import android.widget.TextView;
import android.widget.Toast;
import com.softforum.sample.R;
import com.softforum.xecure.crypto.CertMgr;
import com.softforum.xecure.ui.XTopView;
import com.softforum.xecure.ui.crypto.PKCS11Password;
import com.softforum.xecure.ui.crypto.XecureSmartCertMgrUser;
import com.softforum.xecure.util.EnvironmentConfig;
import com.softforum.xecure.util.XCoreUtil;
import com.softforum.xecure.util.XDetailData;
import com.softforum.xecure.util.XUtil;
import com.softforum.xecurekeypad.XKConstants;
import com.softforum.xecurekeypad.XKEditText;
import java.security.SecureRandom;

public class XecureSmartVerifyVidWithXK
extends Activity {
    public static final int mXecureSmartVerifyVidID = 79000;
    public static final String mMediaIDKey = "xecure_smart_verify_vid_media_id_key";
    public static final String mSelectedCertDataKey = "xecure_smart_verify_vid_data_key";
    private int mMediaID;
    private byte[] m_P_assW_ord = null;
    private byte[] mVid = null;
    private XDetailData mSelectedData;
    private XKEditText m_P_assW_ordTextView = null;
    private XKEditText mVidNumberView = null;
    private String mEncryptedData = null;
    private String mVIDEncryptedData = null;
    private byte[] mRandomValue = new byte[20];
    private XCoreUtil mCoreUtil = new XCoreUtil();

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.crypto_xecure_smart_verify_vid_xk);
        this.mMediaID = this.getIntent().getIntExtra(mMediaIDKey, -1);
        this.mSelectedData = new XDetailData(this.getIntent().getStringArrayExtra(mSelectedCertDataKey), 0);
        if (this.mMediaID == 401) {
            this.findViewById(R.id.password_input_view).setVisibility(8);
        }
        ImageView aIcon = (ImageView)this.findViewById(R.id.icon);
        TextView aMainMsg = (TextView)this.findViewById(R.id.main_msg);
        TextView aSubMsg1 = (TextView)this.findViewById(R.id.sub_msg1);
        TextView aSubMsg2 = (TextView)this.findViewById(R.id.sub_msg2);
        if ("0".equals(this.mSelectedData.getValue(0))) {
            aIcon.setImageResource(R.drawable.cert_state_normal);
        } else if ("1".equals(this.mSelectedData.getValue(0))) {
            aIcon.setImageResource(R.drawable.cert_state_update);
        } else if ("2".equals(this.mSelectedData.getValue(0))) {
            aIcon.setImageResource(R.drawable.cert_state_revoke);
        }
        aMainMsg.setText((CharSequence)XUtil.getCNFromRDN((String)this.mSelectedData.getValue(7)));
        aSubMsg1.setText((CharSequence)(this.mSelectedData.getValue(4) + " : " + this.mSelectedData.getValue(4)));
        aSubMsg2.setText((CharSequence)(this.mSelectedData.getKeyText(4) + " : " + this.mSelectedData.getValue(6)));
        if (EnvironmentConfig.mXecureKeypadEncryptionUsage) {
            SecureRandom sr = new SecureRandom();
            sr.nextBytes(this.mRandomValue);
        }
        this.setKeyPad();
        Button aOKButton = (Button)this.findViewById(R.id.top_right_button);
        aOKButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                XecureSmartVerifyVidWithXK.this.onOKButtonClick(v);
            }
        });
        TextView aSubjectText = (TextView)this.findViewById(R.id.top_subject_text);
        aSubjectText.setFocusableInTouchMode(true);
    }

    private void setKeyPad() {
        int aInputPasswordKeypadType = 0;
        int aInputVidKeypadType = 0;
        int aKeypadViewType = 0;
        this.m_P_assW_ordTextView = (XKEditText)this.findViewById(R.id.password_edittext);
        this.mVidNumberView = (XKEditText)this.findViewById(R.id.vid_edittext);
        if (EnvironmentConfig.mXecureKeypadFullViewUsage) {
            aKeypadViewType = 1;
            this.m_P_assW_ordTextView.setSubTitle("\ube44\ubc00\ubc88\ud638");
            this.mVidNumberView.setSubTitle("\uc8fc\ubbfc\ub4f1\ub85d\ubc88\ud638");
        } else if (EnvironmentConfig.mXecureKeypadNormalViewUsage) {
            aKeypadViewType = 0;
            this.m_P_assW_ordTextView.setLayoutIdentifier(R.id.xk_keypad_root_layout);
            this.mVidNumberView.setLayoutIdentifier(R.id.xk_keypad_root_layout);
        }
        if (aKeypadViewType == 1) {
            this.m_P_assW_ordTextView.setUseInputButton(true);
            this.mVidNumberView.setUseInputButton(true);
            this.m_P_assW_ordTextView.setSubTitle(this.getString(R.string.password));
            this.mVidNumberView.setSubTitle(this.getString(R.string.identification_number));
        }
        aInputPasswordKeypadType = 1;
        aInputVidKeypadType = 0;
        this.m_P_assW_ordTextView.setXKViewType(aKeypadViewType);
        this.m_P_assW_ordTextView.setXKKeypadType(aInputPasswordKeypadType);
        this.mVidNumberView.setXKViewType(aKeypadViewType);
        this.mVidNumberView.setXKKeypadType(aInputVidKeypadType);
        this.mVidNumberView.setXKKeypadMaxLength(13);
    }

    private void onOKButtonClick(View v) {
        int aErrorCode = 0;
        String aSubjectDN = null;
        XTopView aTopView = null;
        CertMgr aCertMgr = CertMgr.getInstance();
        int aVerifyResult = 0;
        aTopView = (XTopView)this.findViewById(R.id.top_view);
        aSubjectDN = this.mSelectedData.getValue(7);
        if (EnvironmentConfig.mXecureKeypadEncryptionUsage) {
            this.mEncryptedData = this.m_P_assW_ordTextView.getEncryptedData(this.mRandomValue);
            this.mVIDEncryptedData = this.mVidNumberView.getEncryptedData(this.mRandomValue);
        } else {
            this.m_P_assW_ord = this.m_P_assW_ordTextView.getData().getBytes();
            this.mVid = this.mVidNumberView.getData().getBytes();
        }
        this.mCoreUtil.resetError();
        if (this.mMediaID != 401) {
            if (EnvironmentConfig.mXecureKeypadEncryptionUsage) {
                if (this.mEncryptedData == null || this.mEncryptedData.length() < 1) {
                    aTopView.setDescription(this.getString(R.string.plugin_input_nothing));
                    return;
                }
            } else if (this.m_P_assW_ord == null || this.m_P_assW_ord.length == 0) {
                aTopView.setDescription(this.getString(R.string.plugin_input_nothing));
                return;
            }
            if (EnvironmentConfig.mXecureKeypadEncryptionUsage) {
                if (this.mEncryptedData != null || this.mEncryptedData.length() != 0) {
                    aVerifyResult = aCertMgr.verifyPassword(this.mMediaID, aSubjectDN, this.mRandomValue, this.mEncryptedData);
                }
            } else {
                aVerifyResult = aCertMgr.verifyPassword(this.mMediaID, 14, aSubjectDN, this.m_P_assW_ord);
            }
            if (aVerifyResult != 0 && (aErrorCode = this.mCoreUtil.lastErrCode()) != 22000015) {
                aTopView.setDescription(this.mCoreUtil.lastErrMsg());
                return;
            }
        }
        if (EnvironmentConfig.mXecureKeypadEncryptionUsage) {
            if (this.mVIDEncryptedData == null || this.mVIDEncryptedData.length() == 0) {
                aTopView.setDescription(this.getString(R.string.xecure_smart_cert_mgr_copy_wrong_vid));
                return;
            }
        } else if (this.mVid == null || this.mVid.length == 0) {
            aTopView.setDescription(this.getString(R.string.xecure_smart_cert_mgr_copy_wrong_vid));
            return;
        }
        if (this.mMediaID == 401) {
            this.startActivityForResult(new Intent((Context)this, PKCS11Password.class), 90000);
        } else {
            this.returnResult();
        }
    }

    private void returnResult() {
        int aResult = 0;
        String aSubjectDN = null;
        Intent aIntent = null;
        CertMgr aCertMgr = CertMgr.getInstance();
        aSubjectDN = this.mSelectedData.getValue(7);
        aIntent = new Intent((Context)this, XecureSmartCertMgrUser.class);
        aResult = EnvironmentConfig.mXecureKeypadEncryptionUsage ? aCertMgr.verifyCertOwner(this.mMediaID, aSubjectDN, this.mRandomValue, this.mEncryptedData, this.mVIDEncryptedData) : aCertMgr.verifyCertOwner(this.mMediaID, 14, aSubjectDN, this.m_P_assW_ord, this.mVid);
        if (aResult == 0) {
            aIntent.putExtra("xecure_smart_cert_mgr_result_key", 0);
            this.setResult(-1, aIntent);
            this.finish();
        } else {
            this.setResult(2, aIntent);
        }
        this.finish();
    }

    public void finish() {
        XUtil.resetByteArray((byte[][])new byte[][]{this.m_P_assW_ord, this.mVid, this.mRandomValue});
        super.finish();
    }

    public void onBackPressed() {
        XUtil.resetByteArray((byte[][])new byte[][]{this.m_P_assW_ord, this.mVid, this.mRandomValue});
        super.onBackPressed();
    }

    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        switch (requestCode) {
            case 90000: {
                if (resultCode == -1) {
                    this.returnResult();
                    break;
                }
                if (resultCode == 100) {
                    this.setResult(resultCode);
                    this.finish();
                    break;
                }
                this.finish();
            }
        }
        if ((requestCode != XKConstants.XKKeypadRequestCode || resultCode != 0) && requestCode == XKConstants.XKKeypadRequestCode && resultCode == 200000) {
            Toast.makeText((Context)this, (CharSequence)"\uc778\ub371\uc2a4 \uc0dd\uc131\uc5d0 \uc2e4\ud328\ud558\uc600\uc2b5\ub2c8\ub2e4.", (int)0).show();
        }
    }
}

