/*
 * Decompiled with CFR 0.152.
 */
package com.softforum.xecure.ui.browser;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.app.AlertDialog;
import android.app.ProgressDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.os.Bundle;
import android.os.Process;
import android.view.KeyEvent;
import android.webkit.CookieManager;
import android.webkit.WebChromeClient;
import android.webkit.WebSettings;
import android.webkit.WebView;
import com.softforum.sample.R;
import com.softforum.xecure.XecureSmart;
import com.softforum.xecure.ui.browser.XNavigator;
import com.softforum.xecure.util.XSLog;
import com.softforum.xecure.util.XUtil;
import com.softforum.xecurecertshare.client.XCSInitialize;
import com.softforum.xecurekeypad.XKCoreWrapperToJni;

public class TBrowser
extends Activity {
    private XecureSmart mXecureSmart;
    private static WebView mWebView;
    private XNavigator mXNavigator;
    ProgressDialog mProgrssBarDialog;
    private boolean mProgressBarTurnedOn = false;
    public static final String mOperationResultKey = "xecure_smart_result_key";
    public static final int mResultForImportCertOK = 2;
    public static final int mResultForImportCertFail = 3;
    public static final int mResultForImportCertCancel = 4;
    public static final int mResultForImportCertCopyFail = 5;
    public static final int mResultForImportCertNotExistSDCard = 6;
    public static final int mResultForImportCertCopyingFail = 7;
    public static final int mResultForImportCertCreateCNumFail = 8;
    public static final int mResultForImportCertConnectionDone = 9;
    public static final int mResultForImportCertWrongVID = 10;
    public static final int mResultForImportCertNetworkError = 11;
    public static final int mResultForExportCertOK = 12;
    public static final int mResultForExportCertFail = 13;
    public static final int mResultForExportCertByXCSOK = 22;
    public static final int mResultForExportCertByXCSFail = 23;
    public static final int mResultForExportCertByXCSCancel = 24;
    public static final int mResultForExportCertByXCSCreateCNumFail = 25;
    public static final int mResultForImportCertByXCSOK = 32;
    public static final int mResultForImportCertByXCSFail = 33;
    public static final int mResultForImportCertByXCSCreateCNumFail = 34;

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.requestWindowFeature(2);
        this.requestWindowFeature(5);
        this.setContentView(R.layout.browser_layout);
        mWebView = (WebView)this.findViewById(R.id.browser);
        this.mXNavigator = (XNavigator)this.findViewById(R.id.xNavigator);
        this.mXNavigator.setWebView(mWebView);
        this.mXecureSmart = XecureSmart.getInstance();
        this.initializeWebView();
        XUtil.initializeXecureCoreConfig((Context)this.getApplicationContext());
        XCSInitialize aXCSInitialize = null;
        try {
            aXCSInitialize = new XCSInitialize();
            aXCSInitialize.setPackageName(this.getPackageName());
            aXCSInitialize.initializeLibrary();
        }
        catch (UnsatisfiedLinkError aLinkError) {
            XSLog.e((String)"[XecureSmart][libXCSAndroid.so load failed.]");
        }
        try {
            XKCoreWrapperToJni.initializeLibrary((Activity)this);
        }
        catch (UnsatisfiedLinkError aLinkError) {
            XSLog.e((String)"[XecureSmart][libXKCore_jni.so load failed.]");
        }
    }

    @SuppressLint(value={"SetJavaScriptEnabled"})
    private void initializeWebView() {
        WebSettings webSettings = mWebView.getSettings();
        webSettings.setDefaultTextEncodingName("MS949");
        webSettings.setJavaScriptEnabled(true);
        webSettings.setBuiltInZoomControls(true);
        mWebView.clearCache(true);
        mWebView.setWebChromeClient((WebChromeClient)new BrowserChromeClient());
        mWebView.addJavascriptInterface((Object)this.mXecureSmart, "XecureWeb");
        this.mXNavigator.getHomeImgBtn().performClick();
    }

    public boolean onKeyDown(int keyCode, KeyEvent event) {
        if (keyCode == 4) {
            this.onBackPressed();
            return true;
        }
        return false;
    }

    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        String aMessage = "";
        int aResultFromThat = -1;
        if (data != null) {
            aResultFromThat = data.getIntExtra(mOperationResultKey, -1);
        }
        if (0 == resultCode) {
            aMessage = this.getString(R.string.requested_task_canceled);
        } else if (aResultFromThat == 2) {
            aMessage = this.getString(R.string.xecure_smart_cert_mgr_copy_ok);
        } else if (aResultFromThat == 3) {
            aMessage = this.getString(R.string.xecure_smart_cert_mgr_copy_fail);
        } else if (aResultFromThat == 4) {
            aMessage = this.getString(R.string.xecure_smart_cert_mgr_copy_cancel);
        } else if (aResultFromThat == 5) {
            aMessage = this.getString(R.string.xecure_smart_cert_mgr_copy_fail);
        } else if (aResultFromThat == 6) {
            aMessage = this.getString(R.string.xecure_smart_cert_mgr_copy_not_exist_sdcard);
        } else if (aResultFromThat == 7) {
            aMessage = this.getString(R.string.xecure_smart_cert_mgr_copy_copying_fail);
        } else if (aResultFromThat == 8) {
            aMessage = this.getString(R.string.xecure_smart_cert_mgr_copy_create_cnum_fail);
        } else if (aResultFromThat == 9) {
            aMessage = this.getString(R.string.xecure_smart_cert_mgr_copy_connection_done);
        } else if (aResultFromThat == 10) {
            aMessage = this.getString(R.string.xecure_smart_cert_mgr_copy_wrong_vid);
        } else if (aResultFromThat == 11) {
            aMessage = this.getString(R.string.xecure_smart_cert_mgr_copy_network_error);
        } else if (aResultFromThat == 12) {
            aMessage = this.getString(R.string.export_certificate_ok);
        } else if (aResultFromThat == 13) {
            aMessage = this.getString(R.string.export_certificate_fail);
        } else if (aResultFromThat == 22) {
            aMessage = this.getString(R.string.export_certificate_ok);
        } else if (aResultFromThat == 23) {
            aMessage = this.getString(R.string.export_certificate_fail);
        } else if (aResultFromThat == 25) {
            aMessage = this.getString(R.string.xecure_smart_cert_mgr_copy_create_cnum_fail);
        }
        if (aMessage.length() > 0) {
            new AlertDialog.Builder((Context)this).setTitle((CharSequence)"\uc54c\ub9bc").setPositiveButton((CharSequence)"\ud655\uc778", null).setMessage((CharSequence)aMessage).show();
        }
    }

    public void onBackPressed() {
        new AlertDialog.Builder((Context)this).setTitle((CharSequence)this.getString(R.string.xbrowser_exit_confirm)).setPositiveButton((CharSequence)this.getString(R.string.xbrowser_exit_yes), new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                CookieManager.getInstance().removeAllCookie();
                XUtil.destroyXecureCore();
                TBrowser.this.finish();
                Process.killProcess((int)Process.myPid());
            }
        }).setNegativeButton((CharSequence)this.getString(R.string.xbrowser_exit_no), null).show();
    }

    private class BrowserChromeClient
    extends WebChromeClient {
        private BrowserChromeClient() {
        }

        public void onProgressChanged(WebView view, int newProgress) {
            super.onProgressChanged(view, newProgress);
            TBrowser.this.setProgress(newProgress * 100);
            if (0 != newProgress && !TBrowser.this.mProgressBarTurnedOn) {
                TBrowser.this.setProgressBarIndeterminateVisibility(true);
                TBrowser.this.mProgressBarTurnedOn = true;
            } else if (100 == newProgress) {
                TBrowser.this.mProgressBarTurnedOn = false;
                TBrowser.this.setProgressBarIndeterminateVisibility(false);
            }
        }
    }
}

