/*
 * Decompiled with CFR 0.152.
 */
package com.softforum.xecure.ui.browser;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.graphics.Bitmap;
import android.net.Uri;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.webkit.MimeTypeMap;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import android.widget.FrameLayout;
import android.widget.ImageButton;
import com.softforum.sample.R;
import com.softforum.xecure.certshare.ImportCertWithCertShare;
import com.softforum.xecure.certshare.SelectExportCertListWithCertShare;
import com.softforum.xecure.keypad.XecureSmartCertMgrInputVIDWithXK;
import com.softforum.xecure.ui.crypto.XecureSmartCertMgr;
import com.softforum.xecure.ui.crypto.XecureSmartCertMgrCopySimple;
import com.softforum.xecure.ui.crypto.XecureSmartCertMgrInputVID;
import com.softforum.xecure.ui.crypto.XecureSmartConfig;
import com.softforum.xecure.ui.crypto.XecureSmartInfo;
import com.softforum.xecure.ui.crypto.XecureSmartSessionList;
import com.softforum.xecure.ui.menu.XSSAPITestMenu;
import com.softforum.xecure.ui.menu.XSlideMenuPanel;
import com.softforum.xecure.ui.transkey.XecureSmartCertMgrInputVIDWithTransKey;
import com.softforum.xecure.util.EnvironmentConfig;
import com.softforum.xecure.yessign.ConnectToYessignApp;
import com.softforum.xecure.yessign.SelectExportCertificateList;
import java.util.ArrayList;

public class XNavigator
extends FrameLayout {
    private WebView mWebView;
    private String mCertUsageInfoURL;
    private String mHomeUrl;
    private FrameLayout mMainFrameLayout;
    private ImageButton mHomeImgBtn;
    private ImageButton mBackwardImgBtn;
    private ImageButton mForwardImgBtn;
    private ImageButton mRefreshImgBtn;
    private ImageButton mClientCSMImgBtn;
    private ImageButton mAPITestImgBtn;
    private ImageButton mCSMMenuSessionImgBtn = null;
    private ImageButton mCSMMenuCertMgrImgBtn = null;
    private ImageButton mCSMMenuConfigImgBtn = null;
    private ImageButton mCSMMenuAboutImgBtn = null;
    private ImageButton mCSMMenuCertCopyImgBtn = null;
    private ImageButton mCSMMenuCertCopySimpleImgBtn = null;
    private ImageButton mCSMMenuCertUsageInfoImgBtn = null;
    private XSlideMenuPanel mXSlideMenuPanel;

    public XNavigator(Context context, AttributeSet attrs) {
        super(context, attrs);
        LayoutInflater aLayoutInflater = (LayoutInflater)this.getContext().getSystemService("layout_inflater");
        this.mMainFrameLayout = (FrameLayout)aLayoutInflater.inflate(R.layout.xnavigator, (ViewGroup)this, false);
        this.addView((View)this.mMainFrameLayout);
        this.mHomeUrl = attrs.getAttributeValue(null, "homeURL");
        if (null == this.mHomeUrl) {
            this.mHomeUrl = "http://reaver.softforum.com/XecureSmart/index.jsp";
        }
        this.mCertUsageInfoURL = attrs.getAttributeValue(null, "certUsageInfoURL");
        if (null == this.mCertUsageInfoURL) {
            this.mCertUsageInfoURL = "";
        }
        this.mHomeImgBtn = (ImageButton)this.mMainFrameLayout.findViewById(R.id.xbrowser_toolbar_home);
        this.mBackwardImgBtn = (ImageButton)this.mMainFrameLayout.findViewById(R.id.xbrowser_toolbar_backward);
        this.mForwardImgBtn = (ImageButton)this.mMainFrameLayout.findViewById(R.id.xbrowser_toolbar_forward);
        this.mRefreshImgBtn = (ImageButton)this.mMainFrameLayout.findViewById(R.id.xbrowser_toolbar_refresh);
        this.mClientCSMImgBtn = (ImageButton)this.mMainFrameLayout.findViewById(R.id.xbrowser_toolbar_client_sm);
        this.mAPITestImgBtn = (ImageButton)this.mMainFrameLayout.findViewById(R.id.xbrowser_toolbar_api_test);
        this.mXSlideMenuPanel = (XSlideMenuPanel)this.mMainFrameLayout.findViewById(R.id.client_sm_panel_menu);
        this.addListeners();
        this.initializeMenuPanel();
    }

    public void setWebView(WebView aWebView) {
        this.mWebView = aWebView;
        this.mWebView.setWebViewClient((WebViewClient)new XBrowserViewClient());
        this.navigateUrl(this.mHomeUrl);
    }

    private void initializeMenuPanel() {
        ArrayList<ImageButton> result = new ArrayList<ImageButton>();
        ImageButton aButton = null;
        int[] aSlideMenuButtons = EnvironmentConfig.mSlideMenuButtons;
        block13: for (int i = 0; i < aSlideMenuButtons.length; ++i) {
            switch (aSlideMenuButtons[i]) {
                case 0: {
                    aButton = this.makeShowSessionInfoBtn();
                    break;
                }
                case 1: {
                    aButton = this.makeShowCertMgrBtn();
                    break;
                }
                case 2: {
                    aButton = this.makeShowInfoBtn();
                    break;
                }
                case 3: {
                    aButton = this.makeShowAboutBtn();
                    break;
                }
                case 10: {
                    aButton = this.makeShowCertCopyBtn();
                    break;
                }
                case 11: {
                    aButton = this.makeShowCertCopySimpleBtn();
                    break;
                }
                case 12: {
                    aButton = this.makeShowCertUsageInfoBtn();
                    break;
                }
                case 13: {
                    aButton = this.makeExportCertificateBtn();
                    break;
                }
                case 14: {
                    aButton = this.makeImportCertificateBtn();
                    break;
                }
                case 15: {
                    aButton = this.makeExportCertWithCertShareBtn();
                    break;
                }
                case 16: {
                    aButton = this.makeImportCertWithCertShareBtn();
                    break;
                }
                default: {
                    continue block13;
                }
            }
            result.add(aButton);
        }
        this.mXSlideMenuPanel.setMenuItems(result);
    }

    private ImageButton makeShowSessionInfoBtn() {
        ImageButton aButton = new ImageButton(this.getContext());
        aButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                XNavigator.this.onShowSessionInfoClick();
            }
        });
        aButton.setBackgroundResource(R.drawable.shape_csm_menu_button_session);
        aButton.setContentDescription((CharSequence)"\uc138\uc158\uc815\ubcf4\ubcf4\uae30");
        aButton.setNextFocusDownId(R.id.xbrowser_toolbar_client_sm);
        this.mCSMMenuSessionImgBtn = aButton;
        return aButton;
    }

    private ImageButton makeShowCertMgrBtn() {
        ImageButton aButton = new ImageButton(this.getContext());
        aButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                XNavigator.this.onCertMgrClick();
            }
        });
        aButton.setBackgroundResource(R.drawable.shape_csm_menu_button_certmgr);
        aButton.setContentDescription((CharSequence)"\uc778\uc99d\uc11c\uad00\ub9ac\uc790");
        aButton.setNextFocusDownId(R.id.xbrowser_toolbar_client_sm);
        this.mCSMMenuCertMgrImgBtn = aButton;
        return aButton;
    }

    private ImageButton makeShowInfoBtn() {
        ImageButton aButton = new ImageButton(this.getContext());
        aButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                XNavigator.this.onConfigClick();
            }
        });
        aButton.setBackgroundResource(R.drawable.shape_csm_menu_button_config);
        aButton.setContentDescription((CharSequence)"\ud658\uacbd\uc124\uc815");
        aButton.setNextFocusDownId(R.id.xbrowser_toolbar_client_sm);
        this.mCSMMenuConfigImgBtn = aButton;
        return aButton;
    }

    private ImageButton makeShowAboutBtn() {
        ImageButton aButton = new ImageButton(this.getContext());
        aButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                XNavigator.this.onXecureSmartInfoClick();
            }
        });
        aButton.setBackgroundResource(R.drawable.shape_csm_menu_button_about);
        aButton.setNextFocusDownId(R.id.xbrowser_toolbar_client_sm);
        this.mCSMMenuAboutImgBtn = aButton;
        return aButton;
    }

    private ImageButton makeShowCertUsageInfoBtn() {
        ImageButton aButton = new ImageButton(this.getContext());
        aButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                XNavigator.this.onCertUsageInfoClick();
            }
        });
        aButton.setBackgroundResource(R.drawable.shape_csm_menu_button_cert_usage_info);
        aButton.setNextFocusDownId(R.id.xbrowser_toolbar_client_sm);
        this.mCSMMenuCertUsageInfoImgBtn = aButton;
        return aButton;
    }

    private ImageButton makeShowCertCopyBtn() {
        ImageButton aButton = new ImageButton(this.getContext());
        aButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                XNavigator.this.onCertCopyClick();
            }
        });
        aButton.setBackgroundResource(R.drawable.shape_csm_menu_button_cert_copy);
        aButton.setContentDescription((CharSequence)"\uc778\uc99d\uc11c\uac00\uc838\uc624\uae30");
        aButton.setNextFocusDownId(R.id.xbrowser_toolbar_client_sm);
        this.mCSMMenuCertCopyImgBtn = aButton;
        return aButton;
    }

    private ImageButton makeShowCertCopySimpleBtn() {
        ImageButton aButton = new ImageButton(this.getContext());
        aButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                XNavigator.this.onCertCopySimpleClick();
            }
        });
        aButton.setBackgroundResource(R.drawable.shape_csm_menu_button_cert_copy_simple);
        aButton.setContentDescription((CharSequence)"\uac04\ud3b8 \uac00\uc838\uc624\uae30");
        aButton.setNextFocusDownId(R.id.xbrowser_toolbar_client_sm);
        this.mCSMMenuCertCopySimpleImgBtn = aButton;
        return aButton;
    }

    private ImageButton makeExportCertificateBtn() {
        ImageButton aButton = new ImageButton(this.getContext());
        aButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                XNavigator.this.onCertExportClick();
            }
        });
        aButton.setBackgroundResource(R.drawable.cert_export_yessign);
        aButton.setContentDescription((CharSequence)"\uc778\uc99d\uc11c \uacf5\uc6a9\uc571\uc73c\ub85c \ub0b4\ubcf4\ub0b4\uae30");
        aButton.setNextFocusDownId(R.id.xbrowser_toolbar_client_sm);
        return aButton;
    }

    private ImageButton makeImportCertificateBtn() {
        ImageButton aButton = new ImageButton(this.getContext());
        aButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                XNavigator.this.onCertImportClick();
            }
        });
        aButton.setBackgroundResource(R.drawable.cert_import_yessign);
        aButton.setContentDescription((CharSequence)"\uc778\uc99d\uc11c \uacf5\uc6a9\uc571\uc73c\ub85c \ubd80\ud130 \uac00\uc838\uc624\uae30");
        aButton.setNextFocusDownId(R.id.xbrowser_toolbar_client_sm);
        return aButton;
    }

    private ImageButton makeExportCertWithCertShareBtn() {
        ImageButton aButton = new ImageButton(this.getContext());
        aButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                XNavigator.this.onCertExportWithCertShareClick();
            }
        });
        aButton.setBackgroundResource(R.drawable.bt_export_certificate);
        aButton.setContentDescription((CharSequence)"PC\ub85c \uc778\uc99d\uc11c \ub0b4\ubcf4\ub0b4\uae30");
        aButton.setNextFocusDownId(R.id.xbrowser_toolbar_client_sm);
        return aButton;
    }

    private ImageButton makeImportCertWithCertShareBtn() {
        ImageButton aButton = new ImageButton(this.getContext());
        aButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                XNavigator.this.onCertImportWithCertShareClick();
            }
        });
        aButton.setBackgroundResource(R.drawable.bt_import_certificate);
        aButton.setContentDescription((CharSequence)"PC\uc5d0\uc11c \uc778\uc99d\uc11c \uac00\uc838\uc624\uae30");
        aButton.setNextFocusDownId(R.id.xbrowser_toolbar_client_sm);
        return aButton;
    }

    private void addListeners() {
        this.mHomeImgBtn.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                XNavigator.this.navigateUrl(XNavigator.this.mHomeUrl);
            }
        });
        this.mBackwardImgBtn.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                XNavigator.this.goBackward();
            }
        });
        this.mForwardImgBtn.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                XNavigator.this.onForward();
            }
        });
        this.mRefreshImgBtn.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                XNavigator.this.onRefresh();
            }
        });
        this.mClientCSMImgBtn.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                XNavigator.this.mClientCSMImgBtn.setNextFocusUpId(R.id.menu_layout);
                XNavigator.this.mXSlideMenuPanel.toggle();
            }
        });
        if (EnvironmentConfig.mUseAPITestMenu) {
            this.mAPITestImgBtn.setVisibility(0);
            this.mAPITestImgBtn.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    XNavigator.this.onAPITestMenu();
                }
            });
        } else {
            this.mAPITestImgBtn.setVisibility(8);
        }
    }

    private void navigateUrl(String url) {
        if (null != url && !"".equals(url.trim())) {
            this.mWebView.loadUrl(url);
        }
    }

    private void goBackward() {
        if (this.mWebView.canGoBack()) {
            this.mWebView.goBack();
        }
    }

    private void onForward() {
        if (this.mWebView.canGoForward()) {
            this.mWebView.goForward();
        }
    }

    private void onRefresh() {
        this.mWebView.reload();
    }

    private void onAPITestMenu() {
        Intent aIntent = null;
        aIntent = new Intent(this.getContext(), XSSAPITestMenu.class);
        this.getContext().startActivity(aIntent);
    }

    private void onShowSessionInfoClick() {
        Intent aIntent = new Intent(this.getContext(), XecureSmartSessionList.class);
        this.getContext().startActivity(aIntent);
        this.mXSlideMenuPanel.hide();
    }

    private void onCertMgrClick() {
        Intent aIntent = new Intent(this.getContext(), XecureSmartCertMgr.class);
        this.getContext().startActivity(aIntent);
        this.mXSlideMenuPanel.hide();
    }

    private void onConfigClick() {
        Intent aIntent = new Intent(this.getContext(), XecureSmartConfig.class);
        this.getContext().startActivity(aIntent);
        this.mXSlideMenuPanel.hide();
    }

    private void onXecureSmartInfoClick() {
        Intent aIntent = new Intent(this.getContext(), XecureSmartInfo.class);
        this.getContext().startActivity(aIntent);
        this.mXSlideMenuPanel.hide();
    }

    private void onCertCopyClick() {
        Intent aIntent = null;
        if (EnvironmentConfig.mBasicKeyUsage) {
            aIntent = new Intent(this.getContext(), XecureSmartCertMgrInputVID.class);
        } else if (EnvironmentConfig.mMTransKeyUsage) {
            aIntent = new Intent(this.getContext(), XecureSmartCertMgrInputVIDWithTransKey.class);
        } else if (EnvironmentConfig.mXecureKeypadFullViewUsage || EnvironmentConfig.mXecureKeypadNormalViewUsage) {
            aIntent = new Intent(this.getContext(), XecureSmartCertMgrInputVIDWithXK.class);
        }
        ((Activity)this.getContext()).startActivityForResult(aIntent, 72600);
        this.mXSlideMenuPanel.hide();
    }

    private void onCertCopySimpleClick() {
        Intent aIntent = null;
        aIntent = new Intent(this.getContext(), XecureSmartCertMgrCopySimple.class);
        ((Activity)this.getContext()).startActivityForResult(aIntent, 72700);
        this.mXSlideMenuPanel.hide();
    }

    private void onCertExportClick() {
        Intent aIntent = null;
        aIntent = new Intent(this.getContext(), SelectExportCertificateList.class);
        aIntent.putExtra("ChoiceAction", 0);
        ((Activity)this.getContext()).startActivityForResult(aIntent, 72800);
        this.mXSlideMenuPanel.hide();
    }

    private void onCertExportWithCertShareClick() {
        Intent aIntent = null;
        aIntent = new Intent(this.getContext(), SelectExportCertListWithCertShare.class);
        ((Activity)this.getContext()).startActivityForResult(aIntent, 72800);
        this.mXSlideMenuPanel.hide();
    }

    private void onCertImportWithCertShareClick() {
        Intent aIntent = null;
        aIntent = new Intent(this.getContext(), ImportCertWithCertShare.class);
        ((Activity)this.getContext()).startActivityForResult(aIntent, 73100);
        this.mXSlideMenuPanel.hide();
    }

    private void onCertImportClick() {
        Intent aIntent = null;
        aIntent = new Intent(this.getContext(), ConnectToYessignApp.class);
        aIntent.putExtra("ChoiceAction", 1);
        ((Activity)this.getContext()).startActivityForResult(aIntent, 73100);
        this.mXSlideMenuPanel.hide();
    }

    private void onCertUsageInfoClick() {
        this.navigateUrl(this.mCertUsageInfoURL);
        this.mXSlideMenuPanel.hide();
    }

    public ImageButton getHomeImgBtn() {
        return this.mHomeImgBtn;
    }

    public ImageButton getCSMMenuSessionImgBtn() {
        return this.mCSMMenuSessionImgBtn;
    }

    public ImageButton getCSMMenuCertMgrImgBtn() {
        return this.mCSMMenuCertMgrImgBtn;
    }

    public ImageButton getClientCSMImgBtn() {
        return this.mClientCSMImgBtn;
    }

    public ImageButton getCSMMenuConfigImgBtn() {
        return this.mCSMMenuConfigImgBtn;
    }

    public ImageButton getCSMMenuAboutImgBtn() {
        return this.mCSMMenuAboutImgBtn;
    }

    public ImageButton getCSMMenuCertCopyImgBtn() {
        return this.mCSMMenuCertCopyImgBtn;
    }

    public ImageButton getCSMMenuCertCopySimpleImgBtn() {
        return this.mCSMMenuCertCopySimpleImgBtn;
    }

    public void setHomeURL(String aHomeURL) {
        if (null != aHomeURL) {
            this.mHomeUrl = aHomeURL;
        }
    }

    public String getCertUsageInfoURL() {
        return this.mCertUsageInfoURL;
    }

    public ImageButton getCSMMenuCertUsageInfoImgBtn() {
        return this.mCSMMenuCertUsageInfoImgBtn;
    }

    public void setCertUsageInfoURL(String aCertUsageInfoURL) {
        if (null != aCertUsageInfoURL) {
            this.mCertUsageInfoURL = aCertUsageInfoURL;
        }
    }

    private class XBrowserViewClient
    extends WebViewClient {
        private Activity mContext;
        private ImageButton mBackwardButton;
        private ImageButton mForwardButton;

        private XBrowserViewClient() {
            this.mContext = (Activity)XNavigator.this.getContext();
            this.mBackwardButton = (ImageButton)this.mContext.findViewById(R.id.xbrowser_toolbar_backward);
            this.mForwardButton = (ImageButton)this.mContext.findViewById(R.id.xbrowser_toolbar_forward);
        }

        public boolean shouldOverrideUrlLoading(WebView view, String url) {
            String mimeType = MimeTypeMap.getSingleton().getMimeTypeFromExtension(MimeTypeMap.getFileExtensionFromUrl((String)url));
            if (null != mimeType && (mimeType.startsWith("video") || mimeType.startsWith("audio")) || url.startsWith("rtsp")) {
                Intent aIntent = new Intent("android.intent.action.VIEW");
                aIntent.setDataAndType(Uri.parse((String)url), mimeType);
                this.mContext.startActivity(aIntent);
            } else {
                view.loadUrl(url);
            }
            return true;
        }

        public void onPageStarted(WebView view, String url, Bitmap favicon) {
            this.updateBackForwardButton(view);
            super.onPageStarted(view, url, favicon);
        }

        public void doUpdateVisitedHistory(WebView view, String url, boolean isReload) {
            this.updateBackForwardButton(view);
            super.doUpdateVisitedHistory(view, url, isReload);
        }

        private void updateBackForwardButton(WebView view) {
            if (view.canGoBack()) {
                this.mBackwardButton.setAlpha(255);
                this.mBackwardButton.setEnabled(true);
            } else {
                this.mBackwardButton.setAlpha(128);
                this.mBackwardButton.setEnabled(false);
            }
            if (view.canGoForward()) {
                this.mForwardButton.setAlpha(255);
                this.mForwardButton.setEnabled(true);
            } else {
                this.mForwardButton.setAlpha(128);
                this.mForwardButton.setEnabled(false);
            }
        }
    }
}

