/*
 * Decompiled with CFR 0.152.
 */
package com.softforum.xecure.ui.crypto;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.widget.TextView;
import com.softforum.sample.R;
import com.softforum.xecure.crypto.CMPMgr;
import com.softforum.xecure.util.BlockerActivityResult;
import com.softforum.xecure.util.BlockerActivityUtil;
import com.softforum.xecure.util.EnvironmentConfig;
import com.softforum.xecure.util.XUtil;

public class CMPProgressDialog
extends Activity {
    public static final int mCMP_REQUEST = 0;
    public static final int mCMP_RENEW = 1;
    public static final int mCMP_REISSUE = 2;
    public static final String mCMPTypeKey = "cmp_type_key";
    public static final String mCAportKey = "ca_port_key";
    public static final String mCAaddrKey = "ca_addr_key";
    public static final String mMediaIDKey = "media_id_key";
    public static final String mCATypeKey = "ca_type_key";
    public static final String mRefNumKey = "ref_num_key";
    public static final String mAuthCodeKey = "auth_code_key";
    public static final String m_P_assW_ordKey = "password_key";
    public static final String mOptionKey = "option_key";
    public static final String mCANameKey = "ca_name_key";
    public static final String mRANameKey = "ra_name_key";
    public static final String mSubjectDNKey = "subject_dn_key";
    public static final String mOldPasswordKey = "old_password_key";
    public static final String mNewPasswordKey = "new_password_key";
    public static final String mRandomValueKey = "random_value_key";
    public static final String mE_ncryptedDataKey = "e_ncrypted_data_key";
    public static final String mNewE_ncryptedDataKey = "new_e_ncrypted_data_key";
    private static int mCMPType;
    private static int mCAport;
    private static String mCAaddr;
    private static int mMediaID;
    private static int mCAType;
    private static String mRefNum;
    private static String mAuthCode;
    private static byte[] m_P_assW_ord;
    private static int mOption;
    private static String mCAName;
    private static String mRAName;
    private static String mSubjectDN;
    private static byte[] mOldPassword;
    private static byte[] mNewPassword;
    private byte[] mRandomValue = null;
    private String mEncryptedData = null;
    private String mNewEncryptedData = null;
    private BlockerActivityResult mBlockerParam;
    private Handler mHandler;
    private int mResultForCMPOK = 2;
    private int mResultForCMPFail = 3;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.cmp_progress_dialog);
        Intent receivedIntent = this.getIntent();
        this.mBlockerParam = BlockerActivityUtil.getParam((Context)this, (Intent)receivedIntent);
        this.mHandler = new Handler(){

            public void handleMessage(Message msg) {
                if (msg.what == CMPProgressDialog.this.mResultForCMPOK) {
                    CMPProgressDialog.this.mBlockerParam.setBlockerResult(-1);
                    CMPProgressDialog.this.finish();
                } else if (msg.what == CMPProgressDialog.this.mResultForCMPFail) {
                    CMPProgressDialog.this.mBlockerParam.setBlockerResult(CMPProgressDialog.this.mResultForCMPFail);
                    CMPProgressDialog.this.finish();
                }
                XUtil.resetByteArray((byte[][])new byte[][]{m_P_assW_ord, mOldPassword, mNewPassword, CMPProgressDialog.this.mRandomValue});
            }
        };
        this.initializeCMPValues();
        this.showProgressDialog();
    }

    private void showProgressDialog() {
        Thread CMPThread = new Thread(new CMPRunnable());
        String aCMPMsg = "";
        TextView aTextView = (TextView)this.findViewById(R.id.cmp_msg);
        switch (mCMPType) {
            case 0: {
                aCMPMsg = this.getString(R.string.request_cert_progress_bar_message);
                break;
            }
            case 1: {
                aCMPMsg = this.getString(R.string.renew_cert_progress_bar_message);
                break;
            }
            case 2: {
                aCMPMsg = this.getString(R.string.reissue_cert_progress_bar_message);
            }
        }
        aTextView.setText((CharSequence)aCMPMsg);
        CMPThread.start();
    }

    private void initializeCMPValues() {
        Intent aIntent = this.getIntent();
        mCMPType = aIntent.getIntExtra(mCMPTypeKey, -1);
        mCAport = aIntent.getIntExtra(mCAportKey, -1);
        mCAaddr = aIntent.getStringExtra(mCAaddrKey);
        mMediaID = aIntent.getIntExtra(mMediaIDKey, -1);
        mCAType = aIntent.getIntExtra(mCATypeKey, -1);
        switch (mCMPType) {
            case 0: {
                mRefNum = aIntent.getStringExtra(mRefNumKey);
                mAuthCode = aIntent.getStringExtra(mAuthCodeKey);
                m_P_assW_ord = aIntent.getByteArrayExtra(m_P_assW_ordKey);
                mOption = aIntent.getIntExtra(mOptionKey, -1);
                mCAName = aIntent.getStringExtra(mCANameKey);
                mRAName = aIntent.getStringExtra(mRANameKey);
                break;
            }
            case 1: {
                mSubjectDN = aIntent.getStringExtra(mSubjectDNKey);
                mOldPassword = aIntent.getByteArrayExtra(mOldPasswordKey);
                mNewPassword = aIntent.getByteArrayExtra(mNewPasswordKey);
                mOption = aIntent.getIntExtra(mOptionKey, -1);
                break;
            }
            case 2: {
                mRefNum = aIntent.getStringExtra(mRefNumKey);
                mAuthCode = aIntent.getStringExtra(mAuthCodeKey);
                m_P_assW_ord = aIntent.getByteArrayExtra(m_P_assW_ordKey);
            }
        }
        if (EnvironmentConfig.mMTransKeyEncryptionUsage || EnvironmentConfig.mXecureKeypadEncryptionUsage) {
            this.mRandomValue = aIntent.getByteArrayExtra(mRandomValueKey);
            this.mEncryptedData = aIntent.getStringExtra(mE_ncryptedDataKey);
            this.mNewEncryptedData = aIntent.getStringExtra(mNewE_ncryptedDataKey);
        }
    }

    public void finish() {
        BlockerActivityUtil.finishBlockerActivity((Object)this.mBlockerParam);
        super.finish();
    }

    public void onBackPressed() {
    }

    private class CMPRunnable
    implements Runnable {
        private CMPRunnable() {
        }

        @Override
        public void run() {
            int aResult = 0;
            CMPMgr aCMPMgr = new CMPMgr();
            switch (mCMPType) {
                case 0: {
                    if (EnvironmentConfig.mMTransKeyEncryptionUsage || EnvironmentConfig.mXecureKeypadEncryptionUsage) {
                        aResult = aCMPMgr.requestCertificateEx(mCAport, mCAaddr, mMediaID, mRefNum, mAuthCode, mCAType, CMPProgressDialog.this.mRandomValue, CMPProgressDialog.this.mEncryptedData, mOption, mCAName, mRAName);
                        break;
                    }
                    aResult = aCMPMgr.requestCertificateEx(mCAport, mCAaddr, mMediaID, mRefNum, mAuthCode, mCAType, m_P_assW_ord, mOption, mCAName, mRAName);
                    break;
                }
                case 1: {
                    if (EnvironmentConfig.mMTransKeyEncryptionUsage || EnvironmentConfig.mXecureKeypadEncryptionUsage) {
                        aResult = aCMPMgr.renewCertificateEx(mCAport, mCAaddr, mSubjectDN, mMediaID, mCAType, CMPProgressDialog.this.mRandomValue, CMPProgressDialog.this.mEncryptedData, CMPProgressDialog.this.mNewEncryptedData, mOption);
                        break;
                    }
                    aResult = aCMPMgr.renewCertificateEx(mCAport, mCAaddr, mSubjectDN, mMediaID, mCAType, mOldPassword, mNewPassword, mOption);
                    break;
                }
                case 2: {
                    aResult = EnvironmentConfig.mMTransKeyEncryptionUsage || EnvironmentConfig.mXecureKeypadEncryptionUsage ? aCMPMgr.reissueCertificate(mCAport, mCAaddr, mMediaID, mRefNum, mAuthCode, mCAType, CMPProgressDialog.this.mRandomValue, CMPProgressDialog.this.mEncryptedData) : aCMPMgr.reissueCertificate(mCAport, mCAaddr, mMediaID, mRefNum, mAuthCode, mCAType, m_P_assW_ord);
                }
            }
            if (aResult == 0) {
                CMPProgressDialog.this.mHandler.sendMessage(CMPProgressDialog.this.mHandler.obtainMessage(CMPProgressDialog.this.mResultForCMPOK));
            } else {
                CMPProgressDialog.this.mHandler.sendMessage(CMPProgressDialog.this.mHandler.obtainMessage(CMPProgressDialog.this.mResultForCMPFail));
            }
        }
    }
}

