/*
 * Decompiled with CFR 0.152.
 */
package com.softforum.xecure.ui.crypto;

import android.app.Activity;
import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.os.Bundle;
import android.view.View;
import android.widget.Button;
import android.widget.TextView;
import com.softforum.sample.R;
import com.softforum.xecure.core.CoreWrapper;
import com.softforum.xecure.ui.XTopView;
import com.softforum.xecure.util.XCoreUtil;
import com.softforum.xecure.util.XUtil;

public class PKCS11PasswordChange
extends Activity {
    public static final int mPKCS11PasswordChangeID = 100000;
    private int m_P_assW_ordTryCount = 0;

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.pkcs11_change_password);
        Button aOKButton = (Button)this.findViewById(R.id.top_right_button);
        aOKButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                PKCS11PasswordChange.this.onOKButtonClick(v);
            }
        });
        if (XCoreUtil.getInstance().isSoftwareTokenPINLocked()) {
            final PKCS11PasswordChange _this = this;
            new AlertDialog.Builder((Context)this).setTitle(R.string.xecure_smart_cert_mgr_confirm_caution).setPositiveButton(R.string.xecure_smart_cert_mgr_confirm_ok, new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int which) {
                    String aMessage = "";
                    int aResult = XCoreUtil.getInstance().initSoftwareToken();
                    aMessage = aResult == 0 ? PKCS11PasswordChange.this.getString(R.string.pkcs11_initialized) : PKCS11PasswordChange.this.getString(R.string.pkcs11_init_failed);
                    new AlertDialog.Builder((Context)_this).setTitle(R.string.xecure_smart_cert_mgr_confirm_caution).setPositiveButton(R.string.xecure_smart_cert_mgr_confirm_ok, new DialogInterface.OnClickListener(){

                        public void onClick(DialogInterface dialog, int which) {
                        }
                    }).setMessage((CharSequence)aMessage).show();
                }
            }).setNegativeButton(R.string.xecure_smart_cert_mgr_confirm_cancel, new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int which) {
                    PKCS11PasswordChange.this.setResult(0);
                    PKCS11PasswordChange.this.finish();
                }
            }).setMessage((CharSequence)this.getString(R.string.pkcs11_token_is_locked)).show();
        }
    }

    private void onOKButtonClick(View v) {
        String aOldPassword = "";
        String aNewPassword = "";
        String aNewPasswordConfirm = "";
        XTopView aTopView = (XTopView)this.findViewById(R.id.top_view);
        TextView aOldPasswordTextView = (TextView)this.findViewById(R.id.password_edittext);
        aOldPassword = aOldPasswordTextView.getText().toString();
        if (aOldPassword.length() > 0) {
            if (CoreWrapper.loginPKCS11((String)"Softforum PKCS#11", (String)aOldPassword) != 0) {
                if (++this.m_P_assW_ordTryCount == 3) {
                    XCoreUtil.getInstance().lockSoftwareTokenPIN();
                    new AlertDialog.Builder((Context)this).setTitle(R.string.xecure_smart_cert_mgr_confirm_caution).setPositiveButton(R.string.xecure_smart_cert_mgr_confirm_ok, new DialogInterface.OnClickListener(){

                        public void onClick(DialogInterface dialog, int which) {
                            PKCS11PasswordChange.this.setResult(0);
                            PKCS11PasswordChange.this.finish();
                        }
                    }).setMessage(R.string.pkcs11_will_be_locked).show();
                    return;
                }
                aTopView.setDescription(this.getString(R.string.pkcs11_incorrect_password));
                aOldPasswordTextView.setText((CharSequence)"");
                return;
            }
        } else {
            aTopView.setDescription(this.getString(R.string.plugin_input_nothing));
            return;
        }
        TextView aNewPasswordTextView = (TextView)this.findViewById(R.id.new_password_edittext);
        TextView aNewPasswordConfirmTextView = (TextView)this.findViewById(R.id.new_password_confirm_edittext);
        aNewPassword = aNewPasswordTextView.getText().toString();
        aNewPasswordConfirm = aNewPasswordConfirmTextView.getText().toString();
        if (aNewPassword.length() == 0) {
            aTopView.setDescription(this.getString(R.string.plugin_input_nothing));
            return;
        }
        int isPasswordMalformed = XUtil.checkPasswordFormat((String)aNewPassword);
        if (isPasswordMalformed == 1) {
            aTopView.setDescription(this.getString(R.string.password_length_error));
            return;
        }
        if (isPasswordMalformed == 2) {
            aTopView.setDescription(this.getString(R.string.password_syntax_error));
            return;
        }
        if (!aNewPassword.equals(aNewPasswordConfirm)) {
            aTopView.setDescription(this.getString(R.string.incorrect_confirm_password));
            return;
        }
        if (CoreWrapper.changeSoftwareTokenPIN((String)aOldPassword, (String)aNewPassword) == 0) {
            this.setResult(-1);
        } else {
            this.setResult(2);
        }
        new AlertDialog.Builder((Context)this).setMessage(R.string.restart_program).setPositiveButton((CharSequence)this.getString(R.string.xecure_smart_cert_mgr_confirm_ok), new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                PKCS11PasswordChange.this.finish();
            }
        }).show();
    }
}

