/*
 * Decompiled with CFR 0.152.
 */
package com.softforum.xecure.ui.crypto;

import android.app.ListActivity;
import android.content.Context;
import android.os.AsyncTask;
import android.os.Bundle;
import android.os.Handler;
import android.text.TextUtils;
import android.view.View;
import android.view.animation.Animation;
import android.view.animation.AnimationUtils;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.SimpleAdapter;
import android.widget.TextView;
import com.softforum.sample.R;
import com.softforum.xecure.crypto.CertMgr;
import com.softforum.xecure.util.XCoreUtil;
import com.softforum.xecure.util.XDetailData;
import java.util.ArrayList;
import java.util.HashMap;

public class XecureSmartCertDetailInfo
extends ListActivity {
    public static final int mXecureSmartCertDetailInfoID = 73000;
    public static final String mParsedXDetailDataKey = "parsed_xdetail_data_key";
    public static final String mCertLocationKey = "cert_location_key";
    private CertMgr mCertMgr = CertMgr.getInstance();
    private int mCertLocation;
    private XDetailData mCertDataInfo;

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.crypto_xecure_smart_cert_detail_info);
        this.setData();
        new Handler().postDelayed(new Runnable(){

            @Override
            public void run() {
                new VerifyTask().execute(new Void[0]);
            }
        }, 200L);
    }

    private void setData() {
        String[] aStringArrayExtra = this.getIntent().getStringArrayExtra(mParsedXDetailDataKey);
        this.mCertDataInfo = new XDetailData(aStringArrayExtra, 0);
        this.mCertLocation = this.getIntent().getIntExtra(mCertLocationKey, 101);
        TextView aMainText = (TextView)this.findViewById(R.id.main_msg);
        aMainText.setText((CharSequence)this.mCertDataInfo.getValue(7));
        ArrayList aResources = new ArrayList();
        for (int i = 1; i < aStringArrayExtra.length; ++i) {
            if (null == this.mCertDataInfo.getValue(i) || "".equals(this.mCertDataInfo.getValue(i))) continue;
            HashMap<String, String> aRow = new HashMap<String, String>();
            aRow.put("keyText", this.mCertDataInfo.getKeyText(i));
            aRow.put("valueText", this.mCertDataInfo.getValue(i));
            aResources.add(aRow);
        }
        this.setListAdapter((ListAdapter)new SimpleAdapter((Context)this, aResources, R.layout.crypto_xecure_smart_cert_detail_info_row, new String[]{"keyText", "valueText"}, new int[]{R.id.key_text, R.id.value_text}));
    }

    protected void onListItemClick(ListView l, View v, int position, long id2) {
        LinearLayout aRowView = (LinearLayout)v;
        TextView aValueText = (TextView)aRowView.getChildAt(1);
        if (TextUtils.TruncateAt.END.equals((Object)aValueText.getEllipsize())) {
            aValueText.setSingleLine(false);
            aValueText.setEllipsize(null);
        } else {
            aValueText.setSingleLine(true);
            aValueText.setEllipsize(TextUtils.TruncateAt.END);
        }
    }

    private class VerifyTask
    extends AsyncTask<Void, Void, Integer> {
        private ImageView mIcon;

        private VerifyTask() {
        }

        protected void onPreExecute() {
            super.onPreExecute();
            this.mIcon = (ImageView)XecureSmartCertDetailInfo.this.findViewById(R.id.icon);
            this.mIcon.setImageResource(R.drawable.indeterminate_spinner);
            Animation aRotateAnimation = AnimationUtils.loadAnimation((Context)XecureSmartCertDetailInfo.this, (int)R.anim.animation_rotate);
            this.mIcon.startAnimation(aRotateAnimation);
        }

        protected Integer doInBackground(Void ... params) {
            int aVerifyCertResult = XecureSmartCertDetailInfo.this.mCertMgr.verifyCert(XecureSmartCertDetailInfo.this.mCertLocation, 3, XecureSmartCertDetailInfo.this.mCertDataInfo.getValue(7), 0);
            return aVerifyCertResult;
        }

        protected void onPostExecute(Integer result) {
            int aVerifyCertResult = result;
            this.mIcon = (ImageView)XecureSmartCertDetailInfo.this.findViewById(R.id.icon);
            TextView aSubText1 = (TextView)XecureSmartCertDetailInfo.this.findViewById(R.id.sub_msg1);
            TextView aSubText2 = (TextView)XecureSmartCertDetailInfo.this.findViewById(R.id.sub_msg2);
            if (aVerifyCertResult == 0 || aVerifyCertResult == 1) {
                this.mIcon.setImageResource(R.drawable.cert_verify_ok);
                aSubText1.setText((CharSequence)XecureSmartCertDetailInfo.this.getString(R.string.cert_detail_info_verify_normal_decorated));
                aSubText2.setText((CharSequence)XecureSmartCertDetailInfo.this.getString(R.string.cert_detail_info_verify_sub_normal_decorated));
            } else if (aVerifyCertResult == 2) {
                this.mIcon.setImageResource(R.drawable.cert_verify_revoke);
            } else {
                this.mIcon.setImageResource(R.drawable.cert_verify_error);
                aSubText1.setText((CharSequence)XecureSmartCertDetailInfo.this.getString(R.string.cert_detail_info_error_decorated));
                aSubText2.setText((CharSequence)new XCoreUtil().lastErrMsg());
            }
            this.mIcon.clearAnimation();
            super.onPostExecute((Object)result);
        }
    }
}

