/*
 * Decompiled with CFR 0.152.
 */
package com.softforum.xecure.ui.crypto;

import android.app.Activity;
import android.app.AlertDialog;
import android.app.ListActivity;
import android.app.PendingIntent;
import android.app.ProgressDialog;
import android.content.Context;
import android.content.Intent;
import android.nfc.NfcAdapter;
import android.nfc.Tag;
import android.nfc.tech.IsoDep;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.view.KeyEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AdapterView;
import android.widget.LinearLayout;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.Spinner;
import android.widget.SpinnerAdapter;
import android.widget.Toast;
import com.consortium.smartusim.SmartUsim;
import com.consortium.smartusim.SmartUsimListener;
import com.consortium.smartusim.SmartUsimResultCode;
import com.softforum.sample.R;
import com.softforum.xecure.XecureSmart;
import com.softforum.xecure.crypto.CertMgr;
import com.softforum.xecure.crypto.ICCardMgr;
import com.softforum.xecure.ui.crypto.XecureSmartCertMgrMenu;
import com.softforum.xecure.ui.menu.XSlideMenuPanel;
import com.softforum.xecure.usim.UsimUtil;
import com.softforum.xecure.util.EnvironmentConfig;
import com.softforum.xecure.util.ImageTextSpinnerAdapter;
import com.softforum.xecure.util.XDetailData;
import com.softforum.xecure.util.XDetailDataParser;
import com.softforum.xecure.util.XDetailDataRowAdapter;
import com.softforum.xecure.util.XDetailDataRowAdapterUSIM;
import com.softforum.xecure.util.XSLog;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.StringTokenizer;
import kr.co.skplanet.utils.Base64;
import kr.or.kftc.mobiletoken_lib.device_control.TokenControl;
import kr.or.kftc.smartcard.SecurityToken;

public class XecureSmartCertMgrUser
extends ListActivity {
    public static final int mXecureSmartCertMgrUserID = 72100;
    public static final String mOperationResultKey = "xecure_smart_cert_mgr_result_key";
    private static int mMediaID = XecureSmart.mDefaultMediaID;
    private XSlideMenuPanel mXSlideMenuPanel;
    private int mSelectedPostion = -1;
    private int MEDIA_SDCARD;
    private int MEDIA_APPDATA;
    private int MEDIA_DREAMSECURITY_USIM;
    private int MEDIA_RAONSECURE_USIM;
    static final String TAG = SecurityToken.class.getSimpleName();
    private IsoDep isoDep;
    private static NfcAdapter mNfcAdapter;
    private TokenControl mToken = null;
    private int MEDIA_ICCARD;
    private int MEDIA_ICCARD_COPY;
    private String mPinValue = "11111111";
    private SmartUsim mSmartUsim = null;
    private final int END_BIND = 101;
    private final int flag_JOIN = 102;
    private static ProgressDialog mProgressDialog;
    public Handler mHandler = new Handler();
    private final String serverAddress = "58.229.178.45";
    private final int serverPort = 25189;
    private ICCardMgr mICCardMgr = null;
    public SmartUsimListener smartUsimListener = new SmartUsimListener(){

        public void onSmartUsimResult(int requestCode, SmartUsimResultCode resultCode) {
            switch (requestCode) {
                case 3: {
                    if (resultCode.getResultCode() == 0) {
                        if (!UsimUtil.mSamrtUsimBindSwitch) break;
                        XecureSmartCertMgrUser.this.mSmartUsim.bindService("58.229.178.45", 25189);
                        UsimUtil.mSamrtUsimBindSwitch = false;
                        break;
                    }
                    XecureSmartCertMgrUser.this.showToast("\uc2a4\ub9c8\ud2b8\uc778\uc99d\uc571\uc774 \uc124\uce58\ub418\uc9c0 \uc54a\uc558\uc2b5\ub2c8\ub2e4.\n\ud655\uc778 \ud6c4 \uc774\uc6a9\ud574 \uc8fc\uc2dc\uae30 \ubc14\ub78d\ub2c8\ub2e4.\n[" + resultCode.getResultCode() + "]");
                    break;
                }
                case 1: {
                    if (resultCode.getResultCode() == 0) {
                        XecureSmartCertMgrUser.this.setInit();
                        break;
                    }
                    XecureSmartCertMgrUser.this.showToast("\ubc14\uc778\ub4dc \uc2e4\ud328\uacf5\ud1b5 /Vendor \ucf54\ub4dc : " + resultCode.getResultCode() + "(" + resultCode.getResultCodeVendor() + ")");
                }
            }
        }
    };

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.crypto_xecure_smart_cert_mgr_user);
        this.mICCardMgr = new ICCardMgr();
        this.mXSlideMenuPanel = (XSlideMenuPanel)this.findViewById(R.id.xslide_panel_menu);
        if (EnvironmentConfig.mSDCardOnlyUse) {
            mMediaID = 101;
        } else if (EnvironmentConfig.mAppDataOnlyUse) {
            mMediaID = 1401;
        }
        if (EnvironmentConfig.mICCardUse) {
            mNfcAdapter = NfcAdapter.getDefaultAdapter((Context)this);
        }
        this.setSpinner();
        if ((EnvironmentConfig.mSDCardOnlyUse || EnvironmentConfig.mAppDataOnlyUse) && !EnvironmentConfig.mUsimUse) {
            this.setUserCertItems(mMediaID);
            View aView = this.findViewById(R.id.media_and_copy_layout);
            aView.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(0, 0));
            aView.setVisibility(4);
        }
    }

    private void setSpinner() {
        if (EnvironmentConfig.mSDCardOnlyUse || EnvironmentConfig.mAppDataOnlyUse) {
            if (!EnvironmentConfig.mUsimUse) {
                View aView = this.findViewById(R.id.select_media);
                aView.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(0, 0));
                aView.setVisibility(4);
            } else if (EnvironmentConfig.mUsimUse) {
                if (EnvironmentConfig.mSDCardOnlyUse) {
                    this.MEDIA_SDCARD = 0;
                    this.MEDIA_DREAMSECURITY_USIM = 1;
                    this.MEDIA_RAONSECURE_USIM = 2;
                    Spinner aSelectStorage = (Spinner)this.findViewById(R.id.select_media);
                    ArrayList<HashMap<String, Object>> aItemList = new ArrayList<HashMap<String, Object>>();
                    HashMap<String, Object> aItem = new HashMap<String, Object>();
                    aItem.put("image", R.drawable.sdcard);
                    aItem.put("text", "SDCard");
                    aItemList.add(aItem);
                    aItem = new HashMap();
                    aItem.put("image", R.drawable.usim_dream);
                    aItem.put("text", "\uc720\uc2ec(\ub4dc\ub9bc)");
                    aItemList.add(aItem);
                    ImageTextSpinnerAdapter aAdapter = new ImageTextSpinnerAdapter((Context)this, aItemList);
                    aSelectStorage.setAdapter((SpinnerAdapter)aAdapter);
                    final XecureSmartCertMgrUser aContext = this;
                    aSelectStorage.setOnItemSelectedListener(new AdapterView.OnItemSelectedListener(){

                        public void onItemSelected(AdapterView<?> parent, View view, int position, long id2) {
                            if (position == XecureSmartCertMgrUser.this.MEDIA_SDCARD) {
                                mMediaID = 101;
                            } else if (position == XecureSmartCertMgrUser.this.MEDIA_DREAMSECURITY_USIM) {
                                mMediaID = 901;
                            } else if (position == XecureSmartCertMgrUser.this.MEDIA_RAONSECURE_USIM) {
                                mMediaID = 902;
                            }
                            aContext.setUserCertItems(mMediaID);
                        }

                        public void onNothingSelected(AdapterView<?> arg0) {
                        }
                    });
                } else if (EnvironmentConfig.mAppDataOnlyUse) {
                    this.MEDIA_APPDATA = 0;
                    this.MEDIA_DREAMSECURITY_USIM = 1;
                    this.MEDIA_RAONSECURE_USIM = 2;
                    Spinner aSelectStorage = (Spinner)this.findViewById(R.id.select_media);
                    ArrayList<HashMap<String, Object>> aItemList = new ArrayList<HashMap<String, Object>>();
                    HashMap<String, Object> aItem = new HashMap<String, Object>();
                    aItem.put("image", R.drawable.icon);
                    aItem.put("text", "\uc571\ub370\uc774\ud130");
                    aItemList.add(aItem);
                    aItem = new HashMap();
                    aItem.put("image", R.drawable.usim_dream);
                    aItem.put("text", "\uc720\uc2ec(\ub4dc\ub9bc)");
                    aItemList.add(aItem);
                    ImageTextSpinnerAdapter aAdapter = new ImageTextSpinnerAdapter((Context)this, aItemList);
                    aSelectStorage.setAdapter((SpinnerAdapter)aAdapter);
                    final XecureSmartCertMgrUser aContext = this;
                    aSelectStorage.setOnItemSelectedListener(new AdapterView.OnItemSelectedListener(){

                        public void onItemSelected(AdapterView<?> parent, View view, int position, long id2) {
                            if (position == XecureSmartCertMgrUser.this.MEDIA_APPDATA) {
                                mMediaID = 1401;
                            } else if (position == XecureSmartCertMgrUser.this.MEDIA_DREAMSECURITY_USIM) {
                                mMediaID = 901;
                            } else if (position == XecureSmartCertMgrUser.this.MEDIA_RAONSECURE_USIM) {
                                mMediaID = 902;
                            }
                            aContext.setUserCertItems(mMediaID);
                        }

                        public void onNothingSelected(AdapterView<?> arg0) {
                        }
                    });
                }
            } else if (EnvironmentConfig.mICCardUse) {
                if (EnvironmentConfig.mSDCardOnlyUse) {
                    this.MEDIA_SDCARD = 0;
                    this.MEDIA_ICCARD = 1;
                    this.MEDIA_ICCARD_COPY = 2;
                    Spinner aSelectStorage = (Spinner)this.findViewById(R.id.select_media);
                    ArrayList<HashMap<String, Object>> aItemList = new ArrayList<HashMap<String, Object>>();
                    HashMap<String, Object> aItem = new HashMap<String, Object>();
                    aItem.put("image", R.drawable.sdcard);
                    aItem.put("text", "SDCard");
                    aItemList.add(aItem);
                    aItem = new HashMap();
                    aItem.put("image", R.drawable.usim_dream);
                    aItem.put("text", "ICCARD");
                    aItemList.add(aItem);
                    aItem = new HashMap();
                    aItem.put("image", R.drawable.usim_dream);
                    aItem.put("text", "ICCARD\uc5d0 \ud14c\uc2a4\ud2b8 \uc778\uc99d\uc11c \ubcf5\uc0ac");
                    aItemList.add(aItem);
                    ImageTextSpinnerAdapter aAdapter = new ImageTextSpinnerAdapter((Context)this, aItemList);
                    aSelectStorage.setAdapter((SpinnerAdapter)aAdapter);
                    final XecureSmartCertMgrUser aContext = this;
                    aSelectStorage.setOnItemSelectedListener(new AdapterView.OnItemSelectedListener(){

                        public void onItemSelected(AdapterView<?> parent, View view, int position, long id2) {
                            if (position == XecureSmartCertMgrUser.this.MEDIA_SDCARD) {
                                mMediaID = 101;
                            } else if (position == XecureSmartCertMgrUser.this.MEDIA_ICCARD) {
                                mMediaID = 903;
                            } else if (position == XecureSmartCertMgrUser.this.MEDIA_ICCARD_COPY) {
                                mMediaID = 904;
                            }
                            aContext.setUserCertItems(mMediaID);
                        }

                        public void onNothingSelected(AdapterView<?> arg0) {
                        }
                    });
                } else if (EnvironmentConfig.mAppDataOnlyUse) {
                    this.MEDIA_APPDATA = 0;
                    this.MEDIA_ICCARD = 1;
                    Spinner aSelectStorage = (Spinner)this.findViewById(R.id.select_media);
                    ArrayList<HashMap<String, Object>> aItemList = new ArrayList<HashMap<String, Object>>();
                    HashMap<String, Object> aItem = new HashMap<String, Object>();
                    aItem.put("image", R.drawable.icon);
                    aItem.put("text", "\uc571\ub370\uc774\ud130");
                    aItemList.add(aItem);
                    aItem = new HashMap();
                    aItem.put("image", R.drawable.usim_dream);
                    aItem.put("text", "ICCARD");
                    aItemList.add(aItem);
                    aItem = new HashMap();
                    aItem.put("image", R.drawable.usim_dream);
                    aItem.put("text", "ICCARD\uc5d0 \ud14c\uc2a4\ud2b8 \uc778\uc99d\uc11c \ubcf5\uc0ac");
                    aItemList.add(aItem);
                    ImageTextSpinnerAdapter aAdapter = new ImageTextSpinnerAdapter((Context)this, aItemList);
                    aSelectStorage.setAdapter((SpinnerAdapter)aAdapter);
                    final XecureSmartCertMgrUser aContext = this;
                    aSelectStorage.setOnItemSelectedListener(new AdapterView.OnItemSelectedListener(){

                        public void onItemSelected(AdapterView<?> parent, View view, int position, long id2) {
                            if (position == XecureSmartCertMgrUser.this.MEDIA_APPDATA) {
                                mMediaID = 1401;
                            } else if (position == XecureSmartCertMgrUser.this.MEDIA_ICCARD) {
                                mMediaID = 903;
                            } else if (position == XecureSmartCertMgrUser.this.MEDIA_ICCARD_COPY) {
                                mMediaID = 904;
                            }
                            aContext.setUserCertItems(mMediaID);
                        }

                        public void onNothingSelected(AdapterView<?> arg0) {
                        }
                    });
                }
            }
        } else if (EnvironmentConfig.mSDCardAppDataUse) {
            this.MEDIA_SDCARD = 0;
            this.MEDIA_APPDATA = 1;
            if (EnvironmentConfig.mICCardUse && !EnvironmentConfig.mUsimUse) {
                this.MEDIA_ICCARD = 2;
                this.MEDIA_ICCARD_COPY = 3;
            } else if (!EnvironmentConfig.mICCardUse && EnvironmentConfig.mUsimUse) {
                this.MEDIA_DREAMSECURITY_USIM = 2;
                this.MEDIA_RAONSECURE_USIM = 3;
            } else if (EnvironmentConfig.mICCardUse && EnvironmentConfig.mUsimUse) {
                this.MEDIA_DREAMSECURITY_USIM = 2;
                this.MEDIA_RAONSECURE_USIM = 3;
                this.MEDIA_ICCARD = 4;
                this.MEDIA_ICCARD_COPY = 5;
            }
            Spinner aSelectStorage = (Spinner)this.findViewById(R.id.select_media);
            ArrayList<HashMap<String, Object>> aItemList = new ArrayList<HashMap<String, Object>>();
            HashMap<String, Object> aItem = new HashMap<String, Object>();
            aItem.put("image", R.drawable.sdcard);
            aItem.put("text", "SDCard");
            aItemList.add(aItem);
            aItem = new HashMap();
            aItem.put("image", R.drawable.icon);
            aItem.put("text", "\uc571\ub370\uc774\ud130");
            aItemList.add(aItem);
            if (EnvironmentConfig.mUsimUse) {
                aItem = new HashMap();
                aItem.put("image", R.drawable.usim_dream);
                aItem.put("text", "\uc720\uc2ec(\ub4dc\ub9bc)");
                aItemList.add(aItem);
            }
            if (EnvironmentConfig.mICCardUse) {
                aItem = new HashMap();
                aItem.put("image", R.drawable.usim_dream);
                aItem.put("text", "ICCARD");
                aItemList.add(aItem);
                aItem = new HashMap();
                aItem.put("image", R.drawable.usim_dream);
                aItem.put("text", "ICCARD\uc5d0 \ud14c\uc2a4\ud2b8 \uc778\uc99d\uc11c \ubcf5\uc0ac");
                aItemList.add(aItem);
            }
            ImageTextSpinnerAdapter aAdapter = new ImageTextSpinnerAdapter((Context)this, aItemList);
            aSelectStorage.setAdapter((SpinnerAdapter)aAdapter);
            final XecureSmartCertMgrUser aContext = this;
            aSelectStorage.setOnItemSelectedListener(new AdapterView.OnItemSelectedListener(){

                public void onItemSelected(AdapterView<?> parent, View view, int position, long id2) {
                    if (position == XecureSmartCertMgrUser.this.MEDIA_SDCARD) {
                        mMediaID = 101;
                    } else if (position == XecureSmartCertMgrUser.this.MEDIA_APPDATA) {
                        mMediaID = 1401;
                    } else if (position == XecureSmartCertMgrUser.this.MEDIA_DREAMSECURITY_USIM) {
                        mMediaID = 901;
                    } else if (position == XecureSmartCertMgrUser.this.MEDIA_RAONSECURE_USIM) {
                        mMediaID = 902;
                    } else if (position == XecureSmartCertMgrUser.this.MEDIA_ICCARD) {
                        mMediaID = 903;
                    } else if (position == XecureSmartCertMgrUser.this.MEDIA_ICCARD_COPY) {
                        mMediaID = 904;
                    }
                    aContext.setUserCertItems(mMediaID);
                }

                public void onNothingSelected(AdapterView<?> arg0) {
                }
            });
        }
    }

    private void setUserCertItems(int pMediaID) {
        int aMediaID = 0;
        String aCertList = null;
        String aMediaList = null;
        StringTokenizer aMediaListTokenizer = null;
        ArrayList<XDetailData> aXCertDataList = new ArrayList<XDetailData>();
        int aSearchCondition = 0;
        boolean isMember = false;
        aMediaID = pMediaID;
        if (aMediaID == 901 || aMediaID == 902) {
            SmartUsimResultCode userResult;
            block22: {
                if (!UsimUtil.mSamrtUsimBindSwitch) {
                    this.endUnBind();
                }
                if (aMediaID == 901) {
                    this.mSmartUsim = SmartUsim.getInstance((Context)this, (SmartUsimListener)this.smartUsimListener, (String)"www.softforum.com", (String)"cpCode", (int)2);
                } else if (aMediaID == 902) {
                    this.mSmartUsim = SmartUsim.getInstance((Context)this, (SmartUsimListener)this.smartUsimListener, (String)"www.softforum.com", (String)"cpCode", (int)1);
                }
                try {
                    isMember = this.mSmartUsim.isMember();
                }
                catch (NoClassDefFoundError e) {
                    userResult = this.mSmartUsim.getLastError();
                    if (userResult.getResultCode() == 2001) break block22;
                    this.showToast("\uc11c\ube44\uc2a4 \ubd88\uac00\ub2a5 \uc0ac\uc6a9\uc790" + userResult.getResultCode() + "/" + userResult.getResultCodeVendor());
                    this.emptyCertList(aMediaID);
                    return;
                }
            }
            if (!isMember && (userResult = this.mSmartUsim.getLastError()).getResultCode() != 2001) {
                this.showToast("\uc11c\ube44\uc2a4 \ubd88\uac00\ub2a5 \uc0ac\uc6a9\uc790" + userResult.getResultCode() + "/" + userResult.getResultCodeVendor());
                this.emptyCertList(aMediaID);
                return;
            }
            boolean isInstall = this.mSmartUsim.isInstalled();
            if (!isInstall) {
                this.mSmartUsim.install();
                this.emptyCertList(aMediaID);
                return;
            }
            if (UsimUtil.mSamrtUsimBindSwitch) {
                this.mSmartUsim.bindService("58.229.178.45", 25189);
                UsimUtil.mSamrtUsimBindSwitch = false;
            }
        } else if (aMediaID == 101 || aMediaID == 1401) {
            if (!UsimUtil.mSamrtUsimBindSwitch) {
                this.endUnBind();
            }
            CertMgr aCertMgr = CertMgr.getInstance();
            aMediaList = aCertMgr.getMediaList(aMediaID - 1, 1, 1);
            aMediaListTokenizer = new StringTokenizer(aMediaList, "\t\n");
            aSearchCondition = 0;
            if (EnvironmentConfig.mExcludeExpiredCert) {
                aSearchCondition = 25;
            }
            while (aMediaListTokenizer.hasMoreTokens()) {
                aMediaID = Integer.parseInt(aMediaListTokenizer.nextToken());
                aCertList = aCertMgr.getCertTree(aMediaID, 2, aSearchCondition, 5, "", null);
                aXCertDataList.addAll(XDetailDataParser.parse((String)aCertList, (int)3, (int)aMediaID));
            }
            this.setListAdapter((ListAdapter)new XDetailDataRowAdapter((Activity)this, aXCertDataList));
        } else if (aMediaID == 903 || aMediaID == 904) {
            if (mNfcAdapter.isEnabled()) {
                if (mNfcAdapter != null && mNfcAdapter.isEnabled()) {
                    String[][] techList = new String[][]{{IsoDep.class.getName()}};
                    PendingIntent pendingIntent = PendingIntent.getActivity((Context)this, (int)0, (Intent)new Intent((Context)this, ((Object)((Object)this)).getClass()).addFlags(0x20000000), (int)0);
                    mNfcAdapter.enableForegroundDispatch((Activity)this, pendingIntent, null, techList);
                    Toast.makeText((Context)this, (CharSequence)"\uc2a4\ub9c8\ud2b8\ud3f0\uc5d0 \ubcf4\uc548\ud1a0\ud070\uc744 \ud130\uce58\ud558\uc138\uc694.", (int)1).show();
                }
            } else if (Build.VERSION.SDK_INT > 16) {
                this.startActivity(new Intent("android.settings.NFC_SETTINGS"));
            } else {
                this.startActivity(new Intent("android.settings.WIRELESS_SETTINGS"));
            }
        }
    }

    protected void onListItemClick(ListView l, View v, int position, long id2) {
        int aMediaID = 0;
        String aCertList = null;
        String aMediaList = null;
        StringTokenizer aMediaListTokenizer = null;
        XDetailData aSelectedCert = null;
        ArrayList aXCertDataList = new ArrayList();
        int aSearchCondition = 0;
        super.onListItemClick(l, v, position, id2);
        aMediaID = mMediaID;
        aSearchCondition = 0;
        if (EnvironmentConfig.mExcludeExpiredCert) {
            aSearchCondition = 25;
        }
        if (aMediaID == 901 || aMediaID == 902) {
            int certCount = this.mSmartUsim.getCertCount();
            if (certCount > 0) {
                aCertList = UsimUtil.ConvertDreamCertToXS(certCount);
                aXCertDataList.addAll(XDetailDataParser.parse((String)aCertList, (int)4, (int)aMediaID));
            }
        } else if (aMediaID == 903) {
            this.mToken.Connect();
            Bundle requestBundle = new Bundle();
            requestBundle.putString("REQUEST_ACTION", "GET_CERTIFICATE_LIST");
            int aCertificateCount = 0;
            Bundle responseBundle = new Bundle();
            this.mToken.Transmit(requestBundle, responseBundle);
            if (responseBundle.getString("RESULT_CODE").equals("0000")) {
                aCertificateCount = responseBundle.getInt("CERT_COUNT");
            } else {
                String errMsg = responseBundle.getString("ERROR_MESSAGE");
                Toast.makeText((Context)this, (CharSequence)errMsg, (int)1).show();
            }
            if (aCertificateCount > 0) {
                for (int index = 1; index <= aCertificateCount; ++index) {
                    requestBundle.putString("REQUEST_ACTION", "GET_CERTIFICATE");
                    requestBundle.putInt("CERTIFICATE_INDEX", index);
                    this.mToken.Transmit(requestBundle, responseBundle);
                    if (!responseBundle.getString("RESULT_CODE").equals("0000")) {
                        String errMsg = responseBundle.getString("ERROR_MESSAGE");
                        Toast.makeText((Context)this, (CharSequence)errMsg, (int)1).show();
                        break;
                    }
                    byte[] a = responseBundle.getByteArray("CERTIFICATE");
                    aCertList = aCertList + this.mICCardMgr.makeCertificateListFromByteArray(a, 0);
                }
            }
            aXCertDataList.addAll(XDetailDataParser.parse((String)aCertList, (int)0, (int)mMediaID));
        } else {
            CertMgr aCertMgr = CertMgr.getInstance();
            aMediaList = aCertMgr.getMediaList(aMediaID - 1, 1, 0);
            aMediaListTokenizer = new StringTokenizer(aMediaList, "\t\n");
            while (aMediaListTokenizer.hasMoreTokens()) {
                aMediaID = Integer.parseInt(aMediaListTokenizer.nextToken());
                aCertList = aCertMgr.getCertTree(aMediaID, 2, aSearchCondition, 0, "", null);
                aXCertDataList.addAll(XDetailDataParser.parse((String)aCertList, (int)0, (int)aMediaID));
            }
        }
        aSelectedCert = (XDetailData)aXCertDataList.get(position);
        if (aMediaID == 901 || aMediaID == 902) {
            XecureSmartCertMgrMenu.getInstance((Activity)this).setUsimCertOperationMenu(aSelectedCert.getMediaID(), aSelectedCert, 4, this.mXSlideMenuPanel, position, this.mSmartUsim);
        } else if (mMediaID == 1401) {
            XecureSmartCertMgrMenu.getInstance((Activity)this).setCertOperationMenu(aSelectedCert.getMediaID(), aSelectedCert, 3, this.mXSlideMenuPanel);
        } else if (mMediaID == 903) {
            XecureSmartCertMgrMenu.getInstance((Activity)this).setICCertOperationMenu(aSelectedCert.getMediaID(), aSelectedCert, 5, this.mXSlideMenuPanel, this.mToken);
        } else {
            XecureSmartCertMgrMenu.getInstance((Activity)this).setCertOperationMenu(aSelectedCert.getMediaID(), aSelectedCert, 0, this.mXSlideMenuPanel);
        }
        if (this.mSelectedPostion != position) {
            this.mXSlideMenuPanel.hide();
        }
        this.mXSlideMenuPanel.toggle();
        this.mSelectedPostion = position;
    }

    public void refreshCertList() {
        this.emptyCertList(mMediaID);
        if (this.mToken != null) {
            this.mToken.Disconnect();
        }
        this.setUserCertItems(mMediaID);
    }

    public void changePasswordUsimCert() {
        this.mSmartUsim.changePIN(4);
    }

    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        switch (requestCode) {
            case 101: {
                this.endUnBind();
                break;
            }
            case 102: {
                if (resultCode != -1) break;
                this.setInit();
            }
        }
        String aMessage = "";
        int aResultFromThat = -1;
        if (data != null) {
            aResultFromThat = data.getIntExtra(mOperationResultKey, -1);
        }
        if (2 == resultCode) {
            aMessage = this.getString(R.string.requested_task_fail);
        } else if (0 == resultCode) {
            aMessage = this.getString(R.string.requested_task_canceled);
        } else if (aResultFromThat == 0) {
            aMessage = this.getString(R.string.xecure_smart_cert_mgr_verify_vid_success);
        } else if (aResultFromThat == 1) {
            aMessage = this.getString(R.string.xecure_smart_cert_mgr_change_password_success);
            this.refreshCertList();
        } else if (aResultFromThat == 3) {
            aMessage = this.getString(R.string.xecure_smart_cert_mgr_movetoappdata_certificate_success);
            this.refreshCertList();
        } else if (aResultFromThat == 4) {
            aMessage = this.getString(R.string.message_password_pin_lock);
        } else if (aResultFromThat == 5) {
            aMessage = this.getString(R.string.message_password_pin_init_state);
        } else if (aResultFromThat == 6) {
            aMessage = this.getString(R.string.message_copy_to_usim_success);
        } else if (aResultFromThat == 7) {
            aMessage = "USIM\uc5d0 \ub3d9\uc77c\ud55c \uc778\uc99d\uc11c\uac00 \uc774\ubbf8 \uc874\uc7ac\ud569\ub2c8\ub2e4.";
        } else if (aResultFromThat == 8) {
            aMessage = this.getString(R.string.message_delete_usim_cert_success);
            this.refreshCertList();
        } else if (aResultFromThat == 9) {
            aMessage = this.getString(R.string.message_delete_usim_cert_fail);
        } else if (aResultFromThat == 11) {
            aMessage = this.getString(R.string.message_verify_owner_usim_cert_fail);
        } else if (aResultFromThat == 10) {
            aMessage = this.getString(R.string.message_verify_owner_usim_cert_success);
        } else if (-1 == resultCode) {
            aMessage = "\uc694\uccad\ud558\uc2e0 \uc791\uc5c5\uc774 \uc815\uc0c1\uc801\uc73c\ub85c \ucc98\ub9ac\ub418\uc5c8\uc2b5\ub2c8\ub2e4.";
            this.refreshCertList();
        } else {
            return;
        }
        if (aMessage.length() > 0) {
            new AlertDialog.Builder((Context)this).setTitle((CharSequence)"\uc54c\ub9bc").setPositiveButton((CharSequence)"\ud655\uc778", null).setMessage((CharSequence)aMessage).show();
        }
    }

    protected void onPause() {
        this.mXSlideMenuPanel.hide();
        super.onPause();
        if (EnvironmentConfig.mICCardUse && this.mToken != null && mNfcAdapter != null && mNfcAdapter.isEnabled()) {
            mNfcAdapter.disableForegroundDispatch((Activity)this);
        }
    }

    public boolean onKeyDown(int keyCode, KeyEvent event) {
        XSlideMenuPanel aPanel;
        if (4 == keyCode && !(aPanel = (XSlideMenuPanel)this.findViewById(R.id.xslide_panel_menu)).isHide()) {
            aPanel.untoggle();
            return true;
        }
        return super.onKeyDown(keyCode, event);
    }

    private void setInit() {
        boolean isPossible = false;
        if (mProgressDialog == null || !mProgressDialog.isShowing()) {
            // empty if block
        }
        isPossible = this.mSmartUsim.isPossibleService();
        SmartUsimResultCode countResult = this.mSmartUsim.getLastError();
        String aCertList = null;
        ArrayList<XDetailData> aXCertDataList = new ArrayList<XDetailData>();
        int aMediaID = mMediaID;
        if (isPossible) {
            int certCount = this.mSmartUsim.getCertCount();
            if (certCount < 0) {
                countResult = this.mSmartUsim.getLastError();
                this.showToast("\uc778\uc99d\uc11c \uac2f\uc218\uc5d0 \uc624\ub958\uac00 \ubc1c\uc0dd\ud558\uc600\uc2b5\ub2c8\ub2e4.(" + countResult.getResultCode() + "/" + countResult.getResultCodeVendor() + ")");
                this.emptyCertList(aMediaID);
                return;
            }
            if (certCount == 0) {
                this.emptyCertList(aMediaID);
            } else {
                UsimUtil.setUsim(this.mSmartUsim);
                aCertList = UsimUtil.ConvertDreamCertToXS(certCount);
                aXCertDataList.addAll(XDetailDataParser.parse((String)aCertList, (int)4, (int)aMediaID));
                this.setListAdapter((ListAdapter)new XDetailDataRowAdapterUSIM((Activity)this, aXCertDataList));
            }
        } else {
            SmartUsimResultCode suResult = this.mSmartUsim.getLastError();
            if (suResult.getResultCodeVendor() == 3001) {
                this.mSmartUsim.joinService(102);
            } else if (suResult.getResultCode() == 3002) {
                this.emptyCertList(aMediaID);
                this.endUnBind();
                this.showToast("\uc2a4\ub9c8\ud2b8\uacf5\uc778\uc778\uc99d \uc571 \uc5c5\ub370\uc774\ud2b8\uac00 \ud544\uc694\ud569\ub2c8\ub2e4.(" + suResult.getResultCodeVendor() + ")");
                this.mSmartUsim.install();
            } else if (suResult.getResultCode() == 3001) {
                this.showToast("\ud5c8\uac00\ub418\uc9c0 \uc54a\uc740 \uc571\uc774 \uc811\uadfc\ud558\uc600\uc2b5\ub2c8\ub2e4." + suResult.getResultCode() + "(" + suResult.getResultCodeVendor() + ")");
                this.emptyCertList(aMediaID);
                this.endUnBind();
            } else {
                this.showToast(suResult.getResultCode() + "(" + suResult.getResultCodeVendor() + ")");
                this.emptyCertList(aMediaID);
                this.endUnBind();
            }
        }
    }

    private void emptyCertList(int pMediaID) {
        String aCertList = "";
        ArrayList<XDetailData> aXCertDataList = new ArrayList<XDetailData>();
        aXCertDataList.addAll(XDetailDataParser.parse((String)aCertList, (int)3, (int)pMediaID));
        this.setListAdapter((ListAdapter)new XDetailDataRowAdapter((Activity)this, aXCertDataList));
    }

    private void endUnBind() {
        try {
            UsimUtil.mSamrtUsimBindSwitch = true;
            this.mSmartUsim.unbindService();
            this.mSmartUsim = null;
        }
        catch (Exception e) {
            XSLog.e((String)e.getMessage());
        }
    }

    public void showToast(final String message) {
        this.mHandler.post(new Runnable(){

            @Override
            public void run() {
                Toast.makeText((Context)XecureSmartCertMgrUser.this, (CharSequence)message, (int)1).show();
            }
        });
    }

    public void onBackPressed() {
        if (!UsimUtil.mSamrtUsimBindSwitch) {
            this.endUnBind();
        }
        if (EnvironmentConfig.mICCardUse && this.mToken != null) {
            this.mToken.Disconnect();
        }
        this.finish();
    }

    public void copyCertificateToICCard() {
        String errMsg;
        byte aCertificateType = -1;
        int aCertificateLength = 0;
        byte[] aCertificate = null;
        Bundle requestBundle = new Bundle();
        requestBundle.putString("REQUEST_ACTION", "GET_CERTIFICATE_LIST");
        int aCertificateCount = 0;
        Bundle responseBundle = new Bundle();
        this.mToken.Transmit(requestBundle, responseBundle);
        if (responseBundle.getString("RESULT_CODE").equals("0000")) {
            aCertificateCount = responseBundle.getInt("CERT_COUNT");
        } else {
            errMsg = responseBundle.getString("ERROR_MESSAGE");
            Toast.makeText((Context)this, (CharSequence)errMsg, (int)1).show();
        }
        int aSaveLocate = aCertificateCount == 0 ? 1 : aCertificateCount + 1;
        try {
            aCertificate = Base64.decode((String)"MIIFxTCCBK2gAwIBAgIDPw2yMA0GCSqGSIb3DQEBCwUAMFcxCzAJBgNVBAYTAmtyMRAwDgYDVQQKDAd5ZXNzaWduMRUwEwYDVQQLDAxBY2NyZWRpdGVkQ0ExHzAdBgNVBAMMFnllc3NpZ25DQS1UZXN0IENsYXNzIDIwHhcNMTQwNjI2MTUwMDAwWhcNMTQwODI4MTQ1OTU5WjB9MQswCQYDVQQGEwJrcjEQMA4GA1UECgwHeWVzc2lnbjEUMBIGA1UECwwLcGVyc29uYWw0SUIxEjAQBgNVBAsMCVNPRlRGT1JVTTEyMDAGA1UEAwwpWGVjdXJlQ2VydFNoYXJlVGVzdCgpMDA5MDA0MjAxNDA1MjcxMTA3MzAwggEiMA0GCSqGSIb3DQEBAQUAA4IBDwAwggEKAoIBAQCbhJ1RcVAlEqDVF+DtGV+fJ92gXMI40qHQtKQMSWkel8uWPCXMA0o31zncLgp9ZF84QzNPcszMALivaGZer68FF3RtxruO1V8Xn0ClqAW6ldQTNMx/rn1E1uOxa7f41jS/T/2HfDgEmsusXRS8f9uAsy6lW7Vm2m+o6bM4PqX9KIuoWIBtvQZtumgS4TOjmU3hgdtjlYxoSB8sA7DbOUEMuuZg8+C6WS10xBw7DfpoKc1UymJTORk9j92f4j00UhJxAISLV9c6ON/Kq6BMPGwesKFktDboxv6vKttKoloD5wFf2WWGD3nY99VV/5EXX2Mgakc0naL2MDPOoCopWXuNAgMBAAGjggJyMIICbjCBkwYDVR0jBIGLMIGIgBQUj6BKC6Xz5vfMJkaxkNJdgJzS9KFtpGswaTELMAkGA1UEBhMCS1IxDTALBgNVBAoMBEtJU0ExLjAsBgNVBAsMJUtvcmVhIENlcnRpZmljYXRpb24gQXV0aG9yaXR5IENlbnRyYWwxGzAZBgNVBAMMEktpc2EgVGVzdCBSb290Q0EgNYIBJTAdBgNVHQ4EFgQUY8bAzJDORnQVHjf3IQ3Hs+I9FRIwDgYDVR0PAQH/BAQDAgbAMH4GA1UdIAEB/wR0MHIwcAYJKoMajJpFAQEEMGMwMAYIKwYBBQUHAgIwJB4ix3QAIMd4yZ3BHLKUACDC3NXYxqkAIMd4yZ3BHMeFssiy5DAvBggrBgEFBQcCARYjaHR0cDovL3Nub29weS55ZXNzaWduLm9yLmtyL2Nwcy5odG0wcgYDVR0RBGswaaBnBgkqgxqMmkQKAQGgWjBYDBNYZWN1cmVDZXJ0U2hhcmVUZXN0MEEwPwYKKoMajJpECgEBATAxMAsGCWCGSAFlAwQCAaAiBCD3KoVOr3amqJOqPv1CDIfMSKjKFEREEAFi4Uau2kiwNTB1BgNVHR8EbjBsMGqgaKBmhmRsZGFwOi8vc25vb3B5Lnllc3NpZ24ub3Iua3I6NjAyMC9vdT1kcDE2cDE3LG91PUFjY3JlZGl0ZWRDQSxvPXllc3NpZ24sYz1rcj9jZXJ0aWZpY2F0ZVJldm9jYXRpb25MaXN0MDwGCCsGAQUFBwEBBDAwLjAsBggrBgEFBQcwAYYgaHR0cDovL3Nub29weS55ZXNzaWduLm9yLmtyOjQ2MTIwDQYJKoZIhvcNAQELBQADggEBAFe/4ePuStI4BvNxitxQF0f7W1sATV8reBvZAaVg+AzwZooPGr1niqdxCKF4V6EzMWzmFNXbe4I1i0mdwkIN5mGRMqQFowu3jdZzAc2S4W0xeZR4AEtzTHdXMHVKBkQTkX/MDCguvr7+9u8GvhDjj0o/5+zJPza5t8/lHe69TP8jLOIJRwae4M4vizD+dDzjgRJlRDeRX4BfmyHsWMIEgPUwM7QXMXo1W8lc1G0RrrDsmPSozAtRNRYnJ4uXKxo9q5pq0kB1rLsOo/N1icYXEzLr1umuHdZ5eIrJPbtHv+tMcUi2Fs4AIJ5e9IzQW9u2Jamjbn8ma1xEetSzVZYsErQ=");
            aCertificateLength = aCertificate.length;
        }
        catch (Exception e) {
            XSLog.i((String)"[Fail to decode Base64.]");
        }
        requestBundle.putString("REQUEST_ACTION", "VERIFY_PIN");
        requestBundle.putByteArray("PIN", this.mPinValue.getBytes());
        this.mToken.Transmit(requestBundle, responseBundle);
        if (responseBundle.getString("RESULT_CODE").equals("0000")) {
            Toast.makeText((Context)this, (CharSequence)"PIN\uc778\uc99d \uc131\uacf5", (int)1).show();
            requestBundle.putString("REQUEST_ACTION", "PUSH_CERTIFICATE");
            requestBundle.putInt("CERTIFICATE_INDEX", aSaveLocate);
            requestBundle.putByte("CERTIFICATE_TYPE", aCertificateType);
            requestBundle.putInt("CERTIFICATE_LENGTH", aCertificateLength);
            requestBundle.putByteArray("CERTIFICATE", aCertificate);
            this.mToken.Transmit(requestBundle, responseBundle);
            if (responseBundle.getString("RESULT_CODE").equals("0000")) {
                Toast.makeText((Context)this, (CharSequence)"\ud14c\uc2a4\ud2b8 \uc778\uc99d\uc11c IC\uce74\ub4dc\uc5d0 \uc800\uc7a5 \uc131\uacf5", (int)1).show();
                mMediaID = 903;
                this.refreshCertList();
            } else {
                errMsg = responseBundle.getString("ERROR_MESSAGE");
                Toast.makeText((Context)this, (CharSequence)errMsg, (int)1).show();
            }
        } else {
            errMsg = responseBundle.getString("ERROR_MESSAGE");
            Toast.makeText((Context)this, (CharSequence)errMsg, (int)1).show();
        }
    }

    public void getICCardCertificateList() {
        Bundle requestBundle = new Bundle();
        requestBundle.putString("REQUEST_ACTION", "GET_CERTIFICATE_LIST");
        int aCertificateCount = 0;
        String aCertList = "";
        ArrayList<XDetailData> aXCertDataList = new ArrayList<XDetailData>();
        Bundle responseBundle = new Bundle();
        this.mToken.Transmit(requestBundle, responseBundle);
        if (responseBundle.getString("RESULT_CODE").equals("0000")) {
            aCertificateCount = responseBundle.getInt("CERT_COUNT");
        } else {
            String errMsg = responseBundle.getString("ERROR_MESSAGE");
            Toast.makeText((Context)this, (CharSequence)errMsg, (int)1).show();
        }
        if (aCertificateCount > 0) {
            for (int index = 1; index <= aCertificateCount; ++index) {
                requestBundle.putString("REQUEST_ACTION", "GET_CERTIFICATE");
                requestBundle.putInt("CERTIFICATE_INDEX", index);
                this.mToken.Transmit(requestBundle, responseBundle);
                if (!responseBundle.getString("RESULT_CODE").equals("0000")) {
                    String errMsg = responseBundle.getString("ERROR_MESSAGE");
                    Toast.makeText((Context)this, (CharSequence)errMsg, (int)1).show();
                    break;
                }
                byte[] a = responseBundle.getByteArray("CERTIFICATE");
                aCertList = aCertList + this.mICCardMgr.makeCertificateListFromByteArray(a, 5);
            }
        }
        aXCertDataList.addAll(XDetailDataParser.parse((String)aCertList, (int)3, (int)mMediaID));
        this.setListAdapter((ListAdapter)new XDetailDataRowAdapter((Activity)this, aXCertDataList));
    }

    protected void onNewIntent(Intent intent) {
        super.onNewIntent(intent);
        try {
            this.emptyCertList(mMediaID);
            Tag mTag = (Tag)intent.getParcelableExtra("android.nfc.extra.TAG");
            if (mTag != null) {
                this.isoDep = IsoDep.get((Tag)mTag);
                this.mToken = new TokenControl(this.isoDep);
                if (this.mToken == null) {
                    return;
                }
                if (this.mToken.Connect()) {
                    this.mToken.SetDebug(true);
                    Toast.makeText((Context)this, (CharSequence)"NFC \ubcf4\uc548\ud1a0\ud070 \uc5f0\uacb0 \uc131\uacf5", (int)0).show();
                    if (mMediaID == 903) {
                        this.getICCardCertificateList();
                    } else if (mMediaID == 904) {
                        this.copyCertificateToICCard();
                    }
                    this.mToken.Disconnect();
                } else {
                    Toast.makeText((Context)this, (CharSequence)"NFC \ubcf4\uc548\ud1a0\ud070 \uc5f0\uacb0 \uc2e4\ud328", (int)1).show();
                }
            }
        }
        catch (Exception e) {
            XSLog.i((String)"[Fail to connect ICCard.]");
        }
    }

    static {
        mProgressDialog = null;
    }
}

