/*
 * Decompiled with CFR 0.152.
 */
package com.softforum.xecure.ui.crypto;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.view.View;
import android.widget.Button;
import android.widget.ImageView;
import android.widget.TextView;
import com.softforum.sample.R;
import com.softforum.xecure.crypto.CertMgr;
import com.softforum.xecure.ui.XTopView;
import com.softforum.xecure.ui.crypto.XecureSmartCertMgrUser;
import com.softforum.xecure.util.XCoreUtil;
import com.softforum.xecure.util.XDetailData;
import com.softforum.xecure.util.XUtil;

public class XecureSmartChangePassword
extends Activity {
    public static final int mXecureSmartChangePasswordID = 78000;
    public static final String mMediaIDKey = "xecure_smart_changepw_media_id_key";
    public static final String mSelectedCertDataKey = "xecure_smart_changepw_data_key";
    public static final String mNewPasswordKey = "sign_cert_password_password_key";
    public static final String mOldPasswordKey = "old_cert_password_password_key";
    public static final String mRandomValueKey = "sign_cert_password_random_value_key";
    public static final String mE_ncryptedDataKey = "sign_cert_password_e_ncrypted_data_key";
    public static final String mNewE_ncryptedDataKey = "sign_cert_password_new_e_ncrypted_data_key";
    public static final int RESULT_PASSWD_FAIL = 2;
    private int mMediaID;
    private int m_P_assW_ordTryCount = 0;
    private XDetailData mSelectedData;
    private XCoreUtil mCoreUtil = new XCoreUtil();
    private String mOldPassword;
    private String mNewPassword;
    private String mNewPasswordConfirm;
    private String mCallMode;
    private int mDetailDataType = 0;
    private int mDetailDataCertSubjectKey = 7;
    private int mDetailDataCertIssuerKey = 4;
    private int mDetailDataCertToKey = 6;

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.crypto_xecure_smart_change_password);
        this.mMediaID = this.getIntent().getIntExtra(mMediaIDKey, -1);
        this.mCallMode = this.getIntent().getStringExtra("call_mode_key");
        if (this.mCallMode != null && this.mCallMode.equals("call_mode_renew")) {
            XTopView aTopView = (XTopView)this.findViewById(R.id.top_view);
            aTopView.setSubject(this.getString(R.string.renew_certificate_window_title));
            aTopView.setDescription(this.getString(R.string.renew_certificate_window_desc));
            this.mDetailDataType = 3;
            this.mDetailDataCertSubjectKey = 2;
            this.mDetailDataCertIssuerKey = 3;
            this.mDetailDataCertToKey = 4;
            TextView aAlertTextView = (TextView)this.findViewById(R.id.new_password_check_alert_textview);
            aAlertTextView.setVisibility(0);
        }
        this.mSelectedData = new XDetailData(this.getIntent().getStringArrayExtra(mSelectedCertDataKey), this.mDetailDataType);
        ImageView aIcon = (ImageView)this.findViewById(R.id.icon);
        TextView aMainMsg = (TextView)this.findViewById(R.id.main_msg);
        TextView aSubMsg1 = (TextView)this.findViewById(R.id.sub_msg1);
        TextView aSubMsg2 = (TextView)this.findViewById(R.id.sub_msg2);
        if ("0".equals(this.mSelectedData.getValue(0))) {
            aIcon.setImageResource(R.drawable.cert_state_normal);
        } else if ("1".equals(this.mSelectedData.getValue(0))) {
            aIcon.setImageResource(R.drawable.cert_state_update);
        } else if ("2".equals(this.mSelectedData.getValue(0))) {
            aIcon.setImageResource(R.drawable.cert_state_revoke);
        }
        aMainMsg.setText((CharSequence)this.mSelectedData.getValue(this.mDetailDataCertSubjectKey));
        aSubMsg1.setText((CharSequence)(this.mSelectedData.getKeyText(this.mDetailDataCertIssuerKey) + " : " + this.mSelectedData.getValue(this.mDetailDataCertIssuerKey)));
        aSubMsg2.setText((CharSequence)(this.mSelectedData.getKeyText(this.mDetailDataCertToKey) + " : " + this.mSelectedData.getValue(this.mDetailDataCertToKey)));
        Button aOKButton = (Button)this.findViewById(R.id.top_right_button);
        aOKButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                XecureSmartChangePassword.this.onOKButtonClick(v);
            }
        });
    }

    private void onOKButtonClick(View v) {
        Intent aIntent = null;
        int aErrorCode = 0;
        CertMgr aCertMgr = CertMgr.getInstance();
        XTopView aTopView = (XTopView)this.findViewById(R.id.top_view);
        TextView aOldPasswordTextView = (TextView)this.findViewById(R.id.password_edittext);
        TextView aNewPasswordTextView = (TextView)this.findViewById(R.id.new_password_edittext);
        TextView aNewPasswordConfirmTextView = (TextView)this.findViewById(R.id.new_password_confirm_edittext);
        String aSubjectDN = this.mSelectedData.getValue(this.mDetailDataCertSubjectKey);
        this.mOldPassword = aOldPasswordTextView.getText().toString();
        this.mNewPassword = aNewPasswordTextView.getText().toString();
        this.mNewPasswordConfirm = aNewPasswordConfirmTextView.getText().toString();
        this.mCoreUtil.resetError();
        if (this.mOldPassword.length() > 0) {
            if (aCertMgr.verifyPassword(this.mMediaID, 14, this.mSelectedData.getValue(this.mDetailDataCertSubjectKey), this.mOldPassword) != 0 && (aErrorCode = this.mCoreUtil.lastErrCode()) != 22000015) {
                aTopView.setDescription(this.mCoreUtil.lastErrMsg());
                this.mOldPassword = "";
                aOldPasswordTextView.setText((CharSequence)"");
                if (++this.m_P_assW_ordTryCount >= 3) {
                    this.setResult(2);
                    this.finish();
                }
                return;
            }
        } else {
            aTopView.setDescription(this.getString(R.string.plugin_input_nothing));
            return;
        }
        if (this.mNewPassword.length() == 0) {
            aTopView.setDescription(this.getString(R.string.plugin_input_nothing));
            return;
        }
        if (this.mCallMode != null && this.mCallMode.equals("call_mode_renew")) {
            switch (XUtil.newCheckPasswordFormat((String)this.mNewPassword)) {
                case 0: {
                    break;
                }
                case 3: {
                    aTopView.setDescription(this.getString(R.string.newpassword_length_error));
                    return;
                }
                case 4: {
                    aTopView.setDescription(this.getString(R.string.newpassword_syntax_error));
                    return;
                }
                case 5: {
                    aTopView.setDescription(this.getString(R.string.newpassword_invalid_error));
                    return;
                }
            }
        } else {
            switch (XUtil.checkPasswordFormat((String)this.mNewPassword)) {
                case 0: {
                    break;
                }
                case 1: {
                    aTopView.setDescription(this.getString(R.string.password_length_error));
                    return;
                }
                case 2: {
                    aTopView.setDescription(this.getString(R.string.password_syntax_error));
                    return;
                }
            }
        }
        if (!this.mNewPassword.equals(this.mNewPasswordConfirm)) {
            aTopView.setDescription(this.getString(R.string.incorrect_confirm_password));
            return;
        }
        if (this.mOldPassword.equals(this.mNewPasswordConfirm)) {
            aTopView.setDescription(this.getString(R.string.password_renew_syntax_error));
            return;
        }
        if (this.mCallMode != null && this.mCallMode.equals("call_mode_renew")) {
            aIntent = new Intent();
            aIntent.putExtra(mOldPasswordKey, this.mOldPassword.getBytes());
            aIntent.putExtra(mNewPasswordKey, this.mNewPassword.getBytes());
            this.setResult(-1, aIntent);
            this.finish();
        } else {
            aIntent = new Intent((Context)this, XecureSmartCertMgrUser.class);
            int error = aCertMgr.changePassword(this.mMediaID, aSubjectDN, this.mOldPassword, this.mNewPassword);
            if (error == 0) {
                aIntent.putExtra("xecure_smart_cert_mgr_result_key", 1);
                aIntent.putExtra(mNewPasswordKey, this.mNewPassword);
                this.setResult(-1, aIntent);
                this.finish();
            } else {
                this.setResult(2, aIntent);
            }
        }
        this.finish();
    }
}

