/*
 * Decompiled with CFR 0.152.
 */
package com.softforum.xecure.ui.crypto;

import android.app.Activity;
import android.app.Dialog;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.view.View;
import android.widget.RadioGroup;
import android.widget.TextView;
import android.widget.ToggleButton;
import com.softforum.sample.R;
import com.softforum.xecure.crypto.CertMgr;
import com.softforum.xecure.crypto.ConfigMgr;
import com.softforum.xecure.ui.crypto.PKCS11PasswordChange;
import com.softforum.xecure.util.EnvironmentConfig;
import com.softforum.xecure.util.XCoreUtil;

public class XecureSmartConfig
extends Activity
implements RadioGroup.OnCheckedChangeListener {
    public static final int mXecureSmartConfigID = 70300;
    private ToggleButton mVerifyCertDestroyConfigBtn;
    private ToggleButton mConnectUsingProxyConfigBtn;
    private ToggleButton mExcludeExpireConfigBtn;
    private RadioGroup mMediaSelectorRadioGroup = null;
    private RadioGroup mKeypadSelectorFirstRadioGroup = null;
    private RadioGroup mKeypadSelectorSecondRadioGroup = null;
    private ConfigMgr mConfigMgr;

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.crypto_xecure_smart_config);
        this.mConfigMgr = new ConfigMgr();
        this.mVerifyCertDestroyConfigBtn = (ToggleButton)this.findViewById(R.id.verify_cert_destroy_config_btn);
        this.mConnectUsingProxyConfigBtn = (ToggleButton)this.findViewById(R.id.connect_using_proxy_config_btn);
        this.mExcludeExpireConfigBtn = (ToggleButton)this.findViewById(R.id.exclude_expire_cert_btn);
        this.mMediaSelectorRadioGroup = (RadioGroup)this.findViewById(R.id.media_use_selector);
        this.mMediaSelectorRadioGroup.setOnCheckedChangeListener((RadioGroup.OnCheckedChangeListener)this);
        this.mKeypadSelectorFirstRadioGroup = (RadioGroup)this.findViewById(R.id.keypad_use_first_selector);
        this.mKeypadSelectorFirstRadioGroup.setOnCheckedChangeListener((RadioGroup.OnCheckedChangeListener)this);
        this.mKeypadSelectorSecondRadioGroup = (RadioGroup)this.findViewById(R.id.keypad_use_second_selector);
        this.mKeypadSelectorSecondRadioGroup.setOnCheckedChangeListener((RadioGroup.OnCheckedChangeListener)this);
        this.addListenerToImgBtn();
        this.findViewById(R.id.change_pkcs11_password_btn).setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                XecureSmartConfig.this.startPKCS11PasswordChangeActivity();
            }
        });
        this.findViewById(R.id.change_sdcard_path_btn).setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                XecureSmartConfig.this.changeExternalPath();
            }
        });
        this.getConfigs();
    }

    private void changeExternalPath() {
        final Dialog dialog = new Dialog((Context)this);
        dialog.setContentView(R.layout.text_input_dialog);
        dialog.setTitle((CharSequence)"SDCARD \uacbd\ub85c\ub97c \uc785\ub825\ud558\uc2ed\uc2dc\uc624");
        final TextView text = (TextView)dialog.findViewById(R.id.edittext);
        String path = XCoreUtil.getInstance().getExternalPath();
        if (path.length() == 0) {
            path = "/sdcard";
        }
        text.setText((CharSequence)path);
        dialog.findViewById(R.id.ok_btn).setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                XCoreUtil.getInstance().setExternalPath(text.getText().toString());
                CertMgr.getInstance().getMediaList(100, 0, 1);
                dialog.dismiss();
            }
        });
        dialog.findViewById(R.id.cancel_btn).setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                dialog.cancel();
            }
        });
        dialog.show();
    }

    private void startPKCS11PasswordChangeActivity() {
        this.startActivityForResult(new Intent((Context)this, PKCS11PasswordChange.class), 100000);
    }

    private void addListenerToImgBtn() {
        this.mVerifyCertDestroyConfigBtn.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                XecureSmartConfig.this.onVerifyCertDestroyConfigBtnClick(v);
            }
        });
        this.mConnectUsingProxyConfigBtn.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                XecureSmartConfig.this.onConnectUsingProxyBtnClick(v);
            }
        });
        this.mExcludeExpireConfigBtn.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                EnvironmentConfig.mExcludeExpiredCert = XecureSmartConfig.this.mExcludeExpireConfigBtn.isChecked();
            }
        });
    }

    private void onVerifyCertDestroyConfigBtnClick(View v) {
        this.mConfigMgr.setValidChkMode(((ToggleButton)v).isChecked() ? 1 : 0);
    }

    private void onConnectUsingProxyBtnClick(View v) {
        this.mConfigMgr.setProxyUsage(((ToggleButton)v).isChecked() ? 1 : 0);
    }

    private void getConfigs() {
        this.mVerifyCertDestroyConfigBtn.setChecked(this.mConfigMgr.getValidChkMode() == 1);
        this.mConnectUsingProxyConfigBtn.setChecked(this.mConfigMgr.getProxyUsage() == 1);
        if (!EnvironmentConfig.mExcludeExpiredCert) {
            this.mExcludeExpireConfigBtn.setChecked(false);
        } else if (EnvironmentConfig.mExcludeExpiredCert) {
            this.mExcludeExpireConfigBtn.setChecked(true);
        }
        if (EnvironmentConfig.mSDCardOnlyUse) {
            this.mMediaSelectorRadioGroup.check(R.id.select_sdcard);
        } else if (EnvironmentConfig.mAppDataOnlyUse) {
            this.mMediaSelectorRadioGroup.check(R.id.select_appdata);
        } else if (EnvironmentConfig.mSDCardAppDataUse) {
            this.mMediaSelectorRadioGroup.check(R.id.select_appdata_sdcard);
        }
        if (EnvironmentConfig.mBasicKeyUsage) {
            this.mKeypadSelectorFirstRadioGroup.check(R.id.select_basic_keytype);
        } else if (EnvironmentConfig.mMTransKeyUsage) {
            this.mKeypadSelectorFirstRadioGroup.check(R.id.select_transkeytype);
        } else if (EnvironmentConfig.mXecureKeypadFullViewUsage) {
            this.mKeypadSelectorSecondRadioGroup.check(R.id.select_xkkeytype_fullview);
        } else if (EnvironmentConfig.mXecureKeypadNormalViewUsage) {
            this.mKeypadSelectorSecondRadioGroup.check(R.id.select_xkkeytype_normalview);
        }
    }

    public void onCheckedChanged(RadioGroup group, int checkedId) {
        if (group == this.mMediaSelectorRadioGroup) {
            if (checkedId == R.id.select_sdcard) {
                EnvironmentConfig.mSDCardOnlyUse = true;
                EnvironmentConfig.mAppDataOnlyUse = false;
                EnvironmentConfig.mSDCardAppDataUse = false;
            } else if (checkedId == R.id.select_appdata) {
                EnvironmentConfig.mAppDataOnlyUse = true;
                EnvironmentConfig.mSDCardOnlyUse = false;
                EnvironmentConfig.mSDCardAppDataUse = false;
            } else if (checkedId == R.id.select_appdata_sdcard) {
                EnvironmentConfig.mSDCardAppDataUse = true;
                EnvironmentConfig.mAppDataOnlyUse = false;
                EnvironmentConfig.mSDCardOnlyUse = false;
            }
        } else if (group == this.mKeypadSelectorFirstRadioGroup) {
            this.mKeypadSelectorSecondRadioGroup.setOnCheckedChangeListener(null);
            this.mKeypadSelectorSecondRadioGroup.clearCheck();
            this.mKeypadSelectorSecondRadioGroup.setOnCheckedChangeListener((RadioGroup.OnCheckedChangeListener)this);
            if (checkedId == R.id.select_basic_keytype) {
                EnvironmentConfig.mBasicKeyUsage = true;
                EnvironmentConfig.mMTransKeyUsage = false;
                EnvironmentConfig.mXecureKeypadFullViewUsage = false;
                EnvironmentConfig.mXecureKeypadNormalViewUsage = false;
            } else if (checkedId == R.id.select_transkeytype) {
                EnvironmentConfig.mBasicKeyUsage = false;
                EnvironmentConfig.mMTransKeyUsage = true;
                EnvironmentConfig.mXecureKeypadFullViewUsage = false;
                EnvironmentConfig.mXecureKeypadNormalViewUsage = false;
            }
        } else if (group == this.mKeypadSelectorSecondRadioGroup) {
            this.mKeypadSelectorFirstRadioGroup.setOnCheckedChangeListener(null);
            this.mKeypadSelectorFirstRadioGroup.clearCheck();
            this.mKeypadSelectorFirstRadioGroup.setOnCheckedChangeListener((RadioGroup.OnCheckedChangeListener)this);
            if (checkedId == R.id.select_xkkeytype_fullview) {
                EnvironmentConfig.mBasicKeyUsage = false;
                EnvironmentConfig.mMTransKeyUsage = false;
                EnvironmentConfig.mXecureKeypadFullViewUsage = true;
                EnvironmentConfig.mXecureKeypadNormalViewUsage = false;
            } else if (checkedId == R.id.select_xkkeytype_normalview) {
                EnvironmentConfig.mBasicKeyUsage = false;
                EnvironmentConfig.mMTransKeyUsage = false;
                EnvironmentConfig.mXecureKeypadFullViewUsage = false;
                EnvironmentConfig.mXecureKeypadNormalViewUsage = true;
            }
        }
    }
}

